# -*- coding: utf-8 -*-
# Copyright 2022 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#

from .services.vm_migration import VmMigrationAsyncClient, VmMigrationClient
from .types.vmmigration import (
    AddGroupMigrationRequest,
    AddGroupMigrationResponse,
    AppliedLicense,
    CancelCloneJobRequest,
    CancelCloneJobResponse,
    CancelCutoverJobRequest,
    CancelCutoverJobResponse,
    CloneJob,
    ComputeEngineBootOption,
    ComputeEngineDiskType,
    ComputeEngineLicenseType,
    ComputeEngineTargetDefaults,
    ComputeEngineTargetDetails,
    ComputeScheduling,
    CreateCloneJobRequest,
    CreateCutoverJobRequest,
    CreateDatacenterConnectorRequest,
    CreateGroupRequest,
    CreateMigratingVmRequest,
    CreateSourceRequest,
    CreateTargetProjectRequest,
    CreateUtilizationReportRequest,
    CutoverJob,
    DatacenterConnector,
    DeleteDatacenterConnectorRequest,
    DeleteGroupRequest,
    DeleteMigratingVmRequest,
    DeleteSourceRequest,
    DeleteTargetProjectRequest,
    DeleteUtilizationReportRequest,
    FetchInventoryRequest,
    FetchInventoryResponse,
    FinalizeMigrationRequest,
    FinalizeMigrationResponse,
    GetCloneJobRequest,
    GetCutoverJobRequest,
    GetDatacenterConnectorRequest,
    GetGroupRequest,
    GetMigratingVmRequest,
    GetSourceRequest,
    GetTargetProjectRequest,
    GetUtilizationReportRequest,
    Group,
    ListCloneJobsRequest,
    ListCloneJobsResponse,
    ListCutoverJobsRequest,
    ListCutoverJobsResponse,
    ListDatacenterConnectorsRequest,
    ListDatacenterConnectorsResponse,
    ListGroupsRequest,
    ListGroupsResponse,
    ListMigratingVmsRequest,
    ListMigratingVmsResponse,
    ListSourcesRequest,
    ListSourcesResponse,
    ListTargetProjectsRequest,
    ListTargetProjectsResponse,
    ListUtilizationReportsRequest,
    ListUtilizationReportsResponse,
    MigratingVm,
    MigrationError,
    NetworkInterface,
    OperationMetadata,
    PauseMigrationRequest,
    PauseMigrationResponse,
    RemoveGroupMigrationRequest,
    RemoveGroupMigrationResponse,
    ReplicationCycle,
    ReplicationSync,
    ResumeMigrationRequest,
    ResumeMigrationResponse,
    SchedulePolicy,
    SchedulingNodeAffinity,
    Source,
    StartMigrationRequest,
    StartMigrationResponse,
    TargetProject,
    UpdateGroupRequest,
    UpdateMigratingVmRequest,
    UpdateSourceRequest,
    UpdateTargetProjectRequest,
    UtilizationReport,
    UtilizationReportView,
    VmUtilizationInfo,
    VmUtilizationMetrics,
    VmwareSourceDetails,
    VmwareVmDetails,
    VmwareVmsDetails,
)

__all__ = (
    "VmMigrationAsyncClient",
    "AddGroupMigrationRequest",
    "AddGroupMigrationResponse",
    "AppliedLicense",
    "CancelCloneJobRequest",
    "CancelCloneJobResponse",
    "CancelCutoverJobRequest",
    "CancelCutoverJobResponse",
    "CloneJob",
    "ComputeEngineBootOption",
    "ComputeEngineDiskType",
    "ComputeEngineLicenseType",
    "ComputeEngineTargetDefaults",
    "ComputeEngineTargetDetails",
    "ComputeScheduling",
    "CreateCloneJobRequest",
    "CreateCutoverJobRequest",
    "CreateDatacenterConnectorRequest",
    "CreateGroupRequest",
    "CreateMigratingVmRequest",
    "CreateSourceRequest",
    "CreateTargetProjectRequest",
    "CreateUtilizationReportRequest",
    "CutoverJob",
    "DatacenterConnector",
    "DeleteDatacenterConnectorRequest",
    "DeleteGroupRequest",
    "DeleteMigratingVmRequest",
    "DeleteSourceRequest",
    "DeleteTargetProjectRequest",
    "DeleteUtilizationReportRequest",
    "FetchInventoryRequest",
    "FetchInventoryResponse",
    "FinalizeMigrationRequest",
    "FinalizeMigrationResponse",
    "GetCloneJobRequest",
    "GetCutoverJobRequest",
    "GetDatacenterConnectorRequest",
    "GetGroupRequest",
    "GetMigratingVmRequest",
    "GetSourceRequest",
    "GetTargetProjectRequest",
    "GetUtilizationReportRequest",
    "Group",
    "ListCloneJobsRequest",
    "ListCloneJobsResponse",
    "ListCutoverJobsRequest",
    "ListCutoverJobsResponse",
    "ListDatacenterConnectorsRequest",
    "ListDatacenterConnectorsResponse",
    "ListGroupsRequest",
    "ListGroupsResponse",
    "ListMigratingVmsRequest",
    "ListMigratingVmsResponse",
    "ListSourcesRequest",
    "ListSourcesResponse",
    "ListTargetProjectsRequest",
    "ListTargetProjectsResponse",
    "ListUtilizationReportsRequest",
    "ListUtilizationReportsResponse",
    "MigratingVm",
    "MigrationError",
    "NetworkInterface",
    "OperationMetadata",
    "PauseMigrationRequest",
    "PauseMigrationResponse",
    "RemoveGroupMigrationRequest",
    "RemoveGroupMigrationResponse",
    "ReplicationCycle",
    "ReplicationSync",
    "ResumeMigrationRequest",
    "ResumeMigrationResponse",
    "SchedulePolicy",
    "SchedulingNodeAffinity",
    "Source",
    "StartMigrationRequest",
    "StartMigrationResponse",
    "TargetProject",
    "UpdateGroupRequest",
    "UpdateMigratingVmRequest",
    "UpdateSourceRequest",
    "UpdateTargetProjectRequest",
    "UtilizationReport",
    "UtilizationReportView",
    "VmMigrationClient",
    "VmUtilizationInfo",
    "VmUtilizationMetrics",
    "VmwareSourceDetails",
    "VmwareVmDetails",
    "VmwareVmsDetails",
)
