from defusedxml.ElementTree import parse, ParseError


def dictfetchall(cursor):
    "Return all rows from a cursor as a dict"
    columns = [col[0] for col in cursor.description]
    return [dict(zip(columns, row)) for row in cursor.fetchall()]


def sanitize_xml(xml_file):
    return parse(xml_file)