import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataUpcloudNetworksConfig extends cdktf.TerraformMetaArguments {
    /**
    * If specified, results will be filtered to match name using a regular expression
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/d/networks#filter_name DataUpcloudNetworks#filter_name}
    */
    readonly filterName?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/d/networks#id DataUpcloudNetworks#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * If specified, this data source will return only networks from this zone
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/d/networks#zone DataUpcloudNetworks#zone}
    */
    readonly zone?: string;
}
export interface DataUpcloudNetworksNetworksIpNetwork {
}
export declare function dataUpcloudNetworksNetworksIpNetworkToTerraform(struct?: DataUpcloudNetworksNetworksIpNetwork): any;
export declare class DataUpcloudNetworksNetworksIpNetworkOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataUpcloudNetworksNetworksIpNetwork | undefined;
    set internalValue(value: DataUpcloudNetworksNetworksIpNetwork | undefined);
    get address(): string;
    get dhcp(): cdktf.IResolvable;
    get dhcpDefaultRoute(): cdktf.IResolvable;
    get dhcpDns(): string[];
    get family(): string;
    get gateway(): string;
}
export declare class DataUpcloudNetworksNetworksIpNetworkList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataUpcloudNetworksNetworksIpNetworkOutputReference;
}
export interface DataUpcloudNetworksNetworksServers {
}
export declare function dataUpcloudNetworksNetworksServersToTerraform(struct?: DataUpcloudNetworksNetworksServers): any;
export declare class DataUpcloudNetworksNetworksServersOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataUpcloudNetworksNetworksServers | undefined;
    set internalValue(value: DataUpcloudNetworksNetworksServers | undefined);
    get id(): string;
    get title(): string;
}
export declare class DataUpcloudNetworksNetworksServersList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataUpcloudNetworksNetworksServersOutputReference;
}
export interface DataUpcloudNetworksNetworks {
}
export declare function dataUpcloudNetworksNetworksToTerraform(struct?: DataUpcloudNetworksNetworks): any;
export declare class DataUpcloudNetworksNetworksOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataUpcloudNetworksNetworks | undefined;
    set internalValue(value: DataUpcloudNetworksNetworks | undefined);
    get id(): string;
    private _ipNetwork;
    get ipNetwork(): DataUpcloudNetworksNetworksIpNetworkList;
    get name(): string;
    private _servers;
    get servers(): DataUpcloudNetworksNetworksServersList;
    get type(): string;
    get zone(): string;
}
export declare class DataUpcloudNetworksNetworksList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataUpcloudNetworksNetworksOutputReference;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/upcloud/d/networks upcloud_networks}
*/
export declare class DataUpcloudNetworks extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "upcloud_networks";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/upcloud/d/networks upcloud_networks} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataUpcloudNetworksConfig = {}
    */
    constructor(scope: Construct, id: string, config?: DataUpcloudNetworksConfig);
    private _filterName?;
    get filterName(): string;
    set filterName(value: string);
    resetFilterName(): void;
    get filterNameInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _networks;
    get networks(): DataUpcloudNetworksNetworksList;
    private _zone?;
    get zone(): string;
    set zone(value: string);
    resetZone(): void;
    get zoneInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
//# sourceMappingURL=data-upcloud-networks.d.ts.map