import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface LoadbalancerFrontendTlsConfigConfig extends cdktf.TerraformMetaArguments {
    /**
    * Reference to certificate bundle ID.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/loadbalancer_frontend_tls_config#certificate_bundle LoadbalancerFrontendTlsConfig#certificate_bundle}
    */
    readonly certificateBundle: string;
    /**
    * ID of the load balancer frontend to which the TLS config is connected.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/loadbalancer_frontend_tls_config#frontend LoadbalancerFrontendTlsConfig#frontend}
    */
    readonly frontend: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/loadbalancer_frontend_tls_config#id LoadbalancerFrontendTlsConfig#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The name of the TLS config must be unique within service frontend.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/loadbalancer_frontend_tls_config#name LoadbalancerFrontendTlsConfig#name}
    */
    readonly name: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/upcloud/r/loadbalancer_frontend_tls_config upcloud_loadbalancer_frontend_tls_config}
*/
export declare class LoadbalancerFrontendTlsConfig extends cdktf.TerraformResource {
    static readonly tfResourceType = "upcloud_loadbalancer_frontend_tls_config";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/upcloud/r/loadbalancer_frontend_tls_config upcloud_loadbalancer_frontend_tls_config} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options LoadbalancerFrontendTlsConfigConfig
    */
    constructor(scope: Construct, id: string, config: LoadbalancerFrontendTlsConfigConfig);
    private _certificateBundle?;
    get certificateBundle(): string;
    set certificateBundle(value: string);
    get certificateBundleInput(): string | undefined;
    private _frontend?;
    get frontend(): string;
    set frontend(value: string);
    get frontendInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
//# sourceMappingURL=loadbalancer-frontend-tls-config.d.ts.map