import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface LoadbalancerResolverConfig extends cdktf.TerraformMetaArguments {
    /**
    * Time in seconds to cache invalid results.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/loadbalancer_resolver#cache_invalid LoadbalancerResolver#cache_invalid}
    */
    readonly cacheInvalid: number;
    /**
    * Time in seconds to cache valid results.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/loadbalancer_resolver#cache_valid LoadbalancerResolver#cache_valid}
    */
    readonly cacheValid: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/loadbalancer_resolver#id LoadbalancerResolver#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * ID of the load balancer to which the resolver is connected.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/loadbalancer_resolver#loadbalancer LoadbalancerResolver#loadbalancer}
    */
    readonly loadbalancer: string;
    /**
    * The name of the resolver must be unique within the service.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/loadbalancer_resolver#name LoadbalancerResolver#name}
    */
    readonly name: string;
    /**
    * List of nameserver IP addresses. Nameserver can reside in public internet or in customer private network.
                  Port is optional, if missing then default 53 will be used.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/loadbalancer_resolver#nameservers LoadbalancerResolver#nameservers}
    */
    readonly nameservers: string[];
    /**
    * Number of retries on failure.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/loadbalancer_resolver#retries LoadbalancerResolver#retries}
    */
    readonly retries: number;
    /**
    * Timeout for the query in seconds.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/loadbalancer_resolver#timeout LoadbalancerResolver#timeout}
    */
    readonly timeout: number;
    /**
    * Timeout for the query retries in seconds.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/loadbalancer_resolver#timeout_retry LoadbalancerResolver#timeout_retry}
    */
    readonly timeoutRetry: number;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/upcloud/r/loadbalancer_resolver upcloud_loadbalancer_resolver}
*/
export declare class LoadbalancerResolver extends cdktf.TerraformResource {
    static readonly tfResourceType = "upcloud_loadbalancer_resolver";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/upcloud/r/loadbalancer_resolver upcloud_loadbalancer_resolver} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options LoadbalancerResolverConfig
    */
    constructor(scope: Construct, id: string, config: LoadbalancerResolverConfig);
    private _cacheInvalid?;
    get cacheInvalid(): number;
    set cacheInvalid(value: number);
    get cacheInvalidInput(): number | undefined;
    private _cacheValid?;
    get cacheValid(): number;
    set cacheValid(value: number);
    get cacheValidInput(): number | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _loadbalancer?;
    get loadbalancer(): string;
    set loadbalancer(value: string);
    get loadbalancerInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _nameservers?;
    get nameservers(): string[];
    set nameservers(value: string[]);
    get nameserversInput(): string[] | undefined;
    private _retries?;
    get retries(): number;
    set retries(value: number);
    get retriesInput(): number | undefined;
    private _timeout?;
    get timeout(): number;
    set timeout(value: number);
    get timeoutInput(): number | undefined;
    private _timeoutRetry?;
    get timeoutRetry(): number;
    set timeoutRetry(value: number);
    get timeoutRetryInput(): number | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
//# sourceMappingURL=loadbalancer-resolver.d.ts.map