import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ManagedDatabasePostgresqlConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/managed_database_postgresql#id ManagedDatabasePostgresql#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Maintenance window day of week. Lower case weekday name (monday, tuesday, ...)
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/managed_database_postgresql#maintenance_window_dow ManagedDatabasePostgresql#maintenance_window_dow}
    */
    readonly maintenanceWindowDow?: string;
    /**
    * Maintenance window UTC time in hh:mm:ss format
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/managed_database_postgresql#maintenance_window_time ManagedDatabasePostgresql#maintenance_window_time}
    */
    readonly maintenanceWindowTime?: string;
    /**
    * Name of the service. The name is used as a prefix for the logical hostname. Must be unique within an account
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/managed_database_postgresql#name ManagedDatabasePostgresql#name}
    */
    readonly name: string;
    /**
    * Service plan to use. This determines how much resources the instance will have
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/managed_database_postgresql#plan ManagedDatabasePostgresql#plan}
    */
    readonly plan: string;
    /**
    * The administrative power state of the service
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/managed_database_postgresql#powered ManagedDatabasePostgresql#powered}
    */
    readonly powered?: boolean | cdktf.IResolvable;
    /**
    * Title of a managed database instance
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/managed_database_postgresql#title ManagedDatabasePostgresql#title}
    */
    readonly title?: string;
    /**
    * Zone where the instance resides
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/managed_database_postgresql#zone ManagedDatabasePostgresql#zone}
    */
    readonly zone: string;
    /**
    * properties block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/managed_database_postgresql#properties ManagedDatabasePostgresql#properties}
    */
    readonly properties?: ManagedDatabasePostgresqlProperties;
}
export interface ManagedDatabasePostgresqlComponents {
}
export declare function managedDatabasePostgresqlComponentsToTerraform(struct?: ManagedDatabasePostgresqlComponents): any;
export declare class ManagedDatabasePostgresqlComponentsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ManagedDatabasePostgresqlComponents | undefined;
    set internalValue(value: ManagedDatabasePostgresqlComponents | undefined);
    get component(): string;
    get host(): string;
    get port(): number;
    get route(): string;
    get usage(): string;
}
export declare class ManagedDatabasePostgresqlComponentsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ManagedDatabasePostgresqlComponentsOutputReference;
}
export interface ManagedDatabasePostgresqlNodeStates {
}
export declare function managedDatabasePostgresqlNodeStatesToTerraform(struct?: ManagedDatabasePostgresqlNodeStates): any;
export declare class ManagedDatabasePostgresqlNodeStatesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ManagedDatabasePostgresqlNodeStates | undefined;
    set internalValue(value: ManagedDatabasePostgresqlNodeStates | undefined);
    get name(): string;
    get role(): string;
    get state(): string;
}
export declare class ManagedDatabasePostgresqlNodeStatesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ManagedDatabasePostgresqlNodeStatesOutputReference;
}
export interface ManagedDatabasePostgresqlPropertiesMigration {
    /**
    * Database name for bootstrapping the initial connection
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/managed_database_postgresql#dbname ManagedDatabasePostgresql#dbname}
    */
    readonly dbname?: string;
    /**
    * Hostname or IP address of the server where to migrate data from
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/managed_database_postgresql#host ManagedDatabasePostgresql#host}
    */
    readonly host?: string;
    /**
    * Comma-separated list of databases, which should be ignored during migration (supported by MySQL only at the moment)
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/managed_database_postgresql#ignore_dbs ManagedDatabasePostgresql#ignore_dbs}
    */
    readonly ignoreDbs?: string;
    /**
    * Password for authentication with the server where to migrate data from
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/managed_database_postgresql#password ManagedDatabasePostgresql#password}
    */
    readonly password?: string;
    /**
    * Port number of the server where to migrate data from
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/managed_database_postgresql#port ManagedDatabasePostgresql#port}
    */
    readonly port?: number;
    /**
    * The server where to migrate data from is secured with SSL
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/managed_database_postgresql#ssl ManagedDatabasePostgresql#ssl}
    */
    readonly ssl?: boolean | cdktf.IResolvable;
    /**
    * User name for authentication with the server where to migrate data from
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/managed_database_postgresql#username ManagedDatabasePostgresql#username}
    */
    readonly username?: string;
}
export declare function managedDatabasePostgresqlPropertiesMigrationToTerraform(struct?: ManagedDatabasePostgresqlPropertiesMigrationOutputReference | ManagedDatabasePostgresqlPropertiesMigration): any;
export declare class ManagedDatabasePostgresqlPropertiesMigrationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ManagedDatabasePostgresqlPropertiesMigration | undefined;
    set internalValue(value: ManagedDatabasePostgresqlPropertiesMigration | undefined);
    private _dbname?;
    get dbname(): string;
    set dbname(value: string);
    resetDbname(): void;
    get dbnameInput(): string | undefined;
    private _host?;
    get host(): string;
    set host(value: string);
    resetHost(): void;
    get hostInput(): string | undefined;
    private _ignoreDbs?;
    get ignoreDbs(): string;
    set ignoreDbs(value: string);
    resetIgnoreDbs(): void;
    get ignoreDbsInput(): string | undefined;
    private _password?;
    get password(): string;
    set password(value: string);
    resetPassword(): void;
    get passwordInput(): string | undefined;
    private _port?;
    get port(): number;
    set port(value: number);
    resetPort(): void;
    get portInput(): number | undefined;
    private _ssl?;
    get ssl(): boolean | cdktf.IResolvable;
    set ssl(value: boolean | cdktf.IResolvable);
    resetSsl(): void;
    get sslInput(): boolean | cdktf.IResolvable | undefined;
    private _username?;
    get username(): string;
    set username(value: string);
    resetUsername(): void;
    get usernameInput(): string | undefined;
}
export interface ManagedDatabasePostgresqlPropertiesPgbouncer {
    /**
    * If the automatically created database pools have been unused this many seconds, they are freed. If 0 then timeout is disabled. [seconds]
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/managed_database_postgresql#autodb_idle_timeout ManagedDatabasePostgresql#autodb_idle_timeout}
    */
    readonly autodbIdleTimeout?: number;
    /**
    * Do not allow more than this many server connections per database (regardless of user). Setting it to 0 means unlimited.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/managed_database_postgresql#autodb_max_db_connections ManagedDatabasePostgresql#autodb_max_db_connections}
    */
    readonly autodbMaxDbConnections?: number;
    /**
    * PGBouncer pool mode
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/managed_database_postgresql#autodb_pool_mode ManagedDatabasePostgresql#autodb_pool_mode}
    */
    readonly autodbPoolMode?: string;
    /**
    * If non-zero then create automatically a pool of that size per user when a pool doesn't exist.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/managed_database_postgresql#autodb_pool_size ManagedDatabasePostgresql#autodb_pool_size}
    */
    readonly autodbPoolSize?: number;
    /**
    * List of parameters to ignore when given in startup packet
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/managed_database_postgresql#ignore_startup_parameters ManagedDatabasePostgresql#ignore_startup_parameters}
    */
    readonly ignoreStartupParameters?: string[];
    /**
    * Add more server connections to pool if below this number. Improves behavior when usual load comes suddenly back after period of total inactivity. The value is effectively capped at the pool size.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/managed_database_postgresql#min_pool_size ManagedDatabasePostgresql#min_pool_size}
    */
    readonly minPoolSize?: number;
    /**
    * If a server connection has been idle more than this many seconds it will be dropped. If 0 then timeout is disabled. [seconds]
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/managed_database_postgresql#server_idle_timeout ManagedDatabasePostgresql#server_idle_timeout}
    */
    readonly serverIdleTimeout?: number;
    /**
    * The pooler will close an unused server connection that has been connected longer than this. [seconds]
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/managed_database_postgresql#server_lifetime ManagedDatabasePostgresql#server_lifetime}
    */
    readonly serverLifetime?: number;
    /**
    * Run server_reset_query (DISCARD ALL) in all pooling modes
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/managed_database_postgresql#server_reset_query_always ManagedDatabasePostgresql#server_reset_query_always}
    */
    readonly serverResetQueryAlways?: boolean | cdktf.IResolvable;
}
export declare function managedDatabasePostgresqlPropertiesPgbouncerToTerraform(struct?: ManagedDatabasePostgresqlPropertiesPgbouncerOutputReference | ManagedDatabasePostgresqlPropertiesPgbouncer): any;
export declare class ManagedDatabasePostgresqlPropertiesPgbouncerOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ManagedDatabasePostgresqlPropertiesPgbouncer | undefined;
    set internalValue(value: ManagedDatabasePostgresqlPropertiesPgbouncer | undefined);
    private _autodbIdleTimeout?;
    get autodbIdleTimeout(): number;
    set autodbIdleTimeout(value: number);
    resetAutodbIdleTimeout(): void;
    get autodbIdleTimeoutInput(): number | undefined;
    private _autodbMaxDbConnections?;
    get autodbMaxDbConnections(): number;
    set autodbMaxDbConnections(value: number);
    resetAutodbMaxDbConnections(): void;
    get autodbMaxDbConnectionsInput(): number | undefined;
    private _autodbPoolMode?;
    get autodbPoolMode(): string;
    set autodbPoolMode(value: string);
    resetAutodbPoolMode(): void;
    get autodbPoolModeInput(): string | undefined;
    private _autodbPoolSize?;
    get autodbPoolSize(): number;
    set autodbPoolSize(value: number);
    resetAutodbPoolSize(): void;
    get autodbPoolSizeInput(): number | undefined;
    private _ignoreStartupParameters?;
    get ignoreStartupParameters(): string[];
    set ignoreStartupParameters(value: string[]);
    resetIgnoreStartupParameters(): void;
    get ignoreStartupParametersInput(): string[] | undefined;
    private _minPoolSize?;
    get minPoolSize(): number;
    set minPoolSize(value: number);
    resetMinPoolSize(): void;
    get minPoolSizeInput(): number | undefined;
    private _serverIdleTimeout?;
    get serverIdleTimeout(): number;
    set serverIdleTimeout(value: number);
    resetServerIdleTimeout(): void;
    get serverIdleTimeoutInput(): number | undefined;
    private _serverLifetime?;
    get serverLifetime(): number;
    set serverLifetime(value: number);
    resetServerLifetime(): void;
    get serverLifetimeInput(): number | undefined;
    private _serverResetQueryAlways?;
    get serverResetQueryAlways(): boolean | cdktf.IResolvable;
    set serverResetQueryAlways(value: boolean | cdktf.IResolvable);
    resetServerResetQueryAlways(): void;
    get serverResetQueryAlwaysInput(): boolean | cdktf.IResolvable | undefined;
}
export interface ManagedDatabasePostgresqlPropertiesPglookout {
    /**
    * max_failover_replication_time_lag
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/managed_database_postgresql#max_failover_replication_time_lag ManagedDatabasePostgresql#max_failover_replication_time_lag}
    */
    readonly maxFailoverReplicationTimeLag?: number;
}
export declare function managedDatabasePostgresqlPropertiesPglookoutToTerraform(struct?: ManagedDatabasePostgresqlPropertiesPglookoutOutputReference | ManagedDatabasePostgresqlPropertiesPglookout): any;
export declare class ManagedDatabasePostgresqlPropertiesPglookoutOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ManagedDatabasePostgresqlPropertiesPglookout | undefined;
    set internalValue(value: ManagedDatabasePostgresqlPropertiesPglookout | undefined);
    private _maxFailoverReplicationTimeLag?;
    get maxFailoverReplicationTimeLag(): number;
    set maxFailoverReplicationTimeLag(value: number);
    resetMaxFailoverReplicationTimeLag(): void;
    get maxFailoverReplicationTimeLagInput(): number | undefined;
}
export interface ManagedDatabasePostgresqlPropertiesTimescaledb {
    /**
    * timescaledb.max_background_workers
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/managed_database_postgresql#max_background_workers ManagedDatabasePostgresql#max_background_workers}
    */
    readonly maxBackgroundWorkers?: number;
}
export declare function managedDatabasePostgresqlPropertiesTimescaledbToTerraform(struct?: ManagedDatabasePostgresqlPropertiesTimescaledbOutputReference | ManagedDatabasePostgresqlPropertiesTimescaledb): any;
export declare class ManagedDatabasePostgresqlPropertiesTimescaledbOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ManagedDatabasePostgresqlPropertiesTimescaledb | undefined;
    set internalValue(value: ManagedDatabasePostgresqlPropertiesTimescaledb | undefined);
    private _maxBackgroundWorkers?;
    get maxBackgroundWorkers(): number;
    set maxBackgroundWorkers(value: number);
    resetMaxBackgroundWorkers(): void;
    get maxBackgroundWorkersInput(): number | undefined;
}
export interface ManagedDatabasePostgresqlProperties {
    /**
    * Custom password for admin user. Defaults to random string. This must be set only when a new service is being created.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/managed_database_postgresql#admin_password ManagedDatabasePostgresql#admin_password}
    */
    readonly adminPassword?: string;
    /**
    * Custom username for admin user. This must be set only when a new service is being created.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/managed_database_postgresql#admin_username ManagedDatabasePostgresql#admin_username}
    */
    readonly adminUsername?: string;
    /**
    * Automatic utility network IP Filter
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/managed_database_postgresql#automatic_utility_network_ip_filter ManagedDatabasePostgresql#automatic_utility_network_ip_filter}
    */
    readonly automaticUtilityNetworkIpFilter?: boolean | cdktf.IResolvable;
    /**
    * autovacuum_analyze_scale_factor
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/managed_database_postgresql#autovacuum_analyze_scale_factor ManagedDatabasePostgresql#autovacuum_analyze_scale_factor}
    */
    readonly autovacuumAnalyzeScaleFactor?: number;
    /**
    * autovacuum_analyze_threshold
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/managed_database_postgresql#autovacuum_analyze_threshold ManagedDatabasePostgresql#autovacuum_analyze_threshold}
    */
    readonly autovacuumAnalyzeThreshold?: number;
    /**
    * autovacuum_freeze_max_age
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/managed_database_postgresql#autovacuum_freeze_max_age ManagedDatabasePostgresql#autovacuum_freeze_max_age}
    */
    readonly autovacuumFreezeMaxAge?: number;
    /**
    * autovacuum_max_workers
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/managed_database_postgresql#autovacuum_max_workers ManagedDatabasePostgresql#autovacuum_max_workers}
    */
    readonly autovacuumMaxWorkers?: number;
    /**
    * autovacuum_naptime
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/managed_database_postgresql#autovacuum_naptime ManagedDatabasePostgresql#autovacuum_naptime}
    */
    readonly autovacuumNaptime?: number;
    /**
    * autovacuum_vacuum_cost_delay
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/managed_database_postgresql#autovacuum_vacuum_cost_delay ManagedDatabasePostgresql#autovacuum_vacuum_cost_delay}
    */
    readonly autovacuumVacuumCostDelay?: number;
    /**
    * autovacuum_vacuum_cost_limit
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/managed_database_postgresql#autovacuum_vacuum_cost_limit ManagedDatabasePostgresql#autovacuum_vacuum_cost_limit}
    */
    readonly autovacuumVacuumCostLimit?: number;
    /**
    * autovacuum_vacuum_scale_factor
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/managed_database_postgresql#autovacuum_vacuum_scale_factor ManagedDatabasePostgresql#autovacuum_vacuum_scale_factor}
    */
    readonly autovacuumVacuumScaleFactor?: number;
    /**
    * autovacuum_vacuum_threshold
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/managed_database_postgresql#autovacuum_vacuum_threshold ManagedDatabasePostgresql#autovacuum_vacuum_threshold}
    */
    readonly autovacuumVacuumThreshold?: number;
    /**
    * The hour of day (in UTC) when backup for the service is started. New backup is only started if previous backup has already completed.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/managed_database_postgresql#backup_hour ManagedDatabasePostgresql#backup_hour}
    */
    readonly backupHour?: number;
    /**
    * The minute of an hour when backup for the service is started. New backup is only started if previous backup has already completed.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/managed_database_postgresql#backup_minute ManagedDatabasePostgresql#backup_minute}
    */
    readonly backupMinute?: number;
    /**
    * bgwriter_delay
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/managed_database_postgresql#bgwriter_delay ManagedDatabasePostgresql#bgwriter_delay}
    */
    readonly bgwriterDelay?: number;
    /**
    * bgwriter_flush_after
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/managed_database_postgresql#bgwriter_flush_after ManagedDatabasePostgresql#bgwriter_flush_after}
    */
    readonly bgwriterFlushAfter?: number;
    /**
    * bgwriter_lru_maxpages
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/managed_database_postgresql#bgwriter_lru_maxpages ManagedDatabasePostgresql#bgwriter_lru_maxpages}
    */
    readonly bgwriterLruMaxpages?: number;
    /**
    * bgwriter_lru_multiplier
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/managed_database_postgresql#bgwriter_lru_multiplier ManagedDatabasePostgresql#bgwriter_lru_multiplier}
    */
    readonly bgwriterLruMultiplier?: number;
    /**
    * deadlock_timeout
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/managed_database_postgresql#deadlock_timeout ManagedDatabasePostgresql#deadlock_timeout}
    */
    readonly deadlockTimeout?: number;
    /**
    * idle_in_transaction_session_timeout
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/managed_database_postgresql#idle_in_transaction_session_timeout ManagedDatabasePostgresql#idle_in_transaction_session_timeout}
    */
    readonly idleInTransactionSessionTimeout?: number;
    /**
    * IP filter
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/managed_database_postgresql#ip_filter ManagedDatabasePostgresql#ip_filter}
    */
    readonly ipFilter?: string[];
    /**
    * jit
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/managed_database_postgresql#jit ManagedDatabasePostgresql#jit}
    */
    readonly jit?: boolean | cdktf.IResolvable;
    /**
    * log_autovacuum_min_duration
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/managed_database_postgresql#log_autovacuum_min_duration ManagedDatabasePostgresql#log_autovacuum_min_duration}
    */
    readonly logAutovacuumMinDuration?: number;
    /**
    * log_error_verbosity
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/managed_database_postgresql#log_error_verbosity ManagedDatabasePostgresql#log_error_verbosity}
    */
    readonly logErrorVerbosity?: string;
    /**
    * log_line_prefix
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/managed_database_postgresql#log_line_prefix ManagedDatabasePostgresql#log_line_prefix}
    */
    readonly logLinePrefix?: string;
    /**
    * log_min_duration_statement
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/managed_database_postgresql#log_min_duration_statement ManagedDatabasePostgresql#log_min_duration_statement}
    */
    readonly logMinDurationStatement?: number;
    /**
    * max_files_per_process
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/managed_database_postgresql#max_files_per_process ManagedDatabasePostgresql#max_files_per_process}
    */
    readonly maxFilesPerProcess?: number;
    /**
    * max_locks_per_transaction
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/managed_database_postgresql#max_locks_per_transaction ManagedDatabasePostgresql#max_locks_per_transaction}
    */
    readonly maxLocksPerTransaction?: number;
    /**
    * max_logical_replication_workers
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/managed_database_postgresql#max_logical_replication_workers ManagedDatabasePostgresql#max_logical_replication_workers}
    */
    readonly maxLogicalReplicationWorkers?: number;
    /**
    * max_parallel_workers
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/managed_database_postgresql#max_parallel_workers ManagedDatabasePostgresql#max_parallel_workers}
    */
    readonly maxParallelWorkers?: number;
    /**
    * max_parallel_workers_per_gather
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/managed_database_postgresql#max_parallel_workers_per_gather ManagedDatabasePostgresql#max_parallel_workers_per_gather}
    */
    readonly maxParallelWorkersPerGather?: number;
    /**
    * max_pred_locks_per_transaction
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/managed_database_postgresql#max_pred_locks_per_transaction ManagedDatabasePostgresql#max_pred_locks_per_transaction}
    */
    readonly maxPredLocksPerTransaction?: number;
    /**
    * max_prepared_transactions
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/managed_database_postgresql#max_prepared_transactions ManagedDatabasePostgresql#max_prepared_transactions}
    */
    readonly maxPreparedTransactions?: number;
    /**
    * max_replication_slots
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/managed_database_postgresql#max_replication_slots ManagedDatabasePostgresql#max_replication_slots}
    */
    readonly maxReplicationSlots?: number;
    /**
    * max_stack_depth
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/managed_database_postgresql#max_stack_depth ManagedDatabasePostgresql#max_stack_depth}
    */
    readonly maxStackDepth?: number;
    /**
    * max_standby_archive_delay
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/managed_database_postgresql#max_standby_archive_delay ManagedDatabasePostgresql#max_standby_archive_delay}
    */
    readonly maxStandbyArchiveDelay?: number;
    /**
    * max_standby_streaming_delay
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/managed_database_postgresql#max_standby_streaming_delay ManagedDatabasePostgresql#max_standby_streaming_delay}
    */
    readonly maxStandbyStreamingDelay?: number;
    /**
    * max_wal_senders
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/managed_database_postgresql#max_wal_senders ManagedDatabasePostgresql#max_wal_senders}
    */
    readonly maxWalSenders?: number;
    /**
    * max_worker_processes
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/managed_database_postgresql#max_worker_processes ManagedDatabasePostgresql#max_worker_processes}
    */
    readonly maxWorkerProcesses?: number;
    /**
    * pg_partman_bgw.interval
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/managed_database_postgresql#pg_partman_bgw_interval ManagedDatabasePostgresql#pg_partman_bgw_interval}
    */
    readonly pgPartmanBgwInterval?: number;
    /**
    * pg_partman_bgw.role
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/managed_database_postgresql#pg_partman_bgw_role ManagedDatabasePostgresql#pg_partman_bgw_role}
    */
    readonly pgPartmanBgwRole?: string;
    /**
    * Should the service which is being forked be a read replica
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/managed_database_postgresql#pg_read_replica ManagedDatabasePostgresql#pg_read_replica}
    */
    readonly pgReadReplica?: boolean | cdktf.IResolvable;
    /**
    * Name of the PG Service from which to fork (deprecated, use service_to_fork_from). This has effect only when a new service is being created.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/managed_database_postgresql#pg_service_to_fork_from ManagedDatabasePostgresql#pg_service_to_fork_from}
    */
    readonly pgServiceToForkFrom?: string;
    /**
    * pg_stat_statements.track
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/managed_database_postgresql#pg_stat_statements_track ManagedDatabasePostgresql#pg_stat_statements_track}
    */
    readonly pgStatStatementsTrack?: string;
    /**
    * Public Access
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/managed_database_postgresql#public_access ManagedDatabasePostgresql#public_access}
    */
    readonly publicAccess?: boolean | cdktf.IResolvable;
    /**
    * shared_buffers_percentage
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/managed_database_postgresql#shared_buffers_percentage ManagedDatabasePostgresql#shared_buffers_percentage}
    */
    readonly sharedBuffersPercentage?: number;
    /**
    * Synchronous replication type. Note that the service plan also needs to support synchronous replication.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/managed_database_postgresql#synchronous_replication ManagedDatabasePostgresql#synchronous_replication}
    */
    readonly synchronousReplication?: string;
    /**
    * temp_file_limit
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/managed_database_postgresql#temp_file_limit ManagedDatabasePostgresql#temp_file_limit}
    */
    readonly tempFileLimit?: number;
    /**
    * timezone
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/managed_database_postgresql#timezone ManagedDatabasePostgresql#timezone}
    */
    readonly timezone?: string;
    /**
    * track_activity_query_size
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/managed_database_postgresql#track_activity_query_size ManagedDatabasePostgresql#track_activity_query_size}
    */
    readonly trackActivityQuerySize?: number;
    /**
    * track_commit_timestamp
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/managed_database_postgresql#track_commit_timestamp ManagedDatabasePostgresql#track_commit_timestamp}
    */
    readonly trackCommitTimestamp?: string;
    /**
    * track_functions
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/managed_database_postgresql#track_functions ManagedDatabasePostgresql#track_functions}
    */
    readonly trackFunctions?: string;
    /**
    * track_io_timing
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/managed_database_postgresql#track_io_timing ManagedDatabasePostgresql#track_io_timing}
    */
    readonly trackIoTiming?: string;
    /**
    * Variant of the PostgreSQL service, may affect the features that are exposed by default
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/managed_database_postgresql#variant ManagedDatabasePostgresql#variant}
    */
    readonly variant?: string;
    /**
    * PostgreSQL major version
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/managed_database_postgresql#version ManagedDatabasePostgresql#version}
    */
    readonly version?: string;
    /**
    * wal_sender_timeout
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/managed_database_postgresql#wal_sender_timeout ManagedDatabasePostgresql#wal_sender_timeout}
    */
    readonly walSenderTimeout?: number;
    /**
    * wal_writer_delay
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/managed_database_postgresql#wal_writer_delay ManagedDatabasePostgresql#wal_writer_delay}
    */
    readonly walWriterDelay?: number;
    /**
    * work_mem
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/managed_database_postgresql#work_mem ManagedDatabasePostgresql#work_mem}
    */
    readonly workMem?: number;
    /**
    * migration block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/managed_database_postgresql#migration ManagedDatabasePostgresql#migration}
    */
    readonly migration?: ManagedDatabasePostgresqlPropertiesMigration;
    /**
    * pgbouncer block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/managed_database_postgresql#pgbouncer ManagedDatabasePostgresql#pgbouncer}
    */
    readonly pgbouncer?: ManagedDatabasePostgresqlPropertiesPgbouncer;
    /**
    * pglookout block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/managed_database_postgresql#pglookout ManagedDatabasePostgresql#pglookout}
    */
    readonly pglookout?: ManagedDatabasePostgresqlPropertiesPglookout;
    /**
    * timescaledb block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/managed_database_postgresql#timescaledb ManagedDatabasePostgresql#timescaledb}
    */
    readonly timescaledb?: ManagedDatabasePostgresqlPropertiesTimescaledb;
}
export declare function managedDatabasePostgresqlPropertiesToTerraform(struct?: ManagedDatabasePostgresqlPropertiesOutputReference | ManagedDatabasePostgresqlProperties): any;
export declare class ManagedDatabasePostgresqlPropertiesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ManagedDatabasePostgresqlProperties | undefined;
    set internalValue(value: ManagedDatabasePostgresqlProperties | undefined);
    private _adminPassword?;
    get adminPassword(): string;
    set adminPassword(value: string);
    resetAdminPassword(): void;
    get adminPasswordInput(): string | undefined;
    private _adminUsername?;
    get adminUsername(): string;
    set adminUsername(value: string);
    resetAdminUsername(): void;
    get adminUsernameInput(): string | undefined;
    private _automaticUtilityNetworkIpFilter?;
    get automaticUtilityNetworkIpFilter(): boolean | cdktf.IResolvable;
    set automaticUtilityNetworkIpFilter(value: boolean | cdktf.IResolvable);
    resetAutomaticUtilityNetworkIpFilter(): void;
    get automaticUtilityNetworkIpFilterInput(): boolean | cdktf.IResolvable | undefined;
    private _autovacuumAnalyzeScaleFactor?;
    get autovacuumAnalyzeScaleFactor(): number;
    set autovacuumAnalyzeScaleFactor(value: number);
    resetAutovacuumAnalyzeScaleFactor(): void;
    get autovacuumAnalyzeScaleFactorInput(): number | undefined;
    private _autovacuumAnalyzeThreshold?;
    get autovacuumAnalyzeThreshold(): number;
    set autovacuumAnalyzeThreshold(value: number);
    resetAutovacuumAnalyzeThreshold(): void;
    get autovacuumAnalyzeThresholdInput(): number | undefined;
    private _autovacuumFreezeMaxAge?;
    get autovacuumFreezeMaxAge(): number;
    set autovacuumFreezeMaxAge(value: number);
    resetAutovacuumFreezeMaxAge(): void;
    get autovacuumFreezeMaxAgeInput(): number | undefined;
    private _autovacuumMaxWorkers?;
    get autovacuumMaxWorkers(): number;
    set autovacuumMaxWorkers(value: number);
    resetAutovacuumMaxWorkers(): void;
    get autovacuumMaxWorkersInput(): number | undefined;
    private _autovacuumNaptime?;
    get autovacuumNaptime(): number;
    set autovacuumNaptime(value: number);
    resetAutovacuumNaptime(): void;
    get autovacuumNaptimeInput(): number | undefined;
    private _autovacuumVacuumCostDelay?;
    get autovacuumVacuumCostDelay(): number;
    set autovacuumVacuumCostDelay(value: number);
    resetAutovacuumVacuumCostDelay(): void;
    get autovacuumVacuumCostDelayInput(): number | undefined;
    private _autovacuumVacuumCostLimit?;
    get autovacuumVacuumCostLimit(): number;
    set autovacuumVacuumCostLimit(value: number);
    resetAutovacuumVacuumCostLimit(): void;
    get autovacuumVacuumCostLimitInput(): number | undefined;
    private _autovacuumVacuumScaleFactor?;
    get autovacuumVacuumScaleFactor(): number;
    set autovacuumVacuumScaleFactor(value: number);
    resetAutovacuumVacuumScaleFactor(): void;
    get autovacuumVacuumScaleFactorInput(): number | undefined;
    private _autovacuumVacuumThreshold?;
    get autovacuumVacuumThreshold(): number;
    set autovacuumVacuumThreshold(value: number);
    resetAutovacuumVacuumThreshold(): void;
    get autovacuumVacuumThresholdInput(): number | undefined;
    private _backupHour?;
    get backupHour(): number;
    set backupHour(value: number);
    resetBackupHour(): void;
    get backupHourInput(): number | undefined;
    private _backupMinute?;
    get backupMinute(): number;
    set backupMinute(value: number);
    resetBackupMinute(): void;
    get backupMinuteInput(): number | undefined;
    private _bgwriterDelay?;
    get bgwriterDelay(): number;
    set bgwriterDelay(value: number);
    resetBgwriterDelay(): void;
    get bgwriterDelayInput(): number | undefined;
    private _bgwriterFlushAfter?;
    get bgwriterFlushAfter(): number;
    set bgwriterFlushAfter(value: number);
    resetBgwriterFlushAfter(): void;
    get bgwriterFlushAfterInput(): number | undefined;
    private _bgwriterLruMaxpages?;
    get bgwriterLruMaxpages(): number;
    set bgwriterLruMaxpages(value: number);
    resetBgwriterLruMaxpages(): void;
    get bgwriterLruMaxpagesInput(): number | undefined;
    private _bgwriterLruMultiplier?;
    get bgwriterLruMultiplier(): number;
    set bgwriterLruMultiplier(value: number);
    resetBgwriterLruMultiplier(): void;
    get bgwriterLruMultiplierInput(): number | undefined;
    private _deadlockTimeout?;
    get deadlockTimeout(): number;
    set deadlockTimeout(value: number);
    resetDeadlockTimeout(): void;
    get deadlockTimeoutInput(): number | undefined;
    private _idleInTransactionSessionTimeout?;
    get idleInTransactionSessionTimeout(): number;
    set idleInTransactionSessionTimeout(value: number);
    resetIdleInTransactionSessionTimeout(): void;
    get idleInTransactionSessionTimeoutInput(): number | undefined;
    private _ipFilter?;
    get ipFilter(): string[];
    set ipFilter(value: string[]);
    resetIpFilter(): void;
    get ipFilterInput(): string[] | undefined;
    private _jit?;
    get jit(): boolean | cdktf.IResolvable;
    set jit(value: boolean | cdktf.IResolvable);
    resetJit(): void;
    get jitInput(): boolean | cdktf.IResolvable | undefined;
    private _logAutovacuumMinDuration?;
    get logAutovacuumMinDuration(): number;
    set logAutovacuumMinDuration(value: number);
    resetLogAutovacuumMinDuration(): void;
    get logAutovacuumMinDurationInput(): number | undefined;
    private _logErrorVerbosity?;
    get logErrorVerbosity(): string;
    set logErrorVerbosity(value: string);
    resetLogErrorVerbosity(): void;
    get logErrorVerbosityInput(): string | undefined;
    private _logLinePrefix?;
    get logLinePrefix(): string;
    set logLinePrefix(value: string);
    resetLogLinePrefix(): void;
    get logLinePrefixInput(): string | undefined;
    private _logMinDurationStatement?;
    get logMinDurationStatement(): number;
    set logMinDurationStatement(value: number);
    resetLogMinDurationStatement(): void;
    get logMinDurationStatementInput(): number | undefined;
    private _maxFilesPerProcess?;
    get maxFilesPerProcess(): number;
    set maxFilesPerProcess(value: number);
    resetMaxFilesPerProcess(): void;
    get maxFilesPerProcessInput(): number | undefined;
    private _maxLocksPerTransaction?;
    get maxLocksPerTransaction(): number;
    set maxLocksPerTransaction(value: number);
    resetMaxLocksPerTransaction(): void;
    get maxLocksPerTransactionInput(): number | undefined;
    private _maxLogicalReplicationWorkers?;
    get maxLogicalReplicationWorkers(): number;
    set maxLogicalReplicationWorkers(value: number);
    resetMaxLogicalReplicationWorkers(): void;
    get maxLogicalReplicationWorkersInput(): number | undefined;
    private _maxParallelWorkers?;
    get maxParallelWorkers(): number;
    set maxParallelWorkers(value: number);
    resetMaxParallelWorkers(): void;
    get maxParallelWorkersInput(): number | undefined;
    private _maxParallelWorkersPerGather?;
    get maxParallelWorkersPerGather(): number;
    set maxParallelWorkersPerGather(value: number);
    resetMaxParallelWorkersPerGather(): void;
    get maxParallelWorkersPerGatherInput(): number | undefined;
    private _maxPredLocksPerTransaction?;
    get maxPredLocksPerTransaction(): number;
    set maxPredLocksPerTransaction(value: number);
    resetMaxPredLocksPerTransaction(): void;
    get maxPredLocksPerTransactionInput(): number | undefined;
    private _maxPreparedTransactions?;
    get maxPreparedTransactions(): number;
    set maxPreparedTransactions(value: number);
    resetMaxPreparedTransactions(): void;
    get maxPreparedTransactionsInput(): number | undefined;
    private _maxReplicationSlots?;
    get maxReplicationSlots(): number;
    set maxReplicationSlots(value: number);
    resetMaxReplicationSlots(): void;
    get maxReplicationSlotsInput(): number | undefined;
    private _maxStackDepth?;
    get maxStackDepth(): number;
    set maxStackDepth(value: number);
    resetMaxStackDepth(): void;
    get maxStackDepthInput(): number | undefined;
    private _maxStandbyArchiveDelay?;
    get maxStandbyArchiveDelay(): number;
    set maxStandbyArchiveDelay(value: number);
    resetMaxStandbyArchiveDelay(): void;
    get maxStandbyArchiveDelayInput(): number | undefined;
    private _maxStandbyStreamingDelay?;
    get maxStandbyStreamingDelay(): number;
    set maxStandbyStreamingDelay(value: number);
    resetMaxStandbyStreamingDelay(): void;
    get maxStandbyStreamingDelayInput(): number | undefined;
    private _maxWalSenders?;
    get maxWalSenders(): number;
    set maxWalSenders(value: number);
    resetMaxWalSenders(): void;
    get maxWalSendersInput(): number | undefined;
    private _maxWorkerProcesses?;
    get maxWorkerProcesses(): number;
    set maxWorkerProcesses(value: number);
    resetMaxWorkerProcesses(): void;
    get maxWorkerProcessesInput(): number | undefined;
    private _pgPartmanBgwInterval?;
    get pgPartmanBgwInterval(): number;
    set pgPartmanBgwInterval(value: number);
    resetPgPartmanBgwInterval(): void;
    get pgPartmanBgwIntervalInput(): number | undefined;
    private _pgPartmanBgwRole?;
    get pgPartmanBgwRole(): string;
    set pgPartmanBgwRole(value: string);
    resetPgPartmanBgwRole(): void;
    get pgPartmanBgwRoleInput(): string | undefined;
    private _pgReadReplica?;
    get pgReadReplica(): boolean | cdktf.IResolvable;
    set pgReadReplica(value: boolean | cdktf.IResolvable);
    resetPgReadReplica(): void;
    get pgReadReplicaInput(): boolean | cdktf.IResolvable | undefined;
    private _pgServiceToForkFrom?;
    get pgServiceToForkFrom(): string;
    set pgServiceToForkFrom(value: string);
    resetPgServiceToForkFrom(): void;
    get pgServiceToForkFromInput(): string | undefined;
    private _pgStatStatementsTrack?;
    get pgStatStatementsTrack(): string;
    set pgStatStatementsTrack(value: string);
    resetPgStatStatementsTrack(): void;
    get pgStatStatementsTrackInput(): string | undefined;
    private _publicAccess?;
    get publicAccess(): boolean | cdktf.IResolvable;
    set publicAccess(value: boolean | cdktf.IResolvable);
    resetPublicAccess(): void;
    get publicAccessInput(): boolean | cdktf.IResolvable | undefined;
    private _sharedBuffersPercentage?;
    get sharedBuffersPercentage(): number;
    set sharedBuffersPercentage(value: number);
    resetSharedBuffersPercentage(): void;
    get sharedBuffersPercentageInput(): number | undefined;
    private _synchronousReplication?;
    get synchronousReplication(): string;
    set synchronousReplication(value: string);
    resetSynchronousReplication(): void;
    get synchronousReplicationInput(): string | undefined;
    private _tempFileLimit?;
    get tempFileLimit(): number;
    set tempFileLimit(value: number);
    resetTempFileLimit(): void;
    get tempFileLimitInput(): number | undefined;
    private _timezone?;
    get timezone(): string;
    set timezone(value: string);
    resetTimezone(): void;
    get timezoneInput(): string | undefined;
    private _trackActivityQuerySize?;
    get trackActivityQuerySize(): number;
    set trackActivityQuerySize(value: number);
    resetTrackActivityQuerySize(): void;
    get trackActivityQuerySizeInput(): number | undefined;
    private _trackCommitTimestamp?;
    get trackCommitTimestamp(): string;
    set trackCommitTimestamp(value: string);
    resetTrackCommitTimestamp(): void;
    get trackCommitTimestampInput(): string | undefined;
    private _trackFunctions?;
    get trackFunctions(): string;
    set trackFunctions(value: string);
    resetTrackFunctions(): void;
    get trackFunctionsInput(): string | undefined;
    private _trackIoTiming?;
    get trackIoTiming(): string;
    set trackIoTiming(value: string);
    resetTrackIoTiming(): void;
    get trackIoTimingInput(): string | undefined;
    private _variant?;
    get variant(): string;
    set variant(value: string);
    resetVariant(): void;
    get variantInput(): string | undefined;
    private _version?;
    get version(): string;
    set version(value: string);
    resetVersion(): void;
    get versionInput(): string | undefined;
    private _walSenderTimeout?;
    get walSenderTimeout(): number;
    set walSenderTimeout(value: number);
    resetWalSenderTimeout(): void;
    get walSenderTimeoutInput(): number | undefined;
    private _walWriterDelay?;
    get walWriterDelay(): number;
    set walWriterDelay(value: number);
    resetWalWriterDelay(): void;
    get walWriterDelayInput(): number | undefined;
    private _workMem?;
    get workMem(): number;
    set workMem(value: number);
    resetWorkMem(): void;
    get workMemInput(): number | undefined;
    private _migration;
    get migration(): ManagedDatabasePostgresqlPropertiesMigrationOutputReference;
    putMigration(value: ManagedDatabasePostgresqlPropertiesMigration): void;
    resetMigration(): void;
    get migrationInput(): ManagedDatabasePostgresqlPropertiesMigration | undefined;
    private _pgbouncer;
    get pgbouncer(): ManagedDatabasePostgresqlPropertiesPgbouncerOutputReference;
    putPgbouncer(value: ManagedDatabasePostgresqlPropertiesPgbouncer): void;
    resetPgbouncer(): void;
    get pgbouncerInput(): ManagedDatabasePostgresqlPropertiesPgbouncer | undefined;
    private _pglookout;
    get pglookout(): ManagedDatabasePostgresqlPropertiesPglookoutOutputReference;
    putPglookout(value: ManagedDatabasePostgresqlPropertiesPglookout): void;
    resetPglookout(): void;
    get pglookoutInput(): ManagedDatabasePostgresqlPropertiesPglookout | undefined;
    private _timescaledb;
    get timescaledb(): ManagedDatabasePostgresqlPropertiesTimescaledbOutputReference;
    putTimescaledb(value: ManagedDatabasePostgresqlPropertiesTimescaledb): void;
    resetTimescaledb(): void;
    get timescaledbInput(): ManagedDatabasePostgresqlPropertiesTimescaledb | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/upcloud/r/managed_database_postgresql upcloud_managed_database_postgresql}
*/
export declare class ManagedDatabasePostgresql extends cdktf.TerraformResource {
    static readonly tfResourceType = "upcloud_managed_database_postgresql";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/upcloud/r/managed_database_postgresql upcloud_managed_database_postgresql} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ManagedDatabasePostgresqlConfig
    */
    constructor(scope: Construct, id: string, config: ManagedDatabasePostgresqlConfig);
    private _components;
    get components(): ManagedDatabasePostgresqlComponentsList;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _maintenanceWindowDow?;
    get maintenanceWindowDow(): string;
    set maintenanceWindowDow(value: string);
    resetMaintenanceWindowDow(): void;
    get maintenanceWindowDowInput(): string | undefined;
    private _maintenanceWindowTime?;
    get maintenanceWindowTime(): string;
    set maintenanceWindowTime(value: string);
    resetMaintenanceWindowTime(): void;
    get maintenanceWindowTimeInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _nodeStates;
    get nodeStates(): ManagedDatabasePostgresqlNodeStatesList;
    private _plan?;
    get plan(): string;
    set plan(value: string);
    get planInput(): string | undefined;
    private _powered?;
    get powered(): boolean | cdktf.IResolvable;
    set powered(value: boolean | cdktf.IResolvable);
    resetPowered(): void;
    get poweredInput(): boolean | cdktf.IResolvable | undefined;
    get primaryDatabase(): string;
    get serviceHost(): string;
    get servicePassword(): string;
    get servicePort(): string;
    get serviceUri(): string;
    get serviceUsername(): string;
    get sslmode(): string;
    get state(): string;
    private _title?;
    get title(): string;
    set title(value: string);
    resetTitle(): void;
    get titleInput(): string | undefined;
    get type(): string;
    private _zone?;
    get zone(): string;
    set zone(value: string);
    get zoneInput(): string | undefined;
    private _properties;
    get properties(): ManagedDatabasePostgresqlPropertiesOutputReference;
    putProperties(value: ManagedDatabasePostgresqlProperties): void;
    resetProperties(): void;
    get propertiesInput(): ManagedDatabasePostgresqlProperties | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
//# sourceMappingURL=managed-database-postgresql.d.ts.map