import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface NetworkConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/network#id Network#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * A valid name for the network
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/network#name Network#name}
    */
    readonly name: string;
    /**
    * The UUID of a router
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/network#router Network#router}
    */
    readonly router?: string;
    /**
    * The zone the network is in
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/network#zone Network#zone}
    */
    readonly zone: string;
    /**
    * ip_network block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/network#ip_network Network#ip_network}
    */
    readonly ipNetwork: NetworkIpNetwork;
}
export interface NetworkIpNetwork {
    /**
    * The CIDR range of the subnet
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/network#address Network#address}
    */
    readonly address: string;
    /**
    * Is DHCP enabled?
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/network#dhcp Network#dhcp}
    */
    readonly dhcp: boolean | cdktf.IResolvable;
    /**
    * Is the gateway the DHCP default route?
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/network#dhcp_default_route Network#dhcp_default_route}
    */
    readonly dhcpDefaultRoute?: boolean | cdktf.IResolvable;
    /**
    * The DNS servers given by DHCP
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/network#dhcp_dns Network#dhcp_dns}
    */
    readonly dhcpDns?: string[];
    /**
    * IP address family
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/network#family Network#family}
    */
    readonly family: string;
    /**
    * Gateway address given by DHCP
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/network#gateway Network#gateway}
    */
    readonly gateway?: string;
}
export declare function networkIpNetworkToTerraform(struct?: NetworkIpNetworkOutputReference | NetworkIpNetwork): any;
export declare class NetworkIpNetworkOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): NetworkIpNetwork | undefined;
    set internalValue(value: NetworkIpNetwork | undefined);
    private _address?;
    get address(): string;
    set address(value: string);
    get addressInput(): string | undefined;
    private _dhcp?;
    get dhcp(): boolean | cdktf.IResolvable;
    set dhcp(value: boolean | cdktf.IResolvable);
    get dhcpInput(): boolean | cdktf.IResolvable | undefined;
    private _dhcpDefaultRoute?;
    get dhcpDefaultRoute(): boolean | cdktf.IResolvable;
    set dhcpDefaultRoute(value: boolean | cdktf.IResolvable);
    resetDhcpDefaultRoute(): void;
    get dhcpDefaultRouteInput(): boolean | cdktf.IResolvable | undefined;
    private _dhcpDns?;
    get dhcpDns(): string[];
    set dhcpDns(value: string[]);
    resetDhcpDns(): void;
    get dhcpDnsInput(): string[] | undefined;
    private _family?;
    get family(): string;
    set family(value: string);
    get familyInput(): string | undefined;
    private _gateway?;
    get gateway(): string;
    set gateway(value: string);
    resetGateway(): void;
    get gatewayInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/upcloud/r/network upcloud_network}
*/
export declare class Network extends cdktf.TerraformResource {
    static readonly tfResourceType = "upcloud_network";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/upcloud/r/network upcloud_network} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options NetworkConfig
    */
    constructor(scope: Construct, id: string, config: NetworkConfig);
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _router?;
    get router(): string;
    set router(value: string);
    resetRouter(): void;
    get routerInput(): string | undefined;
    get type(): string;
    private _zone?;
    get zone(): string;
    set zone(value: string);
    get zoneInput(): string | undefined;
    private _ipNetwork;
    get ipNetwork(): NetworkIpNetworkOutputReference;
    putIpNetwork(value: NetworkIpNetwork): void;
    get ipNetworkInput(): NetworkIpNetwork | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
//# sourceMappingURL=network.d.ts.map