import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface StorageConfig extends cdktf.TerraformMetaArguments {
    /**
    * If set to true, the backup taken before the partition and filesystem resize attempt will be deleted immediately after success.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/storage#delete_autoresize_backup Storage#delete_autoresize_backup}
    */
    readonly deleteAutoresizeBackup?: boolean | cdktf.IResolvable;
    /**
    * If set to true, provider will attempt to resize partition and filesystem when the size of the storage changes.
                  Please note that before the resize attempt is made, backup of the storage will be taken. If the resize attempt fails, the backup will be used
                  to restore the storage and then deleted. If the resize attempt succeeds, backup will be kept (unless delete_autoresize_backup option is set to true).
                  Taking and keeping backups incure costs.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/storage#filesystem_autoresize Storage#filesystem_autoresize}
    */
    readonly filesystemAutoresize?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/storage#id Storage#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The size of the storage in gigabytes
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/storage#size Storage#size}
    */
    readonly size: number;
    /**
    * The storage tier to use
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/storage#tier Storage#tier}
    */
    readonly tier?: string;
    /**
    * A short, informative description
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/storage#title Storage#title}
    */
    readonly title: string;
    /**
    * The zone in which the storage will be created
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/storage#zone Storage#zone}
    */
    readonly zone: string;
    /**
    * backup_rule block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/storage#backup_rule Storage#backup_rule}
    */
    readonly backupRule?: StorageBackupRule;
    /**
    * clone block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/storage#clone Storage#clone}
    */
    readonly clone?: StorageClone;
    /**
    * import block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/storage#import Storage#import}
    */
    readonly import?: StorageImport;
}
export interface StorageBackupRule {
    /**
    * The weekday when the backup is created
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/storage#interval Storage#interval}
    */
    readonly interval: string;
    /**
    * The number of days before a backup is automatically deleted
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/storage#retention Storage#retention}
    */
    readonly retention: number;
    /**
    * The time of day when the backup is created
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/storage#time Storage#time}
    */
    readonly time: string;
}
export declare function storageBackupRuleToTerraform(struct?: StorageBackupRuleOutputReference | StorageBackupRule): any;
export declare class StorageBackupRuleOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): StorageBackupRule | undefined;
    set internalValue(value: StorageBackupRule | undefined);
    private _interval?;
    get interval(): string;
    set interval(value: string);
    get intervalInput(): string | undefined;
    private _retention?;
    get retention(): number;
    set retention(value: number);
    get retentionInput(): number | undefined;
    private _time?;
    get time(): string;
    set time(value: string);
    get timeInput(): string | undefined;
}
export interface StorageClone {
    /**
    * The unique identifier of the storage/template to clone
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/storage#id Storage#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id: string;
}
export declare function storageCloneToTerraform(struct?: StorageCloneOutputReference | StorageClone): any;
export declare class StorageCloneOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): StorageClone | undefined;
    set internalValue(value: StorageClone | undefined);
    private _id?;
    get id(): string;
    set id(value: string);
    get idInput(): string | undefined;
}
export interface StorageImport {
    /**
    * The mode of the import task. One of `http_import` or `direct_upload`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/storage#source Storage#source}
    */
    readonly source: string;
    /**
    * For `direct_upload`; an optional hash of the file to upload.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/storage#source_hash Storage#source_hash}
    */
    readonly sourceHash?: string;
    /**
    * The location of the file to import. For `http_import` an accessible URL for `direct_upload` a local file.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/storage#source_location Storage#source_location}
    */
    readonly sourceLocation: string;
}
export declare function storageImportToTerraform(struct?: StorageImportOutputReference | StorageImport): any;
export declare class StorageImportOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): StorageImport | undefined;
    set internalValue(value: StorageImport | undefined);
    get sha256Sum(): string;
    private _source?;
    get source(): string;
    set source(value: string);
    get sourceInput(): string | undefined;
    private _sourceHash?;
    get sourceHash(): string;
    set sourceHash(value: string);
    resetSourceHash(): void;
    get sourceHashInput(): string | undefined;
    private _sourceLocation?;
    get sourceLocation(): string;
    set sourceLocation(value: string);
    get sourceLocationInput(): string | undefined;
    get writtenBytes(): number;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/upcloud/r/storage upcloud_storage}
*/
export declare class Storage extends cdktf.TerraformResource {
    static readonly tfResourceType = "upcloud_storage";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/upcloud/r/storage upcloud_storage} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options StorageConfig
    */
    constructor(scope: Construct, id: string, config: StorageConfig);
    private _deleteAutoresizeBackup?;
    get deleteAutoresizeBackup(): boolean | cdktf.IResolvable;
    set deleteAutoresizeBackup(value: boolean | cdktf.IResolvable);
    resetDeleteAutoresizeBackup(): void;
    get deleteAutoresizeBackupInput(): boolean | cdktf.IResolvable | undefined;
    private _filesystemAutoresize?;
    get filesystemAutoresize(): boolean | cdktf.IResolvable;
    set filesystemAutoresize(value: boolean | cdktf.IResolvable);
    resetFilesystemAutoresize(): void;
    get filesystemAutoresizeInput(): boolean | cdktf.IResolvable | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _size?;
    get size(): number;
    set size(value: number);
    get sizeInput(): number | undefined;
    private _tier?;
    get tier(): string;
    set tier(value: string);
    resetTier(): void;
    get tierInput(): string | undefined;
    private _title?;
    get title(): string;
    set title(value: string);
    get titleInput(): string | undefined;
    private _zone?;
    get zone(): string;
    set zone(value: string);
    get zoneInput(): string | undefined;
    private _backupRule;
    get backupRule(): StorageBackupRuleOutputReference;
    putBackupRule(value: StorageBackupRule): void;
    resetBackupRule(): void;
    get backupRuleInput(): StorageBackupRule | undefined;
    private _clone;
    get clone(): StorageCloneOutputReference;
    putClone(value: StorageClone): void;
    resetClone(): void;
    get cloneInput(): StorageClone | undefined;
    private _import;
    get import(): StorageImportOutputReference;
    putImport(value: StorageImport): void;
    resetImport(): void;
    get importInput(): StorageImport | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
//# sourceMappingURL=storage.d.ts.map