import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataArchiveFileConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/archive/d/file#excludes DataArchiveFile#excludes}
    */
    readonly excludes?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/archive/d/file#id DataArchiveFile#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/archive/d/file#output_file_mode DataArchiveFile#output_file_mode}
    */
    readonly outputFileMode?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/archive/d/file#output_path DataArchiveFile#output_path}
    */
    readonly outputPath: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/archive/d/file#source_content DataArchiveFile#source_content}
    */
    readonly sourceContent?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/archive/d/file#source_content_filename DataArchiveFile#source_content_filename}
    */
    readonly sourceContentFilename?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/archive/d/file#source_dir DataArchiveFile#source_dir}
    */
    readonly sourceDir?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/archive/d/file#source_file DataArchiveFile#source_file}
    */
    readonly sourceFile?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/archive/d/file#type DataArchiveFile#type}
    */
    readonly type: string;
    /**
    * source block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/archive/d/file#source DataArchiveFile#source}
    */
    readonly source?: DataArchiveFileSource[] | cdktf.IResolvable;
}
export interface DataArchiveFileSource {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/archive/d/file#content DataArchiveFile#content}
    */
    readonly content: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/archive/d/file#filename DataArchiveFile#filename}
    */
    readonly filename: string;
}
export declare function dataArchiveFileSourceToTerraform(struct?: DataArchiveFileSource | cdktf.IResolvable): any;
export declare class DataArchiveFileSourceOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataArchiveFileSource | cdktf.IResolvable | undefined;
    set internalValue(value: DataArchiveFileSource | cdktf.IResolvable | undefined);
    private _content?;
    get content(): string;
    set content(value: string);
    get contentInput(): string | undefined;
    private _filename?;
    get filename(): string;
    set filename(value: string);
    get filenameInput(): string | undefined;
}
export declare class DataArchiveFileSourceList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: DataArchiveFileSource[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataArchiveFileSourceOutputReference;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/archive/d/file archive_file}
*/
export declare class DataArchiveFile extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "archive_file";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/archive/d/file archive_file} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataArchiveFileConfig
    */
    constructor(scope: Construct, id: string, config: DataArchiveFileConfig);
    private _excludes?;
    get excludes(): string[];
    set excludes(value: string[]);
    resetExcludes(): void;
    get excludesInput(): string[] | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get outputBase64Sha256(): string;
    private _outputFileMode?;
    get outputFileMode(): string;
    set outputFileMode(value: string);
    resetOutputFileMode(): void;
    get outputFileModeInput(): string | undefined;
    get outputMd5(): string;
    private _outputPath?;
    get outputPath(): string;
    set outputPath(value: string);
    get outputPathInput(): string | undefined;
    get outputSha(): string;
    get outputSize(): number;
    private _sourceContent?;
    get sourceContent(): string;
    set sourceContent(value: string);
    resetSourceContent(): void;
    get sourceContentInput(): string | undefined;
    private _sourceContentFilename?;
    get sourceContentFilename(): string;
    set sourceContentFilename(value: string);
    resetSourceContentFilename(): void;
    get sourceContentFilenameInput(): string | undefined;
    private _sourceDir?;
    get sourceDir(): string;
    set sourceDir(value: string);
    resetSourceDir(): void;
    get sourceDirInput(): string | undefined;
    private _sourceFile?;
    get sourceFile(): string;
    set sourceFile(value: string);
    resetSourceFile(): void;
    get sourceFileInput(): string | undefined;
    private _type?;
    get type(): string;
    set type(value: string);
    get typeInput(): string | undefined;
    private _source;
    get source(): DataArchiveFileSourceList;
    putSource(value: DataArchiveFileSource[] | cdktf.IResolvable): void;
    resetSource(): void;
    get sourceInput(): cdktf.IResolvable | DataArchiveFileSource[] | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
