# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['pydantic_settings', 'pydantic_settings.decoder']

package_data = \
{'': ['*']}

install_requires = \
['attrs>=19.1,<20.0',
 'class-doc==0.2.0b',
 'pydantic',
 'pyyaml>=5.1.2,<6.0.0',
 'tomlkit>=0.5.5,<0.6.0',
 'typing-extensions>=3.7.4,<4.0.0']

setup_kwargs = {
    'name': 'pydantic-settings',
    'version': '0.2.5',
    'description': 'Hipster-orgazmic tool to mange application settings',
    'long_description': '..\n    AUTOGENERATED DO NOT MODIFY\n\nPydantic settings\n*****************\n\n..\n\n   Hipster-orgazmic tool to mange application settings\n\n.. image:: https://travis-ci.com/danields761/pydantic-settings.svg?branch=master\n   :target: https://travis-ci.com/danields761/pydantic-settings\n.. image:: https://badge.fury.io/py/pydantic-settings.svg\n   :target: https://badge.fury.io/py/pydantic-settings\n.. image:: https://readthedocs.org/projects/pydantic-settings/badge/?version=latest\n   :target: https://pydantic-settings.readthedocs.io/en/latest/?badge=latest\n\nLibrary which extends `pydantic <https://github.com/samuelcolvin/pydantic>`_ functionality in scope of application settings. *Pydantic* already have settings\nimplementation, e.g. ``pydantic.BaseSettings``, but from my point it’s missing some useful features:\n\n1. Overriding settings values by environment variables even for nested fields\n\n2. Providing detailed information about value location inside a loaded file or environment variable, which helps to point user mistake\n\n3. Documenting model fields isn’t feels comfortable, but it’s really essential to write comprehensive documentation for application settings\n\n..\n\n   **NOTE:** Beta quality\n\n\nInstallation\n============\n\nUsing pip:\n\n.. code-block:: sh\n\n   pip install pydantic-settings\n\n\nUsage example\n=============\n\n\nOverride values by env variables\n--------------------------------\n\nAllows to override values for nested fields if they are represented as *pydantic* model.\n\nHere is example:\n\n.. code-block:: python\n\n   from pydantic import BaseModel\n   from pydantic_settings import BaseSettingsModel, load_settings\n\n\n   class ComponentOptions(BaseModel):\n       val: str\n\n\n   class AppSettings(BaseSettingsModel):\n       class Config:\n           env_prefix = \'FOO\'\n\n       component: ComponentOptions\n\n\n   assert (\n       load_settings(\n           AppSettings,\n           \'{}\',\n           load_env=True,\n           type_hint=\'json\',\n           environ={\'FOO_COMPONENT_VAL\': \'SOME VALUE\'},\n       ).component.val\n       == \'SOME VALUE\'\n   )\n\n\nPoint exact error location inside file\n--------------------------------------\n\n.. code-block:: python\n\n   from pydantic import ValidationError, IntegerError\n   from pydantic_settings import BaseSettingsModel, load_settings, TextLocation\n   from pydantic_settings.errors import ExtendedErrorWrapper\n\n\n   class Foo(BaseSettingsModel):\n       val: int\n\n\n   try:\n       load_settings(Foo, \'{"val": "NOT AN INT"}\', type_hint=\'json\')\n   except ValidationError as e:\n       err_wrapper, *_ = e.raw_errors\n       assert isinstance(err_wrapper, ExtendedErrorWrapper)\n       assert isinstance(err_wrapper.exc, IntegerError)\n       assert err_wrapper.source_loc == TextLocation(\n           line=1, col=9, end_line=1, end_col=21, pos=9, end_pos=20\n       )\n   else:\n       raise Exception(\'must rise error\')\n\n\nExtracts fields documentation\n-----------------------------\n\nAllows to extract *Sphinx* style attributes documentation by processing AST tree of class definition\n\n.. code-block:: python\n\n   from pydantic import BaseModel\n   from pydantic_settings import with_attrs_docs\n\n\n   @with_attrs_docs\n   class Foo(BaseModel):\n       bar: str\n       """here is docs"""\n\n       #: docs for baz\n       baz: int\n\n       #: yes\n       #: of course\n       is_there_multiline: bool = True\n\n\n   assert Foo.__fields__[\'bar\'].field_info.description == \'here is docs\'\n   assert Foo.__fields__[\'baz\'].field_info.description == \'docs for baz\'\n   assert Foo.__fields__[\'is_there_multiline\'].field_info.description == (\n       \'yes\\nof course\'\n   )\n\n\nOnline docs\n-----------\n\nRead more detailed documentation on the project\n`Read The Docs <https://pydantic-settings.readthedocs.io/en/latest/>`_ page.\n\n\nDevelopment setup\n=================\n\nProject requires `poetry <https://github.com/sdispater/poetry>`_ for development setup.\n\n* If you aren’t have it already\n\n.. code-block:: sh\n\n   pip install poetry\n\n* Install project dependencies\n\n.. code-block:: sh\n\n   poetry install\n\n* Run tests\n\n.. code-block:: sh\n\n   poetry run pytest .\n\n* Great, all works! Expect one optional step:\n\n* Install `pre-commit <https://github.com/pre-commit/pre-commit>`_ for pre-commit hooks\n\n.. code-block:: sh\n\n   pip install pre-commit\n   pre-commit install\n\nThat will install pre-commit hooks, which will check code with *flake8* and *black*.\n\n..\n\n   *NOTE* project uses **black** as code formatter, but i’am personally really dislike their\n   *“double quoted strings everywhere”* style, that’s why ``black -S`` should be used\n   (anyway it’s configured in *pyproject.toml* file)\n',
    'author': 'Daniel Daniels',
    'author_email': 'danields761@gmail.com',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/danields761/pydantic-settings',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'python_requires': '>=3.6,<4.0',
}


setup(**setup_kwargs)
