# Contributing to Jakarta Vision

We love your input! We want to make contributing to this project as easy and transparent as possible, whether it's:

- Reporting a bug
- Discussing the current state of the code
- Submitting a fix
- Proposing new features
- Becoming a maintainer

## Development installation

### Install requirements.txt

```bash
pip install -r requirements.txt
# or with conda (see https://uoa-eresearch.github.io/eresearch-cookbook/recipe/2014/11/20/conda/)
# conda install --file requirements.txt
```

### Verify development environment

```bash
python test.py
```

## Development Process

1. Fork the repo and create your branch from `main`.
2. If you've changed APIs, update the docstrings and documentation.
3. Make sure your code lints.
4. Issue that pull request!

### Issues

We use GitHub issues to track public bugs. Report a bug by opening a new issue.

**Great Bug Reports** tend to have:

- A quick summary and/or background
- Steps to reproduce
  - Be specific!
  - Give sample code if you can.
- What you expected would happen
- What actually happens
- Notes (possibly including why you think this might be happening, or stuff you tried that didn't work)

### Code Formatting and Typing

Jakartavision uses pycodestyle for formatting, with all the defaults.

- 4 spaces for indentation or tabs

### Unit Test

We are currently formulating the unit test. Kindly open an issue for clear discussion.

### Documentation

Jakartavision uses `pydoctyle` for formatting docstrings. All the defaults and on the brach `gh-pages`.

Please follow the instruction to build and deploy the documentation locally.

```
pdoc --html jakartavision docs
```

Then open `docs/index.html` in your browser.

## License

By contributing, you agree that your contributions will be licensed under its MIT License.
