"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.AwsCdkConstructLibrary = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const projen_1 = require("projen");
class AwsCdkConstructLibrary extends projen_1.awscdk.AwsCdkConstructLibrary {
    /**
     * @experimental
     */
    constructor(options) {
        var _b, _c, _d, _e;
        super({
            ...options,
            authorOrganization: true,
            license: "MIT",
            copyrightOwner: "Pepperize UG (haftungsbeschränkt)",
            autoApproveUpgrades: true,
            autoApproveOptions: {
                ...options.autoApproveOptions,
                allowedUsernames: ["unerty", "pflorek", "acfo", "dependabot[bot]"],
                label: "auto-approve",
                secret: "GITHUB_TOKEN",
            },
            depsUpgradeOptions: {
                ...options.depsUpgradeOptions,
                workflowOptions: {
                    ...(_b = options.depsUpgradeOptions) === null || _b === void 0 ? void 0 : _b.workflowOptions,
                    secret: "PROJEN_GITHUB_TOKEN",
                },
            },
            dependabot: true,
            dependabotOptions: {
                labels: ["auto-approve"],
            },
            eslint: true,
            prettier: true,
            prettierOptions: {
                ...options.prettierOptions,
                settings: {
                    ...(_c = options.prettierOptions) === null || _c === void 0 ? void 0 : _c.settings,
                    printWidth: 120,
                },
            },
            defaultReleaseBranch: "main",
            npmAccess: projen_1.javascript.NpmAccess.PUBLIC,
            release: true,
            gitignore: [...(options.gitignore || [])],
        });
        this.gitignore.exclude(".idea/", "*.iml");
        (_d = this.prettier) === null || _d === void 0 ? void 0 : _d.addIgnorePattern("API.md");
        this.formatTask = this.addTask("format", {
            description: "Format with prettier",
            exec: "prettier --write src/{**/,}*.ts test/{**/,}*.ts .projenrc.js README.md",
        });
        (_e = this.jest) === null || _e === void 0 ? void 0 : _e.addTestMatch("<rootDir>/**/?(*.)@(spec|test).[tj]s?(x)");
    }
}
exports.AwsCdkConstructLibrary = AwsCdkConstructLibrary;
_a = JSII_RTTI_SYMBOL_1;
AwsCdkConstructLibrary[_a] = { fqn: "@pepperize/projen-awscdk-construct.AwsCdkConstructLibrary", version: "0.0.84" };
//# sourceMappingURL=data:application/json;base64,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