# -*- coding: utf-8 -*-
# Generated by Django 1.11.2 on 2018-12-08 18:52


import aparnik.utils.fields
from django.conf import settings
import django.core.validators
from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ('basemodels', '0004_auto_20181103_2233'),
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
        ('province', '0001_initial'),
    ]

    operations = [
        migrations.CreateModel(
            name='UserAddress',
            fields=[
                ('basemodel_ptr', models.OneToOneField(auto_created=True, on_delete=django.db.models.deletion.CASCADE, parent_link=True, primary_key=True, serialize=False, to='basemodels.BaseModel')),
                ('address', models.TextField(verbose_name='Address')),
                ('postal_code', aparnik.utils.fields.PostalCodeField(blank=True, max_length=10, null=True, validators=[django.core.validators.RegexValidator(code=b'nomatch', message='zip code is not valid', regex=b'^\\d{10}$')], verbose_name='Postal code')),
                ('phone', aparnik.utils.fields.PhoneField(blank=True, max_length=255, null=True, validators=[django.core.validators.RegexValidator(code=b'nomatch', message='phone is not valid, please insert with code', regex=b'^0(?!0)\\d{2}([0-9]{8})$')], verbose_name='Phone')),
                ('is_default', models.BooleanField(default=False, verbose_name='Is default')),
                ('is_active', models.BooleanField(default=True, verbose_name='Is Active')),
                ('city_obj', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='addresses', to='province.City', verbose_name='City')),
                ('user_obj', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='addresses', to=settings.AUTH_USER_MODEL, verbose_name='User')),
            ],
            options={
                'verbose_name': 'Address',
                'manager_inheritance_from_future': True,
                'verbose_name_plural': 'Addresses',
            },
            bases=('basemodels.basemodel',),
        ),
    ]
