"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Auditmanager = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const shared_1 = require("../shared");
/**
 * (experimental) Statement provider for service [auditmanager](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsauditmanager.html).
 *
 * @experimental
 */
class Auditmanager extends shared_1.PolicyStatement {
    /**
     * (experimental) Statement provider for service [auditmanager](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsauditmanager.html).
     *
     * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement.
     * @experimental
     */
    constructor(sid) {
        super(sid);
        /**
         * (experimental) Holds the prefix of the service actions, e.g. `ec2`.
         *
         * @experimental
         */
        this.servicePrefix = 'auditmanager';
        /**
         * @experimental
         */
        this.accessLevelList = {
            Write: [
                'AssociateAssessmentReportEvidenceFolder',
                'BatchAssociateAssessmentReportEvidence',
                'BatchCreateDelegationByAssessment',
                'BatchDeleteDelegationByAssessment',
                'BatchDisassociateAssessmentReportEvidence',
                'BatchImportEvidenceToAssessmentControl',
                'CreateAssessment',
                'CreateAssessmentFramework',
                'CreateAssessmentReport',
                'CreateControl',
                'DeleteAssessment',
                'DeleteAssessmentFramework',
                'DeleteAssessmentFrameworkShare',
                'DeleteAssessmentReport',
                'DeleteControl',
                'DeregisterAccount',
                'DeregisterOrganizationAdminAccount',
                'DisassociateAssessmentReportEvidenceFolder',
                'RegisterAccount',
                'RegisterOrganizationAdminAccount',
                'StartAssessmentFrameworkShare',
                'UpdateAssessment',
                'UpdateAssessmentControl',
                'UpdateAssessmentControlSetStatus',
                'UpdateAssessmentFramework',
                'UpdateAssessmentFrameworkShare',
                'UpdateAssessmentStatus',
                'UpdateControl',
                'UpdateSettings'
            ],
            Read: [
                'GetAccountStatus',
                'GetAssessment',
                'GetAssessmentFramework',
                'GetAssessmentReportUrl',
                'GetChangeLogs',
                'GetControl',
                'GetEvidence',
                'GetEvidenceByEvidenceFolder',
                'GetEvidenceFolder',
                'GetEvidenceFoldersByAssessment',
                'GetEvidenceFoldersByAssessmentControl',
                'GetInsights',
                'GetInsightsByAssessment',
                'GetOrganizationAdminAccount',
                'GetServicesInScope',
                'GetSettings',
                'ListTagsForResource',
                'ValidateAssessmentReportIntegrity'
            ],
            List: [
                'GetDelegations',
                'ListAssessmentControlInsightsByControlDomain',
                'ListAssessmentFrameworkShareRequests',
                'ListAssessmentFrameworks',
                'ListAssessmentReports',
                'ListAssessments',
                'ListControlDomainInsights',
                'ListControlDomainInsightsByAssessment',
                'ListControlInsightsByControlDomain',
                'ListControls',
                'ListKeywordsForDataSource',
                'ListNotifications'
            ],
            Tagging: [
                'TagResource',
                'UntagResource'
            ]
        };
    }
    /**
     * (experimental) Grants permission to associate an evidence folder with an assessment report in AWS Audit Manager.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/audit-manager/latest/APIReference/API_AssociateAssessmentReportEvidenceFolder.html
     *
     * @experimental
     */
    toAssociateAssessmentReportEvidenceFolder() {
        return this.to('AssociateAssessmentReportEvidenceFolder');
    }
    /**
     * (experimental) Grants permission to associate a list of evidence to an assessment report in AWS Audit Manager.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/audit-manager/latest/APIReference/API_BatchAssociateAssessmentReportEvidence.html
     *
     * @experimental
     */
    toBatchAssociateAssessmentReportEvidence() {
        return this.to('BatchAssociateAssessmentReportEvidence');
    }
    /**
     * (experimental) Grants permission to create delegations for an assessment in AWS Audit Manager.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/audit-manager/latest/APIReference/API_BatchCreateDelegationByAssessment.html
     *
     * @experimental
     */
    toBatchCreateDelegationByAssessment() {
        return this.to('BatchCreateDelegationByAssessment');
    }
    /**
     * (experimental) Grants permission to delete delegations for an assessment in AWS Audit Manager.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/audit-manager/latest/APIReference/API_BatchDeleteDelegationByAssessment.html
     *
     * @experimental
     */
    toBatchDeleteDelegationByAssessment() {
        return this.to('BatchDeleteDelegationByAssessment');
    }
    /**
     * (experimental) Grants permission to disassociate a list of evidence from an assessment report in AWS Audit Manager.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/audit-manager/latest/APIReference/API_BatchDisassociateAssessmentReportEvidence.html
     *
     * @experimental
     */
    toBatchDisassociateAssessmentReportEvidence() {
        return this.to('BatchDisassociateAssessmentReportEvidence');
    }
    /**
     * (experimental) Grants permission to import a list of evidence to an assessment control in AWS Audit Manager.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/audit-manager/latest/APIReference/API_BatchImportEvidenceToAssessmentControl.html
     *
     * @experimental
     */
    toBatchImportEvidenceToAssessmentControl() {
        return this.to('BatchImportEvidenceToAssessmentControl');
    }
    /**
     * (experimental) Grants permission to create an assessment to be used with AWS Audit Manager.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/audit-manager/latest/APIReference/API_CreateAssessment.html
     *
     * @experimental
     */
    toCreateAssessment() {
        return this.to('CreateAssessment');
    }
    /**
     * (experimental) Grants permission to create a framework for use in AWS Audit Manager.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/audit-manager/latest/APIReference/API_CreateAssessmentFramework.html
     *
     * @experimental
     */
    toCreateAssessmentFramework() {
        return this.to('CreateAssessmentFramework');
    }
    /**
     * (experimental) Grants permission to create an assessment report in AWS Audit Manager.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/audit-manager/latest/APIReference/API_CreateAssessmentReport.html
     *
     * @experimental
     */
    toCreateAssessmentReport() {
        return this.to('CreateAssessmentReport');
    }
    /**
     * (experimental) Grants permission to create a control to be used in AWS Audit Manager.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/audit-manager/latest/APIReference/API_CreateControl.html
     *
     * @experimental
     */
    toCreateControl() {
        return this.to('CreateControl');
    }
    /**
     * (experimental) Grants permission to delete an assessment in AWS Audit Manager.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/audit-manager/latest/APIReference/API_DeleteAssessment.html
     *
     * @experimental
     */
    toDeleteAssessment() {
        return this.to('DeleteAssessment');
    }
    /**
     * (experimental) Grants permission to delete an assessment framework in AWS Audit Manager.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/audit-manager/latest/APIReference/API_DeleteAssessmentFramework.html
     *
     * @experimental
     */
    toDeleteAssessmentFramework() {
        return this.to('DeleteAssessmentFramework');
    }
    /**
     * (experimental) Grants permission to delete a share request for a custom framework in AWS Audit Manager.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/audit-manager/latest/APIReference/API_DeleteAssessmentFrameworkShare.html
     *
     * @experimental
     */
    toDeleteAssessmentFrameworkShare() {
        return this.to('DeleteAssessmentFrameworkShare');
    }
    /**
     * (experimental) Grants permission to delete an assessment report in AWS Audit Manager.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/audit-manager/latest/APIReference/API_DeleteAssessmentReport.html
     *
     * @experimental
     */
    toDeleteAssessmentReport() {
        return this.to('DeleteAssessmentReport');
    }
    /**
     * (experimental) Grants permission to delete a control in AWS Audit Manager.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/audit-manager/latest/APIReference/API_DeleteControl.html
     *
     * @experimental
     */
    toDeleteControl() {
        return this.to('DeleteControl');
    }
    /**
     * (experimental) Grants permission to deregister an account in AWS Audit Manager.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/audit-manager/latest/APIReference/API_ DeregisterAccount.html
     *
     * @experimental
     */
    toDeregisterAccount() {
        return this.to('DeregisterAccount');
    }
    /**
     * (experimental) Grants permission to deregister the delegated administrator account for AWS Audit Manager.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/audit-manager/latest/APIReference/API_DeregisterOrganizationAdminAccount.html
     *
     * @experimental
     */
    toDeregisterOrganizationAdminAccount() {
        return this.to('DeregisterOrganizationAdminAccount');
    }
    /**
     * (experimental) Grants permission to disassociate an evidence folder from an assessment report in AWS Audit Manager.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/audit-manager/latest/APIReference/API_DisassociateAssessmentReportEvidenceFolder.html
     *
     * @experimental
     */
    toDisassociateAssessmentReportEvidenceFolder() {
        return this.to('DisassociateAssessmentReportEvidenceFolder');
    }
    /**
     * (experimental) Grants permission to get the status of an account in AWS Audit Manager.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/audit-manager/latest/APIReference/API_GetAccountStatus.html
     *
     * @experimental
     */
    toGetAccountStatus() {
        return this.to('GetAccountStatus');
    }
    /**
     * (experimental) Grants permission to get an assessment created in AWS Audit Manager.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/audit-manager/latest/APIReference/API_GetAssessment.html
     *
     * @experimental
     */
    toGetAssessment() {
        return this.to('GetAssessment');
    }
    /**
     * (experimental) Grants permission to get an assessment framework in AWS Audit Manager.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/audit-manager/latest/APIReference/API_GetAssessmentFramework.html
     *
     * @experimental
     */
    toGetAssessmentFramework() {
        return this.to('GetAssessmentFramework');
    }
    /**
     * (experimental) Grants permission to get the URL for an assessment report in AWS Audit Manager.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/audit-manager/latest/APIReference/API_GetAssessmentReportUrl.html
     *
     * @experimental
     */
    toGetAssessmentReportUrl() {
        return this.to('GetAssessmentReportUrl');
    }
    /**
     * (experimental) Grants permission to get changelogs for an assessment in AWS Audit Manager.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/audit-manager/latest/APIReference/API_GetChangeLogs.html
     *
     * @experimental
     */
    toGetChangeLogs() {
        return this.to('GetChangeLogs');
    }
    /**
     * (experimental) Grants permission to get a control in AWS Audit Manager.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/audit-manager/latest/APIReference/API_GetControl.html
     *
     * @experimental
     */
    toGetControl() {
        return this.to('GetControl');
    }
    /**
     * (experimental) Grants permission to get all delegations in AWS Audit Manager.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/audit-manager/latest/APIReference/API_GetDelegations.html
     *
     * @experimental
     */
    toGetDelegations() {
        return this.to('GetDelegations');
    }
    /**
     * (experimental) Grants permission to get evidence from AWS Audit Manager.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/audit-manager/latest/APIReference/API_GetEvidence.html
     *
     * @experimental
     */
    toGetEvidence() {
        return this.to('GetEvidence');
    }
    /**
     * (experimental) Grants permission to get all the evidence from an evidence folder in AWS Audit Manager.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/audit-manager/latest/APIReference/API_GetEvidenceByEvidenceFolder.html
     *
     * @experimental
     */
    toGetEvidenceByEvidenceFolder() {
        return this.to('GetEvidenceByEvidenceFolder');
    }
    /**
     * (experimental) Grants permission to get the evidence folder from AWS Audit Manager.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/audit-manager/latest/APIReference/API_GetEvidenceFolder.html
     *
     * @experimental
     */
    toGetEvidenceFolder() {
        return this.to('GetEvidenceFolder');
    }
    /**
     * (experimental) Grants permission to get the evidence folders from an assessment in AWS Audit Manager.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/audit-manager/latest/APIReference/API_GetEvidenceFoldersByAssessment.html
     *
     * @experimental
     */
    toGetEvidenceFoldersByAssessment() {
        return this.to('GetEvidenceFoldersByAssessment');
    }
    /**
     * (experimental) Grants permission to get the evidence folders from an assessment control in AWS Audit Manager.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/audit-manager/latest/APIReference/API_GetEvidenceFoldersByAssessmentControl.html
     *
     * @experimental
     */
    toGetEvidenceFoldersByAssessmentControl() {
        return this.to('GetEvidenceFoldersByAssessmentControl');
    }
    /**
     * (experimental) Grants permission to get analytics data for all active assessments.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/audit-manager/latest/APIReference/API_GetInsights.html
     *
     * @experimental
     */
    toGetInsights() {
        return this.to('GetInsights');
    }
    /**
     * (experimental) Grants permission to get analytics data for a specific active assessment.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/audit-manager/latest/APIReference/API_GetInsightsByAssessment.html
     *
     * @experimental
     */
    toGetInsightsByAssessment() {
        return this.to('GetInsightsByAssessment');
    }
    /**
     * (experimental) Grants permission to get the delegated administrator account in AWS Audit Manager.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/audit-manager/latest/APIReference/API_GetOrganizationAdminAccount.html
     *
     * @experimental
     */
    toGetOrganizationAdminAccount() {
        return this.to('GetOrganizationAdminAccount');
    }
    /**
     * (experimental) Grants permission to get the services in scope for an assessment in AWS Audit Manager.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/audit-manager/latest/APIReference/API_GetServicesInScope.html
     *
     * @experimental
     */
    toGetServicesInScope() {
        return this.to('GetServicesInScope');
    }
    /**
     * (experimental) Grants permission to get all settings configured in AWS Audit Manager.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/audit-manager/latest/APIReference/API_GetSettings.html
     *
     * @experimental
     */
    toGetSettings() {
        return this.to('GetSettings');
    }
    /**
     * (experimental) Grants permission to list analytics data for controls in a specific control domain and active assessment.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/audit-manager/latest/APIReference/API_ListAssessmentControlInsightsByControlDomain.html
     *
     * @experimental
     */
    toListAssessmentControlInsightsByControlDomain() {
        return this.to('ListAssessmentControlInsightsByControlDomain');
    }
    /**
     * (experimental) Grants permission to list all sent or received share requests for custom frameworks in AWS Audit Manager.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/audit-manager/latest/APIReference/API_ListAssessmentFrameworkShareRequests.html
     *
     * @experimental
     */
    toListAssessmentFrameworkShareRequests() {
        return this.to('ListAssessmentFrameworkShareRequests');
    }
    /**
     * (experimental) Grants permission to list all assessment frameworks in AWS Audit Manager.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/audit-manager/latest/APIReference/API_ListAssessmentFrameworks.html
     *
     * @experimental
     */
    toListAssessmentFrameworks() {
        return this.to('ListAssessmentFrameworks');
    }
    /**
     * (experimental) Grants permission to list all assessment reports in AWS Audit Manager.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/audit-manager/latest/APIReference/API_ListAssessmentReports.html
     *
     * @experimental
     */
    toListAssessmentReports() {
        return this.to('ListAssessmentReports');
    }
    /**
     * (experimental) Grants permission to list all assessments in AWS Audit Manager.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/audit-manager/latest/APIReference/API_ListAssessments.html
     *
     * @experimental
     */
    toListAssessments() {
        return this.to('ListAssessments');
    }
    /**
     * (experimental) Grants permission to list analytics data for control domains across all active assessments.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/audit-manager/latest/APIReference/API_ListControlDomainInsights.html
     *
     * @experimental
     */
    toListControlDomainInsights() {
        return this.to('ListControlDomainInsights');
    }
    /**
     * (experimental) Grants permission to list analytics data for control domains in a specific active assessment.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/audit-manager/latest/APIReference/API_ListControlDomainInsightsByAssessment.html
     *
     * @experimental
     */
    toListControlDomainInsightsByAssessment() {
        return this.to('ListControlDomainInsightsByAssessment');
    }
    /**
     * (experimental) Grants permission to list analytics data for controls in a specific control domain across all active assessments.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/audit-manager/latest/APIReference/API_ListControlInsightsByControlDomain.html
     *
     * @experimental
     */
    toListControlInsightsByControlDomain() {
        return this.to('ListControlInsightsByControlDomain');
    }
    /**
     * (experimental) Grants permission to list all controls in AWS Audit Manager.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/audit-manager/latest/APIReference/API_ListControls.html
     *
     * @experimental
     */
    toListControls() {
        return this.to('ListControls');
    }
    /**
     * (experimental) Grants permission to list all the data source keywords in AWS Audit Manager.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/audit-manager/latest/APIReference/API_ListKeywordsForDataSource.html
     *
     * @experimental
     */
    toListKeywordsForDataSource() {
        return this.to('ListKeywordsForDataSource');
    }
    /**
     * (experimental) Grants permission to list all notifications in AWS Audit Manager.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/audit-manager/latest/APIReference/API_ListNotifications.html
     *
     * @experimental
     */
    toListNotifications() {
        return this.to('ListNotifications');
    }
    /**
     * (experimental) Grants permission to list tags for an AWS Audit Manager resource.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/audit-manager/latest/APIReference/API_ListTagsForResource.html
     *
     * @experimental
     */
    toListTagsForResource() {
        return this.to('ListTagsForResource');
    }
    /**
     * (experimental) Grants permission to register an account in AWS Audit Manager.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/audit-manager/latest/APIReference/API_RegisterAccount.html
     *
     * @experimental
     */
    toRegisterAccount() {
        return this.to('RegisterAccount');
    }
    /**
     * (experimental) Grants permission to register an account within the organization as the delegated administrator for AWS Audit Manager.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/audit-manager/latest/APIReference/API_RegisterOrganizationAdminAccount.html
     *
     * @experimental
     */
    toRegisterOrganizationAdminAccount() {
        return this.to('RegisterOrganizationAdminAccount');
    }
    /**
     * (experimental) Grants permission to create a share request for a custom framework in AWS Audit Manager.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/audit-manager/latest/APIReference/API_StartAssessmentFrameworkShare.html
     *
     * @experimental
     */
    toStartAssessmentFrameworkShare() {
        return this.to('StartAssessmentFrameworkShare');
    }
    /**
     * (experimental) Grants permission to tag an AWS Audit Manager resource.
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     * - .ifAwsRequestTag()
     *
     * https://docs.aws.amazon.com/audit-manager/latest/APIReference/API_TagResource.html
     *
     * @experimental
     */
    toTagResource() {
        return this.to('TagResource');
    }
    /**
     * (experimental) Grants permission to untag an AWS Audit Manager resource.
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/audit-manager/latest/APIReference/API_UntagResource.html
     *
     * @experimental
     */
    toUntagResource() {
        return this.to('UntagResource');
    }
    /**
     * (experimental) Grants permission to update an assessment in AWS Audit Manager.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/audit-manager/latest/APIReference/API_UpdateAssessment.html
     *
     * @experimental
     */
    toUpdateAssessment() {
        return this.to('UpdateAssessment');
    }
    /**
     * (experimental) Grants permission to update an assessment control in AWS Audit Manager.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/audit-manager/latest/APIReference/API_UpdateAssessmentControl.html
     *
     * @experimental
     */
    toUpdateAssessmentControl() {
        return this.to('UpdateAssessmentControl');
    }
    /**
     * (experimental) Grants permission to update the status of an assessment control set in AWS Audit Manager.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/audit-manager/latest/APIReference/API_UpdateAssessmentControlSetStatus.html
     *
     * @experimental
     */
    toUpdateAssessmentControlSetStatus() {
        return this.to('UpdateAssessmentControlSetStatus');
    }
    /**
     * (experimental) Grants permission to update an assessment framework in AWS Audit Manager.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/audit-manager/latest/APIReference/API_UpdateAssessmentFramework.html
     *
     * @experimental
     */
    toUpdateAssessmentFramework() {
        return this.to('UpdateAssessmentFramework');
    }
    /**
     * (experimental) Grants permission to update a share request for a custom framework in AWS Audit Manager.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/audit-manager/latest/APIReference/API_UpdateAssessmentFrameworkShare.html
     *
     * @experimental
     */
    toUpdateAssessmentFrameworkShare() {
        return this.to('UpdateAssessmentFrameworkShare');
    }
    /**
     * (experimental) Grants permission to update the status of an assessment in AWS Audit Manager.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/audit-manager/latest/APIReference/API_UpdateAssessmentStatus.html
     *
     * @experimental
     */
    toUpdateAssessmentStatus() {
        return this.to('UpdateAssessmentStatus');
    }
    /**
     * (experimental) Grants permission to update a control in AWS Audit Manager.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/audit-manager/latest/APIReference/API_UpdateControl.html
     *
     * @experimental
     */
    toUpdateControl() {
        return this.to('UpdateControl');
    }
    /**
     * (experimental) Grants permission to update settings in AWS Audit Manager.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/audit-manager/latest/APIReference/API_UpdateSettings.html
     *
     * @experimental
     */
    toUpdateSettings() {
        return this.to('UpdateSettings');
    }
    /**
     * (experimental) Grants permission to validate the integrity of an assessment report in AWS Audit Manager.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/audit-manager/latest/APIReference/API_ValidateAssessmentReportIntegrity.html
     *
     * @experimental
     */
    toValidateAssessmentReportIntegrity() {
        return this.to('ValidateAssessmentReportIntegrity');
    }
    /**
     * (experimental) Adds a resource of type assessment to the statement.
     *
     * https://docs.aws.amazon.com/audit-manager/latest/userguide/API_Assessment.html
     *
     * @param assessmentId - Identifier for the assessmentId.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov];
     * @experimental
     */
    onAssessment(assessmentId, account, region, partition) {
        return this.on(`arn:${partition || 'aws'}:auditmanager:${region || '*'}:${account || '*'}:assessment/${assessmentId}`);
    }
    /**
     * (experimental) Adds a resource of type assessmentFramework to the statement.
     *
     * https://docs.aws.amazon.com/audit-manager/latest/userguide/API_AssessmentFramework.html
     *
     * @param assessmentFrameworkId - Identifier for the assessmentFrameworkId.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov];
     * @experimental
     */
    onAssessmentFramework(assessmentFrameworkId, account, region, partition) {
        return this.on(`arn:${partition || 'aws'}:auditmanager:${region || '*'}:${account || '*'}:assessmentFramework/${assessmentFrameworkId}`);
    }
    /**
     * (experimental) Adds a resource of type assessmentControlSet to the statement.
     *
     * https://docs.aws.amazon.com/audit-manager/latest/userguide/API_AssessmentControlSet.html
     *
     * @param assessmentId - Identifier for the assessmentId.
     * @param controlSetId - Identifier for the controlSetId.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov];
     * @experimental
     */
    onAssessmentControlSet(assessmentId, controlSetId, account, region, partition) {
        return this.on(`arn:${partition || 'aws'}:auditmanager:${region || '*'}:${account || '*'}:assessment/${assessmentId}/ControlSet/${controlSetId}`);
    }
    /**
     * (experimental) Adds a resource of type control to the statement.
     *
     * https://docs.aws.amazon.com/audit-manager/latest/userguide/API_Control.html
     *
     * @param controlId - Identifier for the controlId.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     * @experimental
     */
    onControl(controlId, account, region, partition) {
        return this.on(`arn:${partition || 'aws'}:auditmanager:${region || '*'}:${account || '*'}:control/${controlId}`);
    }
}
exports.Auditmanager = Auditmanager;
_a = JSII_RTTI_SYMBOL_1;
Auditmanager[_a] = { fqn: "iam-floyd.Auditmanager", version: "0.306.0" };
//# sourceMappingURL=data:application/json;base64,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