import { AccessLevelList } from '../shared/access-level';
import { PolicyStatement, Operator } from '../shared';
/**
 * (experimental) Statement provider for service [fsx](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonfsx.html).
 *
 * @experimental
 */
export declare class Fsx extends PolicyStatement {
    /**
     * (experimental) Holds the prefix of the service actions, e.g. `ec2`.
     *
     * @experimental
     */
    servicePrefix: string;
    /**
     * (experimental) Statement provider for service [fsx](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonfsx.html).
     *
     * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement.
     * @experimental
     */
    constructor(sid?: string);
    /**
     * (experimental) Grants permission to associate a File Gateway instance with an Amazon FSx for Windows File Server file system.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/filegateway/latest/filefsxw/what-is-file-fsxw.html
     *
     * @experimental
     */
    toAssociateFileGateway(): this;
    /**
     * (experimental) Grants permission to associate DNS aliases with an Amazon FSx for Windows File Server file system.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/fsx/latest/APIReference/API_AssociateFileSystemAliases.html
     *
     * @experimental
     */
    toAssociateFileSystemAliases(): this;
    /**
     * (experimental) Grants permission to cancel a data repository task.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/fsx/latest/APIReference/API_CancelDataRepositoryTask.html
     *
     * @experimental
     */
    toCancelDataRepositoryTask(): this;
    /**
     * (experimental) Grants permission to copy a backup.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * Dependent actions:
     * - fsx:TagResource
     *
     * https://docs.aws.amazon.com/fsx/latest/APIReference/API_CopyBackup.html
     *
     * @experimental
     */
    toCopyBackup(): this;
    /**
     * (experimental) Grants permission to create a new backup of an Amazon FSx file system or an Amazon FSx volume.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * Dependent actions:
     * - fsx:TagResource
     *
     * https://docs.aws.amazon.com/fsx/latest/APIReference/API_CreateBackup.html
     *
     * @experimental
     */
    toCreateBackup(): this;
    /**
     * (experimental) Grants permission to create a new data respository association for an Amazon FSx for Lustre file system.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * Dependent actions:
     * - fsx:TagResource
     *
     * https://docs.aws.amazon.com/fsx/latest/APIReference/API_CreateDataRepositoryAssociation.html
     *
     * @experimental
     */
    toCreateDataRepositoryAssociation(): this;
    /**
     * (experimental) Grants permission to create a new data respository task for an Amazon FSx for Lustre file system.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * Dependent actions:
     * - fsx:TagResource
     *
     * https://docs.aws.amazon.com/fsx/latest/APIReference/API_CreateDataRepositoryTask.html
     *
     * @experimental
     */
    toCreateDataRepositoryTask(): this;
    /**
     * (experimental) Grants permission to create a new, empty, Amazon FSx file system.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * Dependent actions:
     * - fsx:TagResource
     *
     * https://docs.aws.amazon.com/fsx/latest/APIReference/API_CreateFileSystem.html
     *
     * @experimental
     */
    toCreateFileSystem(): this;
    /**
     * (experimental) Grants permission to create a new Amazon FSx file system from an existing backup.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * Dependent actions:
     * - fsx:TagResource
     *
     * https://docs.aws.amazon.com/fsx/latest/APIReference/API_CreateFileSystemFromBackup.html
     *
     * @experimental
     */
    toCreateFileSystemFromBackup(): this;
    /**
     * (experimental) Grants permission to create a new snapshot on a volume.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * Dependent actions:
     * - fsx:TagResource
     *
     * https://docs.aws.amazon.com/fsx/latest/APIReference/API_CreateSnapshot.html
     *
     * @experimental
     */
    toCreateSnapshot(): this;
    /**
     * (experimental) Grants permission to create a new storage virtual machine in an Amazon FSx for Ontap file system.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * Dependent actions:
     * - fsx:TagResource
     *
     * https://docs.aws.amazon.com/fsx/latest/APIReference/API_CreateStorageVirtualMachine.html
     *
     * @experimental
     */
    toCreateStorageVirtualMachine(): this;
    /**
     * (experimental) Grants permission to create a new volume.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     * - .ifStorageVirtualMachineId()
     * - .ifParentVolumeId()
     *
     * Dependent actions:
     * - fsx:TagResource
     *
     * https://docs.aws.amazon.com/fsx/latest/APIReference/API_CreateVolume.html
     *
     * @experimental
     */
    toCreateVolume(): this;
    /**
     * (experimental) Grants permission to create a new volume from backup.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     * - .ifStorageVirtualMachineId()
     *
     * Dependent actions:
     * - fsx:TagResource
     *
     * https://docs.aws.amazon.com/fsx/latest/APIReference/API_CreateVolumeFromBackup.html
     *
     * @experimental
     */
    toCreateVolumeFromBackup(): this;
    /**
     * (experimental) Grants permission to delete a backup, deleting its contents.
     *
     * After deletion, the backup no longer exists, and its data is no longer available
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/fsx/latest/APIReference/API_DeleteBackup.html
     *
     * @experimental
     */
    toDeleteBackup(): this;
    /**
     * (experimental) Grants permission to delete a data repository association.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/fsx/latest/APIReference/API_DeleteDataRepositoryAssociation.html
     *
     * @experimental
     */
    toDeleteDataRepositoryAssociation(): this;
    /**
     * (experimental) Grants permission to delete a file system, deleting its contents and any existing automatic backups of the file system.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * Dependent actions:
     * - fsx:CreateBackup
     * - fsx:TagResource
     *
     * https://docs.aws.amazon.com/fsx/latest/APIReference/API_DeleteFileSystem.html
     *
     * @experimental
     */
    toDeleteFileSystem(): this;
    /**
     * (experimental) Grants permission to delete a snapshot on a volume.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/fsx/latest/APIReference/API_DeleteSnapshot.html
     *
     * @experimental
     */
    toDeleteSnapshot(): this;
    /**
     * (experimental) Grants permission to delete a storage virtual machine, deleting its contents.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/fsx/latest/APIReference/API_DeleteStorageVirtualMachine.html
     *
     * @experimental
     */
    toDeleteStorageVirtualMachine(): this;
    /**
     * (experimental) Grants permission to delete a volume, deleting its contents and any existing automatic backups of the volume.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     * - .ifStorageVirtualMachineId()
     * - .ifParentVolumeId()
     *
     * https://docs.aws.amazon.com/fsx/latest/APIReference/API_DeleteVolume.html
     *
     * @experimental
     */
    toDeleteVolume(): this;
    /**
     * (experimental) Grants permission to describe the File Gateway instances associated with an Amazon FSx for Windows File Server file system.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/filegateway/latest/filefsxw/what-is-file-fsxw.html
     *
     * @experimental
     */
    toDescribeAssociatedFileGateways(): this;
    /**
     * (experimental) Grants permission to return the descriptions of all backups owned by your AWS account in the AWS Region of the endpoint that you're calling.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/fsx/latest/APIReference/API_DescribeBackups.html
     *
     * @experimental
     */
    toDescribeBackups(): this;
    /**
     * (experimental) Grants permission to return the descriptions of all data repository associations owned by your AWS account in the AWS Region of the endpoint that you're calling.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/fsx/latest/APIReference/API_DescribeDataRepositoryAssociations.html
     *
     * @experimental
     */
    toDescribeDataRepositoryAssociations(): this;
    /**
     * (experimental) Grants permission to return the descriptions of all data repository tasks owned by your AWS account in the AWS Region of the endpoint that you're calling.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/fsx/latest/APIReference/API_DescribeDataRepositoryTasks.html
     *
     * @experimental
     */
    toDescribeDataRepositoryTasks(): this;
    /**
     * (experimental) Grants permission to return the description of all DNS aliases owned by your Amazon FSx for Windows File Server file system.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/fsx/latest/APIReference/API_DescribeFileSystemAliases.html
     *
     * @experimental
     */
    toDescribeFileSystemAliases(): this;
    /**
     * (experimental) Grants permission to return the descriptions of all file systems owned by your AWS account in the AWS Region of the endpoint that you're calling.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/fsx/latest/APIReference/API_DescribeFileSystems.html
     *
     * @experimental
     */
    toDescribeFileSystems(): this;
    /**
     * (experimental) Grants permission to return the descriptions of all snapshots owned by your AWS account in the AWS Region of the endpoint you're calling.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/fsx/latest/APIReference/API_DescribeSnapshots.html
     *
     * @experimental
     */
    toDescribeSnapshots(): this;
    /**
     * (experimental) Grants permission to return the descriptions of all storage virtual machines owned by your AWS account in the AWS Region of the endpoint that you're calling.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/fsx/latest/APIReference/API_DescribeStorageVirtualMachines.html
     *
     * @experimental
     */
    toDescribeStorageVirtualMachines(): this;
    /**
     * (experimental) Grants permission to return the descriptions of all volumes owned by your AWS account in the AWS Region of the endpoint that you're calling.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/fsx/latest/APIReference/API_DescribeVolumes.html
     *
     * @experimental
     */
    toDescribeVolumes(): this;
    /**
     * (experimental) Grants permission to disassociate a File Gateway instance from an Amazon FSx for Windows File Server file system.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/filegateway/latest/filefsxw/what-is-file-fsxw.html
     *
     * @experimental
     */
    toDisassociateFileGateway(): this;
    /**
     * (experimental) Grants permission to disassociate file system aliases with an Amazon FSx for Windows File Server file system.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/fsx/latest/APIReference/API_DisassociateFileSystemAliases.html
     *
     * @experimental
     */
    toDisassociateFileSystemAliases(): this;
    /**
     * (experimental) Grants permission to list tags for an Amazon FSx resource.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/fsx/latest/APIReference/API_ListTagsForResource.html
     *
     * @experimental
     */
    toListTagsForResource(): this;
    /**
     * (experimental) Grants permission to manage backup principal associations through AWS Backup.
     *
     * Access Level: Permissions management
     *
     * https://docs.aws.amazon.com/fsx/latest/APIReference/API_CopyBackup.html
     *
     * @experimental
     */
    toManageBackupPrincipalAssociations(): this;
    /**
     * (experimental) Grants permission to restore volume state from a snapshot.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/fsx/latest/APIReference/API_RestoreVolumeFromSnapshot.html
     *
     * @experimental
     */
    toRestoreVolumeFromSnapshot(): this;
    /**
     * (experimental) Grants permission to tag an Amazon FSx resource.
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     * - .ifAwsRequestTag()
     *
     * https://docs.aws.amazon.com/fsx/latest/APIReference/API_TagResource.html
     *
     * @experimental
     */
    toTagResource(): this;
    /**
     * (experimental) Grants permission to remove a tag from an Amazon FSx resource.
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/fsx/latest/APIReference/API_UntagResource.html
     *
     * @experimental
     */
    toUntagResource(): this;
    /**
     * (experimental) Grants permission to update data repository association configuration.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/fsx/latest/APIReference/API_UpdateDataRepositoryAssociation.html
     *
     * @experimental
     */
    toUpdateDataRepositoryAssociation(): this;
    /**
     * (experimental) Grants permission to update file system configuration.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/fsx/latest/APIReference/API_UpdateFileSystem.html
     *
     * @experimental
     */
    toUpdateFileSystem(): this;
    /**
     * (experimental) Grants permission to update snapshot configuration.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/fsx/latest/APIReference/API_UpdateSnapshot.html
     *
     * @experimental
     */
    toUpdateSnapshot(): this;
    /**
     * (experimental) Grants permission to update storage virtual machine configuration.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/fsx/latest/APIReference/API_UpdateStorageVirtualMachine.html
     *
     * @experimental
     */
    toUpdateStorageVirtualMachine(): this;
    /**
     * (experimental) Grants permission to update volume configuration.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifStorageVirtualMachineId()
     * - .ifParentVolumeId()
     *
     * https://docs.aws.amazon.com/fsx/latest/APIReference/API_UpdateVolume.html
     *
     * @experimental
     */
    toUpdateVolume(): this;
    /**
     * @experimental
     */
    protected accessLevelList: AccessLevelList;
    /**
     * (experimental) Adds a resource of type file-system to the statement.
     *
     * https://docs.aws.amazon.com/fsx/latest/WindowsGuide/access-control-overview.html#access-control-resources
     *
     * @param fileSystemId - Identifier for the fileSystemId.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     * @experimental
     */
    onFileSystem(fileSystemId: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type backup to the statement.
     *
     * https://docs.aws.amazon.com/fsx/latest/WindowsGuide/access-control-overview.html#access-control-resources
     *
     * @param backupId - Identifier for the backupId.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     * @experimental
     */
    onBackup(backupId: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type storage-virtual-machine to the statement.
     *
     * https://docs.aws.amazon.com/fsx/latest/ONTAPGuide/security-iam.html
     *
     * @param fileSystemId - Identifier for the fileSystemId.
     * @param storageVirtualMachineId - Identifier for the storageVirtualMachineId.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     * @experimental
     */
    onStorageVirtualMachine(fileSystemId: string, storageVirtualMachineId: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type task to the statement.
     *
     * https://docs.aws.amazon.com/fsx/latest/LustreGuide/access-control-overview.html#access-control-resources
     *
     * @param taskId - Identifier for the taskId.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     * @experimental
     */
    onTask(taskId: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type association to the statement.
     *
     * https://docs.aws.amazon.com/fsx/latest/LustreGuide/access-control-overview.html#access-control-resources
     *
     * @param dataRepositoryAssociationId - Identifier for the dataRepositoryAssociationId.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     * @experimental
     */
    onAssociation(dataRepositoryAssociationId: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type volume to the statement.
     *
     * https://docs.aws.amazon.com/fsx/latest/ONTAPGuide/security-iam.html
     *
     * @param fileSystemId - Identifier for the fileSystemId.
     * @param volumeId - Identifier for the volumeId.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     * @experimental
     */
    onVolume(fileSystemId: string, volumeId: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type snapshot to the statement.
     *
     * https://docs.aws.amazon.com/fsx/latest/OpenFsGuide/access-control-overview.html#access-control-resources
     *
     * @param volumeId - Identifier for the volumeId.
     * @param snapshotId - Identifier for the snapshotId.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     * @experimental
     */
    onSnapshot(volumeId: string, snapshotId: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Filters access by whether the backup is a destination backup for a CopyBackup operation.
     *
     * https://docs.aws.amazon.com/fsx/latest/WindowsGuide/access-control-manage-access-intro.htmlAPI_CopyBackup.html
     *
     * @param value `true` or `false`.
     * @experimental
     */
    ifIsBackupCopyDestination(value?: boolean): this;
    /**
     * (experimental) Filters access by whether the backup is a source backup for a CopyBackup operation.
     *
     * https://docs.aws.amazon.com/fsx/latest/WindowsGuide/access-control-manage-access-intro.htmlAPI_CopyBackup.html
     *
     * @param value `true` or `false`.
     * @experimental
     */
    ifIsBackupCopySource(value?: boolean): this;
    /**
     * (experimental) Filters access by the containing parent volume for mutating volume operations.
     *
     * https://docs.aws.amazon.com/fsx/latest/WindowsGuide/access-control-manage-access-intro.htmlAPI_CreateVolume.html
     *
     * Applies to actions:
     * - .toCreateVolume()
     * - .toDeleteVolume()
     * - .toUpdateVolume()
     *
     * @param value The value(s) to check.
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`.
     * @experimental
     */
    ifParentVolumeId(value: string | string[], operator?: Operator | string): this;
    /**
     * (experimental) Filters access by the containing storage virtual machine for a volume for mutating volume operations.
     *
     * https://docs.aws.amazon.com/fsx/latest/WindowsGuide/access-control-manage-access-intro.htmlAPI_CreateVolume.html
     *
     * Applies to actions:
     * - .toCreateVolume()
     * - .toCreateVolumeFromBackup()
     * - .toDeleteVolume()
     * - .toUpdateVolume()
     *
     * @param value The value(s) to check.
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`.
     * @experimental
     */
    ifStorageVirtualMachineId(value: string | string[], operator?: Operator | string): this;
}
