import { AccessLevelList } from '../shared/access-level';
import { PolicyStatement } from '../shared';
/**
 * (experimental) Statement provider for service [kafkaconnect](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonmanagedstreamingforkafkaconnect.html).
 *
 * @experimental
 */
export declare class Kafkaconnect extends PolicyStatement {
    /**
     * (experimental) Holds the prefix of the service actions, e.g. `ec2`.
     *
     * @experimental
     */
    servicePrefix: string;
    /**
     * (experimental) Statement provider for service [kafkaconnect](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonmanagedstreamingforkafkaconnect.html).
     *
     * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement.
     * @experimental
     */
    constructor(sid?: string);
    /**
     * (experimental) Grants permission to create an MSK Connect connector.
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - ec2:CreateNetworkInterface
     * - ec2:DescribeSecurityGroups
     * - ec2:DescribeSubnets
     * - ec2:DescribeVpcs
     * - firehose:TagDeliveryStream
     * - iam:AttachRolePolicy
     * - iam:CreateServiceLinkedRole
     * - iam:PassRole
     * - iam:PutRolePolicy
     * - logs:CreateLogDelivery
     * - logs:DescribeLogGroups
     * - logs:DescribeResourcePolicies
     * - logs:GetLogDelivery
     * - logs:ListLogDeliveries
     * - logs:PutResourcePolicy
     * - s3:GetBucketPolicy
     * - s3:PutBucketPolicy
     *
     * https://docs.aws.amazon.com/MSKC/latest/mskc/API_CreateConnector.html
     *
     * @experimental
     */
    toCreateConnector(): this;
    /**
     * (experimental) Grants permission to create an MSK Connect custom plugin.
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - s3:GetObject
     *
     * https://docs.aws.amazon.com/MSKC/latest/mskc/API_CreateCustomPlugin.html
     *
     * @experimental
     */
    toCreateCustomPlugin(): this;
    /**
     * (experimental) Grants permission to create an MSK Connect worker configuration.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/MSKC/latest/mskc/API_CreateWorkerConfiguration.html
     *
     * @experimental
     */
    toCreateWorkerConfiguration(): this;
    /**
     * (experimental) Grants permission to delete an MSK Connect connector.
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - logs:DeleteLogDelivery
     * - logs:ListLogDeliveries
     *
     * https://docs.aws.amazon.com/MSKC/latest/mskc/API_DeleteConnector.html
     *
     * @experimental
     */
    toDeleteConnector(): this;
    /**
     * (experimental) Grants permission to describe an MSK Connect connector.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/MSKC/latest/mskc/API_DescribeConnector.html
     *
     * @experimental
     */
    toDescribeConnector(): this;
    /**
     * (experimental) Grants permission to describe an MSK Connect custom plugin.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/MSKC/latest/mskc/API_DescribeCustomPlugin.html
     *
     * @experimental
     */
    toDescribeCustomPlugin(): this;
    /**
     * (experimental) Grants permission to describe an MSK Connect worker configuration.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/MSKC/latest/mskc/API_DescribeWorkerConfiguration.html
     *
     * @experimental
     */
    toDescribeWorkerConfiguration(): this;
    /**
     * (experimental) Grants permission to list all MSK Connect connectors in this account.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/MSKC/latest/mskc/API_ListConnectors.html
     *
     * @experimental
     */
    toListConnectors(): this;
    /**
     * (experimental) Grants permission to list all MSK Connect custom plugins in this account.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/MSKC/latest/mskc/API_ListCustomPlugins.html
     *
     * @experimental
     */
    toListCustomPlugins(): this;
    /**
     * (experimental) Grants permission to list all MSK Connect worker configurations in this account.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/MSKC/latest/mskc/API_ListWorkerConfigurations.html
     *
     * @experimental
     */
    toListWorkerConfigurations(): this;
    /**
     * (experimental) Grants permission to update an MSK Connect connector.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/MSKC/latest/mskc/API_UpdateConnector.html
     *
     * @experimental
     */
    toUpdateConnector(): this;
    /**
     * @experimental
     */
    protected accessLevelList: AccessLevelList;
    /**
     * (experimental) Adds a resource of type connector to the statement.
     *
     * https://docs.aws.amazon.com/MSKC/latest/mskc/API_ConnectorSummary.html
     *
     * @param connectorName - Identifier for the connectorName.
     * @param uUID - Identifier for the uUID.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov];
     * @experimental
     */
    onConnector(connectorName: string, uUID: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type custom plugin to the statement.
     *
     * https://docs.aws.amazon.com/MSKC/latest/mskc/API_CustomPlugin.html
     *
     * @param customPluginName - Identifier for the customPluginName.
     * @param uUID - Identifier for the uUID.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov];
     * @experimental
     */
    onCustomPlugin(customPluginName: string, uUID: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type worker configuration to the statement.
     *
     * https://docs.aws.amazon.com/MSKC/latest/mskc/API_WorkerConfiguration.html
     *
     * @param workerConfigurationName - Identifier for the workerConfigurationName.
     * @param uUID - Identifier for the uUID.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov];
     * @experimental
     */
    onWorkerConfiguration(workerConfigurationName: string, uUID: string, account?: string, region?: string, partition?: string): this;
}
