import { AccessLevelList } from '../shared/access-level';
import { PolicyStatement } from '../shared';
/**
 * (experimental) Statement provider for service [panorama](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awspanorama.html).
 *
 * @experimental
 */
export declare class Panorama extends PolicyStatement {
    /**
     * (experimental) Holds the prefix of the service actions, e.g. `ec2`.
     *
     * @experimental
     */
    servicePrefix: string;
    /**
     * (experimental) Statement provider for service [panorama](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awspanorama.html).
     *
     * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement.
     * @experimental
     */
    constructor(sid?: string);
    /**
     * (experimental) Grants permission to create an AWS Panorama application.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     * - .ifAwsRequestTag()
     *
     * https://docs.aws.amazon.com/panorama/latest/dev/API_CreateApp.html
     *
     * @experimental
     */
    toCreateApp(): this;
    /**
     * (experimental) Grants permission to deploy an AWS Panorama application.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/panorama/latest/dev/API_CreateAppDeployment.html
     *
     * @experimental
     */
    toCreateAppDeployment(): this;
    /**
     * (experimental) Grants permission to create a version of an AWS Panorama application.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/panorama/latest/dev/API_CreateAppVersion.html
     *
     * @experimental
     */
    toCreateAppVersion(): this;
    /**
     * (experimental) Grants permission to create an AWS Panorama Application Instance.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     * - .ifAwsRequestTag()
     *
     * https://docs.aws.amazon.com/panorama/latest/dev/API_CreateApplicationInstance.html
     *
     * @experimental
     */
    toCreateApplicationInstance(): this;
    /**
     * (experimental) Grants permission to create an AWS Panorama datasource.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     * - .ifAwsRequestTag()
     *
     * https://docs.aws.amazon.com/panorama/latest/dev/API_CreateDataSource.html
     *
     * @experimental
     */
    toCreateDataSource(): this;
    /**
     * (experimental) Grants permission to configure a deployment for an AWS Panorama application.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/panorama/latest/dev/API_CreateDeploymentConfiguration.html
     *
     * @experimental
     */
    toCreateDeploymentConfiguration(): this;
    /**
     * (experimental) Grants permission to generate a list of cameras on the same network as an AWS Panorama Appliance.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/panorama/latest/dev/API_CreateInputList.html
     *
     * @experimental
     */
    toCreateInputs(): this;
    /**
     * (experimental) Grants permission to create a job for an AWS Panorama Appliance.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/panorama/latest/dev/API_CreateJobForDevices.html
     *
     * @experimental
     */
    toCreateJobForDevices(): this;
    /**
     * (experimental) Grants permission to import a machine learning model into AWS Panorama.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     * - .ifAwsRequestTag()
     *
     * https://docs.aws.amazon.com/panorama/latest/dev/API_CreateModel.html
     *
     * @experimental
     */
    toCreateModel(): this;
    /**
     * (experimental) Grants permission to create an AWS Panorama Node.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/panorama/latest/dev/API_CreateNodeFromTemplateJob.html
     *
     * @experimental
     */
    toCreateNodeFromTemplateJob(): this;
    /**
     * (experimental) Grants permission to create an AWS Panorama Package.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     * - .ifAwsRequestTag()
     *
     * https://docs.aws.amazon.com/panorama/latest/dev/API_CreatePackage.html
     *
     * @experimental
     */
    toCreatePackage(): this;
    /**
     * (experimental) Grants permission to create an AWS Panorama Package.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/panorama/latest/dev/API_CreatePackageImportJob.html
     *
     * @experimental
     */
    toCreatePackageImportJob(): this;
    /**
     * (experimental) Grants permission to generate a list of streams available to an AWS Panorama Appliance.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/panorama/latest/dev/API_CreateStreamsList.html
     *
     * @experimental
     */
    toCreateStreams(): this;
    /**
     * (experimental) Grants permission to delete an AWS Panorama application.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/panorama/latest/dev/API_DeleteApp.html
     *
     * @experimental
     */
    toDeleteApp(): this;
    /**
     * (experimental) Grants permission to delete a version of an AWS Panorama application.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/panorama/latest/dev/API_DeleteAppVersion.html
     *
     * @experimental
     */
    toDeleteAppVersion(): this;
    /**
     * (experimental) Grants permission to delete an AWS Panorama datasource.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/panorama/latest/dev/API_DeleteDataSource.html
     *
     * @experimental
     */
    toDeleteDataSource(): this;
    /**
     * (experimental) Grants permission to deregister an AWS Panorama Appliance.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/panorama/latest/dev/API_DeleteDevice.html
     *
     * @experimental
     */
    toDeleteDevice(): this;
    /**
     * (experimental) Grants permission to delete a machine learning model from AWS Panorama.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/panorama/latest/dev/API_DeleteModel.html
     *
     * @experimental
     */
    toDeleteModel(): this;
    /**
     * (experimental) Grants permission to delete an AWS Panorama Package.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/panorama/latest/dev/API_DeletePackage.html
     *
     * @experimental
     */
    toDeletePackage(): this;
    /**
     * (experimental) Grants permission to deregister an AWS Panorama Package Version.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/panorama/latest/dev/API_DeregisterPackageVersion.html
     *
     * @experimental
     */
    toDeregisterPackageVersion(): this;
    /**
     * (experimental) Grants permission to view details about an AWS Panorama application.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/panorama/latest/dev/API_DescribeApp.html
     *
     * @experimental
     */
    toDescribeApp(): this;
    /**
     * (experimental) Grants permission to view details about a deployment for an AWS Panorama application.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/panorama/latest/dev/API_DescribeAppDeployment.html
     *
     * @experimental
     */
    toDescribeAppDeployment(): this;
    /**
     * (experimental) Grants permission to view details about a version of an AWS Panorama application.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/panorama/latest/dev/API_DescribeAppVersion.html
     *
     * @experimental
     */
    toDescribeAppVersion(): this;
    /**
     * (experimental) Grants permission to view details about an AWS Panorama Application Instance.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/panorama/latest/dev/API_DescribeApplicationInstance.html
     *
     * @experimental
     */
    toDescribeApplicationInstance(): this;
    /**
     * (experimental) Grants permission to view details about an AWS Panorama Application Instance.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/panorama/latest/dev/API_DescribeApplicationInstanceDetails.html
     *
     * @experimental
     */
    toDescribeApplicationInstanceDetails(): this;
    /**
     * (experimental) Grants permission to view details about a datasource in AWS Panorama.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/panorama/latest/dev/API_DescribeDataSource.html
     *
     * @experimental
     */
    toDescribeDataSource(): this;
    /**
     * (experimental) Grants permission to view details about an AWS Panorama Appliance.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/panorama/latest/dev/API_DescribeDevice.html
     *
     * @experimental
     */
    toDescribeDevice(): this;
    /**
     * (experimental) Grants permission to view job details for an AWS Panorama Appliance.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/panorama/latest/dev/API_DescribeDeviceJob.html
     *
     * @experimental
     */
    toDescribeDeviceJob(): this;
    /**
     * (experimental) Grants permission to view details about a machine learning model in AWS Panorama.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/panorama/latest/dev/API_DescribeModel.html
     *
     * @experimental
     */
    toDescribeModel(): this;
    /**
     * (experimental) Grants permission to view details about an AWS Panorama Node.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/panorama/latest/dev/API_DescribeNode.html
     *
     * @experimental
     */
    toDescribeNode(): this;
    /**
     * (experimental) Grants permission to view details about AWS Panorama Node.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/panorama/latest/dev/API_DescribeNodeFromTemplateJob.html
     *
     * @experimental
     */
    toDescribeNodeFromTemplateJob(): this;
    /**
     * (experimental) Grants permission to view details about an AWS Panorama Package.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/panorama/latest/dev/API_DescribePackage.html
     *
     * @experimental
     */
    toDescribePackage(): this;
    /**
     * (experimental) Grants permission to view details about an AWS Panorama Package.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/panorama/latest/dev/API_DescribePackageImportJob.html
     *
     * @experimental
     */
    toDescribePackageImportJob(): this;
    /**
     * (experimental) Grants permission to view details about an AWS Panorama Package Version.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/panorama/latest/dev/API_DescribePackageVersion.html
     *
     * @experimental
     */
    toDescribePackageVersion(): this;
    /**
     * (experimental) Grants permission to view details about a software version for the AWS Panorama Appliance.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/panorama/latest/dev/API_DescribeSoftware.html
     *
     * @experimental
     */
    toDescribeSoftware(): this;
    /**
     * (experimental) Grants permission to view details about a deployment configuration for an AWS Panorama application.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/panorama/latest/dev/API_GetDeploymentConfiguration.html
     *
     * @experimental
     */
    toGetDeploymentConfiguration(): this;
    /**
     * (experimental) Grants permission to retrieve a list of cameras generated with CreateInputs.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/panorama/latest/dev/API_GetInputList.html
     *
     * @experimental
     */
    toGetInputs(): this;
    /**
     * (experimental) Grants permission to retrieve a list of streams generated with CreateStreams.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/panorama/latest/dev/API_GetStreamsList.html
     *
     * @experimental
     */
    toGetStreams(): this;
    /**
     * (experimental) Grants permission to generate a WebSocket endpoint for communication with AWS Panorama.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/panorama/latest/dev/API_GetWebSocketURL.html
     *
     * @experimental
     */
    toGetWebSocketURL(): this;
    /**
     * (experimental) Grants permission to retrieve a list of deployments for an AWS Panorama application.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/panorama/latest/dev/API_ListAppDeploymentOperations.html
     *
     * @experimental
     */
    toListAppDeploymentOperations(): this;
    /**
     * (experimental) Grants permission to retrieve a list of application versions in AWS Panorama.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/panorama/latest/dev/API_ListAppVersions.html
     *
     * @experimental
     */
    toListAppVersions(): this;
    /**
     * (experimental) Grants permission to retrieve a list of application instance dependencies in AWS Panorama.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/panorama/latest/dev/API_ListApplicationInstanceDependencies.html
     *
     * @experimental
     */
    toListApplicationInstanceDependencies(): this;
    /**
     * (experimental) Grants permission to retrieve a list of node instances of application instances in AWS Panorama.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/panorama/latest/dev/API_ListApplicationInstanceNodeInstances.html
     *
     * @experimental
     */
    toListApplicationInstanceNodeInstances(): this;
    /**
     * (experimental) Grants permission to retrieve a list of application instances in AWS Panorama.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/panorama/latest/dev/API_ListApplicationInstances.html
     *
     * @experimental
     */
    toListApplicationInstances(): this;
    /**
     * (experimental) Grants permission to retrieve a list of applications in AWS Panorama.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/panorama/latest/dev/API_ListApps.html
     *
     * @experimental
     */
    toListApps(): this;
    /**
     * (experimental) Grants permission to retrieve a list of datasources in AWS Panorama.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/panorama/latest/dev/API_ListDataSources.html
     *
     * @experimental
     */
    toListDataSources(): this;
    /**
     * (experimental) Grants permission to retrieve a list of deployment configurations in AWS Panorama.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/panorama/latest/dev/API_ListDeploymentConfigurations.html
     *
     * @experimental
     */
    toListDeploymentConfigurations(): this;
    /**
     * (experimental) Grants permission to retrieve a list of appliances in AWS Panorama.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/panorama/latest/dev/API_ListDevices.html
     *
     * @experimental
     */
    toListDevices(): this;
    /**
     * (experimental) Grants permission to retrieve a list of jobs for an AWS Panorama Appliance.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/panorama/latest/dev/API_ListDevicesJobs.html
     *
     * @experimental
     */
    toListDevicesJobs(): this;
    /**
     * (experimental) Grants permission to retrieve a list of models in AWS Panorama.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/panorama/latest/dev/API_ListModels.html
     *
     * @experimental
     */
    toListModels(): this;
    /**
     * (experimental) Grants permission to retrieve a list of Nodes for an AWS Panorama Appliance.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/panorama/latest/dev/API_ListNodeFromTemplateJobs.html
     *
     * @experimental
     */
    toListNodeFromTemplateJobs(): this;
    /**
     * (experimental) Grants permission to retrieve a list of nodes in AWS Panorama.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/panorama/latest/dev/API_ListNodes.html
     *
     * @experimental
     */
    toListNodes(): this;
    /**
     * (experimental) Grants permission to retrieve a list of packages in AWS Panorama.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/panorama/latest/dev/API_ListPackageImportJobs.html
     *
     * @experimental
     */
    toListPackageImportJobs(): this;
    /**
     * (experimental) Grants permission to retrieve a list of packages in AWS Panorama.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/panorama/latest/dev/API_ListPackages.html
     *
     * @experimental
     */
    toListPackages(): this;
    /**
     * (experimental) Grants permission to retrieve a list of tags for a resource in AWS Panorama.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/panorama/latest/dev/API_ListTagsForResource.html
     *
     * @experimental
     */
    toListTagsForResource(): this;
    /**
     * (experimental) Grants permission to register an AWS Panorama Appliance.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     * - .ifAwsRequestTag()
     *
     * https://docs.aws.amazon.com/panorama/latest/dev/API_ProvisionDevice.html
     *
     * @experimental
     */
    toProvisionDevice(): this;
    /**
     * (experimental) Grants permission to register an AWS Panorama Package Version.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/panorama/latest/dev/API_RegisterPackageVersion.html
     *
     * @experimental
     */
    toRegisterPackageVersion(): this;
    /**
     * (experimental) Grants permission to remove an AWS Panorama Application Instance.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/panorama/latest/dev/API_RemoveApplicationInstance.html
     *
     * @experimental
     */
    toRemoveApplicationInstance(): this;
    /**
     * (experimental) Grants permission to add tags to a resource in AWS Panorama.
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     * - .ifAwsRequestTag()
     *
     * https://docs.aws.amazon.com/panorama/latest/dev/API_TagResource.html
     *
     * @experimental
     */
    toTagResource(): this;
    /**
     * (experimental) Grants permission to remove tags from a resource in AWS Panorama.
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/panorama/latest/dev/API_UntagResource.html
     *
     * @experimental
     */
    toUntagResource(): this;
    /**
     * (experimental) Grants permission to modify an AWS Panorama application.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/panorama/latest/dev/API_UpdateApp.html
     *
     * @experimental
     */
    toUpdateApp(): this;
    /**
     * (experimental) Grants permission to modify the version-specific configuration of an AWS Panorama application.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/panorama/latest/dev/API_UpdateAppConfiguration.html
     *
     * @experimental
     */
    toUpdateAppConfiguration(): this;
    /**
     * (experimental) Grants permission to modify an AWS Panorama datasource.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/panorama/latest/dev/API_UpdateDataSource.html
     *
     * @experimental
     */
    toUpdateDataSource(): this;
    /**
     * (experimental) Grants permission to modify basic settings for an AWS Panorama Appliance.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/panorama/latest/dev/API_UpdateDeviceMetadata.html
     *
     * @experimental
     */
    toUpdateDeviceMetadata(): this;
    /**
     * @experimental
     */
    protected accessLevelList: AccessLevelList;
    /**
     * (experimental) Adds a resource of type device to the statement.
     *
     * https://docs.aws.amazon.com/panorama/latest/dev/
     *
     * @param deviceId - Identifier for the deviceId.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     * @experimental
     */
    onDevice(deviceId: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type package to the statement.
     *
     * https://docs.aws.amazon.com/panorama/latest/dev/
     *
     * @param packageId - Identifier for the packageId.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     * @experimental
     */
    onPackage(packageId: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type applicationInstance to the statement.
     *
     * https://docs.aws.amazon.com/panorama/latest/dev/
     *
     * @param applicationInstanceId - Identifier for the applicationInstanceId.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     * @experimental
     */
    onApplicationInstance(applicationInstanceId: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type dataSource to the statement.
     *
     * https://docs.aws.amazon.com/panorama/latest/dev/
     *
     * @param deviceId - Identifier for the deviceId.
     * @param dataSourceName - Identifier for the dataSourceName.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     * @experimental
     */
    onDataSource(deviceId: string, dataSourceName: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type model to the statement.
     *
     * https://docs.aws.amazon.com/panorama/latest/dev/
     *
     * @param modelName - Identifier for the modelName.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     * @experimental
     */
    onModel(modelName: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type app to the statement.
     *
     * https://docs.aws.amazon.com/panorama/latest/dev/
     *
     * @param appName - Identifier for the appName.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     * @experimental
     */
    onApp(appName: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type appVersion to the statement.
     *
     * https://docs.aws.amazon.com/panorama/latest/dev/
     *
     * @param appName - Identifier for the appName.
     * @param appVersion - Identifier for the appVersion.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov];
     * @experimental
     */
    onAppVersion(appName: string, appVersion: string, account?: string, region?: string, partition?: string): this;
}
