# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['glassknife']

package_data = \
{'': ['*']}

install_requires = \
['PyYAML>=5.4.1,<6.0.0', 'pydantic>=1.8.2,<2.0.0', 'xdg>=5.1.1,<6.0.0']

entry_points = \
{'console_scripts': ['make-indexes = '
                     'glassknife.make_indexes:handle_command_line',
                     'process-notes = '
                     'glassknife.process_notes:handle_command_line']}

setup_kwargs = {
    'name': 'glassknife',
    'version': '0.1.0',
    'description': 'Obsidian vault management tools',
    'long_description': 'Glass Knife\n===========\n\n**Python utilities for working with Obsidian vaults.**\n\nObsidian_ is a pretty layer on top of a folder full of Markdown files. The contents of that folder are Obsidian\'s database and you can add, remove, and edit files inside it at will. This gives users incredible flexibility to manage those files and their contents outside of Obsidian, which they may want to do for a few reasons:\n\n* Obsidian extensions are written in JavaScript and a user wants to develop tooling in their own preferred language. JavaScript is fine, but I like Python.\n* Writing a standalone program outside Obsidian is way easier than writing an extension. Extensions are cool, but that can be a lot of overhead for a simple need.\n* A user wants to run tasks on a schedule, even if Obsidian itself isn\'t running on their computer. Sometimes a simple cron job is exactly the right tool.\n* The program they want to write wouldn\'t benefit from running inside Obsidian. Unix tools are *really good* at text processing.\n\nCurrent status\n==============\n\nI wrote these tools for my own personal use. They might be useful for other people, too, so I\'m releasing them although they\'re still pretty early-stage. They make a few assumptions:\n\n* All of a vault\'s daily notes live in the same directory.\n* All of a vault\'s templates live in the same directory.\n* Daily notes use the default naming convention of ``YYYY-MM-DD.md``.\n* You\'re using Reminders or OmniFocus_ to record your action items.\n* You\'re using `Day One`_ as your journal.\n\nIt should be very easy to edit the code if your setup doesn\'t exactly match mine. While I intend to make this more configurable later, I haven\'t gotten around to that yet.\n\nInstallation\n============\n\n``pip install glassknife``\n\nConfiguration\n=============\n\nMake a file in your home directory called ``~/.config/glassknife/config.yaml`` (but using your own information)::\n\n    vaults:\n      Everything:\n        path: /path/to/my/vault\n        notes_subdir: "Daily notes go here"\n        templates_subdir: "Templates are here"\n        daily_template_name: "My daily note template.md"\n\n    process_notes:\n        actions:\n            "- ": Reminders\n            "* ": "Day One"\n            "- [ ] ": OmniFocus\n\nThe tools\n=========\n\nThese are the first tools in the collection.\n\nmake-indexes\n------------\n\n**Create a set of yearly and monthly index files for daily notes files.**\n\nI have a ``Daily notes`` directory with a lot of unindexed notes in it. I wanted to have `Maps of Content`_ from calendar months to all the notes in each month, and MOCs from years to the monthly MOCs in each year. For instance, suppose I have these daily notes:\n\n* ``2020-12-31.md``\n* ``2021-01-01.md``\n* ``2021-01-02.md``\n* ``2021-02-02.md``\n\nThen I\'d want to have annual indexes like ``Daily notes - 2020.md``::\n\n    Months in 2020:\n\n    We stayed home a lot this year.\n\n    ---\n\n    [[Daily notes - 2020-12]]\n\n    ---\n\nand ``Daily notes - 2021.md``::\n\n    Months in 2021:\n\n    ---\n\n    [[Daily notes - 2021-01]]\n    [[Daily notes - 2021-02]]\n\n    ---\n\n    This is the year we went camping a lot!\n\nEach month\'s index would look similar, like ``Daily notes - 2021-01.md``::\n\n    Days in 2021-01:\n\n    We made it to a grocery store this month.\n\n    ---\n\n    [[2021-01-01]]\n    [[2021-01-02]]\n\n    ---\n\n``make-indexes Everything`` does this for me. Now it\'s easy to drill down to all the months in 2021, and from there all the days in September 2021. I run it from an hourly cron job like::\n\n    0 * * * * /path/to/glassknife/.venv/bin/make-indexes Everything\n\nNote that ``make-indexes`` "owns" the content between the two separator ``---`` lines. Your own notes above and below that block are yours to edit as you see fit.\n\nprocess-notes\n-------------\n\n**Send items in your daily notes to other programs.**\n\nI wrote a `Quick Journaling`_ extension for Drafts_. After finding Obsidian, I wanted something similar for it so that I could record actions I want to take and journal entries I\'d like to make into applications other than Obsidian (which is brilliant for lots of things but still bested by special-purpose applications in some ways). This is the start of my answer to it. My daily notes template looks like::\n\n    # Work\n\n    # Personal\n\n    #unprocessed\n\nAfter adding things to a note all day, the note might end up looking like::\n\n    # Work\n\n    - [ ] Tell boss I\'m going on vacation\n\n    # Personal\n\n    Worked on [[Glass Knife]] project.\n    * Had dim sum for lunch.\n    Watching [[Ted Lasso]]\n    * Took the car for an oil change.\n    - [ ] Buy coffee filters\n    - Water the plant\n\n    # unprocessed\n\nRunning ``process-notes Everything`` with the sample configuration given above will do a few things:\n\n* Lines starting with ":literal:`- [ ] \\ `" will turn into OmniFocus actions and be removed from the daily note.\n* Lines starting with ":literal:`- \\ `" will become actions in the Reminders.app Inbox.\n* Lines starting with ":literal:`* \\ `" will be collected together and turned into a Day One journal entry, and removed from the daily note.\n* Since the ``# Work`` section is now empty, it will be removed from the daily note.\n* The ``#unprocessed`` tag will be removed from the daily note.\n\nThe end result will look like::\n\n    # Personal\n\n    Worked on [[Glass Knife]] project.\n    Watching [[Ted Lasso]]\n\nIf the resulting note is completely empty because all lines have been processed and there are no sections left, it will be deleted.\n\nI run this nightly with a cron job::\n\n    50 23 * * * /path/to/obsidian/.venv/bin/process-notes Stuff\n\nConfiguration\n^^^^^^^^^^^^^\n\nThe example configuration file above had this block::\n\n    process_notes:\n        actions:\n            "- ": Reminders\n            "* ": "Day One"\n            "- [ ] ": OmniFocus\n\nThat means that a line beginning with one those prefixes will be sent to the corresponding program. Feel free to alter this to your own preferences! If you don\'t use Day One, remove the ``"* ": "Day One"`` item. If you want lines starting with ```&&&`` to be sent to Reminders, add ``"&&&": Reminders`` to it.\n\nAs of this writing,\n\n* Day One\n* OmniFocus\n* Reminders\n\nare supported.\n\nContributing\n============\n\nPatches are welcome! Use Black_ to format them, and Pylint_, Flake8_, and mypy_ for linting.\n\nCopyright\n=========\n\nGlass Knife is copyright 2021 `Kirk Strauser <mailto:kirk@strauser.com>`_, and distributed under the terms of the Apache-2.0 License.\n\n.. _Black: https://pypi.org/project/black/\n.. _Day One: https://dayoneapp.com/\n.. _Drafts: https://getdrafts.com/\n.. _Flake8: https://flake8.pycqa.org/en/latest/\n.. _Maps of Content: https://publish.obsidian.md/lyt-kit/Umami/MOCs+(defn)\n.. _mypy: http://mypy-lang.org/\n.. _Obsidian: https://obsidian.md/\n.. _OmniFocus: https://www.omnigroup.com/omnifocus/\n.. _Pylint: https://pylint.org/\n.. _Quick Journaling: https://actions.getdrafts.com/g/1Sd\n',
    'author': 'Kirk Strauser',
    'author_email': 'kirk@strauser.com',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/kstrauser/glassknife',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'entry_points': entry_points,
    'python_requires': '>=3.7,<4.0',
}


setup(**setup_kwargs)
