# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities

__all__ = [
    'GetKafkaSchemaConfigurationResult',
    'AwaitableGetKafkaSchemaConfigurationResult',
    'get_kafka_schema_configuration',
    'get_kafka_schema_configuration_output',
]

@pulumi.output_type
class GetKafkaSchemaConfigurationResult:
    """
    A collection of values returned by getKafkaSchemaConfiguration.
    """
    def __init__(__self__, compatibility_level=None, id=None, project=None, schema=None, service_name=None, subject_name=None, version=None):
        if compatibility_level and not isinstance(compatibility_level, str):
            raise TypeError("Expected argument 'compatibility_level' to be a str")
        pulumi.set(__self__, "compatibility_level", compatibility_level)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if project and not isinstance(project, str):
            raise TypeError("Expected argument 'project' to be a str")
        pulumi.set(__self__, "project", project)
        if schema and not isinstance(schema, str):
            raise TypeError("Expected argument 'schema' to be a str")
        pulumi.set(__self__, "schema", schema)
        if service_name and not isinstance(service_name, str):
            raise TypeError("Expected argument 'service_name' to be a str")
        pulumi.set(__self__, "service_name", service_name)
        if subject_name and not isinstance(subject_name, str):
            raise TypeError("Expected argument 'subject_name' to be a str")
        pulumi.set(__self__, "subject_name", subject_name)
        if version and not isinstance(version, int):
            raise TypeError("Expected argument 'version' to be a int")
        pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter(name="compatibilityLevel")
    def compatibility_level(self) -> Optional[str]:
        """
        is the Global Kafka Schema configuration compatibility level when defined 
        for `KafkaSchemaConfiguration` resource. Also, Kafka Schema configuration
        compatibility level can be overridden for a specific subject when used in `KafkaSchema`
        resource. If the compatibility level not specified for the individual subject by default,
        it takes a global value. Allowed values: `BACKWARD`, `BACKWARD_TRANSITIVE`, `FORWARD`,
        `FORWARD_TRANSITIVE`, `FULL`, `FULL_TRANSITIVE`, `NONE`.
        """
        return pulumi.get(self, "compatibility_level")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def project(self) -> str:
        return pulumi.get(self, "project")

    @property
    @pulumi.getter
    def schema(self) -> Optional[str]:
        return pulumi.get(self, "schema")

    @property
    @pulumi.getter(name="serviceName")
    def service_name(self) -> str:
        return pulumi.get(self, "service_name")

    @property
    @pulumi.getter(name="subjectName")
    def subject_name(self) -> Optional[str]:
        return pulumi.get(self, "subject_name")

    @property
    @pulumi.getter
    def version(self) -> int:
        return pulumi.get(self, "version")


class AwaitableGetKafkaSchemaConfigurationResult(GetKafkaSchemaConfigurationResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetKafkaSchemaConfigurationResult(
            compatibility_level=self.compatibility_level,
            id=self.id,
            project=self.project,
            schema=self.schema,
            service_name=self.service_name,
            subject_name=self.subject_name,
            version=self.version)


def get_kafka_schema_configuration(compatibility_level: Optional[str] = None,
                                   project: Optional[str] = None,
                                   schema: Optional[str] = None,
                                   service_name: Optional[str] = None,
                                   subject_name: Optional[str] = None,
                                   version: Optional[int] = None,
                                   opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetKafkaSchemaConfigurationResult:
    """
    ## # Kafka Schema Configuration Data Source

    The Kafka Schema Configuration data source provides information about the existing Aiven
    Kafka Schema Configuration.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_aiven as aiven

    config = aiven.get_kafka_schema_configuration(project=aiven_project["kafka-schemas-project1"]["project"],
        service_name=aiven_service["kafka-service1"]["service_name"])
    ```


    :param str compatibility_level: is the Global Kafka Schema configuration compatibility level when defined 
           for `KafkaSchemaConfiguration` resource. Also, Kafka Schema configuration
           compatibility level can be overridden for a specific subject when used in `KafkaSchema`
           resource. If the compatibility level not specified for the individual subject by default,
           it takes a global value. Allowed values: `BACKWARD`, `BACKWARD_TRANSITIVE`, `FORWARD`,
           `FORWARD_TRANSITIVE`, `FULL`, `FULL_TRANSITIVE`, `NONE`.
    :param str project: and `service_name` - (Required) define the project and service the Kafka Schemas belongs to. 
           They should be defined using reference as shown above to set up dependencies correctly.
    """
    __args__ = dict()
    __args__['compatibilityLevel'] = compatibility_level
    __args__['project'] = project
    __args__['schema'] = schema
    __args__['serviceName'] = service_name
    __args__['subjectName'] = subject_name
    __args__['version'] = version
    if opts is None:
        opts = pulumi.InvokeOptions()
    if opts.version is None:
        opts.version = _utilities.get_version()
    __ret__ = pulumi.runtime.invoke('aiven:index/getKafkaSchemaConfiguration:getKafkaSchemaConfiguration', __args__, opts=opts, typ=GetKafkaSchemaConfigurationResult).value

    return AwaitableGetKafkaSchemaConfigurationResult(
        compatibility_level=__ret__.compatibility_level,
        id=__ret__.id,
        project=__ret__.project,
        schema=__ret__.schema,
        service_name=__ret__.service_name,
        subject_name=__ret__.subject_name,
        version=__ret__.version)


@_utilities.lift_output_func(get_kafka_schema_configuration)
def get_kafka_schema_configuration_output(compatibility_level: Optional[pulumi.Input[Optional[str]]] = None,
                                          project: Optional[pulumi.Input[str]] = None,
                                          schema: Optional[pulumi.Input[Optional[str]]] = None,
                                          service_name: Optional[pulumi.Input[str]] = None,
                                          subject_name: Optional[pulumi.Input[Optional[str]]] = None,
                                          version: Optional[pulumi.Input[Optional[int]]] = None,
                                          opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetKafkaSchemaConfigurationResult]:
    """
    ## # Kafka Schema Configuration Data Source

    The Kafka Schema Configuration data source provides information about the existing Aiven
    Kafka Schema Configuration.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_aiven as aiven

    config = aiven.get_kafka_schema_configuration(project=aiven_project["kafka-schemas-project1"]["project"],
        service_name=aiven_service["kafka-service1"]["service_name"])
    ```


    :param str compatibility_level: is the Global Kafka Schema configuration compatibility level when defined 
           for `KafkaSchemaConfiguration` resource. Also, Kafka Schema configuration
           compatibility level can be overridden for a specific subject when used in `KafkaSchema`
           resource. If the compatibility level not specified for the individual subject by default,
           it takes a global value. Allowed values: `BACKWARD`, `BACKWARD_TRANSITIVE`, `FORWARD`,
           `FORWARD_TRANSITIVE`, `FULL`, `FULL_TRANSITIVE`, `NONE`.
    :param str project: and `service_name` - (Required) define the project and service the Kafka Schemas belongs to. 
           They should be defined using reference as shown above to set up dependencies correctly.
    """
    ...
