# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities

__all__ = [
    'GetServiceUserResult',
    'AwaitableGetServiceUserResult',
    'get_service_user',
    'get_service_user_output',
]

@pulumi.output_type
class GetServiceUserResult:
    """
    A collection of values returned by getServiceUser.
    """
    def __init__(__self__, access_cert=None, access_key=None, authentication=None, id=None, password=None, project=None, redis_acl_categories=None, redis_acl_channels=None, redis_acl_commands=None, redis_acl_keys=None, service_name=None, type=None, username=None):
        if access_cert and not isinstance(access_cert, str):
            raise TypeError("Expected argument 'access_cert' to be a str")
        pulumi.set(__self__, "access_cert", access_cert)
        if access_key and not isinstance(access_key, str):
            raise TypeError("Expected argument 'access_key' to be a str")
        pulumi.set(__self__, "access_key", access_key)
        if authentication and not isinstance(authentication, str):
            raise TypeError("Expected argument 'authentication' to be a str")
        pulumi.set(__self__, "authentication", authentication)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if password and not isinstance(password, str):
            raise TypeError("Expected argument 'password' to be a str")
        pulumi.set(__self__, "password", password)
        if project and not isinstance(project, str):
            raise TypeError("Expected argument 'project' to be a str")
        pulumi.set(__self__, "project", project)
        if redis_acl_categories and not isinstance(redis_acl_categories, list):
            raise TypeError("Expected argument 'redis_acl_categories' to be a list")
        pulumi.set(__self__, "redis_acl_categories", redis_acl_categories)
        if redis_acl_channels and not isinstance(redis_acl_channels, list):
            raise TypeError("Expected argument 'redis_acl_channels' to be a list")
        pulumi.set(__self__, "redis_acl_channels", redis_acl_channels)
        if redis_acl_commands and not isinstance(redis_acl_commands, list):
            raise TypeError("Expected argument 'redis_acl_commands' to be a list")
        pulumi.set(__self__, "redis_acl_commands", redis_acl_commands)
        if redis_acl_keys and not isinstance(redis_acl_keys, list):
            raise TypeError("Expected argument 'redis_acl_keys' to be a list")
        pulumi.set(__self__, "redis_acl_keys", redis_acl_keys)
        if service_name and not isinstance(service_name, str):
            raise TypeError("Expected argument 'service_name' to be a str")
        pulumi.set(__self__, "service_name", service_name)
        if type and not isinstance(type, str):
            raise TypeError("Expected argument 'type' to be a str")
        pulumi.set(__self__, "type", type)
        if username and not isinstance(username, str):
            raise TypeError("Expected argument 'username' to be a str")
        pulumi.set(__self__, "username", username)

    @property
    @pulumi.getter(name="accessCert")
    def access_cert(self) -> str:
        """
        is the access certificate of the user (not applicable for all services).
        """
        return pulumi.get(self, "access_cert")

    @property
    @pulumi.getter(name="accessKey")
    def access_key(self) -> str:
        """
        is the access key of the user (not applicable for all services).
        """
        return pulumi.get(self, "access_key")

    @property
    @pulumi.getter
    def authentication(self) -> Optional[str]:
        return pulumi.get(self, "authentication")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def password(self) -> str:
        """
        is the password of the user (not applicable for all services).
        """
        return pulumi.get(self, "password")

    @property
    @pulumi.getter
    def project(self) -> str:
        return pulumi.get(self, "project")

    @property
    @pulumi.getter(name="redisAclCategories")
    def redis_acl_categories(self) -> Optional[Sequence[str]]:
        """
        Redis specific field, defines command category rules.
        """
        return pulumi.get(self, "redis_acl_categories")

    @property
    @pulumi.getter(name="redisAclChannels")
    def redis_acl_channels(self) -> Optional[Sequence[str]]:
        return pulumi.get(self, "redis_acl_channels")

    @property
    @pulumi.getter(name="redisAclCommands")
    def redis_acl_commands(self) -> Optional[Sequence[str]]:
        """
        Redis specific field, defines rules for individual commands.
        """
        return pulumi.get(self, "redis_acl_commands")

    @property
    @pulumi.getter(name="redisAclKeys")
    def redis_acl_keys(self) -> Optional[Sequence[str]]:
        """
        Redis specific field, defines key access rules.
        """
        return pulumi.get(self, "redis_acl_keys")

    @property
    @pulumi.getter(name="serviceName")
    def service_name(self) -> str:
        return pulumi.get(self, "service_name")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        tells whether the user is primary account or regular account.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def username(self) -> str:
        return pulumi.get(self, "username")


class AwaitableGetServiceUserResult(GetServiceUserResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetServiceUserResult(
            access_cert=self.access_cert,
            access_key=self.access_key,
            authentication=self.authentication,
            id=self.id,
            password=self.password,
            project=self.project,
            redis_acl_categories=self.redis_acl_categories,
            redis_acl_channels=self.redis_acl_channels,
            redis_acl_commands=self.redis_acl_commands,
            redis_acl_keys=self.redis_acl_keys,
            service_name=self.service_name,
            type=self.type,
            username=self.username)


def get_service_user(access_cert: Optional[str] = None,
                     access_key: Optional[str] = None,
                     authentication: Optional[str] = None,
                     password: Optional[str] = None,
                     project: Optional[str] = None,
                     redis_acl_categories: Optional[Sequence[str]] = None,
                     redis_acl_channels: Optional[Sequence[str]] = None,
                     redis_acl_commands: Optional[Sequence[str]] = None,
                     redis_acl_keys: Optional[Sequence[str]] = None,
                     service_name: Optional[str] = None,
                     type: Optional[str] = None,
                     username: Optional[str] = None,
                     opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetServiceUserResult:
    """
    ## # Service User Data Source

    The Service User data source provides information about the existing Aiven Service User.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_aiven as aiven

    myserviceuser = aiven.get_service_user(project=aiven_project["myproject"]["project"],
        service_name=aiven_service["myservice"]["service_name"],
        username="<USERNAME>")
    ```

    > **Note** The service user data source is not supported for Aiven Grafana services.


    :param str access_cert: is the access certificate of the user (not applicable for all services).
    :param str access_key: is the access key of the user (not applicable for all services).
    :param str password: is the password of the user (not applicable for all services).
    :param str project: and `service_name` - (Required) define the project and service the user belongs to. They should be defined
           using reference as shown above to set up dependencies correctly.
    :param Sequence[str] redis_acl_categories: Redis specific field, defines command category rules.
    :param Sequence[str] redis_acl_commands: Redis specific field, defines rules for individual commands.
    :param Sequence[str] redis_acl_keys: Redis specific field, defines key access rules.
    :param str type: tells whether the user is primary account or regular account.
    :param str username: is the actual name of the user account.
    """
    __args__ = dict()
    __args__['accessCert'] = access_cert
    __args__['accessKey'] = access_key
    __args__['authentication'] = authentication
    __args__['password'] = password
    __args__['project'] = project
    __args__['redisAclCategories'] = redis_acl_categories
    __args__['redisAclChannels'] = redis_acl_channels
    __args__['redisAclCommands'] = redis_acl_commands
    __args__['redisAclKeys'] = redis_acl_keys
    __args__['serviceName'] = service_name
    __args__['type'] = type
    __args__['username'] = username
    if opts is None:
        opts = pulumi.InvokeOptions()
    if opts.version is None:
        opts.version = _utilities.get_version()
    __ret__ = pulumi.runtime.invoke('aiven:index/getServiceUser:getServiceUser', __args__, opts=opts, typ=GetServiceUserResult).value

    return AwaitableGetServiceUserResult(
        access_cert=__ret__.access_cert,
        access_key=__ret__.access_key,
        authentication=__ret__.authentication,
        id=__ret__.id,
        password=__ret__.password,
        project=__ret__.project,
        redis_acl_categories=__ret__.redis_acl_categories,
        redis_acl_channels=__ret__.redis_acl_channels,
        redis_acl_commands=__ret__.redis_acl_commands,
        redis_acl_keys=__ret__.redis_acl_keys,
        service_name=__ret__.service_name,
        type=__ret__.type,
        username=__ret__.username)


@_utilities.lift_output_func(get_service_user)
def get_service_user_output(access_cert: Optional[pulumi.Input[Optional[str]]] = None,
                            access_key: Optional[pulumi.Input[Optional[str]]] = None,
                            authentication: Optional[pulumi.Input[Optional[str]]] = None,
                            password: Optional[pulumi.Input[Optional[str]]] = None,
                            project: Optional[pulumi.Input[str]] = None,
                            redis_acl_categories: Optional[pulumi.Input[Optional[Sequence[str]]]] = None,
                            redis_acl_channels: Optional[pulumi.Input[Optional[Sequence[str]]]] = None,
                            redis_acl_commands: Optional[pulumi.Input[Optional[Sequence[str]]]] = None,
                            redis_acl_keys: Optional[pulumi.Input[Optional[Sequence[str]]]] = None,
                            service_name: Optional[pulumi.Input[str]] = None,
                            type: Optional[pulumi.Input[Optional[str]]] = None,
                            username: Optional[pulumi.Input[str]] = None,
                            opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetServiceUserResult]:
    """
    ## # Service User Data Source

    The Service User data source provides information about the existing Aiven Service User.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_aiven as aiven

    myserviceuser = aiven.get_service_user(project=aiven_project["myproject"]["project"],
        service_name=aiven_service["myservice"]["service_name"],
        username="<USERNAME>")
    ```

    > **Note** The service user data source is not supported for Aiven Grafana services.


    :param str access_cert: is the access certificate of the user (not applicable for all services).
    :param str access_key: is the access key of the user (not applicable for all services).
    :param str password: is the password of the user (not applicable for all services).
    :param str project: and `service_name` - (Required) define the project and service the user belongs to. They should be defined
           using reference as shown above to set up dependencies correctly.
    :param Sequence[str] redis_acl_categories: Redis specific field, defines command category rules.
    :param Sequence[str] redis_acl_commands: Redis specific field, defines rules for individual commands.
    :param Sequence[str] redis_acl_keys: Redis specific field, defines key access rules.
    :param str type: tells whether the user is primary account or regular account.
    :param str username: is the actual name of the user account.
    """
    ...
