# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities

__all__ = ['OpenSearchAclConfigArgs', 'OpenSearchAclConfig']

@pulumi.input_type
class OpenSearchAclConfigArgs:
    def __init__(__self__, *,
                 project: pulumi.Input[str],
                 service_name: pulumi.Input[str],
                 enabled: Optional[pulumi.Input[bool]] = None,
                 extended_acl: Optional[pulumi.Input[bool]] = None):
        """
        The set of arguments for constructing a OpenSearchAclConfig resource.
        :param pulumi.Input[str] project: and `service_name` - (Required) define the project and service the ACL belongs to. They should be defined
               using reference as shown above to set up dependencies correctly.
        :param pulumi.Input[str] service_name: Service to link the Opensearch ACLs to
        :param pulumi.Input[bool] enabled: enables of disables Opensearch ACL's.
        :param pulumi.Input[bool] extended_acl: Index rules can be applied in a limited fashion to the _mget, _msearch and _bulk APIs
               (and only those) by enabling the ExtendedAcl option for the service. When it is enabled, users can use these APIs as
               long as all operations only target indexes they have been granted access to.
        """
        pulumi.set(__self__, "project", project)
        pulumi.set(__self__, "service_name", service_name)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if extended_acl is not None:
            pulumi.set(__self__, "extended_acl", extended_acl)

    @property
    @pulumi.getter
    def project(self) -> pulumi.Input[str]:
        """
        and `service_name` - (Required) define the project and service the ACL belongs to. They should be defined
        using reference as shown above to set up dependencies correctly.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: pulumi.Input[str]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter(name="serviceName")
    def service_name(self) -> pulumi.Input[str]:
        """
        Service to link the Opensearch ACLs to
        """
        return pulumi.get(self, "service_name")

    @service_name.setter
    def service_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "service_name", value)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        enables of disables Opensearch ACL's.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter(name="extendedAcl")
    def extended_acl(self) -> Optional[pulumi.Input[bool]]:
        """
        Index rules can be applied in a limited fashion to the _mget, _msearch and _bulk APIs
        (and only those) by enabling the ExtendedAcl option for the service. When it is enabled, users can use these APIs as
        long as all operations only target indexes they have been granted access to.
        """
        return pulumi.get(self, "extended_acl")

    @extended_acl.setter
    def extended_acl(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "extended_acl", value)


@pulumi.input_type
class _OpenSearchAclConfigState:
    def __init__(__self__, *,
                 enabled: Optional[pulumi.Input[bool]] = None,
                 extended_acl: Optional[pulumi.Input[bool]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 service_name: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering OpenSearchAclConfig resources.
        :param pulumi.Input[bool] enabled: enables of disables Opensearch ACL's.
        :param pulumi.Input[bool] extended_acl: Index rules can be applied in a limited fashion to the _mget, _msearch and _bulk APIs
               (and only those) by enabling the ExtendedAcl option for the service. When it is enabled, users can use these APIs as
               long as all operations only target indexes they have been granted access to.
        :param pulumi.Input[str] project: and `service_name` - (Required) define the project and service the ACL belongs to. They should be defined
               using reference as shown above to set up dependencies correctly.
        :param pulumi.Input[str] service_name: Service to link the Opensearch ACLs to
        """
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if extended_acl is not None:
            pulumi.set(__self__, "extended_acl", extended_acl)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if service_name is not None:
            pulumi.set(__self__, "service_name", service_name)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        enables of disables Opensearch ACL's.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter(name="extendedAcl")
    def extended_acl(self) -> Optional[pulumi.Input[bool]]:
        """
        Index rules can be applied in a limited fashion to the _mget, _msearch and _bulk APIs
        (and only those) by enabling the ExtendedAcl option for the service. When it is enabled, users can use these APIs as
        long as all operations only target indexes they have been granted access to.
        """
        return pulumi.get(self, "extended_acl")

    @extended_acl.setter
    def extended_acl(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "extended_acl", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[str]]:
        """
        and `service_name` - (Required) define the project and service the ACL belongs to. They should be defined
        using reference as shown above to set up dependencies correctly.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter(name="serviceName")
    def service_name(self) -> Optional[pulumi.Input[str]]:
        """
        Service to link the Opensearch ACLs to
        """
        return pulumi.get(self, "service_name")

    @service_name.setter
    def service_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "service_name", value)


class OpenSearchAclConfig(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 enabled: Optional[pulumi.Input[bool]] = None,
                 extended_acl: Optional[pulumi.Input[bool]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 service_name: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        ## # Opensearch ACL Config Resource

        The Opensearch ACL Config resource allows the configuration of ACL management on an Aiven Opensearch service.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aiven as aiven

        os_acl_config = aiven.OpenSearchAclConfig("os-acl-config",
            project=aiven_project["os-project"]["project"],
            service_name=aiven_opensearch["os"]["service_name"],
            enabled=True,
            extended_acl=False)
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] enabled: enables of disables Opensearch ACL's.
        :param pulumi.Input[bool] extended_acl: Index rules can be applied in a limited fashion to the _mget, _msearch and _bulk APIs
               (and only those) by enabling the ExtendedAcl option for the service. When it is enabled, users can use these APIs as
               long as all operations only target indexes they have been granted access to.
        :param pulumi.Input[str] project: and `service_name` - (Required) define the project and service the ACL belongs to. They should be defined
               using reference as shown above to set up dependencies correctly.
        :param pulumi.Input[str] service_name: Service to link the Opensearch ACLs to
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: OpenSearchAclConfigArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## # Opensearch ACL Config Resource

        The Opensearch ACL Config resource allows the configuration of ACL management on an Aiven Opensearch service.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aiven as aiven

        os_acl_config = aiven.OpenSearchAclConfig("os-acl-config",
            project=aiven_project["os-project"]["project"],
            service_name=aiven_opensearch["os"]["service_name"],
            enabled=True,
            extended_acl=False)
        ```

        :param str resource_name: The name of the resource.
        :param OpenSearchAclConfigArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(OpenSearchAclConfigArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 enabled: Optional[pulumi.Input[bool]] = None,
                 extended_acl: Optional[pulumi.Input[bool]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 service_name: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = OpenSearchAclConfigArgs.__new__(OpenSearchAclConfigArgs)

            __props__.__dict__["enabled"] = enabled
            __props__.__dict__["extended_acl"] = extended_acl
            if project is None and not opts.urn:
                raise TypeError("Missing required property 'project'")
            __props__.__dict__["project"] = project
            if service_name is None and not opts.urn:
                raise TypeError("Missing required property 'service_name'")
            __props__.__dict__["service_name"] = service_name
        super(OpenSearchAclConfig, __self__).__init__(
            'aiven:index/openSearchAclConfig:OpenSearchAclConfig',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            enabled: Optional[pulumi.Input[bool]] = None,
            extended_acl: Optional[pulumi.Input[bool]] = None,
            project: Optional[pulumi.Input[str]] = None,
            service_name: Optional[pulumi.Input[str]] = None) -> 'OpenSearchAclConfig':
        """
        Get an existing OpenSearchAclConfig resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] enabled: enables of disables Opensearch ACL's.
        :param pulumi.Input[bool] extended_acl: Index rules can be applied in a limited fashion to the _mget, _msearch and _bulk APIs
               (and only those) by enabling the ExtendedAcl option for the service. When it is enabled, users can use these APIs as
               long as all operations only target indexes they have been granted access to.
        :param pulumi.Input[str] project: and `service_name` - (Required) define the project and service the ACL belongs to. They should be defined
               using reference as shown above to set up dependencies correctly.
        :param pulumi.Input[str] service_name: Service to link the Opensearch ACLs to
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _OpenSearchAclConfigState.__new__(_OpenSearchAclConfigState)

        __props__.__dict__["enabled"] = enabled
        __props__.__dict__["extended_acl"] = extended_acl
        __props__.__dict__["project"] = project
        __props__.__dict__["service_name"] = service_name
        return OpenSearchAclConfig(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def enabled(self) -> pulumi.Output[Optional[bool]]:
        """
        enables of disables Opensearch ACL's.
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter(name="extendedAcl")
    def extended_acl(self) -> pulumi.Output[Optional[bool]]:
        """
        Index rules can be applied in a limited fashion to the _mget, _msearch and _bulk APIs
        (and only those) by enabling the ExtendedAcl option for the service. When it is enabled, users can use these APIs as
        long as all operations only target indexes they have been granted access to.
        """
        return pulumi.get(self, "extended_acl")

    @property
    @pulumi.getter
    def project(self) -> pulumi.Output[str]:
        """
        and `service_name` - (Required) define the project and service the ACL belongs to. They should be defined
        using reference as shown above to set up dependencies correctly.
        """
        return pulumi.get(self, "project")

    @property
    @pulumi.getter(name="serviceName")
    def service_name(self) -> pulumi.Output[str]:
        """
        Service to link the Opensearch ACLs to
        """
        return pulumi.get(self, "service_name")

