# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ServiceArgs', 'Service']

@pulumi.input_type
class ServiceArgs:
    def __init__(__self__, *,
                 project: pulumi.Input[str],
                 service_name: pulumi.Input[str],
                 service_type: pulumi.Input[str],
                 cassandra: Optional[pulumi.Input['ServiceCassandraArgs']] = None,
                 cassandra_user_config: Optional[pulumi.Input['ServiceCassandraUserConfigArgs']] = None,
                 cloud_name: Optional[pulumi.Input[str]] = None,
                 elasticsearch: Optional[pulumi.Input['ServiceElasticsearchArgs']] = None,
                 elasticsearch_user_config: Optional[pulumi.Input['ServiceElasticsearchUserConfigArgs']] = None,
                 grafana: Optional[pulumi.Input['ServiceGrafanaArgs']] = None,
                 grafana_user_config: Optional[pulumi.Input['ServiceGrafanaUserConfigArgs']] = None,
                 influxdb: Optional[pulumi.Input['ServiceInfluxdbArgs']] = None,
                 influxdb_user_config: Optional[pulumi.Input['ServiceInfluxdbUserConfigArgs']] = None,
                 kafka: Optional[pulumi.Input['ServiceKafkaArgs']] = None,
                 kafka_connect: Optional[pulumi.Input['ServiceKafkaConnectArgs']] = None,
                 kafka_connect_user_config: Optional[pulumi.Input['ServiceKafkaConnectUserConfigArgs']] = None,
                 kafka_mirrormaker: Optional[pulumi.Input['ServiceKafkaMirrormakerArgs']] = None,
                 kafka_mirrormaker_user_config: Optional[pulumi.Input['ServiceKafkaMirrormakerUserConfigArgs']] = None,
                 kafka_user_config: Optional[pulumi.Input['ServiceKafkaUserConfigArgs']] = None,
                 maintenance_window_dow: Optional[pulumi.Input[str]] = None,
                 maintenance_window_time: Optional[pulumi.Input[str]] = None,
                 mysql: Optional[pulumi.Input['ServiceMysqlArgs']] = None,
                 mysql_user_config: Optional[pulumi.Input['ServiceMysqlUserConfigArgs']] = None,
                 opensearch: Optional[pulumi.Input['ServiceOpensearchArgs']] = None,
                 opensearch_user_config: Optional[pulumi.Input['ServiceOpensearchUserConfigArgs']] = None,
                 pg: Optional[pulumi.Input['ServicePgArgs']] = None,
                 pg_user_config: Optional[pulumi.Input['ServicePgUserConfigArgs']] = None,
                 plan: Optional[pulumi.Input[str]] = None,
                 project_vpc_id: Optional[pulumi.Input[str]] = None,
                 redis: Optional[pulumi.Input['ServiceRedisArgs']] = None,
                 redis_user_config: Optional[pulumi.Input['ServiceRedisUserConfigArgs']] = None,
                 service_integrations: Optional[pulumi.Input[Sequence[pulumi.Input['ServiceServiceIntegrationArgs']]]] = None,
                 termination_protection: Optional[pulumi.Input[bool]] = None):
        """
        The set of arguments for constructing a Service resource.
        :param pulumi.Input[str] project: Target project
        :param pulumi.Input[str] service_name: Service name
        :param pulumi.Input[str] service_type: Service type code
        :param pulumi.Input['ServiceCassandraArgs'] cassandra: Cassandra specific server provided values
        :param pulumi.Input['ServiceCassandraUserConfigArgs'] cassandra_user_config: Cassandra specific user configurable settings
        :param pulumi.Input[str] cloud_name: Cloud the service runs in
        :param pulumi.Input['ServiceElasticsearchArgs'] elasticsearch: Elasticsearch specific server provided values
        :param pulumi.Input['ServiceElasticsearchUserConfigArgs'] elasticsearch_user_config: Elasticsearch specific user configurable settings
        :param pulumi.Input['ServiceGrafanaArgs'] grafana: Grafana specific server provided values
        :param pulumi.Input['ServiceGrafanaUserConfigArgs'] grafana_user_config: Grafana specific user configurable settings
        :param pulumi.Input['ServiceInfluxdbArgs'] influxdb: InfluxDB specific server provided values
        :param pulumi.Input['ServiceInfluxdbUserConfigArgs'] influxdb_user_config: InfluxDB specific user configurable settings
        :param pulumi.Input['ServiceKafkaArgs'] kafka: Kafka specific server provided values
        :param pulumi.Input['ServiceKafkaConnectArgs'] kafka_connect: Kafka Connect specific server provided values
        :param pulumi.Input['ServiceKafkaConnectUserConfigArgs'] kafka_connect_user_config: Kafka Connect specific user configurable settings
        :param pulumi.Input['ServiceKafkaMirrormakerArgs'] kafka_mirrormaker: Kafka MirrorMaker 2 specific server provided values
        :param pulumi.Input['ServiceKafkaMirrormakerUserConfigArgs'] kafka_mirrormaker_user_config: Kafka MirrorMaker 2 specific user configurable settings
        :param pulumi.Input['ServiceKafkaUserConfigArgs'] kafka_user_config: Kafka specific user configurable settings
        :param pulumi.Input[str] maintenance_window_dow: Day of week when maintenance operations should be performed. One monday, tuesday, wednesday, etc.
        :param pulumi.Input[str] maintenance_window_time: Time of day when maintenance operations should be performed. UTC time in HH:mm:ss format.
        :param pulumi.Input['ServiceMysqlArgs'] mysql: MySQL specific server provided values
        :param pulumi.Input['ServiceMysqlUserConfigArgs'] mysql_user_config: MySQL specific user configurable settings
        :param pulumi.Input['ServiceOpensearchArgs'] opensearch: Opensearch specific server provided values
        :param pulumi.Input['ServiceOpensearchUserConfigArgs'] opensearch_user_config: Opensearch specific user configurable settings
        :param pulumi.Input['ServicePgArgs'] pg: PostgreSQL specific server provided values
        :param pulumi.Input['ServicePgUserConfigArgs'] pg_user_config: PostgreSQL specific user configurable settings
        :param pulumi.Input[str] plan: Subscription plan
        :param pulumi.Input[str] project_vpc_id: Identifier of the VPC the service should be in, if any
        :param pulumi.Input['ServiceRedisArgs'] redis: Redis specific server provided values
        :param pulumi.Input['ServiceRedisUserConfigArgs'] redis_user_config: Redis specific user configurable settings
        :param pulumi.Input[Sequence[pulumi.Input['ServiceServiceIntegrationArgs']]] service_integrations: Service integrations to specify when creating a service. Not applied after initial service creation
        :param pulumi.Input[bool] termination_protection: Prevent service from being deleted. It is recommended to have this enabled for all services.
        """
        pulumi.set(__self__, "project", project)
        pulumi.set(__self__, "service_name", service_name)
        pulumi.set(__self__, "service_type", service_type)
        if cassandra is not None:
            pulumi.set(__self__, "cassandra", cassandra)
        if cassandra_user_config is not None:
            pulumi.set(__self__, "cassandra_user_config", cassandra_user_config)
        if cloud_name is not None:
            pulumi.set(__self__, "cloud_name", cloud_name)
        if elasticsearch is not None:
            pulumi.set(__self__, "elasticsearch", elasticsearch)
        if elasticsearch_user_config is not None:
            pulumi.set(__self__, "elasticsearch_user_config", elasticsearch_user_config)
        if grafana is not None:
            pulumi.set(__self__, "grafana", grafana)
        if grafana_user_config is not None:
            pulumi.set(__self__, "grafana_user_config", grafana_user_config)
        if influxdb is not None:
            pulumi.set(__self__, "influxdb", influxdb)
        if influxdb_user_config is not None:
            pulumi.set(__self__, "influxdb_user_config", influxdb_user_config)
        if kafka is not None:
            pulumi.set(__self__, "kafka", kafka)
        if kafka_connect is not None:
            pulumi.set(__self__, "kafka_connect", kafka_connect)
        if kafka_connect_user_config is not None:
            pulumi.set(__self__, "kafka_connect_user_config", kafka_connect_user_config)
        if kafka_mirrormaker is not None:
            pulumi.set(__self__, "kafka_mirrormaker", kafka_mirrormaker)
        if kafka_mirrormaker_user_config is not None:
            pulumi.set(__self__, "kafka_mirrormaker_user_config", kafka_mirrormaker_user_config)
        if kafka_user_config is not None:
            pulumi.set(__self__, "kafka_user_config", kafka_user_config)
        if maintenance_window_dow is not None:
            pulumi.set(__self__, "maintenance_window_dow", maintenance_window_dow)
        if maintenance_window_time is not None:
            pulumi.set(__self__, "maintenance_window_time", maintenance_window_time)
        if mysql is not None:
            pulumi.set(__self__, "mysql", mysql)
        if mysql_user_config is not None:
            pulumi.set(__self__, "mysql_user_config", mysql_user_config)
        if opensearch is not None:
            pulumi.set(__self__, "opensearch", opensearch)
        if opensearch_user_config is not None:
            pulumi.set(__self__, "opensearch_user_config", opensearch_user_config)
        if pg is not None:
            pulumi.set(__self__, "pg", pg)
        if pg_user_config is not None:
            pulumi.set(__self__, "pg_user_config", pg_user_config)
        if plan is not None:
            pulumi.set(__self__, "plan", plan)
        if project_vpc_id is not None:
            pulumi.set(__self__, "project_vpc_id", project_vpc_id)
        if redis is not None:
            pulumi.set(__self__, "redis", redis)
        if redis_user_config is not None:
            pulumi.set(__self__, "redis_user_config", redis_user_config)
        if service_integrations is not None:
            pulumi.set(__self__, "service_integrations", service_integrations)
        if termination_protection is not None:
            pulumi.set(__self__, "termination_protection", termination_protection)

    @property
    @pulumi.getter
    def project(self) -> pulumi.Input[str]:
        """
        Target project
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: pulumi.Input[str]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter(name="serviceName")
    def service_name(self) -> pulumi.Input[str]:
        """
        Service name
        """
        return pulumi.get(self, "service_name")

    @service_name.setter
    def service_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "service_name", value)

    @property
    @pulumi.getter(name="serviceType")
    def service_type(self) -> pulumi.Input[str]:
        """
        Service type code
        """
        return pulumi.get(self, "service_type")

    @service_type.setter
    def service_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "service_type", value)

    @property
    @pulumi.getter
    def cassandra(self) -> Optional[pulumi.Input['ServiceCassandraArgs']]:
        """
        Cassandra specific server provided values
        """
        return pulumi.get(self, "cassandra")

    @cassandra.setter
    def cassandra(self, value: Optional[pulumi.Input['ServiceCassandraArgs']]):
        pulumi.set(self, "cassandra", value)

    @property
    @pulumi.getter(name="cassandraUserConfig")
    def cassandra_user_config(self) -> Optional[pulumi.Input['ServiceCassandraUserConfigArgs']]:
        """
        Cassandra specific user configurable settings
        """
        return pulumi.get(self, "cassandra_user_config")

    @cassandra_user_config.setter
    def cassandra_user_config(self, value: Optional[pulumi.Input['ServiceCassandraUserConfigArgs']]):
        pulumi.set(self, "cassandra_user_config", value)

    @property
    @pulumi.getter(name="cloudName")
    def cloud_name(self) -> Optional[pulumi.Input[str]]:
        """
        Cloud the service runs in
        """
        return pulumi.get(self, "cloud_name")

    @cloud_name.setter
    def cloud_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cloud_name", value)

    @property
    @pulumi.getter
    def elasticsearch(self) -> Optional[pulumi.Input['ServiceElasticsearchArgs']]:
        """
        Elasticsearch specific server provided values
        """
        return pulumi.get(self, "elasticsearch")

    @elasticsearch.setter
    def elasticsearch(self, value: Optional[pulumi.Input['ServiceElasticsearchArgs']]):
        pulumi.set(self, "elasticsearch", value)

    @property
    @pulumi.getter(name="elasticsearchUserConfig")
    def elasticsearch_user_config(self) -> Optional[pulumi.Input['ServiceElasticsearchUserConfigArgs']]:
        """
        Elasticsearch specific user configurable settings
        """
        return pulumi.get(self, "elasticsearch_user_config")

    @elasticsearch_user_config.setter
    def elasticsearch_user_config(self, value: Optional[pulumi.Input['ServiceElasticsearchUserConfigArgs']]):
        pulumi.set(self, "elasticsearch_user_config", value)

    @property
    @pulumi.getter
    def grafana(self) -> Optional[pulumi.Input['ServiceGrafanaArgs']]:
        """
        Grafana specific server provided values
        """
        return pulumi.get(self, "grafana")

    @grafana.setter
    def grafana(self, value: Optional[pulumi.Input['ServiceGrafanaArgs']]):
        pulumi.set(self, "grafana", value)

    @property
    @pulumi.getter(name="grafanaUserConfig")
    def grafana_user_config(self) -> Optional[pulumi.Input['ServiceGrafanaUserConfigArgs']]:
        """
        Grafana specific user configurable settings
        """
        return pulumi.get(self, "grafana_user_config")

    @grafana_user_config.setter
    def grafana_user_config(self, value: Optional[pulumi.Input['ServiceGrafanaUserConfigArgs']]):
        pulumi.set(self, "grafana_user_config", value)

    @property
    @pulumi.getter
    def influxdb(self) -> Optional[pulumi.Input['ServiceInfluxdbArgs']]:
        """
        InfluxDB specific server provided values
        """
        return pulumi.get(self, "influxdb")

    @influxdb.setter
    def influxdb(self, value: Optional[pulumi.Input['ServiceInfluxdbArgs']]):
        pulumi.set(self, "influxdb", value)

    @property
    @pulumi.getter(name="influxdbUserConfig")
    def influxdb_user_config(self) -> Optional[pulumi.Input['ServiceInfluxdbUserConfigArgs']]:
        """
        InfluxDB specific user configurable settings
        """
        return pulumi.get(self, "influxdb_user_config")

    @influxdb_user_config.setter
    def influxdb_user_config(self, value: Optional[pulumi.Input['ServiceInfluxdbUserConfigArgs']]):
        pulumi.set(self, "influxdb_user_config", value)

    @property
    @pulumi.getter
    def kafka(self) -> Optional[pulumi.Input['ServiceKafkaArgs']]:
        """
        Kafka specific server provided values
        """
        return pulumi.get(self, "kafka")

    @kafka.setter
    def kafka(self, value: Optional[pulumi.Input['ServiceKafkaArgs']]):
        pulumi.set(self, "kafka", value)

    @property
    @pulumi.getter(name="kafkaConnect")
    def kafka_connect(self) -> Optional[pulumi.Input['ServiceKafkaConnectArgs']]:
        """
        Kafka Connect specific server provided values
        """
        return pulumi.get(self, "kafka_connect")

    @kafka_connect.setter
    def kafka_connect(self, value: Optional[pulumi.Input['ServiceKafkaConnectArgs']]):
        pulumi.set(self, "kafka_connect", value)

    @property
    @pulumi.getter(name="kafkaConnectUserConfig")
    def kafka_connect_user_config(self) -> Optional[pulumi.Input['ServiceKafkaConnectUserConfigArgs']]:
        """
        Kafka Connect specific user configurable settings
        """
        return pulumi.get(self, "kafka_connect_user_config")

    @kafka_connect_user_config.setter
    def kafka_connect_user_config(self, value: Optional[pulumi.Input['ServiceKafkaConnectUserConfigArgs']]):
        pulumi.set(self, "kafka_connect_user_config", value)

    @property
    @pulumi.getter(name="kafkaMirrormaker")
    def kafka_mirrormaker(self) -> Optional[pulumi.Input['ServiceKafkaMirrormakerArgs']]:
        """
        Kafka MirrorMaker 2 specific server provided values
        """
        return pulumi.get(self, "kafka_mirrormaker")

    @kafka_mirrormaker.setter
    def kafka_mirrormaker(self, value: Optional[pulumi.Input['ServiceKafkaMirrormakerArgs']]):
        pulumi.set(self, "kafka_mirrormaker", value)

    @property
    @pulumi.getter(name="kafkaMirrormakerUserConfig")
    def kafka_mirrormaker_user_config(self) -> Optional[pulumi.Input['ServiceKafkaMirrormakerUserConfigArgs']]:
        """
        Kafka MirrorMaker 2 specific user configurable settings
        """
        return pulumi.get(self, "kafka_mirrormaker_user_config")

    @kafka_mirrormaker_user_config.setter
    def kafka_mirrormaker_user_config(self, value: Optional[pulumi.Input['ServiceKafkaMirrormakerUserConfigArgs']]):
        pulumi.set(self, "kafka_mirrormaker_user_config", value)

    @property
    @pulumi.getter(name="kafkaUserConfig")
    def kafka_user_config(self) -> Optional[pulumi.Input['ServiceKafkaUserConfigArgs']]:
        """
        Kafka specific user configurable settings
        """
        return pulumi.get(self, "kafka_user_config")

    @kafka_user_config.setter
    def kafka_user_config(self, value: Optional[pulumi.Input['ServiceKafkaUserConfigArgs']]):
        pulumi.set(self, "kafka_user_config", value)

    @property
    @pulumi.getter(name="maintenanceWindowDow")
    def maintenance_window_dow(self) -> Optional[pulumi.Input[str]]:
        """
        Day of week when maintenance operations should be performed. One monday, tuesday, wednesday, etc.
        """
        return pulumi.get(self, "maintenance_window_dow")

    @maintenance_window_dow.setter
    def maintenance_window_dow(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "maintenance_window_dow", value)

    @property
    @pulumi.getter(name="maintenanceWindowTime")
    def maintenance_window_time(self) -> Optional[pulumi.Input[str]]:
        """
        Time of day when maintenance operations should be performed. UTC time in HH:mm:ss format.
        """
        return pulumi.get(self, "maintenance_window_time")

    @maintenance_window_time.setter
    def maintenance_window_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "maintenance_window_time", value)

    @property
    @pulumi.getter
    def mysql(self) -> Optional[pulumi.Input['ServiceMysqlArgs']]:
        """
        MySQL specific server provided values
        """
        return pulumi.get(self, "mysql")

    @mysql.setter
    def mysql(self, value: Optional[pulumi.Input['ServiceMysqlArgs']]):
        pulumi.set(self, "mysql", value)

    @property
    @pulumi.getter(name="mysqlUserConfig")
    def mysql_user_config(self) -> Optional[pulumi.Input['ServiceMysqlUserConfigArgs']]:
        """
        MySQL specific user configurable settings
        """
        return pulumi.get(self, "mysql_user_config")

    @mysql_user_config.setter
    def mysql_user_config(self, value: Optional[pulumi.Input['ServiceMysqlUserConfigArgs']]):
        pulumi.set(self, "mysql_user_config", value)

    @property
    @pulumi.getter
    def opensearch(self) -> Optional[pulumi.Input['ServiceOpensearchArgs']]:
        """
        Opensearch specific server provided values
        """
        return pulumi.get(self, "opensearch")

    @opensearch.setter
    def opensearch(self, value: Optional[pulumi.Input['ServiceOpensearchArgs']]):
        pulumi.set(self, "opensearch", value)

    @property
    @pulumi.getter(name="opensearchUserConfig")
    def opensearch_user_config(self) -> Optional[pulumi.Input['ServiceOpensearchUserConfigArgs']]:
        """
        Opensearch specific user configurable settings
        """
        return pulumi.get(self, "opensearch_user_config")

    @opensearch_user_config.setter
    def opensearch_user_config(self, value: Optional[pulumi.Input['ServiceOpensearchUserConfigArgs']]):
        pulumi.set(self, "opensearch_user_config", value)

    @property
    @pulumi.getter
    def pg(self) -> Optional[pulumi.Input['ServicePgArgs']]:
        """
        PostgreSQL specific server provided values
        """
        return pulumi.get(self, "pg")

    @pg.setter
    def pg(self, value: Optional[pulumi.Input['ServicePgArgs']]):
        pulumi.set(self, "pg", value)

    @property
    @pulumi.getter(name="pgUserConfig")
    def pg_user_config(self) -> Optional[pulumi.Input['ServicePgUserConfigArgs']]:
        """
        PostgreSQL specific user configurable settings
        """
        return pulumi.get(self, "pg_user_config")

    @pg_user_config.setter
    def pg_user_config(self, value: Optional[pulumi.Input['ServicePgUserConfigArgs']]):
        pulumi.set(self, "pg_user_config", value)

    @property
    @pulumi.getter
    def plan(self) -> Optional[pulumi.Input[str]]:
        """
        Subscription plan
        """
        return pulumi.get(self, "plan")

    @plan.setter
    def plan(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "plan", value)

    @property
    @pulumi.getter(name="projectVpcId")
    def project_vpc_id(self) -> Optional[pulumi.Input[str]]:
        """
        Identifier of the VPC the service should be in, if any
        """
        return pulumi.get(self, "project_vpc_id")

    @project_vpc_id.setter
    def project_vpc_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project_vpc_id", value)

    @property
    @pulumi.getter
    def redis(self) -> Optional[pulumi.Input['ServiceRedisArgs']]:
        """
        Redis specific server provided values
        """
        return pulumi.get(self, "redis")

    @redis.setter
    def redis(self, value: Optional[pulumi.Input['ServiceRedisArgs']]):
        pulumi.set(self, "redis", value)

    @property
    @pulumi.getter(name="redisUserConfig")
    def redis_user_config(self) -> Optional[pulumi.Input['ServiceRedisUserConfigArgs']]:
        """
        Redis specific user configurable settings
        """
        return pulumi.get(self, "redis_user_config")

    @redis_user_config.setter
    def redis_user_config(self, value: Optional[pulumi.Input['ServiceRedisUserConfigArgs']]):
        pulumi.set(self, "redis_user_config", value)

    @property
    @pulumi.getter(name="serviceIntegrations")
    def service_integrations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ServiceServiceIntegrationArgs']]]]:
        """
        Service integrations to specify when creating a service. Not applied after initial service creation
        """
        return pulumi.get(self, "service_integrations")

    @service_integrations.setter
    def service_integrations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ServiceServiceIntegrationArgs']]]]):
        pulumi.set(self, "service_integrations", value)

    @property
    @pulumi.getter(name="terminationProtection")
    def termination_protection(self) -> Optional[pulumi.Input[bool]]:
        """
        Prevent service from being deleted. It is recommended to have this enabled for all services.
        """
        return pulumi.get(self, "termination_protection")

    @termination_protection.setter
    def termination_protection(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "termination_protection", value)


@pulumi.input_type
class _ServiceState:
    def __init__(__self__, *,
                 cassandra: Optional[pulumi.Input['ServiceCassandraArgs']] = None,
                 cassandra_user_config: Optional[pulumi.Input['ServiceCassandraUserConfigArgs']] = None,
                 cloud_name: Optional[pulumi.Input[str]] = None,
                 components: Optional[pulumi.Input[Sequence[pulumi.Input['ServiceComponentArgs']]]] = None,
                 elasticsearch: Optional[pulumi.Input['ServiceElasticsearchArgs']] = None,
                 elasticsearch_user_config: Optional[pulumi.Input['ServiceElasticsearchUserConfigArgs']] = None,
                 grafana: Optional[pulumi.Input['ServiceGrafanaArgs']] = None,
                 grafana_user_config: Optional[pulumi.Input['ServiceGrafanaUserConfigArgs']] = None,
                 influxdb: Optional[pulumi.Input['ServiceInfluxdbArgs']] = None,
                 influxdb_user_config: Optional[pulumi.Input['ServiceInfluxdbUserConfigArgs']] = None,
                 kafka: Optional[pulumi.Input['ServiceKafkaArgs']] = None,
                 kafka_connect: Optional[pulumi.Input['ServiceKafkaConnectArgs']] = None,
                 kafka_connect_user_config: Optional[pulumi.Input['ServiceKafkaConnectUserConfigArgs']] = None,
                 kafka_mirrormaker: Optional[pulumi.Input['ServiceKafkaMirrormakerArgs']] = None,
                 kafka_mirrormaker_user_config: Optional[pulumi.Input['ServiceKafkaMirrormakerUserConfigArgs']] = None,
                 kafka_user_config: Optional[pulumi.Input['ServiceKafkaUserConfigArgs']] = None,
                 maintenance_window_dow: Optional[pulumi.Input[str]] = None,
                 maintenance_window_time: Optional[pulumi.Input[str]] = None,
                 mysql: Optional[pulumi.Input['ServiceMysqlArgs']] = None,
                 mysql_user_config: Optional[pulumi.Input['ServiceMysqlUserConfigArgs']] = None,
                 opensearch: Optional[pulumi.Input['ServiceOpensearchArgs']] = None,
                 opensearch_user_config: Optional[pulumi.Input['ServiceOpensearchUserConfigArgs']] = None,
                 pg: Optional[pulumi.Input['ServicePgArgs']] = None,
                 pg_user_config: Optional[pulumi.Input['ServicePgUserConfigArgs']] = None,
                 plan: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 project_vpc_id: Optional[pulumi.Input[str]] = None,
                 redis: Optional[pulumi.Input['ServiceRedisArgs']] = None,
                 redis_user_config: Optional[pulumi.Input['ServiceRedisUserConfigArgs']] = None,
                 service_host: Optional[pulumi.Input[str]] = None,
                 service_integrations: Optional[pulumi.Input[Sequence[pulumi.Input['ServiceServiceIntegrationArgs']]]] = None,
                 service_name: Optional[pulumi.Input[str]] = None,
                 service_password: Optional[pulumi.Input[str]] = None,
                 service_port: Optional[pulumi.Input[int]] = None,
                 service_type: Optional[pulumi.Input[str]] = None,
                 service_uri: Optional[pulumi.Input[str]] = None,
                 service_username: Optional[pulumi.Input[str]] = None,
                 state: Optional[pulumi.Input[str]] = None,
                 termination_protection: Optional[pulumi.Input[bool]] = None):
        """
        Input properties used for looking up and filtering Service resources.
        :param pulumi.Input['ServiceCassandraArgs'] cassandra: Cassandra specific server provided values
        :param pulumi.Input['ServiceCassandraUserConfigArgs'] cassandra_user_config: Cassandra specific user configurable settings
        :param pulumi.Input[str] cloud_name: Cloud the service runs in
        :param pulumi.Input[Sequence[pulumi.Input['ServiceComponentArgs']]] components: Service component information objects
        :param pulumi.Input['ServiceElasticsearchArgs'] elasticsearch: Elasticsearch specific server provided values
        :param pulumi.Input['ServiceElasticsearchUserConfigArgs'] elasticsearch_user_config: Elasticsearch specific user configurable settings
        :param pulumi.Input['ServiceGrafanaArgs'] grafana: Grafana specific server provided values
        :param pulumi.Input['ServiceGrafanaUserConfigArgs'] grafana_user_config: Grafana specific user configurable settings
        :param pulumi.Input['ServiceInfluxdbArgs'] influxdb: InfluxDB specific server provided values
        :param pulumi.Input['ServiceInfluxdbUserConfigArgs'] influxdb_user_config: InfluxDB specific user configurable settings
        :param pulumi.Input['ServiceKafkaArgs'] kafka: Kafka specific server provided values
        :param pulumi.Input['ServiceKafkaConnectArgs'] kafka_connect: Kafka Connect specific server provided values
        :param pulumi.Input['ServiceKafkaConnectUserConfigArgs'] kafka_connect_user_config: Kafka Connect specific user configurable settings
        :param pulumi.Input['ServiceKafkaMirrormakerArgs'] kafka_mirrormaker: Kafka MirrorMaker 2 specific server provided values
        :param pulumi.Input['ServiceKafkaMirrormakerUserConfigArgs'] kafka_mirrormaker_user_config: Kafka MirrorMaker 2 specific user configurable settings
        :param pulumi.Input['ServiceKafkaUserConfigArgs'] kafka_user_config: Kafka specific user configurable settings
        :param pulumi.Input[str] maintenance_window_dow: Day of week when maintenance operations should be performed. One monday, tuesday, wednesday, etc.
        :param pulumi.Input[str] maintenance_window_time: Time of day when maintenance operations should be performed. UTC time in HH:mm:ss format.
        :param pulumi.Input['ServiceMysqlArgs'] mysql: MySQL specific server provided values
        :param pulumi.Input['ServiceMysqlUserConfigArgs'] mysql_user_config: MySQL specific user configurable settings
        :param pulumi.Input['ServiceOpensearchArgs'] opensearch: Opensearch specific server provided values
        :param pulumi.Input['ServiceOpensearchUserConfigArgs'] opensearch_user_config: Opensearch specific user configurable settings
        :param pulumi.Input['ServicePgArgs'] pg: PostgreSQL specific server provided values
        :param pulumi.Input['ServicePgUserConfigArgs'] pg_user_config: PostgreSQL specific user configurable settings
        :param pulumi.Input[str] plan: Subscription plan
        :param pulumi.Input[str] project: Target project
        :param pulumi.Input[str] project_vpc_id: Identifier of the VPC the service should be in, if any
        :param pulumi.Input['ServiceRedisArgs'] redis: Redis specific server provided values
        :param pulumi.Input['ServiceRedisUserConfigArgs'] redis_user_config: Redis specific user configurable settings
        :param pulumi.Input[str] service_host: Service hostname
        :param pulumi.Input[Sequence[pulumi.Input['ServiceServiceIntegrationArgs']]] service_integrations: Service integrations to specify when creating a service. Not applied after initial service creation
        :param pulumi.Input[str] service_name: Service name
        :param pulumi.Input[str] service_password: Password used for connecting to the service, if applicable
        :param pulumi.Input[int] service_port: Service port
        :param pulumi.Input[str] service_type: Service type code
        :param pulumi.Input[str] service_uri: URI for connecting to the service. Service specific info is under "kafka", "pg", etc.
        :param pulumi.Input[str] service_username: Username used for connecting to the service, if applicable
        :param pulumi.Input[str] state: Service state
        :param pulumi.Input[bool] termination_protection: Prevent service from being deleted. It is recommended to have this enabled for all services.
        """
        if cassandra is not None:
            pulumi.set(__self__, "cassandra", cassandra)
        if cassandra_user_config is not None:
            pulumi.set(__self__, "cassandra_user_config", cassandra_user_config)
        if cloud_name is not None:
            pulumi.set(__self__, "cloud_name", cloud_name)
        if components is not None:
            pulumi.set(__self__, "components", components)
        if elasticsearch is not None:
            pulumi.set(__self__, "elasticsearch", elasticsearch)
        if elasticsearch_user_config is not None:
            pulumi.set(__self__, "elasticsearch_user_config", elasticsearch_user_config)
        if grafana is not None:
            pulumi.set(__self__, "grafana", grafana)
        if grafana_user_config is not None:
            pulumi.set(__self__, "grafana_user_config", grafana_user_config)
        if influxdb is not None:
            pulumi.set(__self__, "influxdb", influxdb)
        if influxdb_user_config is not None:
            pulumi.set(__self__, "influxdb_user_config", influxdb_user_config)
        if kafka is not None:
            pulumi.set(__self__, "kafka", kafka)
        if kafka_connect is not None:
            pulumi.set(__self__, "kafka_connect", kafka_connect)
        if kafka_connect_user_config is not None:
            pulumi.set(__self__, "kafka_connect_user_config", kafka_connect_user_config)
        if kafka_mirrormaker is not None:
            pulumi.set(__self__, "kafka_mirrormaker", kafka_mirrormaker)
        if kafka_mirrormaker_user_config is not None:
            pulumi.set(__self__, "kafka_mirrormaker_user_config", kafka_mirrormaker_user_config)
        if kafka_user_config is not None:
            pulumi.set(__self__, "kafka_user_config", kafka_user_config)
        if maintenance_window_dow is not None:
            pulumi.set(__self__, "maintenance_window_dow", maintenance_window_dow)
        if maintenance_window_time is not None:
            pulumi.set(__self__, "maintenance_window_time", maintenance_window_time)
        if mysql is not None:
            pulumi.set(__self__, "mysql", mysql)
        if mysql_user_config is not None:
            pulumi.set(__self__, "mysql_user_config", mysql_user_config)
        if opensearch is not None:
            pulumi.set(__self__, "opensearch", opensearch)
        if opensearch_user_config is not None:
            pulumi.set(__self__, "opensearch_user_config", opensearch_user_config)
        if pg is not None:
            pulumi.set(__self__, "pg", pg)
        if pg_user_config is not None:
            pulumi.set(__self__, "pg_user_config", pg_user_config)
        if plan is not None:
            pulumi.set(__self__, "plan", plan)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if project_vpc_id is not None:
            pulumi.set(__self__, "project_vpc_id", project_vpc_id)
        if redis is not None:
            pulumi.set(__self__, "redis", redis)
        if redis_user_config is not None:
            pulumi.set(__self__, "redis_user_config", redis_user_config)
        if service_host is not None:
            pulumi.set(__self__, "service_host", service_host)
        if service_integrations is not None:
            pulumi.set(__self__, "service_integrations", service_integrations)
        if service_name is not None:
            pulumi.set(__self__, "service_name", service_name)
        if service_password is not None:
            pulumi.set(__self__, "service_password", service_password)
        if service_port is not None:
            pulumi.set(__self__, "service_port", service_port)
        if service_type is not None:
            pulumi.set(__self__, "service_type", service_type)
        if service_uri is not None:
            pulumi.set(__self__, "service_uri", service_uri)
        if service_username is not None:
            pulumi.set(__self__, "service_username", service_username)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if termination_protection is not None:
            pulumi.set(__self__, "termination_protection", termination_protection)

    @property
    @pulumi.getter
    def cassandra(self) -> Optional[pulumi.Input['ServiceCassandraArgs']]:
        """
        Cassandra specific server provided values
        """
        return pulumi.get(self, "cassandra")

    @cassandra.setter
    def cassandra(self, value: Optional[pulumi.Input['ServiceCassandraArgs']]):
        pulumi.set(self, "cassandra", value)

    @property
    @pulumi.getter(name="cassandraUserConfig")
    def cassandra_user_config(self) -> Optional[pulumi.Input['ServiceCassandraUserConfigArgs']]:
        """
        Cassandra specific user configurable settings
        """
        return pulumi.get(self, "cassandra_user_config")

    @cassandra_user_config.setter
    def cassandra_user_config(self, value: Optional[pulumi.Input['ServiceCassandraUserConfigArgs']]):
        pulumi.set(self, "cassandra_user_config", value)

    @property
    @pulumi.getter(name="cloudName")
    def cloud_name(self) -> Optional[pulumi.Input[str]]:
        """
        Cloud the service runs in
        """
        return pulumi.get(self, "cloud_name")

    @cloud_name.setter
    def cloud_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cloud_name", value)

    @property
    @pulumi.getter
    def components(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ServiceComponentArgs']]]]:
        """
        Service component information objects
        """
        return pulumi.get(self, "components")

    @components.setter
    def components(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ServiceComponentArgs']]]]):
        pulumi.set(self, "components", value)

    @property
    @pulumi.getter
    def elasticsearch(self) -> Optional[pulumi.Input['ServiceElasticsearchArgs']]:
        """
        Elasticsearch specific server provided values
        """
        return pulumi.get(self, "elasticsearch")

    @elasticsearch.setter
    def elasticsearch(self, value: Optional[pulumi.Input['ServiceElasticsearchArgs']]):
        pulumi.set(self, "elasticsearch", value)

    @property
    @pulumi.getter(name="elasticsearchUserConfig")
    def elasticsearch_user_config(self) -> Optional[pulumi.Input['ServiceElasticsearchUserConfigArgs']]:
        """
        Elasticsearch specific user configurable settings
        """
        return pulumi.get(self, "elasticsearch_user_config")

    @elasticsearch_user_config.setter
    def elasticsearch_user_config(self, value: Optional[pulumi.Input['ServiceElasticsearchUserConfigArgs']]):
        pulumi.set(self, "elasticsearch_user_config", value)

    @property
    @pulumi.getter
    def grafana(self) -> Optional[pulumi.Input['ServiceGrafanaArgs']]:
        """
        Grafana specific server provided values
        """
        return pulumi.get(self, "grafana")

    @grafana.setter
    def grafana(self, value: Optional[pulumi.Input['ServiceGrafanaArgs']]):
        pulumi.set(self, "grafana", value)

    @property
    @pulumi.getter(name="grafanaUserConfig")
    def grafana_user_config(self) -> Optional[pulumi.Input['ServiceGrafanaUserConfigArgs']]:
        """
        Grafana specific user configurable settings
        """
        return pulumi.get(self, "grafana_user_config")

    @grafana_user_config.setter
    def grafana_user_config(self, value: Optional[pulumi.Input['ServiceGrafanaUserConfigArgs']]):
        pulumi.set(self, "grafana_user_config", value)

    @property
    @pulumi.getter
    def influxdb(self) -> Optional[pulumi.Input['ServiceInfluxdbArgs']]:
        """
        InfluxDB specific server provided values
        """
        return pulumi.get(self, "influxdb")

    @influxdb.setter
    def influxdb(self, value: Optional[pulumi.Input['ServiceInfluxdbArgs']]):
        pulumi.set(self, "influxdb", value)

    @property
    @pulumi.getter(name="influxdbUserConfig")
    def influxdb_user_config(self) -> Optional[pulumi.Input['ServiceInfluxdbUserConfigArgs']]:
        """
        InfluxDB specific user configurable settings
        """
        return pulumi.get(self, "influxdb_user_config")

    @influxdb_user_config.setter
    def influxdb_user_config(self, value: Optional[pulumi.Input['ServiceInfluxdbUserConfigArgs']]):
        pulumi.set(self, "influxdb_user_config", value)

    @property
    @pulumi.getter
    def kafka(self) -> Optional[pulumi.Input['ServiceKafkaArgs']]:
        """
        Kafka specific server provided values
        """
        return pulumi.get(self, "kafka")

    @kafka.setter
    def kafka(self, value: Optional[pulumi.Input['ServiceKafkaArgs']]):
        pulumi.set(self, "kafka", value)

    @property
    @pulumi.getter(name="kafkaConnect")
    def kafka_connect(self) -> Optional[pulumi.Input['ServiceKafkaConnectArgs']]:
        """
        Kafka Connect specific server provided values
        """
        return pulumi.get(self, "kafka_connect")

    @kafka_connect.setter
    def kafka_connect(self, value: Optional[pulumi.Input['ServiceKafkaConnectArgs']]):
        pulumi.set(self, "kafka_connect", value)

    @property
    @pulumi.getter(name="kafkaConnectUserConfig")
    def kafka_connect_user_config(self) -> Optional[pulumi.Input['ServiceKafkaConnectUserConfigArgs']]:
        """
        Kafka Connect specific user configurable settings
        """
        return pulumi.get(self, "kafka_connect_user_config")

    @kafka_connect_user_config.setter
    def kafka_connect_user_config(self, value: Optional[pulumi.Input['ServiceKafkaConnectUserConfigArgs']]):
        pulumi.set(self, "kafka_connect_user_config", value)

    @property
    @pulumi.getter(name="kafkaMirrormaker")
    def kafka_mirrormaker(self) -> Optional[pulumi.Input['ServiceKafkaMirrormakerArgs']]:
        """
        Kafka MirrorMaker 2 specific server provided values
        """
        return pulumi.get(self, "kafka_mirrormaker")

    @kafka_mirrormaker.setter
    def kafka_mirrormaker(self, value: Optional[pulumi.Input['ServiceKafkaMirrormakerArgs']]):
        pulumi.set(self, "kafka_mirrormaker", value)

    @property
    @pulumi.getter(name="kafkaMirrormakerUserConfig")
    def kafka_mirrormaker_user_config(self) -> Optional[pulumi.Input['ServiceKafkaMirrormakerUserConfigArgs']]:
        """
        Kafka MirrorMaker 2 specific user configurable settings
        """
        return pulumi.get(self, "kafka_mirrormaker_user_config")

    @kafka_mirrormaker_user_config.setter
    def kafka_mirrormaker_user_config(self, value: Optional[pulumi.Input['ServiceKafkaMirrormakerUserConfigArgs']]):
        pulumi.set(self, "kafka_mirrormaker_user_config", value)

    @property
    @pulumi.getter(name="kafkaUserConfig")
    def kafka_user_config(self) -> Optional[pulumi.Input['ServiceKafkaUserConfigArgs']]:
        """
        Kafka specific user configurable settings
        """
        return pulumi.get(self, "kafka_user_config")

    @kafka_user_config.setter
    def kafka_user_config(self, value: Optional[pulumi.Input['ServiceKafkaUserConfigArgs']]):
        pulumi.set(self, "kafka_user_config", value)

    @property
    @pulumi.getter(name="maintenanceWindowDow")
    def maintenance_window_dow(self) -> Optional[pulumi.Input[str]]:
        """
        Day of week when maintenance operations should be performed. One monday, tuesday, wednesday, etc.
        """
        return pulumi.get(self, "maintenance_window_dow")

    @maintenance_window_dow.setter
    def maintenance_window_dow(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "maintenance_window_dow", value)

    @property
    @pulumi.getter(name="maintenanceWindowTime")
    def maintenance_window_time(self) -> Optional[pulumi.Input[str]]:
        """
        Time of day when maintenance operations should be performed. UTC time in HH:mm:ss format.
        """
        return pulumi.get(self, "maintenance_window_time")

    @maintenance_window_time.setter
    def maintenance_window_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "maintenance_window_time", value)

    @property
    @pulumi.getter
    def mysql(self) -> Optional[pulumi.Input['ServiceMysqlArgs']]:
        """
        MySQL specific server provided values
        """
        return pulumi.get(self, "mysql")

    @mysql.setter
    def mysql(self, value: Optional[pulumi.Input['ServiceMysqlArgs']]):
        pulumi.set(self, "mysql", value)

    @property
    @pulumi.getter(name="mysqlUserConfig")
    def mysql_user_config(self) -> Optional[pulumi.Input['ServiceMysqlUserConfigArgs']]:
        """
        MySQL specific user configurable settings
        """
        return pulumi.get(self, "mysql_user_config")

    @mysql_user_config.setter
    def mysql_user_config(self, value: Optional[pulumi.Input['ServiceMysqlUserConfigArgs']]):
        pulumi.set(self, "mysql_user_config", value)

    @property
    @pulumi.getter
    def opensearch(self) -> Optional[pulumi.Input['ServiceOpensearchArgs']]:
        """
        Opensearch specific server provided values
        """
        return pulumi.get(self, "opensearch")

    @opensearch.setter
    def opensearch(self, value: Optional[pulumi.Input['ServiceOpensearchArgs']]):
        pulumi.set(self, "opensearch", value)

    @property
    @pulumi.getter(name="opensearchUserConfig")
    def opensearch_user_config(self) -> Optional[pulumi.Input['ServiceOpensearchUserConfigArgs']]:
        """
        Opensearch specific user configurable settings
        """
        return pulumi.get(self, "opensearch_user_config")

    @opensearch_user_config.setter
    def opensearch_user_config(self, value: Optional[pulumi.Input['ServiceOpensearchUserConfigArgs']]):
        pulumi.set(self, "opensearch_user_config", value)

    @property
    @pulumi.getter
    def pg(self) -> Optional[pulumi.Input['ServicePgArgs']]:
        """
        PostgreSQL specific server provided values
        """
        return pulumi.get(self, "pg")

    @pg.setter
    def pg(self, value: Optional[pulumi.Input['ServicePgArgs']]):
        pulumi.set(self, "pg", value)

    @property
    @pulumi.getter(name="pgUserConfig")
    def pg_user_config(self) -> Optional[pulumi.Input['ServicePgUserConfigArgs']]:
        """
        PostgreSQL specific user configurable settings
        """
        return pulumi.get(self, "pg_user_config")

    @pg_user_config.setter
    def pg_user_config(self, value: Optional[pulumi.Input['ServicePgUserConfigArgs']]):
        pulumi.set(self, "pg_user_config", value)

    @property
    @pulumi.getter
    def plan(self) -> Optional[pulumi.Input[str]]:
        """
        Subscription plan
        """
        return pulumi.get(self, "plan")

    @plan.setter
    def plan(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "plan", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[str]]:
        """
        Target project
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter(name="projectVpcId")
    def project_vpc_id(self) -> Optional[pulumi.Input[str]]:
        """
        Identifier of the VPC the service should be in, if any
        """
        return pulumi.get(self, "project_vpc_id")

    @project_vpc_id.setter
    def project_vpc_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project_vpc_id", value)

    @property
    @pulumi.getter
    def redis(self) -> Optional[pulumi.Input['ServiceRedisArgs']]:
        """
        Redis specific server provided values
        """
        return pulumi.get(self, "redis")

    @redis.setter
    def redis(self, value: Optional[pulumi.Input['ServiceRedisArgs']]):
        pulumi.set(self, "redis", value)

    @property
    @pulumi.getter(name="redisUserConfig")
    def redis_user_config(self) -> Optional[pulumi.Input['ServiceRedisUserConfigArgs']]:
        """
        Redis specific user configurable settings
        """
        return pulumi.get(self, "redis_user_config")

    @redis_user_config.setter
    def redis_user_config(self, value: Optional[pulumi.Input['ServiceRedisUserConfigArgs']]):
        pulumi.set(self, "redis_user_config", value)

    @property
    @pulumi.getter(name="serviceHost")
    def service_host(self) -> Optional[pulumi.Input[str]]:
        """
        Service hostname
        """
        return pulumi.get(self, "service_host")

    @service_host.setter
    def service_host(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "service_host", value)

    @property
    @pulumi.getter(name="serviceIntegrations")
    def service_integrations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ServiceServiceIntegrationArgs']]]]:
        """
        Service integrations to specify when creating a service. Not applied after initial service creation
        """
        return pulumi.get(self, "service_integrations")

    @service_integrations.setter
    def service_integrations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ServiceServiceIntegrationArgs']]]]):
        pulumi.set(self, "service_integrations", value)

    @property
    @pulumi.getter(name="serviceName")
    def service_name(self) -> Optional[pulumi.Input[str]]:
        """
        Service name
        """
        return pulumi.get(self, "service_name")

    @service_name.setter
    def service_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "service_name", value)

    @property
    @pulumi.getter(name="servicePassword")
    def service_password(self) -> Optional[pulumi.Input[str]]:
        """
        Password used for connecting to the service, if applicable
        """
        return pulumi.get(self, "service_password")

    @service_password.setter
    def service_password(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "service_password", value)

    @property
    @pulumi.getter(name="servicePort")
    def service_port(self) -> Optional[pulumi.Input[int]]:
        """
        Service port
        """
        return pulumi.get(self, "service_port")

    @service_port.setter
    def service_port(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "service_port", value)

    @property
    @pulumi.getter(name="serviceType")
    def service_type(self) -> Optional[pulumi.Input[str]]:
        """
        Service type code
        """
        return pulumi.get(self, "service_type")

    @service_type.setter
    def service_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "service_type", value)

    @property
    @pulumi.getter(name="serviceUri")
    def service_uri(self) -> Optional[pulumi.Input[str]]:
        """
        URI for connecting to the service. Service specific info is under "kafka", "pg", etc.
        """
        return pulumi.get(self, "service_uri")

    @service_uri.setter
    def service_uri(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "service_uri", value)

    @property
    @pulumi.getter(name="serviceUsername")
    def service_username(self) -> Optional[pulumi.Input[str]]:
        """
        Username used for connecting to the service, if applicable
        """
        return pulumi.get(self, "service_username")

    @service_username.setter
    def service_username(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "service_username", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[str]]:
        """
        Service state
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "state", value)

    @property
    @pulumi.getter(name="terminationProtection")
    def termination_protection(self) -> Optional[pulumi.Input[bool]]:
        """
        Prevent service from being deleted. It is recommended to have this enabled for all services.
        """
        return pulumi.get(self, "termination_protection")

    @termination_protection.setter
    def termination_protection(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "termination_protection", value)


class Service(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cassandra: Optional[pulumi.Input[pulumi.InputType['ServiceCassandraArgs']]] = None,
                 cassandra_user_config: Optional[pulumi.Input[pulumi.InputType['ServiceCassandraUserConfigArgs']]] = None,
                 cloud_name: Optional[pulumi.Input[str]] = None,
                 elasticsearch: Optional[pulumi.Input[pulumi.InputType['ServiceElasticsearchArgs']]] = None,
                 elasticsearch_user_config: Optional[pulumi.Input[pulumi.InputType['ServiceElasticsearchUserConfigArgs']]] = None,
                 grafana: Optional[pulumi.Input[pulumi.InputType['ServiceGrafanaArgs']]] = None,
                 grafana_user_config: Optional[pulumi.Input[pulumi.InputType['ServiceGrafanaUserConfigArgs']]] = None,
                 influxdb: Optional[pulumi.Input[pulumi.InputType['ServiceInfluxdbArgs']]] = None,
                 influxdb_user_config: Optional[pulumi.Input[pulumi.InputType['ServiceInfluxdbUserConfigArgs']]] = None,
                 kafka: Optional[pulumi.Input[pulumi.InputType['ServiceKafkaArgs']]] = None,
                 kafka_connect: Optional[pulumi.Input[pulumi.InputType['ServiceKafkaConnectArgs']]] = None,
                 kafka_connect_user_config: Optional[pulumi.Input[pulumi.InputType['ServiceKafkaConnectUserConfigArgs']]] = None,
                 kafka_mirrormaker: Optional[pulumi.Input[pulumi.InputType['ServiceKafkaMirrormakerArgs']]] = None,
                 kafka_mirrormaker_user_config: Optional[pulumi.Input[pulumi.InputType['ServiceKafkaMirrormakerUserConfigArgs']]] = None,
                 kafka_user_config: Optional[pulumi.Input[pulumi.InputType['ServiceKafkaUserConfigArgs']]] = None,
                 maintenance_window_dow: Optional[pulumi.Input[str]] = None,
                 maintenance_window_time: Optional[pulumi.Input[str]] = None,
                 mysql: Optional[pulumi.Input[pulumi.InputType['ServiceMysqlArgs']]] = None,
                 mysql_user_config: Optional[pulumi.Input[pulumi.InputType['ServiceMysqlUserConfigArgs']]] = None,
                 opensearch: Optional[pulumi.Input[pulumi.InputType['ServiceOpensearchArgs']]] = None,
                 opensearch_user_config: Optional[pulumi.Input[pulumi.InputType['ServiceOpensearchUserConfigArgs']]] = None,
                 pg: Optional[pulumi.Input[pulumi.InputType['ServicePgArgs']]] = None,
                 pg_user_config: Optional[pulumi.Input[pulumi.InputType['ServicePgUserConfigArgs']]] = None,
                 plan: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 project_vpc_id: Optional[pulumi.Input[str]] = None,
                 redis: Optional[pulumi.Input[pulumi.InputType['ServiceRedisArgs']]] = None,
                 redis_user_config: Optional[pulumi.Input[pulumi.InputType['ServiceRedisUserConfigArgs']]] = None,
                 service_integrations: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ServiceServiceIntegrationArgs']]]]] = None,
                 service_name: Optional[pulumi.Input[str]] = None,
                 service_type: Optional[pulumi.Input[str]] = None,
                 termination_protection: Optional[pulumi.Input[bool]] = None,
                 __props__=None):
        """
        Create a Service resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[pulumi.InputType['ServiceCassandraArgs']] cassandra: Cassandra specific server provided values
        :param pulumi.Input[pulumi.InputType['ServiceCassandraUserConfigArgs']] cassandra_user_config: Cassandra specific user configurable settings
        :param pulumi.Input[str] cloud_name: Cloud the service runs in
        :param pulumi.Input[pulumi.InputType['ServiceElasticsearchArgs']] elasticsearch: Elasticsearch specific server provided values
        :param pulumi.Input[pulumi.InputType['ServiceElasticsearchUserConfigArgs']] elasticsearch_user_config: Elasticsearch specific user configurable settings
        :param pulumi.Input[pulumi.InputType['ServiceGrafanaArgs']] grafana: Grafana specific server provided values
        :param pulumi.Input[pulumi.InputType['ServiceGrafanaUserConfigArgs']] grafana_user_config: Grafana specific user configurable settings
        :param pulumi.Input[pulumi.InputType['ServiceInfluxdbArgs']] influxdb: InfluxDB specific server provided values
        :param pulumi.Input[pulumi.InputType['ServiceInfluxdbUserConfigArgs']] influxdb_user_config: InfluxDB specific user configurable settings
        :param pulumi.Input[pulumi.InputType['ServiceKafkaArgs']] kafka: Kafka specific server provided values
        :param pulumi.Input[pulumi.InputType['ServiceKafkaConnectArgs']] kafka_connect: Kafka Connect specific server provided values
        :param pulumi.Input[pulumi.InputType['ServiceKafkaConnectUserConfigArgs']] kafka_connect_user_config: Kafka Connect specific user configurable settings
        :param pulumi.Input[pulumi.InputType['ServiceKafkaMirrormakerArgs']] kafka_mirrormaker: Kafka MirrorMaker 2 specific server provided values
        :param pulumi.Input[pulumi.InputType['ServiceKafkaMirrormakerUserConfigArgs']] kafka_mirrormaker_user_config: Kafka MirrorMaker 2 specific user configurable settings
        :param pulumi.Input[pulumi.InputType['ServiceKafkaUserConfigArgs']] kafka_user_config: Kafka specific user configurable settings
        :param pulumi.Input[str] maintenance_window_dow: Day of week when maintenance operations should be performed. One monday, tuesday, wednesday, etc.
        :param pulumi.Input[str] maintenance_window_time: Time of day when maintenance operations should be performed. UTC time in HH:mm:ss format.
        :param pulumi.Input[pulumi.InputType['ServiceMysqlArgs']] mysql: MySQL specific server provided values
        :param pulumi.Input[pulumi.InputType['ServiceMysqlUserConfigArgs']] mysql_user_config: MySQL specific user configurable settings
        :param pulumi.Input[pulumi.InputType['ServiceOpensearchArgs']] opensearch: Opensearch specific server provided values
        :param pulumi.Input[pulumi.InputType['ServiceOpensearchUserConfigArgs']] opensearch_user_config: Opensearch specific user configurable settings
        :param pulumi.Input[pulumi.InputType['ServicePgArgs']] pg: PostgreSQL specific server provided values
        :param pulumi.Input[pulumi.InputType['ServicePgUserConfigArgs']] pg_user_config: PostgreSQL specific user configurable settings
        :param pulumi.Input[str] plan: Subscription plan
        :param pulumi.Input[str] project: Target project
        :param pulumi.Input[str] project_vpc_id: Identifier of the VPC the service should be in, if any
        :param pulumi.Input[pulumi.InputType['ServiceRedisArgs']] redis: Redis specific server provided values
        :param pulumi.Input[pulumi.InputType['ServiceRedisUserConfigArgs']] redis_user_config: Redis specific user configurable settings
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ServiceServiceIntegrationArgs']]]] service_integrations: Service integrations to specify when creating a service. Not applied after initial service creation
        :param pulumi.Input[str] service_name: Service name
        :param pulumi.Input[str] service_type: Service type code
        :param pulumi.Input[bool] termination_protection: Prevent service from being deleted. It is recommended to have this enabled for all services.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ServiceArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Create a Service resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param ServiceArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ServiceArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cassandra: Optional[pulumi.Input[pulumi.InputType['ServiceCassandraArgs']]] = None,
                 cassandra_user_config: Optional[pulumi.Input[pulumi.InputType['ServiceCassandraUserConfigArgs']]] = None,
                 cloud_name: Optional[pulumi.Input[str]] = None,
                 elasticsearch: Optional[pulumi.Input[pulumi.InputType['ServiceElasticsearchArgs']]] = None,
                 elasticsearch_user_config: Optional[pulumi.Input[pulumi.InputType['ServiceElasticsearchUserConfigArgs']]] = None,
                 grafana: Optional[pulumi.Input[pulumi.InputType['ServiceGrafanaArgs']]] = None,
                 grafana_user_config: Optional[pulumi.Input[pulumi.InputType['ServiceGrafanaUserConfigArgs']]] = None,
                 influxdb: Optional[pulumi.Input[pulumi.InputType['ServiceInfluxdbArgs']]] = None,
                 influxdb_user_config: Optional[pulumi.Input[pulumi.InputType['ServiceInfluxdbUserConfigArgs']]] = None,
                 kafka: Optional[pulumi.Input[pulumi.InputType['ServiceKafkaArgs']]] = None,
                 kafka_connect: Optional[pulumi.Input[pulumi.InputType['ServiceKafkaConnectArgs']]] = None,
                 kafka_connect_user_config: Optional[pulumi.Input[pulumi.InputType['ServiceKafkaConnectUserConfigArgs']]] = None,
                 kafka_mirrormaker: Optional[pulumi.Input[pulumi.InputType['ServiceKafkaMirrormakerArgs']]] = None,
                 kafka_mirrormaker_user_config: Optional[pulumi.Input[pulumi.InputType['ServiceKafkaMirrormakerUserConfigArgs']]] = None,
                 kafka_user_config: Optional[pulumi.Input[pulumi.InputType['ServiceKafkaUserConfigArgs']]] = None,
                 maintenance_window_dow: Optional[pulumi.Input[str]] = None,
                 maintenance_window_time: Optional[pulumi.Input[str]] = None,
                 mysql: Optional[pulumi.Input[pulumi.InputType['ServiceMysqlArgs']]] = None,
                 mysql_user_config: Optional[pulumi.Input[pulumi.InputType['ServiceMysqlUserConfigArgs']]] = None,
                 opensearch: Optional[pulumi.Input[pulumi.InputType['ServiceOpensearchArgs']]] = None,
                 opensearch_user_config: Optional[pulumi.Input[pulumi.InputType['ServiceOpensearchUserConfigArgs']]] = None,
                 pg: Optional[pulumi.Input[pulumi.InputType['ServicePgArgs']]] = None,
                 pg_user_config: Optional[pulumi.Input[pulumi.InputType['ServicePgUserConfigArgs']]] = None,
                 plan: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 project_vpc_id: Optional[pulumi.Input[str]] = None,
                 redis: Optional[pulumi.Input[pulumi.InputType['ServiceRedisArgs']]] = None,
                 redis_user_config: Optional[pulumi.Input[pulumi.InputType['ServiceRedisUserConfigArgs']]] = None,
                 service_integrations: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ServiceServiceIntegrationArgs']]]]] = None,
                 service_name: Optional[pulumi.Input[str]] = None,
                 service_type: Optional[pulumi.Input[str]] = None,
                 termination_protection: Optional[pulumi.Input[bool]] = None,
                 __props__=None):
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ServiceArgs.__new__(ServiceArgs)

            __props__.__dict__["cassandra"] = cassandra
            __props__.__dict__["cassandra_user_config"] = cassandra_user_config
            __props__.__dict__["cloud_name"] = cloud_name
            __props__.__dict__["elasticsearch"] = elasticsearch
            __props__.__dict__["elasticsearch_user_config"] = elasticsearch_user_config
            __props__.__dict__["grafana"] = grafana
            __props__.__dict__["grafana_user_config"] = grafana_user_config
            __props__.__dict__["influxdb"] = influxdb
            __props__.__dict__["influxdb_user_config"] = influxdb_user_config
            __props__.__dict__["kafka"] = kafka
            __props__.__dict__["kafka_connect"] = kafka_connect
            __props__.__dict__["kafka_connect_user_config"] = kafka_connect_user_config
            __props__.__dict__["kafka_mirrormaker"] = kafka_mirrormaker
            __props__.__dict__["kafka_mirrormaker_user_config"] = kafka_mirrormaker_user_config
            __props__.__dict__["kafka_user_config"] = kafka_user_config
            __props__.__dict__["maintenance_window_dow"] = maintenance_window_dow
            __props__.__dict__["maintenance_window_time"] = maintenance_window_time
            __props__.__dict__["mysql"] = mysql
            __props__.__dict__["mysql_user_config"] = mysql_user_config
            __props__.__dict__["opensearch"] = opensearch
            __props__.__dict__["opensearch_user_config"] = opensearch_user_config
            __props__.__dict__["pg"] = pg
            __props__.__dict__["pg_user_config"] = pg_user_config
            __props__.__dict__["plan"] = plan
            if project is None and not opts.urn:
                raise TypeError("Missing required property 'project'")
            __props__.__dict__["project"] = project
            __props__.__dict__["project_vpc_id"] = project_vpc_id
            __props__.__dict__["redis"] = redis
            __props__.__dict__["redis_user_config"] = redis_user_config
            __props__.__dict__["service_integrations"] = service_integrations
            if service_name is None and not opts.urn:
                raise TypeError("Missing required property 'service_name'")
            __props__.__dict__["service_name"] = service_name
            if service_type is None and not opts.urn:
                raise TypeError("Missing required property 'service_type'")
            __props__.__dict__["service_type"] = service_type
            __props__.__dict__["termination_protection"] = termination_protection
            __props__.__dict__["components"] = None
            __props__.__dict__["service_host"] = None
            __props__.__dict__["service_password"] = None
            __props__.__dict__["service_port"] = None
            __props__.__dict__["service_uri"] = None
            __props__.__dict__["service_username"] = None
            __props__.__dict__["state"] = None
        super(Service, __self__).__init__(
            'aiven:index/service:Service',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            cassandra: Optional[pulumi.Input[pulumi.InputType['ServiceCassandraArgs']]] = None,
            cassandra_user_config: Optional[pulumi.Input[pulumi.InputType['ServiceCassandraUserConfigArgs']]] = None,
            cloud_name: Optional[pulumi.Input[str]] = None,
            components: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ServiceComponentArgs']]]]] = None,
            elasticsearch: Optional[pulumi.Input[pulumi.InputType['ServiceElasticsearchArgs']]] = None,
            elasticsearch_user_config: Optional[pulumi.Input[pulumi.InputType['ServiceElasticsearchUserConfigArgs']]] = None,
            grafana: Optional[pulumi.Input[pulumi.InputType['ServiceGrafanaArgs']]] = None,
            grafana_user_config: Optional[pulumi.Input[pulumi.InputType['ServiceGrafanaUserConfigArgs']]] = None,
            influxdb: Optional[pulumi.Input[pulumi.InputType['ServiceInfluxdbArgs']]] = None,
            influxdb_user_config: Optional[pulumi.Input[pulumi.InputType['ServiceInfluxdbUserConfigArgs']]] = None,
            kafka: Optional[pulumi.Input[pulumi.InputType['ServiceKafkaArgs']]] = None,
            kafka_connect: Optional[pulumi.Input[pulumi.InputType['ServiceKafkaConnectArgs']]] = None,
            kafka_connect_user_config: Optional[pulumi.Input[pulumi.InputType['ServiceKafkaConnectUserConfigArgs']]] = None,
            kafka_mirrormaker: Optional[pulumi.Input[pulumi.InputType['ServiceKafkaMirrormakerArgs']]] = None,
            kafka_mirrormaker_user_config: Optional[pulumi.Input[pulumi.InputType['ServiceKafkaMirrormakerUserConfigArgs']]] = None,
            kafka_user_config: Optional[pulumi.Input[pulumi.InputType['ServiceKafkaUserConfigArgs']]] = None,
            maintenance_window_dow: Optional[pulumi.Input[str]] = None,
            maintenance_window_time: Optional[pulumi.Input[str]] = None,
            mysql: Optional[pulumi.Input[pulumi.InputType['ServiceMysqlArgs']]] = None,
            mysql_user_config: Optional[pulumi.Input[pulumi.InputType['ServiceMysqlUserConfigArgs']]] = None,
            opensearch: Optional[pulumi.Input[pulumi.InputType['ServiceOpensearchArgs']]] = None,
            opensearch_user_config: Optional[pulumi.Input[pulumi.InputType['ServiceOpensearchUserConfigArgs']]] = None,
            pg: Optional[pulumi.Input[pulumi.InputType['ServicePgArgs']]] = None,
            pg_user_config: Optional[pulumi.Input[pulumi.InputType['ServicePgUserConfigArgs']]] = None,
            plan: Optional[pulumi.Input[str]] = None,
            project: Optional[pulumi.Input[str]] = None,
            project_vpc_id: Optional[pulumi.Input[str]] = None,
            redis: Optional[pulumi.Input[pulumi.InputType['ServiceRedisArgs']]] = None,
            redis_user_config: Optional[pulumi.Input[pulumi.InputType['ServiceRedisUserConfigArgs']]] = None,
            service_host: Optional[pulumi.Input[str]] = None,
            service_integrations: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ServiceServiceIntegrationArgs']]]]] = None,
            service_name: Optional[pulumi.Input[str]] = None,
            service_password: Optional[pulumi.Input[str]] = None,
            service_port: Optional[pulumi.Input[int]] = None,
            service_type: Optional[pulumi.Input[str]] = None,
            service_uri: Optional[pulumi.Input[str]] = None,
            service_username: Optional[pulumi.Input[str]] = None,
            state: Optional[pulumi.Input[str]] = None,
            termination_protection: Optional[pulumi.Input[bool]] = None) -> 'Service':
        """
        Get an existing Service resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[pulumi.InputType['ServiceCassandraArgs']] cassandra: Cassandra specific server provided values
        :param pulumi.Input[pulumi.InputType['ServiceCassandraUserConfigArgs']] cassandra_user_config: Cassandra specific user configurable settings
        :param pulumi.Input[str] cloud_name: Cloud the service runs in
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ServiceComponentArgs']]]] components: Service component information objects
        :param pulumi.Input[pulumi.InputType['ServiceElasticsearchArgs']] elasticsearch: Elasticsearch specific server provided values
        :param pulumi.Input[pulumi.InputType['ServiceElasticsearchUserConfigArgs']] elasticsearch_user_config: Elasticsearch specific user configurable settings
        :param pulumi.Input[pulumi.InputType['ServiceGrafanaArgs']] grafana: Grafana specific server provided values
        :param pulumi.Input[pulumi.InputType['ServiceGrafanaUserConfigArgs']] grafana_user_config: Grafana specific user configurable settings
        :param pulumi.Input[pulumi.InputType['ServiceInfluxdbArgs']] influxdb: InfluxDB specific server provided values
        :param pulumi.Input[pulumi.InputType['ServiceInfluxdbUserConfigArgs']] influxdb_user_config: InfluxDB specific user configurable settings
        :param pulumi.Input[pulumi.InputType['ServiceKafkaArgs']] kafka: Kafka specific server provided values
        :param pulumi.Input[pulumi.InputType['ServiceKafkaConnectArgs']] kafka_connect: Kafka Connect specific server provided values
        :param pulumi.Input[pulumi.InputType['ServiceKafkaConnectUserConfigArgs']] kafka_connect_user_config: Kafka Connect specific user configurable settings
        :param pulumi.Input[pulumi.InputType['ServiceKafkaMirrormakerArgs']] kafka_mirrormaker: Kafka MirrorMaker 2 specific server provided values
        :param pulumi.Input[pulumi.InputType['ServiceKafkaMirrormakerUserConfigArgs']] kafka_mirrormaker_user_config: Kafka MirrorMaker 2 specific user configurable settings
        :param pulumi.Input[pulumi.InputType['ServiceKafkaUserConfigArgs']] kafka_user_config: Kafka specific user configurable settings
        :param pulumi.Input[str] maintenance_window_dow: Day of week when maintenance operations should be performed. One monday, tuesday, wednesday, etc.
        :param pulumi.Input[str] maintenance_window_time: Time of day when maintenance operations should be performed. UTC time in HH:mm:ss format.
        :param pulumi.Input[pulumi.InputType['ServiceMysqlArgs']] mysql: MySQL specific server provided values
        :param pulumi.Input[pulumi.InputType['ServiceMysqlUserConfigArgs']] mysql_user_config: MySQL specific user configurable settings
        :param pulumi.Input[pulumi.InputType['ServiceOpensearchArgs']] opensearch: Opensearch specific server provided values
        :param pulumi.Input[pulumi.InputType['ServiceOpensearchUserConfigArgs']] opensearch_user_config: Opensearch specific user configurable settings
        :param pulumi.Input[pulumi.InputType['ServicePgArgs']] pg: PostgreSQL specific server provided values
        :param pulumi.Input[pulumi.InputType['ServicePgUserConfigArgs']] pg_user_config: PostgreSQL specific user configurable settings
        :param pulumi.Input[str] plan: Subscription plan
        :param pulumi.Input[str] project: Target project
        :param pulumi.Input[str] project_vpc_id: Identifier of the VPC the service should be in, if any
        :param pulumi.Input[pulumi.InputType['ServiceRedisArgs']] redis: Redis specific server provided values
        :param pulumi.Input[pulumi.InputType['ServiceRedisUserConfigArgs']] redis_user_config: Redis specific user configurable settings
        :param pulumi.Input[str] service_host: Service hostname
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ServiceServiceIntegrationArgs']]]] service_integrations: Service integrations to specify when creating a service. Not applied after initial service creation
        :param pulumi.Input[str] service_name: Service name
        :param pulumi.Input[str] service_password: Password used for connecting to the service, if applicable
        :param pulumi.Input[int] service_port: Service port
        :param pulumi.Input[str] service_type: Service type code
        :param pulumi.Input[str] service_uri: URI for connecting to the service. Service specific info is under "kafka", "pg", etc.
        :param pulumi.Input[str] service_username: Username used for connecting to the service, if applicable
        :param pulumi.Input[str] state: Service state
        :param pulumi.Input[bool] termination_protection: Prevent service from being deleted. It is recommended to have this enabled for all services.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ServiceState.__new__(_ServiceState)

        __props__.__dict__["cassandra"] = cassandra
        __props__.__dict__["cassandra_user_config"] = cassandra_user_config
        __props__.__dict__["cloud_name"] = cloud_name
        __props__.__dict__["components"] = components
        __props__.__dict__["elasticsearch"] = elasticsearch
        __props__.__dict__["elasticsearch_user_config"] = elasticsearch_user_config
        __props__.__dict__["grafana"] = grafana
        __props__.__dict__["grafana_user_config"] = grafana_user_config
        __props__.__dict__["influxdb"] = influxdb
        __props__.__dict__["influxdb_user_config"] = influxdb_user_config
        __props__.__dict__["kafka"] = kafka
        __props__.__dict__["kafka_connect"] = kafka_connect
        __props__.__dict__["kafka_connect_user_config"] = kafka_connect_user_config
        __props__.__dict__["kafka_mirrormaker"] = kafka_mirrormaker
        __props__.__dict__["kafka_mirrormaker_user_config"] = kafka_mirrormaker_user_config
        __props__.__dict__["kafka_user_config"] = kafka_user_config
        __props__.__dict__["maintenance_window_dow"] = maintenance_window_dow
        __props__.__dict__["maintenance_window_time"] = maintenance_window_time
        __props__.__dict__["mysql"] = mysql
        __props__.__dict__["mysql_user_config"] = mysql_user_config
        __props__.__dict__["opensearch"] = opensearch
        __props__.__dict__["opensearch_user_config"] = opensearch_user_config
        __props__.__dict__["pg"] = pg
        __props__.__dict__["pg_user_config"] = pg_user_config
        __props__.__dict__["plan"] = plan
        __props__.__dict__["project"] = project
        __props__.__dict__["project_vpc_id"] = project_vpc_id
        __props__.__dict__["redis"] = redis
        __props__.__dict__["redis_user_config"] = redis_user_config
        __props__.__dict__["service_host"] = service_host
        __props__.__dict__["service_integrations"] = service_integrations
        __props__.__dict__["service_name"] = service_name
        __props__.__dict__["service_password"] = service_password
        __props__.__dict__["service_port"] = service_port
        __props__.__dict__["service_type"] = service_type
        __props__.__dict__["service_uri"] = service_uri
        __props__.__dict__["service_username"] = service_username
        __props__.__dict__["state"] = state
        __props__.__dict__["termination_protection"] = termination_protection
        return Service(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def cassandra(self) -> pulumi.Output['outputs.ServiceCassandra']:
        """
        Cassandra specific server provided values
        """
        return pulumi.get(self, "cassandra")

    @property
    @pulumi.getter(name="cassandraUserConfig")
    def cassandra_user_config(self) -> pulumi.Output[Optional['outputs.ServiceCassandraUserConfig']]:
        """
        Cassandra specific user configurable settings
        """
        return pulumi.get(self, "cassandra_user_config")

    @property
    @pulumi.getter(name="cloudName")
    def cloud_name(self) -> pulumi.Output[Optional[str]]:
        """
        Cloud the service runs in
        """
        return pulumi.get(self, "cloud_name")

    @property
    @pulumi.getter
    def components(self) -> pulumi.Output[Sequence['outputs.ServiceComponent']]:
        """
        Service component information objects
        """
        return pulumi.get(self, "components")

    @property
    @pulumi.getter
    def elasticsearch(self) -> pulumi.Output['outputs.ServiceElasticsearch']:
        """
        Elasticsearch specific server provided values
        """
        return pulumi.get(self, "elasticsearch")

    @property
    @pulumi.getter(name="elasticsearchUserConfig")
    def elasticsearch_user_config(self) -> pulumi.Output[Optional['outputs.ServiceElasticsearchUserConfig']]:
        """
        Elasticsearch specific user configurable settings
        """
        return pulumi.get(self, "elasticsearch_user_config")

    @property
    @pulumi.getter
    def grafana(self) -> pulumi.Output['outputs.ServiceGrafana']:
        """
        Grafana specific server provided values
        """
        return pulumi.get(self, "grafana")

    @property
    @pulumi.getter(name="grafanaUserConfig")
    def grafana_user_config(self) -> pulumi.Output[Optional['outputs.ServiceGrafanaUserConfig']]:
        """
        Grafana specific user configurable settings
        """
        return pulumi.get(self, "grafana_user_config")

    @property
    @pulumi.getter
    def influxdb(self) -> pulumi.Output['outputs.ServiceInfluxdb']:
        """
        InfluxDB specific server provided values
        """
        return pulumi.get(self, "influxdb")

    @property
    @pulumi.getter(name="influxdbUserConfig")
    def influxdb_user_config(self) -> pulumi.Output[Optional['outputs.ServiceInfluxdbUserConfig']]:
        """
        InfluxDB specific user configurable settings
        """
        return pulumi.get(self, "influxdb_user_config")

    @property
    @pulumi.getter
    def kafka(self) -> pulumi.Output['outputs.ServiceKafka']:
        """
        Kafka specific server provided values
        """
        return pulumi.get(self, "kafka")

    @property
    @pulumi.getter(name="kafkaConnect")
    def kafka_connect(self) -> pulumi.Output['outputs.ServiceKafkaConnect']:
        """
        Kafka Connect specific server provided values
        """
        return pulumi.get(self, "kafka_connect")

    @property
    @pulumi.getter(name="kafkaConnectUserConfig")
    def kafka_connect_user_config(self) -> pulumi.Output[Optional['outputs.ServiceKafkaConnectUserConfig']]:
        """
        Kafka Connect specific user configurable settings
        """
        return pulumi.get(self, "kafka_connect_user_config")

    @property
    @pulumi.getter(name="kafkaMirrormaker")
    def kafka_mirrormaker(self) -> pulumi.Output['outputs.ServiceKafkaMirrormaker']:
        """
        Kafka MirrorMaker 2 specific server provided values
        """
        return pulumi.get(self, "kafka_mirrormaker")

    @property
    @pulumi.getter(name="kafkaMirrormakerUserConfig")
    def kafka_mirrormaker_user_config(self) -> pulumi.Output[Optional['outputs.ServiceKafkaMirrormakerUserConfig']]:
        """
        Kafka MirrorMaker 2 specific user configurable settings
        """
        return pulumi.get(self, "kafka_mirrormaker_user_config")

    @property
    @pulumi.getter(name="kafkaUserConfig")
    def kafka_user_config(self) -> pulumi.Output[Optional['outputs.ServiceKafkaUserConfig']]:
        """
        Kafka specific user configurable settings
        """
        return pulumi.get(self, "kafka_user_config")

    @property
    @pulumi.getter(name="maintenanceWindowDow")
    def maintenance_window_dow(self) -> pulumi.Output[Optional[str]]:
        """
        Day of week when maintenance operations should be performed. One monday, tuesday, wednesday, etc.
        """
        return pulumi.get(self, "maintenance_window_dow")

    @property
    @pulumi.getter(name="maintenanceWindowTime")
    def maintenance_window_time(self) -> pulumi.Output[Optional[str]]:
        """
        Time of day when maintenance operations should be performed. UTC time in HH:mm:ss format.
        """
        return pulumi.get(self, "maintenance_window_time")

    @property
    @pulumi.getter
    def mysql(self) -> pulumi.Output['outputs.ServiceMysql']:
        """
        MySQL specific server provided values
        """
        return pulumi.get(self, "mysql")

    @property
    @pulumi.getter(name="mysqlUserConfig")
    def mysql_user_config(self) -> pulumi.Output[Optional['outputs.ServiceMysqlUserConfig']]:
        """
        MySQL specific user configurable settings
        """
        return pulumi.get(self, "mysql_user_config")

    @property
    @pulumi.getter
    def opensearch(self) -> pulumi.Output['outputs.ServiceOpensearch']:
        """
        Opensearch specific server provided values
        """
        return pulumi.get(self, "opensearch")

    @property
    @pulumi.getter(name="opensearchUserConfig")
    def opensearch_user_config(self) -> pulumi.Output[Optional['outputs.ServiceOpensearchUserConfig']]:
        """
        Opensearch specific user configurable settings
        """
        return pulumi.get(self, "opensearch_user_config")

    @property
    @pulumi.getter
    def pg(self) -> pulumi.Output['outputs.ServicePg']:
        """
        PostgreSQL specific server provided values
        """
        return pulumi.get(self, "pg")

    @property
    @pulumi.getter(name="pgUserConfig")
    def pg_user_config(self) -> pulumi.Output[Optional['outputs.ServicePgUserConfig']]:
        """
        PostgreSQL specific user configurable settings
        """
        return pulumi.get(self, "pg_user_config")

    @property
    @pulumi.getter
    def plan(self) -> pulumi.Output[Optional[str]]:
        """
        Subscription plan
        """
        return pulumi.get(self, "plan")

    @property
    @pulumi.getter
    def project(self) -> pulumi.Output[str]:
        """
        Target project
        """
        return pulumi.get(self, "project")

    @property
    @pulumi.getter(name="projectVpcId")
    def project_vpc_id(self) -> pulumi.Output[Optional[str]]:
        """
        Identifier of the VPC the service should be in, if any
        """
        return pulumi.get(self, "project_vpc_id")

    @property
    @pulumi.getter
    def redis(self) -> pulumi.Output['outputs.ServiceRedis']:
        """
        Redis specific server provided values
        """
        return pulumi.get(self, "redis")

    @property
    @pulumi.getter(name="redisUserConfig")
    def redis_user_config(self) -> pulumi.Output[Optional['outputs.ServiceRedisUserConfig']]:
        """
        Redis specific user configurable settings
        """
        return pulumi.get(self, "redis_user_config")

    @property
    @pulumi.getter(name="serviceHost")
    def service_host(self) -> pulumi.Output[str]:
        """
        Service hostname
        """
        return pulumi.get(self, "service_host")

    @property
    @pulumi.getter(name="serviceIntegrations")
    def service_integrations(self) -> pulumi.Output[Optional[Sequence['outputs.ServiceServiceIntegration']]]:
        """
        Service integrations to specify when creating a service. Not applied after initial service creation
        """
        return pulumi.get(self, "service_integrations")

    @property
    @pulumi.getter(name="serviceName")
    def service_name(self) -> pulumi.Output[str]:
        """
        Service name
        """
        return pulumi.get(self, "service_name")

    @property
    @pulumi.getter(name="servicePassword")
    def service_password(self) -> pulumi.Output[str]:
        """
        Password used for connecting to the service, if applicable
        """
        return pulumi.get(self, "service_password")

    @property
    @pulumi.getter(name="servicePort")
    def service_port(self) -> pulumi.Output[int]:
        """
        Service port
        """
        return pulumi.get(self, "service_port")

    @property
    @pulumi.getter(name="serviceType")
    def service_type(self) -> pulumi.Output[str]:
        """
        Service type code
        """
        return pulumi.get(self, "service_type")

    @property
    @pulumi.getter(name="serviceUri")
    def service_uri(self) -> pulumi.Output[str]:
        """
        URI for connecting to the service. Service specific info is under "kafka", "pg", etc.
        """
        return pulumi.get(self, "service_uri")

    @property
    @pulumi.getter(name="serviceUsername")
    def service_username(self) -> pulumi.Output[str]:
        """
        Username used for connecting to the service, if applicable
        """
        return pulumi.get(self, "service_username")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[str]:
        """
        Service state
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="terminationProtection")
    def termination_protection(self) -> pulumi.Output[Optional[bool]]:
        """
        Prevent service from being deleted. It is recommended to have this enabled for all services.
        """
        return pulumi.get(self, "termination_protection")

