import * as cdk from '@aws-cdk/core';
/**
 * A resource provider for Aqua Enterprise Server.
 *
 * @schema CfnServerProps
 */
export interface CfnServerProps {
    /**
     * EKS cluster name.
     *
     * @schema CfnServerProps#ClusterID
     */
    readonly clusterId?: string;
    /**
     * Secrets Manager ARN for kubeconfig file.
     *
     * @schema CfnServerProps#KubeConfig
     */
    readonly kubeConfig?: string;
    /**
     * IAM to use with EKS cluster authentication, if not resource execution role will be used.
     *
     * @schema CfnServerProps#RoleArn
     */
    readonly roleArn?: string;
    /**
     * Namespace to use with helm.
     *
     * Created if doesn't exist and default will be used if not provided
     *
     * @schema CfnServerProps#Namespace
     */
    readonly namespace?: string;
    /**
     * Name for the helm release.
     *
     * @schema CfnServerProps#Name
     */
    readonly name?: string;
    /**
     * Custom Values can optionally be specified.
     *
     * @schema CfnServerProps#Values
     */
    readonly values?: any;
    /**
     * String representation of a values.yaml file.
     *
     * @schema CfnServerProps#ValueYaml
     */
    readonly valueYaml?: string;
    /**
     * Version can be specified, if not latest will be used.
     *
     * @schema CfnServerProps#Version
     */
    readonly version?: string;
    /**
     * Custom Value Yaml file can optionally be specified.
     *
     * @schema CfnServerProps#ValueOverrideURL
     */
    readonly valueOverrideUrl?: string;
    /**
     * Timeout for resource provider.
     *
     * Default 60 mins
     *
     * @schema CfnServerProps#TimeOut
     */
    readonly timeOut?: number;
    /**
     * For network connectivity to Cluster inside VPC.
     *
     * @schema CfnServerProps#VPCConfiguration
     */
    readonly vpcConfiguration?: CfnServerPropsVpcConfiguration;
}
/**
 * Converts an object of type 'CfnServerProps' to JSON representation.
 */
export declare function toJson_CfnServerProps(obj: CfnServerProps | undefined): Record<string, any> | undefined;
/**
 * For network connectivity to Cluster inside VPC.
 *
 * @schema CfnServerPropsVpcConfiguration
 */
export interface CfnServerPropsVpcConfiguration {
    /**
     * Specify one or more security groups.
     *
     * @schema CfnServerPropsVpcConfiguration#SecurityGroupIds
     */
    readonly securityGroupIds?: string[];
    /**
     * Specify one or more subnets.
     *
     * @schema CfnServerPropsVpcConfiguration#SubnetIds
     */
    readonly subnetIds?: string[];
}
/**
 * Converts an object of type 'CfnServerPropsVpcConfiguration' to JSON representation.
 */
export declare function toJson_CfnServerPropsVpcConfiguration(obj: CfnServerPropsVpcConfiguration | undefined): Record<string, any> | undefined;
/**
 * A CloudFormation `Aqua::Enterprise::Server`.
 *
 * @external
 * @cloudformationResource Aqua::Enterprise::Server
 * @link https://github.com/aquasecurity/aqua-helm.git
 */
export declare class CfnServer extends cdk.CfnResource {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "Aqua::Enterprise::Server";
    /**
     * Resource props.
     *
     * @external
     */
    readonly props: CfnServerProps;
    /**
     * Attribute `Aqua::Enterprise::Server.ID`.
     *
     * @external
     * @link https://github.com/aquasecurity/aqua-helm.git
     */
    readonly attrId: string;
    /**
     * Create a new `Aqua::Enterprise::Server`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnServerProps);
}
