# -*- coding: utf-8 -*-
from setuptools import setup

package_dir = \
{'': 'bin'}

packages = \
['pytaxonomies',
 'pytaxonomies.data.misp-taxonomies.tools',
 'pytaxonomies.data.misp-taxonomies.tools.generator']

package_data = \
{'': ['*'],
 'pytaxonomies': ['data/misp-taxonomies/*',
                  'data/misp-taxonomies/CERT-XLM/*',
                  'data/misp-taxonomies/DFRLab-dichotomies-of-disinformation/*',
                  'data/misp-taxonomies/DML/*',
                  'data/misp-taxonomies/PAP/*',
                  'data/misp-taxonomies/access-method/*',
                  'data/misp-taxonomies/accessnow/*',
                  'data/misp-taxonomies/action-taken/*',
                  'data/misp-taxonomies/admiralty-scale/*',
                  'data/misp-taxonomies/adversary/*',
                  'data/misp-taxonomies/ais-marking/*',
                  'data/misp-taxonomies/analyst-assessment/*',
                  'data/misp-taxonomies/approved-category-of-action/*',
                  'data/misp-taxonomies/binary-class/*',
                  'data/misp-taxonomies/cccs/*',
                  'data/misp-taxonomies/circl/*',
                  'data/misp-taxonomies/coa/*',
                  'data/misp-taxonomies/collaborative-intelligence/*',
                  'data/misp-taxonomies/common-taxonomy/*',
                  'data/misp-taxonomies/copine-scale/*',
                  'data/misp-taxonomies/course-of-action/*',
                  'data/misp-taxonomies/cryptocurrency-threat/*',
                  'data/misp-taxonomies/csirt-americas/*',
                  'data/misp-taxonomies/csirt_case_classification/*',
                  'data/misp-taxonomies/cssa/*',
                  'data/misp-taxonomies/cyber-threat-framework/*',
                  'data/misp-taxonomies/cytomic-orion/*',
                  'data/misp-taxonomies/dark-web/*',
                  'data/misp-taxonomies/data-classification/*',
                  'data/misp-taxonomies/dcso-sharing/*',
                  'data/misp-taxonomies/ddos/*',
                  'data/misp-taxonomies/de-vs/*',
                  'data/misp-taxonomies/dhs-ciip-sectors/*',
                  'data/misp-taxonomies/diamond-model/*',
                  'data/misp-taxonomies/dni-ism/*',
                  'data/misp-taxonomies/domain-abuse/*',
                  'data/misp-taxonomies/drugs/*',
                  'data/misp-taxonomies/economical-impact/*',
                  'data/misp-taxonomies/ecsirt/*',
                  'data/misp-taxonomies/enisa/*',
                  'data/misp-taxonomies/estimative-language/*',
                  'data/misp-taxonomies/eu-marketop-and-publicadmin/*',
                  'data/misp-taxonomies/eu-nis-sector-and-subsectors/*',
                  'data/misp-taxonomies/euci/*',
                  'data/misp-taxonomies/europol-event/*',
                  'data/misp-taxonomies/europol-incident/*',
                  'data/misp-taxonomies/event-assessment/*',
                  'data/misp-taxonomies/event-classification/*',
                  'data/misp-taxonomies/exercise/*',
                  'data/misp-taxonomies/failure-mode-in-machine-learning/*',
                  'data/misp-taxonomies/false-positive/*',
                  'data/misp-taxonomies/file-type/*',
                  'data/misp-taxonomies/flesch-reading-ease/*',
                  'data/misp-taxonomies/fpf/*',
                  'data/misp-taxonomies/fr-classif/*',
                  'data/misp-taxonomies/gdpr/*',
                  'data/misp-taxonomies/gea-nz-activities/*',
                  'data/misp-taxonomies/gea-nz-entities/*',
                  'data/misp-taxonomies/gea-nz-motivators/*',
                  'data/misp-taxonomies/gsma-attack-category/*',
                  'data/misp-taxonomies/gsma-fraud/*',
                  'data/misp-taxonomies/gsma-network-technology/*',
                  'data/misp-taxonomies/honeypot-basic/*',
                  'data/misp-taxonomies/ics/*',
                  'data/misp-taxonomies/iep/*',
                  'data/misp-taxonomies/iep2-policy/*',
                  'data/misp-taxonomies/iep2-reference/*',
                  'data/misp-taxonomies/ifx-vetting/*',
                  'data/misp-taxonomies/incident-disposition/*',
                  'data/misp-taxonomies/infoleak/*',
                  'data/misp-taxonomies/information-security-data-source/*',
                  'data/misp-taxonomies/information-security-indicators/*',
                  'data/misp-taxonomies/interception-method/*',
                  'data/misp-taxonomies/iot/*',
                  'data/misp-taxonomies/kill-chain/*',
                  'data/misp-taxonomies/maec-delivery-vectors/*',
                  'data/misp-taxonomies/maec-malware-behavior/*',
                  'data/misp-taxonomies/maec-malware-capabilities/*',
                  'data/misp-taxonomies/maec-malware-obfuscation-methods/*',
                  'data/misp-taxonomies/malware_classification/*',
                  'data/misp-taxonomies/mapping/*',
                  'data/misp-taxonomies/misp/*',
                  'data/misp-taxonomies/monarc-threat/*',
                  'data/misp-taxonomies/ms-caro-malware-full/*',
                  'data/misp-taxonomies/ms-caro-malware/*',
                  'data/misp-taxonomies/mwdb/*',
                  'data/misp-taxonomies/nato/*',
                  'data/misp-taxonomies/nis/*',
                  'data/misp-taxonomies/open_threat/*',
                  'data/misp-taxonomies/osint/*',
                  'data/misp-taxonomies/passivetotal/*',
                  'data/misp-taxonomies/pentest/*',
                  'data/misp-taxonomies/phishing/*',
                  'data/misp-taxonomies/priority-level/*',
                  'data/misp-taxonomies/ransomware/*',
                  'data/misp-taxonomies/retention/*',
                  'data/misp-taxonomies/rsit/*',
                  'data/misp-taxonomies/rt_event_status/*',
                  'data/misp-taxonomies/runtime-packer/*',
                  'data/misp-taxonomies/scrippsco2-fgc/*',
                  'data/misp-taxonomies/scrippsco2-fgi/*',
                  'data/misp-taxonomies/scrippsco2-sampling-stations/*',
                  'data/misp-taxonomies/smart-airports-threats/*',
                  'data/misp-taxonomies/stealth_malware/*',
                  'data/misp-taxonomies/stix-ttp/*',
                  'data/misp-taxonomies/targeted-threat-index/*',
                  'data/misp-taxonomies/threats-to-dns/*',
                  'data/misp-taxonomies/tlp/*',
                  'data/misp-taxonomies/tor/*',
                  'data/misp-taxonomies/type/*',
                  'data/misp-taxonomies/use-case-applicability/*',
                  'data/misp-taxonomies/veris/*',
                  'data/misp-taxonomies/vocabulaire-des-probabilites-estimatives/*',
                  'data/misp-taxonomies/workflow/*'],
 'pytaxonomies.data.misp-taxonomies.tools': ['docs/images/*']}

modules = \
['pytaxonomies']
extras_require = \
{'remote': ['requests>=2.22.0,<3.0.0'],
 'webui': ['flask-nav>=0.6,<0.7',
           'Flask>=1.1.1,<2.0.0',
           'Flask-Bootstrap>=3.3.7,<4.0.0',
           'Flask-WTF>=0.14.3,<0.15.0']}

entry_points = \
{'console_scripts': ['pytaxonomies = bin.pytaxonomies:main']}

setup_kwargs = {
    'name': 'pytaxonomies',
    'version': '1.0',
    'description': 'Python API for the taxonomies.',
    'long_description': '# PyTaxonomies\n\n[![Build Status](https://travis-ci.org/MISP/PyTaxonomies.svg?branch=master)](https://travis-ci.org/MISP/PyTaxonomies)\n[![Coverage Status](https://coveralls.io/repos/github/MISP/PyTaxonomies/badge.svg?branch=master)](https://coveralls.io/github/MISP/PyTaxonomies?branch=master)\n[![codecov.io](https://codecov.io/github/MISP/PyTaxonomies/coverage.svg?branch=master)](https://codecov.io/github/MISP/PyTaxonomies?branch=master)\n\nPythonic way to work with the taxonomies defined there: https://github.com/MISP/misp-taxonomies\n\n# Usage\n\nTaxonomies and predicates are represented as immutable Python dictionaries.\n\n# Installation\n```\npip3 install git+https://github.com/MISP/PyTaxonomies\n```\nor\n```\ngit clone https://github.com/MISP/PyTaxonomies\ncd PyTaxonomies\ngit submodule init && git submodule update\npython3 setup.py install\n```\n\n## Basics\n\n```\nIn [1]: from pytaxonomies import Taxonomies\n\nIn [2]: taxonomies = Taxonomies()\n\nIn [3]: taxonomies.version\nOut[3]: \'20160725\'\n\nIn [4]: taxonomies.license\nOut[4]: \'CC-BY\'\n\nIn [5]: taxonomies.description\nOut[5]: \'Manifest file of MISP taxonomies available.\'\n\n# How many taxonomies have been imported\nIn [6]: len(taxonomies)\nOut[6]: 27\n\n# Names of the taxonomies\nIn [7]: list(taxonomies.keys())\nOut[7]:\n[\'tlp\',\n \'eu-critical-sectors\',\n \'dni-ism\',\n \'de-vs\',\n \'osint\',\n \'ms-caro-malware\',\n \'open-threat\',\n \'circl\',\n \'iep\',\n \'euci\',\n \'kill-chain\',\n \'europol-events\',\n \'veris\',\n \'information-security-indicators\',\n \'estimative-language\',\n \'adversary\',\n \'europol-incident\',\n \'malware_classification\',\n \'ecsirt\',\n \'dhs-ciip-sectors\',\n \'csirt_case_classification\',\n \'nato\',\n \'fr-classif\',\n \'enisa\',\n \'misp\',\n \'admiralty-scale\',\n \'ms-caro-malware-full\']\n\nIn [8]: taxonomies.get(\'enisa\').description\nOut[8]: \'The present threat taxonomy is an initial version that has been developed on the basis of available ENISA material. This material has been used as an ENISA-internal structuring aid for information collection and threat consolidation purposes. It emerged in the time period 2012-2015.\'\n\nIn [9]: taxonomies.get(\'enisa\').version\nOut[9]: 201601\n\nIn [10]: taxonomies.get(\'enisa\').name\nOut[10]: \'enisa\'\n\nIn [11]: list(taxonomies.get(\'enisa\').keys())\nOut[11]:\n[\'legal\',\n \'outages\',\n \'eavesdropping-interception-hijacking\',\n \'nefarious-activity-abuse\',\n \'physical-attack\',\n \'failures-malfunction\',\n \'disaster\',\n \'unintentional-damage\']\n\nIn [12]: list(taxonomies.get(\'enisa\').get(\'physical-attack\'))\nOut[12]:\n[\'fraud-by-employees\',\n \'theft\',\n \'unauthorised-physical-access-or-unauthorised-entry-to-premises\',\n \'theft-of-documents\',\n \'information-leak-or-unauthorised-sharing\',\n \'vandalism\',\n \'damage-from-the-wafare\',\n \'sabotage\',\n \'coercion-or-extortion-or-corruption\',\n \'theft-of-mobile-devices\',\n \'theft-of-fixed-hardware\',\n \'terrorist-attack\',\n \'theft-of-backups\',\n \'fraud\']\n\nIn [13]: taxonomies.get(\'enisa\').get(\'physical-attack\').get(\'vandalism\').value\nOut[13]: \'vandalism\'\n\nIn [14]: taxonomies.get(\'enisa\').get(\'physical-attack\').get(\'vandalism\').expanded\nOut[14]: \'Vandalism\'\n\nIn [15]: taxonomies.get(\'enisa\').get(\'physical-attack\').get(\'vandalism\').description\nOut[15]: \'Act of physically damaging IT assets.\'\n\n```\n\n## Get machine tags\n\n```\nIn [1]: print(taxonomies)  # or taxonomies.all_machinetags()\n\n<display the machine tags for all the taxonomies>\n\nIn [2]: print(taxonomies.get(\'circl\'))  # or taxonomies.get(\'circl\').machinetags()\ncircl:incident-classification="vulnerability"\ncircl:incident-classification="malware"\ncircl:incident-classification="fastflux"\ncircl:incident-classification="system-compromise"\ncircl:incident-classification="sql-injection"\ncircl:incident-classification="scan"\ncircl:incident-classification="XSS"\ncircl:incident-classification="information-leak"\ncircl:incident-classification="scam"\ncircl:incident-classification="copyright-issue"\ncircl:incident-classification="denial-of-service"\ncircl:incident-classification="phishing"\ncircl:incident-classification="spam"\ncircl:topic="undefined"\ncircl:topic="industry"\ncircl:topic="ict"\ncircl:topic="finance"\ncircl:topic="services"\ncircl:topic="individual"\ncircl:topic="medical"\n\n# All entries\nIn [3]: taxonomies.get(\'circl\').amount_entries()\nOut[3]: 28\n\n# Amount predicates\nIn [3]: len(taxonomies.get(\'circl\'))\nOut[3]: 2\n\n```\n\n## Expanded machine tag\n\n```\nIn [10]: print(taxonomies.get(\'circl\').machinetags_expanded())\ncircl:topic="Individual"\ncircl:topic="Services"\ncircl:topic="Finance"\ncircl:topic="Medical"\ncircl:topic="Industry"\ncircl:topic="Undefined"\ncircl:topic="ICT"\ncircl:incident-classification="Phishing"\ncircl:incident-classification="Malware"\ncircl:incident-classification="XSS"\ncircl:incident-classification="Copyright issue"\ncircl:incident-classification="Spam"\ncircl:incident-classification="SQL Injection"\ncircl:incident-classification="Scan"\ncircl:incident-classification="Scam"\ncircl:incident-classification="Vulnerability"\ncircl:incident-classification="Denial of Service"\ncircl:incident-classification="Information leak"\ncircl:incident-classification="Fastflux"\ncircl:incident-classification="System compromise"\n```\n',
    'author': 'Raphaël Vinot',
    'author_email': 'raphael.vinot@circl.lu',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/MISP/PyTaxonomies',
    'package_dir': package_dir,
    'packages': packages,
    'package_data': package_data,
    'py_modules': modules,
    'extras_require': extras_require,
    'entry_points': entry_points,
    'python_requires': '>=3.6,<4.0',
}


setup(**setup_kwargs)
