"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.GithubActionsIdentityProvider = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const iam = require("@aws-cdk/aws-iam");
const cdk = require("@aws-cdk/core");
/**
 * (experimental) Github Actions as OpenID Connect Identity Provider for AWS IAM. There can be only one (per AWS Account).
 *
 * Use `fromAccount` to retrieve a reference to existing Github OIDC provider.
 *
 * @see https://docs.github.com/en/actions/deployment/security-hardening-your-deployments/configuring-openid-connect-in-amazon-web-services
 * @experimental
 */
class GithubActionsIdentityProvider extends iam.OpenIdConnectProvider {
    /**
     * (experimental) Define a new Github OpenID Connect Identity PRovider for AWS IAM.
     *
     * There can be only one (per AWS Account).
     *
     * @param scope CDK Stack or Construct to which the provider is assigned to.
     * @param id CDK Construct ID given to the construct.
     * @experimental
     * @example
     *
     * new GithubActionsIdentityProvider(scope, "GithubProvider");
     */
    constructor(scope, id) {
        super(scope, id, {
            url: `https://${GithubActionsIdentityProvider.issuer}`,
            thumbprints: [GithubActionsIdentityProvider.thumbprint],
            clientIds: ['sts.amazonaws.com'],
        });
    }
    /**
     * (experimental) Retrieve a reference to existing Github OIDC provider in your AWS account.
     *
     * An AWS account can only have single Github OIDC provider configured into it,
     * so internally the reference is made by constructing the ARN from AWS
     * Account ID & Github issuer URL.
     *
     * @param scope CDK Stack or Construct to which the provider is assigned to.
     * @param id CDK Construct ID given to the construct.
     * @returns a CDK Construct representing the Github OIDC provider
     * @experimental
     * @example
     *
     * GithubActionsIdentityProvider.fromAccount(scope, "GithubProvider");
     */
    static fromAccount(scope, id) {
        const accountId = cdk.Stack.of(scope).account;
        const providerArn = `arn:aws:iam::${accountId}:oidc-provider/${GithubActionsIdentityProvider.issuer}`;
        const provider = iam.OpenIdConnectProvider.fromOpenIdConnectProviderArn(scope, id, providerArn);
        return provider;
    }
}
exports.GithubActionsIdentityProvider = GithubActionsIdentityProvider;
_a = JSII_RTTI_SYMBOL_1;
GithubActionsIdentityProvider[_a] = { fqn: "aws-cdk-github-oidc.GithubActionsIdentityProvider", version: "0.0.8" };
/**
 * @experimental
 */
GithubActionsIdentityProvider.issuer = 'token.actions.githubusercontent.com';
/**
 * @experimental
 */
GithubActionsIdentityProvider.thumbprint = 'a031c46782e6e6c662c2c87c76da9aa62ccabd8e';
//# sourceMappingURL=data:application/json;base64,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