# 获取中国国家统计局网站数据

数据源：http://www.stats.gov.cn/

## PyPi安装

```bash
pip install cn-stats
```

## cn-stats使用

```python
from cnstats.stats import stats

stats('A0D01', '202201')
```

## 命令行中使用

例：获取2022年1月货币供应量数据

```bash
$ python -m cnstats A0D01 202201
A0D0101 202201 2431022.72
A0D0102 202201 9.8
A0D0103 202201 613859.35
A0D0104 202201 -1.9
A0D0105 202201 106188.87
A0D0106 202201 18.5
```

例：获取多个月货币供应量数据

```bash
python -m cnstats A0D01 202112,202201
A0D0101 202201 2431022.72
A0D0101 202112 2382899.56
A0D0102 202201 9.8
A0D0102 202112 9.0
A0D0103 202201 613859.35
A0D0103 202112 647443.35
A0D0104 202201 -1.9
A0D0104 202112 3.5
A0D0105 202201 106188.87
A0D0105 202112 90825.15
A0D0106 202201 18.5
A0D0106 202112 7.7
```

## 指标代码

代码 | 释义
---|---
A01|价格指数
A0101|居民消费价格分类指数(上年同月=100)
A010101|全国居民消费价格分类指数(上年同月=100)(2016-)
A010102|全国居民消费价格分类指数(上年同月=100)(-2015)
A010103|全国食品类居民消费价格指数(上年同月=100)
A010104|城市居民消费价格分类指数(上年同月=100)(2016-)
A010105|城市居民消费价格分类指数(上年同月=100)(-2015)
A010106|食品类城市居民消费价格指数(上年同月=100)
A010107|农村居民消费价格分类指数(上年同月=100)(2016-)
A010108|农村居民消费价格分类指数(上年同月=100)(-2015)
A010109|食品类农村居民消费价格指数(上年同月=100)
A0102|居民消费价格分类指数(上年同期=100)
A010201|全国居民消费价格分类指数(上年同期=100)(2016-)
A010202|全国居民消费价格分类指数(上年同期=100)(-2015)
A010203|全国食品类居民消费价格指数(上年同期=100)
A010204|城市居民消费价格分类指数(上年同期=100)(2016-)
A010205|城市居民消费价格分类指数(上年同期=100)(-2015)
A010206|食品类城市居民消费价格指数(上年同期=100)
A010207|农村居民消费价格分类指数(上年同期=100)(2016-)
A010208|农村居民消费价格分类指数(上年同期=100)(-2015)
A010209|食品类农村居民消费价格指数(上年同期=100)
A0103|居民消费价格分类指数(上月=100)
A010301|全国居民消费价格分类指数(上月=100)(2016-)
A010302|全国居民消费价格分类指数(上月=100)(-2015)
A010303|食品类居民消费价格指数(上月=100)
A010304|城市居民消费价格分类指数(上月=100)(2016-)
A010305|城市居民消费价格分类指数(上月=100)(-2015)
A010306|食品类城市居民消费价格指数(上月=100)
A010307|农村居民消费价格分类指数(上月=100)(2016-)
A010308|农村居民消费价格分类指数(上月=100)(-2015)
A010309|食品类农村居民消费价格指数(上月=100)
A0104|商品零售价格分类指数(上年同月=100)
A010401|商品零售价格指数(上年同月=100)
A010402|城市商品零售价格指数(上年同月=100)
A010403|农村商品零售价格指数(上年同月=100)
A0105|商品零售价格分类指数(上年同期=100)
A010501|商品零售价格指数(上年同期=100)
A010502|城市商品零售价格指数(上年同期=100)
A010503|农村商品零售价格指数(上年同期=100)
A0106|商品零售价格分类指数(上月=100)
A010601|商品零售价格指数(上月=100)
A010602|城市商品零售价格指数(上月=100)
A010603|农村商品零售价格指数(上月=100)
A0107|工业生产者购进价格指数
A010701|工业生产者购进价格指数(上年同月=100)
A010702|工业生产者购进价格指数(上年同期=100)
A010703|工业生产者购进价格指数(上月=100)
A0108|工业生产者出厂价格分类指数
A010801|工业生产者出厂价格指数(上年同月=100)
A010802|生产资料工业生产者出厂价格指数(上年同月=100)
A010803|生活资料工业生产者出厂价格指数(上年同月=100)
A010804|工业生产者出厂价格指数(上年同期=100)
A010805|生产资料工业生产者出厂价格指数(上年同期=100)
A010806|生活资料工业生产者出厂价格指数(上年同期=100)
A010807|工业生产者出厂价格指数(上月=100)
A010808|生产资料工业生产者出厂价格指数(上月=100)
A010809|生活资料工业生产者出厂价格指数(上月=100)
A01080A|按工业部门分工业生产者出厂价格指数(上年同月=100)
A0109|分行业工业生产者出厂价格指数(上年同月=100)(2007-2013)
A010A|分行业工业生产者出厂价格指数(上年同月=100)(2014-2017)
A010B|分行业工业生产者出厂价格指数(上年同月=100)(2018-至今)
A010E|分行业工业生产者出厂价格指数(上年同期=100)
A010F|分行业工业生产者出厂价格指数(上月=100)
A010C|分行业中类工业生产者出厂价格指数(上年同月=100)(2014-2017)
A010C01|煤炭开采和洗选业工业生产者出厂价格指数(上年同月=100)
A010C02|石油和天然气开采业工业生产者出厂价格指数(上年同月=100)
A010C03|黑色金属矿采选业工业生产者出厂价格指数(上年同月=100)
A010C04|有色金属矿采选业工业生产者出厂价格指数(上年同月=100)
A010C05|非金属矿采选业工业生产者出厂价格指数(上年同月=100)
A010C06|开采辅助活动工业生产者出厂价格指数(上年同月=100)
A010C07|农副食品加工业工业生产者出厂价格指数(上年同月=100)
A010C08|食品制造业工业生产者出厂价格指数(上年同月=100)
A010C09|酒、饮料和精制茶制造业工业生产者出厂价格指数(上年同月=100)
A010C0A|烟草制品业工业生产者出厂价格指数(上年同月=100)
A010C0B|纺织业工业生产者出厂价格指数(上年同月=100)
A010C0C|纺织服装、服饰业工业生产者出厂价格指数(上年同月=100)
A010C0D|皮革、毛皮、羽毛及其制品和制鞋业工业生产者出厂价格指数(上年同月=100)
A010C0E|木材加工和木、竹、藤、棕、草制品业工业生产者出厂价格指数(上年同月=100)
A010C0F|家具制造业工业生产者出厂价格指数(上年同月=100)
A010C0G|造纸和纸制品业工业生产者出厂价格指数(上年同月=100)
A010C0H|印刷和记录媒介复制业工业生产者出厂价格指数(上年同月=100)
A010C0I|文教、工美、体育和娱乐用品制造业工业生产者出厂价格指数(上年同月=100)
A010C0J|石油加工、炼焦和核燃料加工业工业生产者出厂价格指数(上年同月=100)
A010C0K|化学原料和化学制品制造业工业生产者出厂价格指数(上年同月=100)
A010C0L|医药制造业工业生产者出厂价格指数(上年同月=100)
A010C0M|化学纤维制造业工业生产者出厂价格指数(上年同月=100)
A010C0N|橡胶和塑料制品业工业生产者出厂价格指数(上年同月=100)
A010C0O|非金属矿物制品业工业生产者出厂价格指数(上年同月=100)
A010C0P|黑色金属冶炼和压延加工业工业生产者出厂价格指数(上年同月=100)
A010C0Q|有色金属冶炼和压延加工业工业生产者出厂价格指数(上年同月=100)
A010C0R|金属制品业工业生产者出厂价格指数(上年同月=100)
A010C0S|通用设备制造业工业生产者出厂价格指数(上年同月=100)
A010C0T|专用设备制造业工业生产者出厂价格指数(上年同月=100)
A010C0U|汽车制造业工业生产者出厂价格指数(上年同月=100)
A010C0V|铁路、船舶、航空航天和其他运输设备制造业工业生产者出厂价格指数(上年同月=100)
A010C0W|电气机械和器材制造业工业生产者出厂价格指数(上年同月=100)
A010C0X|计算机、通信和其他电子设备制造业工业生产者出厂价格指数(上年同月=100)
A010C0Y|仪器仪表制造业工业生产者出厂价格指数(上年同月=100)
A010C0Z|其他制造业工业生产者出厂价格指数(上年同月=100)
A010C10|废弃资源综合利用业工业生产者出厂价格指数(上年同月=100)
A010C11|金属制品、机械和设备修理业工业生产者出厂价格指数(上年同月=100)
A010C12|电力、热力生产和供应业工业生产者出厂价格指数(上年同月=100)
A010C13|水的生产和供应业工业生产者出厂价格指数(上年同月=100)
A010D|分行业中类工业生产者出厂价格指数(上年同月=100)(2018-至今)
A010D01|煤炭开采和洗选业工业生产者出厂价格指数(上年同月=100)
A010D02|石油和天然气开采业工业生产者出厂价格指数(上年同月=100)
A010D03|黑色金属矿采选业工业生产者出厂价格指数(上年同月=100)
A010D04|有色金属矿采选业工业生产者出厂价格指数(上年同月=100)
A010D05|非金属矿采选业工业生产者出厂价格指数(上年同月=100)
A010D06|开采专业及辅助性活动工业生产者出厂价格指数(上年同月=100)
A010D07|农副食品加工业工业生产者出厂价格指数(上年同月=100)
A010D08|食品制造业工业生产者出厂价格指数(上年同月=100)
A010D09|酒、饮料及精制茶制造业工业生产者出厂价格指数(上年同月=100)
A010D0A|烟草制品业工业生产者出厂价格指数(上年同月=100)
A010D0B|纺织业工业生产者出厂价格指数(上年同月=100)
A010D0C|纺织服装、服饰业工业生产者出厂价格指数(上年同月=100)
A010D0D|皮革、毛皮、羽毛及其制品和制鞋业工业生产者出厂价格指数(上年同月=100)
A010D0E|木材加工和木、竹、藤、棕、草制品业工业生产者出厂价格指数(上年同月=100)
A010D0F|家具制造业工业生产者出厂价格指数(上年同月=100)
A010D0G|造纸和纸制品业工业生产者出厂价格指数(上年同月=100)
A010D0H|印刷和记录媒介复制业工业生产者出厂价格指数(上年同月=100)
A010D0I|文教、工美、体育和娱乐用品制造业工业生产者出厂价格指数(上年同月=100)
A010D0J|石油、煤炭及其他燃料加工业工业生产者出厂价格指数(上年同月=100)
A010D0K|化学原料和化学制品制造业工业生产者出厂价格指数(上年同月=100)
A010D0L|医药制造业工业生产者出厂价格指数(上年同月=100)
A010D0M|化学纤维制造业工业生产者出厂价格指数(上年同月=100)
A010D0N|橡胶和塑料制品业工业生产者出厂价格指数(上年同月=100)
A010D0O|非金属矿物制品业工业生产者出厂价格指数(上年同月=100)
A010D0P|黑色金属冶炼和压延加工业工业生产者出厂价格指数(上年同月=100)
A010D0Q|有色金属冶炼和压延加工业工业生产者出厂价格指数(上年同月=100)
A010D0R|金属制品业工业生产者出厂价格指数(上年同月=100)
A010D0S|通用设备制造业工业生产者出厂价格指数(上年同月=100)
A010D0T|专用设备制造业工业生产者出厂价格指数(上年同月=100)
A010D0U|汽车制造业工业生产者出厂价格指数(上年同月=100)
A010D0V|铁路、船舶、航空航天和其他运输设备制造业工业生产者出厂价格指数(上年同月=100)
A010D0W|电气机械和器材制造业工业生产者出厂价格指数(上年同月=100)
A010D0X|计算机、通信和其他电子设备制造业工业生产者出厂价格指数(上年同月=100)
A010D0Y|仪器仪表制造业工业生产者出厂价格指数(上年同月=100)
A010D0Z|其他制造业工业生产者出厂价格指数(上年同月=100)
A010D10|废弃资源综合利用业工业生产者出厂价格指数(上年同月=100)
A010D11|金属制品、机械和设备修理业工业生产者出厂价格指数(上年同月=100)
A010D12|电力、热力生产和供应业工业生产者出厂价格指数(上年同月=100)
A010D13|燃气生产和供应业工业生产者出厂价格指数(上年同月=100)
A010D14|水的生产和供应业工业生产者出厂价格指数(上年同月=100)
A010G|农产品集贸市场价格
A010G01|粮食集贸市场价格
A010G02|经济作物类集贸市场价格
A010G03|畜产品集贸市场价格
A010G04|水产品集贸市场价格
A010G05|蔬菜集贸市场价格
A010G06|水果集贸市场价格
A02|工业
A0201|工业增加值增长速度
A0202|按经济类型分工业增加值增长速度
A020P|按三大门类分工业增加值增长速度
A0203|工业分大类行业增加值增长速度(2003-2011)
A0204|工业分大类行业增加值增长速度(2012-2017)
A0205|工业分大类行业增加值增长速度(2018-至今)
A0206|工业分大类行业出口交货值(2003-2011)
A020601|工业出口交货值
A020602|煤炭开采和洗选业
A020603|石油和天然气开采业
A020604|黑色金属矿采选业
A020605|有色金属矿采选业
A020606|非金属矿采选业
A020607|其他采矿业
A020608|农副食品加工业
A020609|食品制造业
A02060A|饮料制造业
A02060B|烟草制品业
A02060C|纺织业
A02060D|纺织服装、鞋、帽制造业
A02060E|皮革、毛皮、羽毛(绒)及其制品业
A02060F|木材加工及木、竹、藤、棕、草制品业
A02060G|家具制造业
A02060H|造纸及纸制品业
A02060I|印刷业和记录媒介的复制
A02060J|文教体育用品制造业
A02060K|石油加工、炼焦及核燃料加工业
A02060L|化学原料及化学制品制造业
A02060M|医药制造业
A02060N|化学纤维制造业
A02060O|橡胶制品业
A02060P|塑料制品业
A02060Q|非金属矿物制品业
A02060R|黑色金属冶炼及压延加工业
A02060S|有色金属冶炼及压延加工业
A02060T|金属制品业
A02060U|通用设备制造业
A02060V|专用设备制造业
A02060W|交通运输设备制造业
A02060X|电气机械及器材制造业
A02060Y|通信设备、计算机及其他电子设备制造业
A02060Z|仪器仪表及文化、办公用机械制造业
A020610|工艺品及其他制造业
A020611|废弃资源和废旧材料回收加工业
A020612|电力、热力的生产和供应业
A020613|燃气生产和供应业
A020614|水的生产和供应业
A0207|工业分大类行业出口交货值(2012-2017)
A020701|工业出口交货值
A020702|煤炭开采和洗选业
A020703|石油和天然气开采业
A020704|黑色金属矿采选业
A020705|有色金属矿采选业
A020706|非金属矿采选业
A020707|开采辅助活动
A020708|其他采矿业
A020709|农副食品加工业
A02070A|食品制造业
A02070B|酒、饮料和精制茶制造业
A02070C|烟草制品业
A02070D|纺织业
A02070E|纺织服装、服饰业
A02070F|皮革、毛皮、羽毛及其制品和制鞋业
A02070G|木材加工及木、竹、藤、棕、草制品业
A02070H|家具制造业
A02070I|造纸及纸制品业
A02070J|印刷和记录媒介复制业
A02070K|文教、工美、体育和娱乐用品制造业
A02070L|石油加工、炼焦及核燃料加工业
A02070M|化学原料及化学制品制造业
A02070N|医药制造业
A02070O|化学纤维制造业
A02070P|橡胶和塑料制品业
A02070Q|非金属矿物制品业
A02070R|黑色金属冶炼及压延加工业
A02070S|有色金属冶炼及压延加工业
A02070T|金属制品业
A02070U|通用设备制造业
A02070V|专用设备制造业
A02070W|汽车制造业
A02070X|铁路、船舶、航空航天和其他运输设备制造业
A02070Y|电气机械及器材制造业
A02070Z|通信设备、计算机及其他电子设备制造业
A020710|仪器仪表制造业
A020711|其他制造业
A020712|废弃资源综合利用业
A020713|金属制品、机械和设备修理业
A020714|电力、热力的生产和供应业
A020715|燃气生产和供应业
A020716|水的生产和供应业
A0208|工业分大类行业出口交货值(2018-至今)
A020801|工业出口交货值
A020802|煤炭开采和洗选业
A020803|石油和天然气开采业
A020804|黑色金属矿采选业
A020805|有色金属矿采选业
A020806|非金属矿采选业
A020807|开采专业及辅助性活动
A020808|其他采矿业
A020809|农副食品加工业
A02080A|食品制造业
A02080B|酒、饮料和精制茶制造业
A02080C|烟草制品业
A02080D|纺织业
A02080E|纺织服装、服饰业
A02080F|皮革、毛皮、羽毛及其制品和制鞋业
A02080G|木材加工和木、竹、藤、棕、草制品业
A02080H|家具制造业
A02080I|造纸和纸制品业
A02080J|印刷和记录媒介复制业
A02080K|文教、工美、体育和娱乐用品制造业
A02080L|石油、煤炭及其他燃料加工业
A02080M|化学原料和化学制品制造业
A02080N|医药制造业
A02080O|化学纤维制造业
A02080P|橡胶和塑料制品业
A02080Q|非金属矿物制品业
A02080R|黑色金属冶炼和压延加工业
A02080S|有色金属冶炼和压延加工业
A02080T|金属制品业
A02080U|通用设备制造业
A02080V|专用设备制造业
A02080W|汽车制造业
A02080X|铁路、船舶、航空航天和其他运输设备制造业
A02080Y|电气机械和器材制造业
A02080Z|计算机、通信和其他电子设备制造业
A020810|仪器仪表制造业
A020811|其他制造业
A020812|废弃资源综合利用业
A020813|金属制品、机械和设备修理业
A020814|电力、热力生产和供应业
A020815|燃气生产和供应业
A020816|水的生产和供应业
A020Q|产品销售率(按现价计算)
A0209|工业主要产品产量
A020901|铁矿石原矿
A020902|磷矿石（折含五氧化二磷30％）
A020903|原盐
A020904|饲料
A020905|精制食用植物油
A020906|成品糖
A020907|鲜、冷藏肉
A020908|乳制品
A020909|白酒（折65度，商品量）
A02090A|啤酒
A02090B|葡萄酒
A02090C|饮料
A02090D|卷烟
A02090E|纱
A02090F|布
A02090G|蚕丝及交织机织物（含蚕丝≥30％）
A02090H|机制纸及纸板（外购原纸加工除外）
A02090I|新闻纸
A02090J|硫酸（折100％）
A02090K|烧碱（折100％）
A02090L|纯碱（碳酸钠）
A02090M|乙烯
A02090N|农用氮、磷、钾化学肥料（折纯）
A02090O|化学农药原药（折有效成分100％）
A02090P|初级形态塑料
A02090Q|合成橡胶
A02090R|合成洗涤剂
A02090S|化学药品原药
A02090T|中成药
A02090U|化学纤维
A02090V|合成纤维
A02090W|橡胶轮胎外胎
A02090X|塑料制品
A02090Y|水泥
A02090Z|平板玻璃
A020910|钢化玻璃
A020911|夹层玻璃
A020912|中空玻璃
A020913|生铁
A020914|粗钢
A020915|钢材
A020916|钢筋
A020917|线材（盘条）
A020918|冷轧薄板
A020919|中厚宽钢带
A02091A|焊接钢管
A02091B|铁合金
A02091C|氧化铝
A02091D|十种有色金属
A02091E|精炼铜（电解铜）
A02091F|铅
A02091G|锌
A02091H|原铝（电解铝）
A02091I|铝合金
A02091J|铜材
A02091K|铝材
A02091L|金属集装箱
A02091M|工业锅炉
A02091N|发动机
A02091O|金属切削机床
A02091P|金属成形机床
A02091Q|电梯、自动扶梯及升降机
A02091R|电动手提式工具
A02091S|包装专用设备
A02091T|复印和胶版印制设备
A02092T|挖掘铲土运输机械
A02091U|挖掘机
A02091V|水泥专用设备
A02091W|金属冶炼设备
A02091X|饲料生产专用设备
A02091Y|大型拖拉机
A02091Z|中型拖拉机
A020920|小型拖拉机
A020921|大气污染防治设备
A020922|工业机器人
A02092U|服务机器人
A020923|汽车
A020924|基本型乘用车（轿车）
A020925|运动型多用途乘用车（SUV）
A020926|载货汽车
A020927|铁路机车
A020928|动车组
A020929|民用钢质船舶
A02092A|发电机组（发电设备）
A02092B|交流电动机
A02092C|光缆
A02092D|锂离子电池
A02092E|太阳能电池（光伏电池）
A02092F|家用电冰箱（家用冷冻冷藏箱）
A02092G|家用冷柜（家用冷冻箱）
A02092H|房间空气调节器
A02092I|家用洗衣机
A02092J|电子计算机整机
A02092K|微型计算机设备
A02092L|程控交换机
A02092M|移动通信基站设备
A02092N|传真机
A02092O|移动通信手持机（手机）
A02092P|彩色电视机
A02092Q|集成电路
A02092R|光电子器件
A02092V|智能手表
A02092S|电工仪器仪表
A020A|工业企业主要经济指标
A020B|国有工业企业主要经济指标
A020C|集体工业企业主要经济指标
A020D|股份合作工业企业主要经济指标
A020E|股份制工业企业主要经济指标
A020F|外商及港澳台投资工业企业主要经济指标
A020G|其它工业企业主要经济指标
A020H|国有控股工业企业主要经济指标
A020I|大中型工业企业主要经济指标
A020J|大中型国有控股工业企业主要经济指标
A020K|私营工业企业主要经济指标
A020L|按行业分工业企业主要经济指标(2001-2002)
A020L01|工业企业单位数
A020L02|工业亏损企业单位数
A020L03|工业企业流动资产平均余额
A020L04|工业企业应收账款
A020L05|工业企业产成品存货
A020L06|工业企业资产总计
A020L07|工业企业负债合计
A020L08|工业企业主营业务收入
A020L09|工业企业主营业务成本
A020L0A|工业企业主营业务税金及附加
A020L0B|工业企业营业费用
A020L0C|工业企业管理费用
A020L0D|工业企业财务费用
A020L0E|工业企业利息净支出
A020L0F|工业企业利润总额
A020L0G|工业亏损企业亏损总额
A020L0H|工业企业应交增值税
A020M|按行业分工业企业主要经济指标(2003-2011)
A020M01|工业企业单位数
A020M02|工业亏损企业单位数
A020M03|工业企业流动资产平均余额
A020M04|工业企业应收账款
A020M05|工业企业产成品存货
A020M06|工业企业资产总计
A020M07|工业企业负债合计
A020M08|工业企业主营业务收入
A020M09|工业企业主营业务成本
A020M0A|工业企业主营业务税金及附加
A020M0B|工业企业营业费用
A020M0C|工业企业管理费用
A020M0D|工业企业财务费用
A020M0E|工业企业利息净支出
A020M0F|工业企业利润总额
A020M0G|工业企业亏损企业亏损总额
A020M0H|工业企业应交增值税
A020N|按行业分工业企业主要经济指标(2012-2017)
A020N01|工业企业单位数
A020N02|工业亏损企业单位数
A020N03|工业企业流动资产合计
A020N04|工业企业应收账款
A020N05|工业企业存货
A020N06|工业企业产成品存货
A020N07|工业企业资产总计
A020N08|工业企业负债合计
A020N09|工业企业营业收入
A020N0A|工业企业主营业务收入
A020N0B|工业企业营业成本
A020N0C|工业企业主营业务成本
A020N0D|工业企业主营业务税金及附加
A020N0E|工业企业销售费用
A020N0F|工业企业管理费用
A020N0G|工业企业财务费用
A020N0H|工业企业利息支出
A020N0I|工业企业利润总额
A020N0J|工业亏损企业亏损总额
A020N0K|工业企业应交增值税
A020O|按行业分工业企业主要经济指标(2018-至今)
A020O01|工业企业单位数
A020O02|工业亏损企业单位数
A020O03|工业企业流动资产合计
A020O0N|工业企业应收票据及应收账款
A020O04|工业企业应收账款
A020O05|工业企业存货
A020O06|工业企业产成品存货
A020O07|工业企业资产总计
A020O08|工业企业负债合计
A020O0P|工业企业所有者权益合计
A020O09|工业企业营业收入
A020O0A|工业企业主营业务收入
A020O0B|工业企业营业成本
A020O0C|工业企业主营业务成本
A020O0D|工业企业主营业务税金及附加
A020O0E|工业企业销售费用
A020O0F|工业企业管理费用
A020O0G|工业企业财务费用
A020O0O|工业企业利息费用
A020O0H|工业企业利息支出
A020O0I|工业企业投资收益
A020O0J|工业企业营业利润
A020O0K|工业企业利润总额
A020O0L|工业亏损企业亏损总额
A020O0M|工业企业应交增值税
A020O0Q|工业企业平均用工人数
A03|能源
A0301|能源主要产品产量
A030101|原煤
A030102|原油
A030103|天然气
A030104|煤层气
A030105|液化天然气
A030106|原油加工量
A030107|汽油
A030108|煤油
A030109|柴油
A03010A|燃料油
A03010B|石脑油
A03010C|液化石油气
A03010D|石油焦
A03010E|石油沥青
A03010F|焦炭
A03010G|发电量
A03010H|火力发电量
A03010I|水力发电量
A03010J|核能发电量
A03010K|风力发电量
A03010L|太阳能发电量
A03010M|煤气
A04|固定资产投资(不含农户)
A0401|固定资产投资概况
A0402|固定资产投资增速
A0403|按行业分固定资产投资增速（2018-）
A0404|按登记注册类型分固定资产投资增速
A0405|按行业分民间固定资产投资增速
A0406|固定资产投资(不含农户)资金来源增速情况
A0407|分行业固定资产投资情况(2012-2017)
A0408|分行业固定资产投资情况(2004-2011)
A0409|按行业分固定资产投资情况(1998-2003)
A040A|固定资产投资项目计划总投资增长情况
A05|服务业生产指数
A0501|服务业生产指数
A0E|城镇调查失业率
A0E01|城镇调查失业率
A06|房地产
A0601|房地产开发投资情况
A0602|房地产开发投资实际到位资金
A0603|房地产土地开发与销售情况
A0604|房地产施工、竣工面积
A0605|商品住宅施工、竣工面积
A0606|办公楼施工、竣工面积
A0607|商业营业用房施工、竣工面积
A0608|商品房销售面积
A0609|商品房销售额
A060A|商品住宅销售面积
A060B|商品住宅销售额
A060C|办公楼销售面积
A060D|办公楼销售额
A060E|商业营业用房销售面积
A060F|商业营业用房销售额
A07|国内贸易
A0701|社会消费品零售总额
A0702|按经营地分社会消费品零售总额
A0703|按消费类型分社会消费品零售总额
A0704|限上单位商品零售类值
A070401|粮油、食品、饮料、烟酒类
A070402|服装鞋帽、针、纺织品类
A070403|化妆品类
A070404|金银珠宝类
A070405|日用品类
A070406|体育、娱乐用品类
A070407|书报杂志类
A070408|家用电器和音像器材类
A070409|中西药品类
A07040A|文化办公用品类
A07040B|家具类
A07040C|通讯器材类
A07040D|石油及制品类
A07040E|建筑及装潢材料类
A07040F|汽车类
A07040G|其他
A0705|限额以上住宿和餐饮业经营情况(-2009)
A0706|网上零售额
A08|对外经济
A0801|进出口总额
A0802|外商直接投资
A09|交通运输
A0901|货物运输量
A0902|货物周转量
A0903|旅客运输量
A0904|旅客周转量
A0905|规模以上港口吞吐量（2005-2018）
A0906|全国港口货物吞吐量（2019-）
A0A|邮电通信
A0A01|邮电业务总量
A0A02|邮电业务收入
A0A03|邮政业务量
A0A04|电信业务量
A0A05|软件业务收入
A0B|采购经理指数
A0B01|制造业采购经理指数
A0B02|非制造业采购经理指数
A0B03|综合PMI产出指数
A0C|财政
A0C01|国家财政预算收入
A0C02|国家财政预算支出
A0D|金融
A0D01|货币供应量
