# Copyright (c) 2017-2021 Digital Asset (Switzerland) GmbH and/or its affiliates. All rights reserved.
# SPDX-License-Identifier: Apache-2.0
# fmt: off
# isort: skip_file

import builtins as _builtins, sys, typing as _typing

from google.protobuf.internal.containers import RepeatedCompositeFieldContainer
from google.protobuf.message import Message as _Message
from google.protobuf.timestamp_pb2 import Timestamp

if sys.version_info >= (3, 8):
    from typing import Literal as _L
else:
    from typing_extensions import Literal as _L

__all__ = [
    "ListKnownPackagesRequest",
    "ListKnownPackagesResponse",
    "PackageDetails",
    "UploadDarFileRequest",
    "UploadDarFileResponse",
]


class ListKnownPackagesRequest(_Message):
    def __init__(self): ...
    def HasField(self, field_name: _typing.NoReturn) -> _typing.NoReturn: ...
    def ClearField(self, field_name: _typing.NoReturn) -> _typing.NoReturn: ...
    def WhichOneof(self, oneof_group: _typing.NoReturn) -> _typing.NoReturn: ...

class ListKnownPackagesResponse(_Message):
    @property
    def package_details(self) -> RepeatedCompositeFieldContainer[PackageDetails]: ...
    def __init__(self, *, package_details: _typing.Optional[_typing.Iterable[PackageDetails]] = ...): ...
    def HasField(self, field_name: _L["package_details"]) -> _builtins.bool: ...
    def ClearField(self, field_name: _L["package_details"]) -> None: ...
    def WhichOneof(self, oneof_group: _typing.NoReturn) -> _typing.NoReturn: ...

class PackageDetails(_Message):
    package_id: _builtins.str
    package_size: _builtins.int
    @property
    def known_since(self) -> Timestamp: ...
    source_description: _builtins.str
    def __init__(self, *, package_id: _typing.Optional[_builtins.str] = ..., package_size: _typing.Optional[_builtins.int] = ..., known_since: _typing.Optional[Timestamp] = ..., source_description: _typing.Optional[_builtins.str] = ...): ...
    def HasField(self, field_name: _L["package_id", "package_size", "known_since", "source_description"]) -> _builtins.bool: ...
    def ClearField(self, field_name: _L["package_id", "package_size", "known_since", "source_description"]) -> None: ...
    def WhichOneof(self, oneof_group: _typing.NoReturn) -> _typing.NoReturn: ...

class UploadDarFileRequest(_Message):
    dar_file: _builtins.bytes
    submission_id: _builtins.str
    def __init__(self, *, dar_file: _typing.Optional[_builtins.bytes] = ..., submission_id: _typing.Optional[_builtins.str] = ...): ...
    def HasField(self, field_name: _L["dar_file", "submission_id"]) -> _builtins.bool: ...
    def ClearField(self, field_name: _L["dar_file", "submission_id"]) -> None: ...
    def WhichOneof(self, oneof_group: _typing.NoReturn) -> _typing.NoReturn: ...

class UploadDarFileResponse(_Message):
    def __init__(self): ...
    def HasField(self, field_name: _typing.NoReturn) -> _typing.NoReturn: ...
    def ClearField(self, field_name: _typing.NoReturn) -> _typing.NoReturn: ...
    def WhichOneof(self, oneof_group: _typing.NoReturn) -> _typing.NoReturn: ...
