# Copyright (c) 2017-2021 Digital Asset (Switzerland) GmbH and/or its affiliates. All rights reserved.
# SPDX-License-Identifier: Apache-2.0
# fmt: off
# isort: skip_file

import builtins as _builtins, sys, typing as _typing

from google.protobuf.message import Message as _Message

from .commands_pb2 import Commands
from .transaction_pb2 import Transaction, TransactionTree

if sys.version_info >= (3, 8):
    from typing import Literal as _L
else:
    from typing_extensions import Literal as _L

__all__ = [
    "SubmitAndWaitRequest",
    "SubmitAndWaitForTransactionIdResponse",
    "SubmitAndWaitForTransactionResponse",
    "SubmitAndWaitForTransactionTreeResponse",
]


class SubmitAndWaitRequest(_Message):
    @property
    def commands(self) -> Commands: ...
    def __init__(self, *, commands: _typing.Optional[Commands] = ...): ...
    def HasField(self, field_name: _L["commands"]) -> _builtins.bool: ...
    def ClearField(self, field_name: _L["commands"]) -> None: ...
    def WhichOneof(self, oneof_group: _typing.NoReturn) -> _typing.NoReturn: ...

class SubmitAndWaitForTransactionIdResponse(_Message):
    transaction_id: _builtins.str
    def __init__(self, *, transaction_id: _typing.Optional[_builtins.str] = ...): ...
    def HasField(self, field_name: _L["transaction_id"]) -> _builtins.bool: ...
    def ClearField(self, field_name: _L["transaction_id"]) -> None: ...
    def WhichOneof(self, oneof_group: _typing.NoReturn) -> _typing.NoReturn: ...

class SubmitAndWaitForTransactionResponse(_Message):
    @property
    def transaction(self) -> Transaction: ...
    def __init__(self, *, transaction: _typing.Optional[Transaction] = ...): ...
    def HasField(self, field_name: _L["transaction"]) -> _builtins.bool: ...
    def ClearField(self, field_name: _L["transaction"]) -> None: ...
    def WhichOneof(self, oneof_group: _typing.NoReturn) -> _typing.NoReturn: ...

class SubmitAndWaitForTransactionTreeResponse(_Message):
    @property
    def transaction(self) -> TransactionTree: ...
    def __init__(self, *, transaction: _typing.Optional[TransactionTree] = ...): ...
    def HasField(self, field_name: _L["transaction"]) -> _builtins.bool: ...
    def ClearField(self, field_name: _L["transaction"]) -> None: ...
    def WhichOneof(self, oneof_group: _typing.NoReturn) -> _typing.NoReturn: ...
