# Copyright (c) 2017-2021 Digital Asset (Switzerland) GmbH and/or its affiliates. All rights reserved.
# SPDX-License-Identifier: Apache-2.0
# fmt: off
# isort: skip_file

import builtins as _builtins, sys, typing as _typing

from google.protobuf.empty_pb2 import Empty
from google.protobuf.internal.containers import RepeatedCompositeFieldContainer
from google.protobuf.message import Message as _Message

if sys.version_info >= (3, 8):
    from typing import Literal as _L
else:
    from typing_extensions import Literal as _L

__all__ = [
    "Value",
    "Record",
    "RecordField",
    "Identifier",
    "Variant",
    "Enum",
    "List",
    "Optional",
    "Map",
    "GenMap",
]


class Value(_Message):
    @property
    def record(self) -> Record: ...
    @property
    def variant(self) -> Variant: ...
    contract_id: _builtins.str
    @property
    def list(self) -> List: ...
    int64: _builtins.int
    numeric: _builtins.str
    text: _builtins.str
    timestamp: _builtins.float
    party: _builtins.str
    bool: _builtins.bool
    @property
    def unit(self) -> Empty: ...
    date: _builtins.int
    @property
    def optional(self) -> Optional: ...
    @property
    def map(self) -> Map: ...
    @property
    def enum(self) -> Enum: ...
    @property
    def gen_map(self) -> GenMap: ...
    @_typing.overload
    def __init__(self): ...
    @_typing.overload
    def __init__(self, *, record: Record = ...): ...
    @_typing.overload
    def __init__(self, *, variant: Variant = ...): ...
    @_typing.overload
    def __init__(self, *, contract_id: _builtins.str = ...): ...
    @_typing.overload
    def __init__(self, *, list: List = ...): ...
    @_typing.overload
    def __init__(self, *, int64: _builtins.int = ...): ...
    @_typing.overload
    def __init__(self, *, numeric: _builtins.str = ...): ...
    @_typing.overload
    def __init__(self, *, text: _builtins.str = ...): ...
    @_typing.overload
    def __init__(self, *, timestamp: _builtins.float = ...): ...
    @_typing.overload
    def __init__(self, *, party: _builtins.str = ...): ...
    @_typing.overload
    def __init__(self, *, bool: _builtins.bool = ...): ...
    @_typing.overload
    def __init__(self, *, unit: Empty = ...): ...
    @_typing.overload
    def __init__(self, *, date: _builtins.int = ...): ...
    @_typing.overload
    def __init__(self, *, optional: Optional = ...): ...
    @_typing.overload
    def __init__(self, *, map: Map = ...): ...
    @_typing.overload
    def __init__(self, *, enum: Enum = ...): ...
    @_typing.overload
    def __init__(self, *, gen_map: GenMap = ...): ...
    def HasField(self, field_name: _L["Sum", "record", "variant", "contract_id", "list", "int64", "numeric", "text", "timestamp", "party", "bool", "unit", "date", "optional", "map", "enum", "gen_map"]) -> _builtins.bool: ...
    def ClearField(self, field_name: _L["Sum", "record", "variant", "contract_id", "list", "int64", "numeric", "text", "timestamp", "party", "bool", "unit", "date", "optional", "map", "enum", "gen_map"]) -> None: ...
    def WhichOneof(self, oneof_group: _L["Sum"]) -> _L[None, "record", "variant", "contract_id", "list", "int64", "numeric", "text", "timestamp", "party", "bool", "unit", "date", "optional", "map", "enum", "gen_map"]: ...

class Record(_Message):
    @property
    def record_id(self) -> Identifier: ...
    @property
    def fields(self) -> RepeatedCompositeFieldContainer[RecordField]: ...
    def __init__(self, *, record_id: _typing.Optional[Identifier] = ..., fields: _typing.Optional[_typing.Iterable[RecordField]] = ...): ...
    def HasField(self, field_name: _L["record_id", "fields"]) -> _builtins.bool: ...
    def ClearField(self, field_name: _L["record_id", "fields"]) -> None: ...
    def WhichOneof(self, oneof_group: _typing.NoReturn) -> _typing.NoReturn: ...

class RecordField(_Message):
    label: _builtins.str
    @property
    def value(self) -> Value: ...
    def __init__(self, *, label: _typing.Optional[_builtins.str] = ..., value: _typing.Optional[Value] = ...): ...
    def HasField(self, field_name: _L["label", "value"]) -> _builtins.bool: ...
    def ClearField(self, field_name: _L["label", "value"]) -> None: ...
    def WhichOneof(self, oneof_group: _typing.NoReturn) -> _typing.NoReturn: ...

class Identifier(_Message):
    package_id: _builtins.str
    module_name: _builtins.str
    entity_name: _builtins.str
    def __init__(self, *, package_id: _typing.Optional[_builtins.str] = ..., module_name: _typing.Optional[_builtins.str] = ..., entity_name: _typing.Optional[_builtins.str] = ...): ...
    def HasField(self, field_name: _L["package_id", "module_name", "entity_name"]) -> _builtins.bool: ...
    def ClearField(self, field_name: _L["package_id", "module_name", "entity_name"]) -> None: ...
    def WhichOneof(self, oneof_group: _typing.NoReturn) -> _typing.NoReturn: ...

class Variant(_Message):
    @property
    def variant_id(self) -> Identifier: ...
    constructor: _builtins.str
    @property
    def value(self) -> Value: ...
    def __init__(self, *, variant_id: _typing.Optional[Identifier] = ..., constructor: _typing.Optional[_builtins.str] = ..., value: _typing.Optional[Value] = ...): ...
    def HasField(self, field_name: _L["variant_id", "constructor", "value"]) -> _builtins.bool: ...
    def ClearField(self, field_name: _L["variant_id", "constructor", "value"]) -> None: ...
    def WhichOneof(self, oneof_group: _typing.NoReturn) -> _typing.NoReturn: ...

class Enum(_Message):
    @property
    def enum_id(self) -> Identifier: ...
    constructor: _builtins.str
    def __init__(self, *, enum_id: _typing.Optional[Identifier] = ..., constructor: _typing.Optional[_builtins.str] = ...): ...
    def HasField(self, field_name: _L["enum_id", "constructor"]) -> _builtins.bool: ...
    def ClearField(self, field_name: _L["enum_id", "constructor"]) -> None: ...
    def WhichOneof(self, oneof_group: _typing.NoReturn) -> _typing.NoReturn: ...

class List(_Message):
    @property
    def elements(self) -> RepeatedCompositeFieldContainer[Value]: ...
    def __init__(self, *, elements: _typing.Optional[_typing.Iterable[Value]] = ...): ...
    def HasField(self, field_name: _L["elements"]) -> _builtins.bool: ...
    def ClearField(self, field_name: _L["elements"]) -> None: ...
    def WhichOneof(self, oneof_group: _typing.NoReturn) -> _typing.NoReturn: ...

class Optional(_Message):
    @property
    def value(self) -> Value: ...
    def __init__(self, *, value: _typing.Optional[Value] = ...): ...
    def HasField(self, field_name: _L["value"]) -> _builtins.bool: ...
    def ClearField(self, field_name: _L["value"]) -> None: ...
    def WhichOneof(self, oneof_group: _typing.NoReturn) -> _typing.NoReturn: ...

class Map(_Message):
    
    class Entry(_Message):
        key: _builtins.str
        @property
        def value(self) -> Value: ...
        def __init__(self, *, key: _typing.Optional[_builtins.str] = ..., value: _typing.Optional[Value] = ...): ...
        def HasField(self, field_name: _L["key", "value"]) -> _builtins.bool: ...
        def ClearField(self, field_name: _L["key", "value"]) -> None: ...
        def WhichOneof(self, oneof_group: _typing.NoReturn) -> _typing.NoReturn: ...
    @property
    def entries(self) -> RepeatedCompositeFieldContainer[Map.Entry]: ...
    def __init__(self, *, entries: _typing.Optional[_typing.Iterable[Map.Entry]] = ...): ...
    def HasField(self, field_name: _L["entries"]) -> _builtins.bool: ...
    def ClearField(self, field_name: _L["entries"]) -> None: ...
    def WhichOneof(self, oneof_group: _typing.NoReturn) -> _typing.NoReturn: ...

class GenMap(_Message):
    
    class Entry(_Message):
        @property
        def key(self) -> Value: ...
        @property
        def value(self) -> Value: ...
        def __init__(self, *, key: _typing.Optional[Value] = ..., value: _typing.Optional[Value] = ...): ...
        def HasField(self, field_name: _L["key", "value"]) -> _builtins.bool: ...
        def ClearField(self, field_name: _L["key", "value"]) -> None: ...
        def WhichOneof(self, oneof_group: _typing.NoReturn) -> _typing.NoReturn: ...
    @property
    def entries(self) -> RepeatedCompositeFieldContainer[GenMap.Entry]: ...
    def __init__(self, *, entries: _typing.Optional[_typing.Iterable[GenMap.Entry]] = ...): ...
    def HasField(self, field_name: _L["entries"]) -> _builtins.bool: ...
    def ClearField(self, field_name: _L["entries"]) -> None: ...
    def WhichOneof(self, oneof_group: _typing.NoReturn) -> _typing.NoReturn: ...
