from ctypes import c_int, c_char_p

from .lib import lib

MagicRequestType = c_int

MAGIC_REQUEST_NONE = 0

MAGIC_REQUEST_STORE_REGISTER = 1
MAGIC_REQUEST_STORE_UNREGISTER = 2
MAGIC_REQUEST_STORE_STATUS = 3
MAGIC_REQUEST_STORE_OPEN = 4
MAGIC_REQUEST_STORE_CLOSE = 5
MAGIC_REQUEST_STORE_DISABLE = 6
MAGIC_REQUEST_STORE_INFO = 7
MAGIC_REQUEST_STORE_STATS = 8
MAGIC_REQUEST_STORE_STREAM_UPDATE = 9
MAGIC_REQUEST_STORE_STREAM_FRAME = 10
MAGIC_REQUEST_STORE_ADD_CLIENT = 11
MAGIC_REQUEST_STORE_RMV_CLIENT = 12
MAGIC_REQUEST_STORE_ACCESS = 13
MAGIC_REQUEST_STORE_EXIT = 14

MAGIC_REQUEST_FRAME = 21
MAGIC_REQUEST_MOVEMENT_START = 22
MAGIC_REQUEST_MOVEMENT_END = 23

MAGIC_REQUEST_HUMANS_COUNT = 32
MAGIC_REQUEST_HANDS_COORDS = 33
MAGIC_REQUEST_FACE_COORDS = 34
MAGIC_REQUEST_POSE_STREAM = 41
MAGIC_REQUEST_POSE_OUTPUT = 42
MAGIC_REQUEST_RECON_OUTPUT = 43
MAGIC_REQUEST_FACE_OUTPUT = 44
MAGIC_REQUEST_ACTIONS_OUTPUT = 44

MAGIC_REQUEST_CLIENT_STATUS = 51
MAGIC_REQUEST_CLIENT_CART = 52
MAGIC_REQUEST_CLIENT_CART_HISTORY = 53
MAGIC_REQUEST_CLIENT_ADD_PRODUCT = 54
MAGIC_REQUEST_CLIENT_RMV_PRODUCT = 55

MAGIC_REQUEST_TEST = 100
MAGIC_REQUEST_TEST_MSG = 101

magic_request_type_to_string = lib.magic_request_type_to_string
magic_request_type_to_string.argtypes = [MagicRequestType]
magic_request_type_to_string.restype = c_char_p

magic_request_type_description = lib.magic_request_type_description
magic_request_type_description.argtypes = [MagicRequestType]
magic_request_type_description.restype = c_char_p
