#### 常规消息推送（SignalR：http://ip:port/pushhub）

1. ###### 细则执行
   
   （1）基本信息：ReceiveRegulationJob(RegulationJob job)
   
   ```json
   //参数 RegulationJob
   {
       "id": "071f113d-d24c-4789-945a-b5f33e39a55e",
       "user": "user@127.0.0.1:63909",
       "name":"/某分系统/某细则文件.xml",
       "startTime": 1700730399056, //ms utc 时间戳
       "endTime": 1700730421416, //ms utc 时间戳
       "progress": "5/18",
       "status": "Canceled", //Ready[0],Running[1],Suspended[2],Successed[3],Failed[4],Canceled[5]
       "isJudge": false,
       "ignoreJudgeFailure": false,
       "loop": "1/2",
       "isSecret": false,
       "regulationId": "EA1A3B7A-E0B5-4267-AA8F-F3E69DDD99FD",
       "regulationVersion": "1.2",
       "test": "某测试项",
       "testId": "D819C392-7A57-4B00-AB84-1B6B0992EF85",
       "commandChain": [
           {
               "id": "0405998B-C270-4A80-967A-78C6AB1D67B8",
               "version": "2.2"
           },
           {
               "id": "0405998B-C270-4A80-967A-78C6AB1D67B8",
               "version": "2.2"
           }
       ]
   }
   ```
   
   （2）任务进度状态：ReceiveRegulationJobProgress(...)
   
   | 参数        | 类型     |                                                                                              |
   | --------- | ------ | -------------------------------------------------------------------------------------------- |
   | id        | string | 任务 ID                                                                                        |
   | status    | 枚举     | Ready[0]<br/>Running[1]<br/>Suspended[2]<br/>Successed[3]<br/>Failed[4]<br/>Canceled[5]<br/> |
   | loopIndex | int    | 当前指令链正处于第 loopIndex 次执行                                                                      |
   | progress  | string | 包含所有指令链，整个执行序列的进度                                                                            |
   | value（可空） | string | status 为 Failed 或 Canceled 时的原因描述                                                            |
   
   （3）判读结果：ReceiveRegulationJobCommandJudgeResult(...)
   
   | 参数           | 类型                                                                                                     |                                                               |
   | ------------ | ------------------------------------------------------------------------------------------------------ | ------------------------------------------------------------- |
   | id           | string                                                                                                 |                                                               |
   | loopIndex    | int                                                                                                    | 当前指令正处于第 loopIndex 次执行                                        |
   | runningIndex | int                                                                                                    | 正在执行的项（command/judge/popup/wait/variable）的索引，基于当前所有指令链中的所有执行项 |
   | result       | {<br/>"BaseJudgeResult":"Success",<br/>"DiffJudgeResult":"Failed",<br/>"ParamJudgeResult":"None"<br/>} | 判据结果<br/>None[0]/Success[1]/Failed[2]                         |
   
   （4）指令链进度状态：ReceiveRegulationJobCommandChainProgress(...)

| 参数           | 类型                     |                                                                                                                                                                                                                                                                                                                                                                                                                                         |
| ------------ | ---------------------- | --------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- |
| id           | string                 | 任务 ID                                                                                                                                                                                                                                                                                                                                                                                                                                   |
| loopIndex    | int                    | 当前指令正处于第 loopIndex 次执行                                                                                                                                                                                                                                                                                                                                                                                                                  |
| runningIndex | int                    | 正在执行的项（command/judge/popup/wait/variable）的索引，基于当前所有指令链中的所有执行项                                                                                                                                                                                                                                                                                                                                                                           |
| type         | 枚举                     | Command[0]<br/>Judge[1]<br/>Popup[2]<br/>Wait[3]<br/>Variable[4]<br/>                                                                                                                                                                                                                                                                                                                                                                   |
| status       | 枚举                     | Running[1]<br/>Successed[3]<br/>Failed[4]<br/>Canceled[5]<br/>                                                                                                                                                                                                                                                                                                                                                                          |
| value（可空）    | 不定,根据 type 与 status 决定 | **Running**<br/>（1）Wait：double（等待时长）<br/>（2）Popup：string（消息内容）<br/>（3）Command：string（同一指令执行多次的进度）<br/>（4）Judge：空<br/>（5）Variable：空<br/>**Successed**<br/>（1）Wait：空<br/>（2）Popup：空<br/>（3）Command：string（进度）<br/>（4）Judge：Success<br/>（枚举：None[0]/Success[1]/Failed[2]）<br/>（5）Variable：{"name":"","value":""}<br/>**Failed**<br/>（1）Judge：Failed<br/>（枚举：None[0]/Success[1]/Failed[2]）<br/>（2）其他：string（失败原因）或空<br/>**Canceled**：空<br/> |
| confirm（可空）  | 枚举                     | StopContinue[0]<br/>RetryStop[1]<br/>RetryIgnoreStop[2]<br/>通过 api/v1/job/manage 接口执行 stop[2],retry[3],ignore[4],continue[5]                                                                                                                                                                                                                                                                                                            |
