# akeyless-uam-api
UAM manages client accounts and allows each client to define items, roles and auth methods. The core operations of UAM are as follows: Creating new accounts. For each account: Creating items. Adding new auth methods Adding new roles creating roles - auth methods association. Returning the key's metadata together with temporary access credentials in order to access the key fragments.

This Python package is automatically generated by the [Swagger Codegen](https://github.com/swagger-api/swagger-codegen) project:

- API version: 0.1.0
- Package version: 0.1.1
- Build package: io.swagger.codegen.languages.PythonClientCodegen
For more information, please visit [https://www.akeyless-security.com](https://www.akeyless-security.com)

## Requirements.

Python 2.7 and 3.4+

## Installation & Usage
### pip install

If the python package is hosted on Github, you can install directly from Github

```sh
pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git
```
(you may need to run `pip` with root permission: `sudo pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git`)

Then import the package:
```python
import akeyless_uam_api 
```

### Setuptools

Install via [Setuptools](http://pypi.python.org/pypi/setuptools).

```sh
python setup.py install --user
```
(or `sudo python setup.py install` to install the package for all users)

Then import the package:
```python
import akeyless_uam_api
```

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```python
from __future__ import print_function
import time
import akeyless_uam_api
from akeyless_uam_api.rest import ApiException
from pprint import pprint

# create an instance of the API class
api_instance = akeyless_uam_api.DefaultApi(akeyless_uam_api.ApiClient(configuration))
access_id = 'access_id_example' # str | Access id.
akeyless_request_id = 'akeyless_request_id_example' # str | Request Id for logging (optional)
akeyless_client_id = 'akeyless_client_id_example' # str | Client Id for logging (optional)
timestamp = 789 # int | A Unix timestamp which was used for the signature (relevant only in case of api key access). (optional)
nonce = 'nonce_example' # str | Random string which was used for the signature (relevant only in case of api key access authentication). (optional)
signature = 'signature_example' # str | A digital signature generated with the private key that complies with the access authentication (relevant only in case of api key access authentication). (optional)
access_token = 'access_token_example' # str | An access token as a signed JSON Web Toke (relevant only in case of azure-az/oauth2 access authentication). (optional)
client_ip = 'client_ip_example' # str | The Client's IP for authentication. Relevant only in case of the services that mediate between Auth and their clients in obtaining temporary access credentials. (optional)
creds_expiry = 60 # int | The requested expiration time of the temporary credentials in minutes. (optional) (default to 60)

try:
    # Return a temporary access credentials
    api_response = api_instance.authenticate(access_id, akeyless_request_id=akeyless_request_id, akeyless_client_id=akeyless_client_id, timestamp=timestamp, nonce=nonce, signature=signature, access_token=access_token, client_ip=client_ip, creds_expiry=creds_expiry)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling DefaultApi->authenticate: %s\n" % e)

```

## Documentation for API Endpoints

All URIs are relative to *https://$HOST*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*DefaultApi* | [**authenticate**](docs/DefaultApi.md#authenticate) | **POST** /auth | Return a temporary access credentials
*DefaultApi* | [**authenticate_uam**](docs/DefaultApi.md#authenticate_uam) | **POST** /auth-uam | Return a combination of three temporary access credentials for accessing Auth, UAM and KFMs instances.
*DefaultApi* | [**create_access**](docs/DefaultApi.md#create_access) | **POST** /access | Creating a new access.
*DefaultApi* | [**create_account**](docs/DefaultApi.md#create_account) | **POST** /account | Create new account.
*DefaultApi* | [**create_account_creds**](docs/DefaultApi.md#create_account_creds) | **POST** /create-account-creds | Getting temporary access credentials to create new account in the UAM service. The UAM service will use this credentials to create an access to be used for accessing the account
*DefaultApi* | [**create_auth_method**](docs/DefaultApi.md#create_auth_method) | **POST** /auth-method | Add a new auth method to the account.
*DefaultApi* | [**create_item**](docs/DefaultApi.md#create_item) | **POST** /item | Add a new item to the account.
*DefaultApi* | [**create_role**](docs/DefaultApi.md#create_role) | **POST** /role | Add a new role to the account.
*DefaultApi* | [**create_role_auth_method_assoc**](docs/DefaultApi.md#create_role_auth_method_assoc) | **POST** /role-auth-method-assoc | Add an association between a role and an auth method.
*DefaultApi* | [**delete_access**](docs/DefaultApi.md#delete_access) | **DELETE** /access/{access_id} | Deleting an existing access.
*DefaultApi* | [**delete_auth_method**](docs/DefaultApi.md#delete_auth_method) | **DELETE** /auth-method/{auth_method_name} | Deleting an existing auth method from the account.
*DefaultApi* | [**delete_item**](docs/DefaultApi.md#delete_item) | **DELETE** /item | Deleting an existing item from the account.
*DefaultApi* | [**delete_role**](docs/DefaultApi.md#delete_role) | **DELETE** /role/{role_name} | Deleting an existing role from the account.
*DefaultApi* | [**delete_role_auth_method_assoc**](docs/DefaultApi.md#delete_role_auth_method_assoc) | **DELETE** /role-auth-method-assoc | Deleting an association between a role and an auth method.
*DefaultApi* | [**get_access**](docs/DefaultApi.md#get_access) | **GET** /access/{access_id} | Getting an existing access.
*DefaultApi* | [**get_accesses**](docs/DefaultApi.md#get_accesses) | **GET** /accesses | Geting a list of accesses
*DefaultApi* | [**get_account_auth_methods**](docs/DefaultApi.md#get_account_auth_methods) | **GET** /auth-methods | Get All the existing auth methods in the account.
*DefaultApi* | [**get_account_details**](docs/DefaultApi.md#get_account_details) | **GET** /account/ | Get account details.
*DefaultApi* | [**get_account_roles**](docs/DefaultApi.md#get_account_roles) | **GET** /roles | Get All the existing roles in the account.
*DefaultApi* | [**get_auth_method**](docs/DefaultApi.md#get_auth_method) | **GET** /auth-method/{auth_method_name} | Get auth method details.
*DefaultApi* | [**get_auth_status**](docs/DefaultApi.md#get_auth_status) | **GET** /auth-status | 
*DefaultApi* | [**get_dynamic_secret_mq_access**](docs/DefaultApi.md#get_dynamic_secret_mq_access) | **GET** /dynamic-secret-mq-access | Get a signed request to receive messages from a Message Queue of a Dynamic Secret.
*DefaultApi* | [**get_dynamic_secret_producer_creds**](docs/DefaultApi.md#get_dynamic_secret_producer_creds) | **GET** /dynamic-secret-producer-cred | Get a dynamic secret producer derivation credentials.
*DefaultApi* | [**get_item**](docs/DefaultApi.md#get_item) | **GET** /item | Get item details.
*DefaultApi* | [**get_item_derivation_creds**](docs/DefaultApi.md#get_item_derivation_creds) | **GET** /derivation-creds | Get temporary access credentials to KFM instances for item&#39;s fragments derivation.
*DefaultApi* | [**get_public_signing_key**](docs/DefaultApi.md#get_public_signing_key) | **GET** /public-signing-key/{signing_key_id} | Getting the public part of the key used by Auth to sign the temporary access credentials.
*DefaultApi* | [**get_role**](docs/DefaultApi.md#get_role) | **GET** /role/{role_name} | Get role details.
*DefaultApi* | [**get_rsa_key_decrypt_creds**](docs/DefaultApi.md#get_rsa_key_decrypt_creds) | **GET** /rsa-decrypt-creds | Get temporary access credentials to KFM instances for RSA key fragments decryption.
*DefaultApi* | [**get_secret_access_creds**](docs/DefaultApi.md#get_secret_access_creds) | **GET** /secret-access-creds | 
*DefaultApi* | [**get_ssh_cert_issuer_access_creds**](docs/DefaultApi.md#get_ssh_cert_issuer_access_creds) | **GET** /ssh-cert-issuer-access-creds | Get temporary access credentials to KFM instances for signing a specific SSH certificate.
*DefaultApi* | [**get_status**](docs/DefaultApi.md#get_status) | **GET** /status | 
*DefaultApi* | [**get_time**](docs/DefaultApi.md#get_time) | **GET** /time | 
*DefaultApi* | [**get_upload_rsa_key_creds**](docs/DefaultApi.md#get_upload_rsa_key_creds) | **GET** /upload-rsa-key-creds | Get temporary access credentials to upload RSA private key fragments into KFMs instances.
*DefaultApi* | [**get_upload_secret_creds**](docs/DefaultApi.md#get_upload_secret_creds) | **GET** /upload-secret-creds | Get temporary access credentials to KFM instances to produce the derived protection key of the secret.
*DefaultApi* | [**list_items**](docs/DefaultApi.md#list_items) | **GET** /items | List all the accessible items.
*DefaultApi* | [**list_items_in_path**](docs/DefaultApi.md#list_items_in_path) | **GET** /items-in-path | List items at the given path.
*DefaultApi* | [**prepare_dynamic_secret_value**](docs/DefaultApi.md#prepare_dynamic_secret_value) | **GET** /prepare-dynamic-secret-value | Get the new dynamic secret ID to be pull and derivation credentials to decrypt the new dynamic secret value.
*DefaultApi* | [**pull_dynamic_secret_value**](docs/DefaultApi.md#pull_dynamic_secret_value) | **POST** /pull-dynamic-secret-value | Pull a new dynamic secret value on demand.
*DefaultApi* | [**push_dynamic_secret_value**](docs/DefaultApi.md#push_dynamic_secret_value) | **POST** /push-dynamic-secret-value | Push a new dynamic secret value on demand.
*DefaultApi* | [**reset_access_key**](docs/DefaultApi.md#reset_access_key) | **GET** /reset-access-key | Getting a validation number to reset an admin account&#39;s access key.
*DefaultApi* | [**reset_access_key_0**](docs/DefaultApi.md#reset_access_key_0) | **PUT** /reset-access-key | Getting temporary access credentials to reset an account&#39;s access key. The UAM service will use these credentials to update the account&#39;s api key auth method.
*DefaultApi* | [**reset_admin_account_access_key**](docs/DefaultApi.md#reset_admin_account_access_key) | **PUT** /reset-admin-account-access-key | Reset admin account access key.
*DefaultApi* | [**set_uam_access_creds**](docs/DefaultApi.md#set_uam_access_creds) | **POST** /set-uam-access-creds | Getting temporary access credentials to add a new access or to update an existing access in an UAM account. The UAM service will use this credentials to create/update an access to be used for accessing key fragments.
*DefaultApi* | [**update_access**](docs/DefaultApi.md#update_access) | **PUT** /access/{access_id} | Updating an existing access
*DefaultApi* | [**update_auth_method**](docs/DefaultApi.md#update_auth_method) | **PUT** /auth-method/{auth_method_name} | Updating an existing auth method in the account
*DefaultApi* | [**update_item**](docs/DefaultApi.md#update_item) | **PUT** /item | 
*DefaultApi* | [**update_role**](docs/DefaultApi.md#update_role) | **PUT** /role/{role_name} | Updating an existing role in the account
*DefaultApi* | [**validate_account**](docs/DefaultApi.md#validate_account) | **GET** /account-validation | Request new validation number.
*DefaultApi* | [**validate_account_0**](docs/DefaultApi.md#validate_account_0) | **PUT** /account-validation | Request new validation number.
*DefaultApi* | [**validate_client_credentials**](docs/DefaultApi.md#validate_client_credentials) | **POST** /validate-client-credentials | Validate client credentials


## Documentation For Models

 - [APIKeyAccessRules](docs/APIKeyAccessRules.md)
 - [AccessParams](docs/AccessParams.md)
 - [AccessRules](docs/AccessRules.md)
 - [AccessRulesType](docs/AccessRulesType.md)
 - [AccessType](docs/AccessType.md)
 - [AccountReplyObj](docs/AccountReplyObj.md)
 - [AccountStatus](docs/AccountStatus.md)
 - [Algorithm](docs/Algorithm.md)
 - [AuthMethodAccessInfo](docs/AuthMethodAccessInfo.md)
 - [AuthMethodRoleAssociation](docs/AuthMethodRoleAssociation.md)
 - [AuthStatusReplyObj](docs/AuthStatusReplyObj.md)
 - [AzureADAccessRules](docs/AzureADAccessRules.md)
 - [CreateAccessReplyObj](docs/CreateAccessReplyObj.md)
 - [CreateAccountCredsParams](docs/CreateAccountCredsParams.md)
 - [CreateAuthMethodReplyObj](docs/CreateAuthMethodReplyObj.md)
 - [CreateRoleAuthMethodAssocReplyObj](docs/CreateRoleAuthMethodAssocReplyObj.md)
 - [CredentialsReplyObj](docs/CredentialsReplyObj.md)
 - [DerivationCredsReplyObj](docs/DerivationCredsReplyObj.md)
 - [DerivedFragmentReplyObj](docs/DerivedFragmentReplyObj.md)
 - [DynamicSecretMQAccessReplyObj](docs/DynamicSecretMQAccessReplyObj.md)
 - [DynamicSecretMessageQueueInfo](docs/DynamicSecretMessageQueueInfo.md)
 - [DynamicSecretProducerCredsReplyObj](docs/DynamicSecretProducerCredsReplyObj.md)
 - [ErrorReplyObj](docs/ErrorReplyObj.md)
 - [FragmentType](docs/FragmentType.md)
 - [FragmentsDerivationsCreds](docs/FragmentsDerivationsCreds.md)
 - [GetAccessReplyObj](docs/GetAccessReplyObj.md)
 - [GetAccessesReplyObj](docs/GetAccessesReplyObj.md)
 - [GetAccountAuthMethodsReplyObj](docs/GetAccountAuthMethodsReplyObj.md)
 - [GetAccountDetailsReplyObj](docs/GetAccountDetailsReplyObj.md)
 - [GetAccountRolesReplyObj](docs/GetAccountRolesReplyObj.md)
 - [GetAuthMethodReplyObj](docs/GetAuthMethodReplyObj.md)
 - [GetFragmentDetailsReplyObj](docs/GetFragmentDetailsReplyObj.md)
 - [GetItemReplyObj](docs/GetItemReplyObj.md)
 - [GetRoleReplyObj](docs/GetRoleReplyObj.md)
 - [KFMStatusReplyObj](docs/KFMStatusReplyObj.md)
 - [LdapAccessRules](docs/LdapAccessRules.md)
 - [ListItemsInPathReplyObj](docs/ListItemsInPathReplyObj.md)
 - [ListItemsReplyObj](docs/ListItemsReplyObj.md)
 - [OAuth2AccessRules](docs/OAuth2AccessRules.md)
 - [OAuth2CustomClaim](docs/OAuth2CustomClaim.md)
 - [PathRule](docs/PathRule.md)
 - [PrepareDynamicSecretValueReplyObj](docs/PrepareDynamicSecretValueReplyObj.md)
 - [PublicSigningKeyReplyObj](docs/PublicSigningKeyReplyObj.md)
 - [PullDynamicSecretValueReplyObj](docs/PullDynamicSecretValueReplyObj.md)
 - [RSADecryptCreds](docs/RSADecryptCreds.md)
 - [RSADecryptCredsReplyObj](docs/RSADecryptCredsReplyObj.md)
 - [RSAFragmentDecryptReplyObj](docs/RSAFragmentDecryptReplyObj.md)
 - [RoleAuthMethodAssociation](docs/RoleAuthMethodAssociation.md)
 - [Rules](docs/Rules.md)
 - [SSHCertIssuerAccessCredsReplyObj](docs/SSHCertIssuerAccessCredsReplyObj.md)
 - [SSHCertificateIssueDetails](docs/SSHCertificateIssueDetails.md)
 - [SSHCertificateParams](docs/SSHCertificateParams.md)
 - [SSHCertificateType](docs/SSHCertificateType.md)
 - [SamlAccessRules](docs/SamlAccessRules.md)
 - [SamlAttribute](docs/SamlAttribute.md)
 - [SecretAccessCredsReplyObj](docs/SecretAccessCredsReplyObj.md)
 - [SetItemRequestBodyParams](docs/SetItemRequestBodyParams.md)
 - [SetRoleRequestParams](docs/SetRoleRequestParams.md)
 - [SetUAMAccessCredsParams](docs/SetUAMAccessCredsParams.md)
 - [SystemAccessCredentialsReplyObj](docs/SystemAccessCredentialsReplyObj.md)
 - [TimeReplyObj](docs/TimeReplyObj.md)
 - [UAMStatusReplyObj](docs/UAMStatusReplyObj.md)
 - [UpdateAccessMode](docs/UpdateAccessMode.md)
 - [UploadRSAFragmentReplyObj](docs/UploadRSAFragmentReplyObj.md)
 - [UploadRSAKeyCredsReplyObj](docs/UploadRSAKeyCredsReplyObj.md)
 - [ValidateClientCredsReplyObj](docs/ValidateClientCredsReplyObj.md)


## Documentation For Authorization

 All endpoints do not require authorization.


## Author

refael@akeyless-security.com

