# coding: utf-8

"""
    UAM - Application API

    UAM manages client accounts and allows each client to define items, roles and auth methods. The core operations of UAM are as follows: Creating new accounts. For each account: Creating items. Adding new auth methods Adding new roles creating roles - auth methods association. Returning the key's metadata together with temporary access credentials in order to access the key fragments.  # noqa: E501

    OpenAPI spec version: 0.1.0
    Contact: refael@akeyless-security.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from akeyless_uam_api.api_client import ApiClient


class DefaultApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def authenticate(self, access_id, **kwargs):  # noqa: E501
        """Return a temporary access credentials  # noqa: E501

        Client that meet an access params will be able to get temporary credentials to access the service that created the access for him. The client must provide the relevant parameters that proves his compliance with the access. In this case the IP address used for authentication will be taken from the http request.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.authenticate(access_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str access_id: Access id. (required)
        :param str akeyless_request_id: Request Id for logging
        :param str akeyless_client_id: Client Id for logging
        :param int timestamp: A Unix timestamp which was used for the signature (relevant only in case of api key access).
        :param str nonce: Random string which was used for the signature (relevant only in case of api key access authentication).
        :param str signature: A digital signature generated with the private key that complies with the access authentication (relevant only in case of api key access authentication).
        :param str access_token: An access token as a signed JSON Web Toke (relevant only in case of azure-az/oauth2 access authentication).
        :param str client_ip: The Client's IP for authentication. Relevant only in case of the services that mediate between Auth and their clients in obtaining temporary access credentials.
        :param int creds_expiry: The requested expiration time of the temporary credentials in minutes.
        :return: CredentialsReplyObj
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.authenticate_with_http_info(access_id, **kwargs)  # noqa: E501
        else:
            (data) = self.authenticate_with_http_info(access_id, **kwargs)  # noqa: E501
            return data

    def authenticate_with_http_info(self, access_id, **kwargs):  # noqa: E501
        """Return a temporary access credentials  # noqa: E501

        Client that meet an access params will be able to get temporary credentials to access the service that created the access for him. The client must provide the relevant parameters that proves his compliance with the access. In this case the IP address used for authentication will be taken from the http request.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.authenticate_with_http_info(access_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str access_id: Access id. (required)
        :param str akeyless_request_id: Request Id for logging
        :param str akeyless_client_id: Client Id for logging
        :param int timestamp: A Unix timestamp which was used for the signature (relevant only in case of api key access).
        :param str nonce: Random string which was used for the signature (relevant only in case of api key access authentication).
        :param str signature: A digital signature generated with the private key that complies with the access authentication (relevant only in case of api key access authentication).
        :param str access_token: An access token as a signed JSON Web Toke (relevant only in case of azure-az/oauth2 access authentication).
        :param str client_ip: The Client's IP for authentication. Relevant only in case of the services that mediate between Auth and their clients in obtaining temporary access credentials.
        :param int creds_expiry: The requested expiration time of the temporary credentials in minutes.
        :return: CredentialsReplyObj
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['access_id', 'akeyless_request_id', 'akeyless_client_id', 'timestamp', 'nonce', 'signature', 'access_token', 'client_ip', 'creds_expiry']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method authenticate" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'access_id' is set
        if ('access_id' not in params or
                params['access_id'] is None):
            raise ValueError("Missing the required parameter `access_id` when calling `authenticate`")  # noqa: E501

        if 'creds_expiry' in params and params['creds_expiry'] > 60:  # noqa: E501
            raise ValueError("Invalid value for parameter `creds_expiry` when calling `authenticate`, must be a value less than or equal to `60`")  # noqa: E501
        if 'creds_expiry' in params and params['creds_expiry'] < 2:  # noqa: E501
            raise ValueError("Invalid value for parameter `creds_expiry` when calling `authenticate`, must be a value greater than or equal to `2`")  # noqa: E501
        collection_formats = {}

        path_params = {}

        query_params = []
        if 'access_id' in params:
            query_params.append(('access_id', params['access_id']))  # noqa: E501
        if 'timestamp' in params:
            query_params.append(('timestamp', params['timestamp']))  # noqa: E501
        if 'nonce' in params:
            query_params.append(('nonce', params['nonce']))  # noqa: E501
        if 'signature' in params:
            query_params.append(('signature', params['signature']))  # noqa: E501
        if 'access_token' in params:
            query_params.append(('access_token', params['access_token']))  # noqa: E501
        if 'client_ip' in params:
            query_params.append(('client_ip', params['client_ip']))  # noqa: E501
        if 'creds_expiry' in params:
            query_params.append(('creds_expiry', params['creds_expiry']))  # noqa: E501

        header_params = {}
        if 'akeyless_request_id' in params:
            header_params['AkeylessRequestId'] = params['akeyless_request_id']  # noqa: E501
        if 'akeyless_client_id' in params:
            header_params['AkeylessClientId'] = params['akeyless_client_id']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/auth', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CredentialsReplyObj',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def authenticate_uam(self, access_id, **kwargs):  # noqa: E501
        """Return a combination of three temporary access credentials for accessing Auth, UAM and KFMs instances.  # noqa: E501

        UAM client that meet the access rules will be able to get a combination of three temporary access credentials signed by Auth for accessing Auth, UAM and KFMs instances. The client must provide the relevant parameters that proves his compliance with the access. In this case the IP address used for authentication will be taken from the http request.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.authenticate_uam(access_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str access_id: Access id. (required)
        :param str akeyless_request_id: Request Id for logging
        :param str akeyless_client_id: Client Id for logging
        :param int timestamp: A Unix timestamp which was used for the signature (relevant only in case of api key access).
        :param str nonce: Random string which was used for the signature (relevant only in case of api key access authentication).
        :param str signature: A digital signature generated with the private key that complies with the access authentication (relevant only in case of api key access authentication).
        :param str access_token: An access token as a signed JSON Web Toke (relevant only in case of azure-az/oauth2 access authentication).
        :param str client_ip: The Client's IP for authentication. Relevant only in case of the services that mediate between Auth and their clients in obtaining temporary access credentials.
        :param int creds_expiry: The requested expiration time of the temporary credentials in minutes.
        :return: SystemAccessCredentialsReplyObj
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.authenticate_uam_with_http_info(access_id, **kwargs)  # noqa: E501
        else:
            (data) = self.authenticate_uam_with_http_info(access_id, **kwargs)  # noqa: E501
            return data

    def authenticate_uam_with_http_info(self, access_id, **kwargs):  # noqa: E501
        """Return a combination of three temporary access credentials for accessing Auth, UAM and KFMs instances.  # noqa: E501

        UAM client that meet the access rules will be able to get a combination of three temporary access credentials signed by Auth for accessing Auth, UAM and KFMs instances. The client must provide the relevant parameters that proves his compliance with the access. In this case the IP address used for authentication will be taken from the http request.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.authenticate_uam_with_http_info(access_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str access_id: Access id. (required)
        :param str akeyless_request_id: Request Id for logging
        :param str akeyless_client_id: Client Id for logging
        :param int timestamp: A Unix timestamp which was used for the signature (relevant only in case of api key access).
        :param str nonce: Random string which was used for the signature (relevant only in case of api key access authentication).
        :param str signature: A digital signature generated with the private key that complies with the access authentication (relevant only in case of api key access authentication).
        :param str access_token: An access token as a signed JSON Web Toke (relevant only in case of azure-az/oauth2 access authentication).
        :param str client_ip: The Client's IP for authentication. Relevant only in case of the services that mediate between Auth and their clients in obtaining temporary access credentials.
        :param int creds_expiry: The requested expiration time of the temporary credentials in minutes.
        :return: SystemAccessCredentialsReplyObj
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['access_id', 'akeyless_request_id', 'akeyless_client_id', 'timestamp', 'nonce', 'signature', 'access_token', 'client_ip', 'creds_expiry']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method authenticate_uam" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'access_id' is set
        if ('access_id' not in params or
                params['access_id'] is None):
            raise ValueError("Missing the required parameter `access_id` when calling `authenticate_uam`")  # noqa: E501

        if 'creds_expiry' in params and params['creds_expiry'] > 60:  # noqa: E501
            raise ValueError("Invalid value for parameter `creds_expiry` when calling `authenticate_uam`, must be a value less than or equal to `60`")  # noqa: E501
        if 'creds_expiry' in params and params['creds_expiry'] < 2:  # noqa: E501
            raise ValueError("Invalid value for parameter `creds_expiry` when calling `authenticate_uam`, must be a value greater than or equal to `2`")  # noqa: E501
        collection_formats = {}

        path_params = {}

        query_params = []
        if 'access_id' in params:
            query_params.append(('access_id', params['access_id']))  # noqa: E501
        if 'timestamp' in params:
            query_params.append(('timestamp', params['timestamp']))  # noqa: E501
        if 'nonce' in params:
            query_params.append(('nonce', params['nonce']))  # noqa: E501
        if 'signature' in params:
            query_params.append(('signature', params['signature']))  # noqa: E501
        if 'access_token' in params:
            query_params.append(('access_token', params['access_token']))  # noqa: E501
        if 'client_ip' in params:
            query_params.append(('client_ip', params['client_ip']))  # noqa: E501
        if 'creds_expiry' in params:
            query_params.append(('creds_expiry', params['creds_expiry']))  # noqa: E501

        header_params = {}
        if 'akeyless_request_id' in params:
            header_params['AkeylessRequestId'] = params['akeyless_request_id']  # noqa: E501
        if 'akeyless_client_id' in params:
            header_params['AkeylessClientId'] = params['akeyless_client_id']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/auth-uam', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='SystemAccessCredentialsReplyObj',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_access(self, akeyless_credentials, body, **kwargs):  # noqa: E501
        """Creating a new access.  # noqa: E501

        This endpoint is accessible only by services that have a permission to access Auth for managing their accesses for their clients.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_access(akeyless_credentials, body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str akeyless_credentials: Temporary credentials for accessing the endpoint (required)
        :param AccessParams body: Access rules and attaches. (required)
        :param str akeyless_request_id: Request Id for logging
        :param str akeyless_client_id: Client Id for logging
        :return: CreateAccessReplyObj
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_access_with_http_info(akeyless_credentials, body, **kwargs)  # noqa: E501
        else:
            (data) = self.create_access_with_http_info(akeyless_credentials, body, **kwargs)  # noqa: E501
            return data

    def create_access_with_http_info(self, akeyless_credentials, body, **kwargs):  # noqa: E501
        """Creating a new access.  # noqa: E501

        This endpoint is accessible only by services that have a permission to access Auth for managing their accesses for their clients.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_access_with_http_info(akeyless_credentials, body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str akeyless_credentials: Temporary credentials for accessing the endpoint (required)
        :param AccessParams body: Access rules and attaches. (required)
        :param str akeyless_request_id: Request Id for logging
        :param str akeyless_client_id: Client Id for logging
        :return: CreateAccessReplyObj
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['akeyless_credentials', 'body', 'akeyless_request_id', 'akeyless_client_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_access" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'akeyless_credentials' is set
        if ('akeyless_credentials' not in params or
                params['akeyless_credentials'] is None):
            raise ValueError("Missing the required parameter `akeyless_credentials` when calling `create_access`")  # noqa: E501
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `create_access`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}
        if 'akeyless_request_id' in params:
            header_params['AkeylessRequestId'] = params['akeyless_request_id']  # noqa: E501
        if 'akeyless_client_id' in params:
            header_params['AkeylessClientId'] = params['akeyless_client_id']  # noqa: E501
        if 'akeyless_credentials' in params:
            header_params['Akeyless-Credentials'] = params['akeyless_credentials']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/access', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CreateAccessReplyObj',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_account(self, **kwargs):  # noqa: E501
        """Create new account.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_account(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: AccountReplyObj
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_account_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.create_account_with_http_info(**kwargs)  # noqa: E501
            return data

    def create_account_with_http_info(self, **kwargs):  # noqa: E501
        """Create new account.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_account_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: AccountReplyObj
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_account" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/account', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='AccountReplyObj',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_account_creds(self, body, **kwargs):  # noqa: E501
        """Getting temporary access credentials to create new account in the UAM service. The UAM service will use this credentials to create an access to be used for accessing the account  # noqa: E501

        This endpoint is accessible only by services that have a permission to access Auth for managing their accesses for their clients.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_account_creds(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param CreateAccountCredsParams body: Access rules to be used for accessing the new account. (required)
        :return: CredentialsReplyObj
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_account_creds_with_http_info(body, **kwargs)  # noqa: E501
        else:
            (data) = self.create_account_creds_with_http_info(body, **kwargs)  # noqa: E501
            return data

    def create_account_creds_with_http_info(self, body, **kwargs):  # noqa: E501
        """Getting temporary access credentials to create new account in the UAM service. The UAM service will use this credentials to create an access to be used for accessing the account  # noqa: E501

        This endpoint is accessible only by services that have a permission to access Auth for managing their accesses for their clients.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_account_creds_with_http_info(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param CreateAccountCredsParams body: Access rules to be used for accessing the new account. (required)
        :return: CredentialsReplyObj
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_account_creds" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `create_account_creds`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/create-account-creds', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CredentialsReplyObj',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_auth_method(self, akeyless_uam_access_creds, akeyless_set_auth_method_creds, new_auth_method_name, **kwargs):  # noqa: E501
        """Add a new auth method to the account.  # noqa: E501

        This endpoint is accessible only by an admin  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_auth_method(akeyless_uam_access_creds, akeyless_set_auth_method_creds, new_auth_method_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str akeyless_uam_access_creds: Temporary credentials for accessing the endpoint (required)
        :param str akeyless_set_auth_method_creds: Temporary credentials for accessing the endpoint (required)
        :param str new_auth_method_name: The auth method name to be created (in case of update auth method, this is the new auth method name that will replace the existing one) (required)
        :param str akeyless_request_id: Request Id for logging
        :param str akeyless_client_id: Client Id for logging
        :return: CreateAuthMethodReplyObj
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_auth_method_with_http_info(akeyless_uam_access_creds, akeyless_set_auth_method_creds, new_auth_method_name, **kwargs)  # noqa: E501
        else:
            (data) = self.create_auth_method_with_http_info(akeyless_uam_access_creds, akeyless_set_auth_method_creds, new_auth_method_name, **kwargs)  # noqa: E501
            return data

    def create_auth_method_with_http_info(self, akeyless_uam_access_creds, akeyless_set_auth_method_creds, new_auth_method_name, **kwargs):  # noqa: E501
        """Add a new auth method to the account.  # noqa: E501

        This endpoint is accessible only by an admin  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_auth_method_with_http_info(akeyless_uam_access_creds, akeyless_set_auth_method_creds, new_auth_method_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str akeyless_uam_access_creds: Temporary credentials for accessing the endpoint (required)
        :param str akeyless_set_auth_method_creds: Temporary credentials for accessing the endpoint (required)
        :param str new_auth_method_name: The auth method name to be created (in case of update auth method, this is the new auth method name that will replace the existing one) (required)
        :param str akeyless_request_id: Request Id for logging
        :param str akeyless_client_id: Client Id for logging
        :return: CreateAuthMethodReplyObj
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['akeyless_uam_access_creds', 'akeyless_set_auth_method_creds', 'new_auth_method_name', 'akeyless_request_id', 'akeyless_client_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_auth_method" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'akeyless_uam_access_creds' is set
        if ('akeyless_uam_access_creds' not in params or
                params['akeyless_uam_access_creds'] is None):
            raise ValueError("Missing the required parameter `akeyless_uam_access_creds` when calling `create_auth_method`")  # noqa: E501
        # verify the required parameter 'akeyless_set_auth_method_creds' is set
        if ('akeyless_set_auth_method_creds' not in params or
                params['akeyless_set_auth_method_creds'] is None):
            raise ValueError("Missing the required parameter `akeyless_set_auth_method_creds` when calling `create_auth_method`")  # noqa: E501
        # verify the required parameter 'new_auth_method_name' is set
        if ('new_auth_method_name' not in params or
                params['new_auth_method_name'] is None):
            raise ValueError("Missing the required parameter `new_auth_method_name` when calling `create_auth_method`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'new_auth_method_name' in params:
            query_params.append(('new_auth_method_name', params['new_auth_method_name']))  # noqa: E501

        header_params = {}
        if 'akeyless_request_id' in params:
            header_params['AkeylessRequestId'] = params['akeyless_request_id']  # noqa: E501
        if 'akeyless_client_id' in params:
            header_params['AkeylessClientId'] = params['akeyless_client_id']  # noqa: E501
        if 'akeyless_uam_access_creds' in params:
            header_params['AkeylessUAM-AccessCreds'] = params['akeyless_uam_access_creds']  # noqa: E501
        if 'akeyless_set_auth_method_creds' in params:
            header_params['Akeyless-SetAuthMethodCreds'] = params['akeyless_set_auth_method_creds']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/auth-method', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CreateAuthMethodReplyObj',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_item(self, akeyless_uam_access_creds, item_name, item_type, item_metadata, split_level, **kwargs):  # noqa: E501
        """Add a new item to the account.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_item(akeyless_uam_access_creds, item_name, item_type, item_metadata, split_level, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str akeyless_uam_access_creds: Temporary credentials for accessing the endpoint (required)
        :param str item_name: The item name (including the path to item) to be created (required)
        :param str item_type: The type of the item to be created Types available are: [AES128GCM, AES256GCM, AES128SIV, AES256SIV] (required)
        :param str item_metadata: The metadata about the item. (required)
        :param int split_level: The splitting level represent the number of fragments that the item will be split into. (required)
        :param str akeyless_request_id: Request Id for logging
        :param str akeyless_client_id: Client Id for logging
        :param int size: The length of the item to be created.
        :param str customer_fragment_id: The customer fragment ID associated with this item (if any).
        :param str upload_rsa_key_creds: The credentials to upload an RSA key. this parameter relevant only in case of item of RSA Key. in this case all the item's creation parameters should be correlated with the parameters in the UploadRSAKeyCreds.
        :param str upload_secret_creds: The credentials to upload a secret. this parameter relevant only in case of create a new secret. This parameter will be used to extract the protection key and the derivation data that used to encrypt the secret.
        :param str secret_enc_val: The encrypted secret value. this parameter relevant only in case of create a new secret. This parameter should contain the encrypted secret that is encrypted using the protection key.
        :param str protection_key_name: The name of the key that will be used to encrypt a dynamic secret. If not provided, the account default secret key will be used. This parameter relevant only in case of create a new dynamic secret.
        :param str signer_key_name: The name of the key that will be used to singing the ssh certificate. This parameter relevant and required only in case of create a new ssh cert issuer.
        :param SetItemRequestBodyParams body: Body params for create or update an item.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_item_with_http_info(akeyless_uam_access_creds, item_name, item_type, item_metadata, split_level, **kwargs)  # noqa: E501
        else:
            (data) = self.create_item_with_http_info(akeyless_uam_access_creds, item_name, item_type, item_metadata, split_level, **kwargs)  # noqa: E501
            return data

    def create_item_with_http_info(self, akeyless_uam_access_creds, item_name, item_type, item_metadata, split_level, **kwargs):  # noqa: E501
        """Add a new item to the account.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_item_with_http_info(akeyless_uam_access_creds, item_name, item_type, item_metadata, split_level, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str akeyless_uam_access_creds: Temporary credentials for accessing the endpoint (required)
        :param str item_name: The item name (including the path to item) to be created (required)
        :param str item_type: The type of the item to be created Types available are: [AES128GCM, AES256GCM, AES128SIV, AES256SIV] (required)
        :param str item_metadata: The metadata about the item. (required)
        :param int split_level: The splitting level represent the number of fragments that the item will be split into. (required)
        :param str akeyless_request_id: Request Id for logging
        :param str akeyless_client_id: Client Id for logging
        :param int size: The length of the item to be created.
        :param str customer_fragment_id: The customer fragment ID associated with this item (if any).
        :param str upload_rsa_key_creds: The credentials to upload an RSA key. this parameter relevant only in case of item of RSA Key. in this case all the item's creation parameters should be correlated with the parameters in the UploadRSAKeyCreds.
        :param str upload_secret_creds: The credentials to upload a secret. this parameter relevant only in case of create a new secret. This parameter will be used to extract the protection key and the derivation data that used to encrypt the secret.
        :param str secret_enc_val: The encrypted secret value. this parameter relevant only in case of create a new secret. This parameter should contain the encrypted secret that is encrypted using the protection key.
        :param str protection_key_name: The name of the key that will be used to encrypt a dynamic secret. If not provided, the account default secret key will be used. This parameter relevant only in case of create a new dynamic secret.
        :param str signer_key_name: The name of the key that will be used to singing the ssh certificate. This parameter relevant and required only in case of create a new ssh cert issuer.
        :param SetItemRequestBodyParams body: Body params for create or update an item.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['akeyless_uam_access_creds', 'item_name', 'item_type', 'item_metadata', 'split_level', 'akeyless_request_id', 'akeyless_client_id', 'size', 'customer_fragment_id', 'upload_rsa_key_creds', 'upload_secret_creds', 'secret_enc_val', 'protection_key_name', 'signer_key_name', 'body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_item" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'akeyless_uam_access_creds' is set
        if ('akeyless_uam_access_creds' not in params or
                params['akeyless_uam_access_creds'] is None):
            raise ValueError("Missing the required parameter `akeyless_uam_access_creds` when calling `create_item`")  # noqa: E501
        # verify the required parameter 'item_name' is set
        if ('item_name' not in params or
                params['item_name'] is None):
            raise ValueError("Missing the required parameter `item_name` when calling `create_item`")  # noqa: E501
        # verify the required parameter 'item_type' is set
        if ('item_type' not in params or
                params['item_type'] is None):
            raise ValueError("Missing the required parameter `item_type` when calling `create_item`")  # noqa: E501
        # verify the required parameter 'item_metadata' is set
        if ('item_metadata' not in params or
                params['item_metadata'] is None):
            raise ValueError("Missing the required parameter `item_metadata` when calling `create_item`")  # noqa: E501
        # verify the required parameter 'split_level' is set
        if ('split_level' not in params or
                params['split_level'] is None):
            raise ValueError("Missing the required parameter `split_level` when calling `create_item`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'item_name' in params:
            query_params.append(('item_name', params['item_name']))  # noqa: E501
        if 'item_type' in params:
            query_params.append(('item_type', params['item_type']))  # noqa: E501
        if 'item_metadata' in params:
            query_params.append(('item_metadata', params['item_metadata']))  # noqa: E501
        if 'split_level' in params:
            query_params.append(('split_level', params['split_level']))  # noqa: E501
        if 'size' in params:
            query_params.append(('size', params['size']))  # noqa: E501
        if 'customer_fragment_id' in params:
            query_params.append(('customer_fragment_id', params['customer_fragment_id']))  # noqa: E501
        if 'upload_rsa_key_creds' in params:
            query_params.append(('upload_rsa_key_creds', params['upload_rsa_key_creds']))  # noqa: E501
        if 'upload_secret_creds' in params:
            query_params.append(('upload_secret_creds', params['upload_secret_creds']))  # noqa: E501
        if 'secret_enc_val' in params:
            query_params.append(('secret_enc_val', params['secret_enc_val']))  # noqa: E501
        if 'protection_key_name' in params:
            query_params.append(('protection_key_name', params['protection_key_name']))  # noqa: E501
        if 'signer_key_name' in params:
            query_params.append(('signer_key_name', params['signer_key_name']))  # noqa: E501

        header_params = {}
        if 'akeyless_request_id' in params:
            header_params['AkeylessRequestId'] = params['akeyless_request_id']  # noqa: E501
        if 'akeyless_client_id' in params:
            header_params['AkeylessClientId'] = params['akeyless_client_id']  # noqa: E501
        if 'akeyless_uam_access_creds' in params:
            header_params['AkeylessUAM-AccessCreds'] = params['akeyless_uam_access_creds']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/item', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_role(self, akeyless_uam_access_creds, body, **kwargs):  # noqa: E501
        """Add a new role to the account.  # noqa: E501

        This endpoint is accessible only by an admin  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_role(akeyless_uam_access_creds, body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str akeyless_uam_access_creds: Temporary credentials for accessing the endpoint (required)
        :param SetRoleRequestParams body: Params for create or update role request. (required)
        :param str akeyless_request_id: Request Id for logging
        :param str akeyless_client_id: Client Id for logging
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_role_with_http_info(akeyless_uam_access_creds, body, **kwargs)  # noqa: E501
        else:
            (data) = self.create_role_with_http_info(akeyless_uam_access_creds, body, **kwargs)  # noqa: E501
            return data

    def create_role_with_http_info(self, akeyless_uam_access_creds, body, **kwargs):  # noqa: E501
        """Add a new role to the account.  # noqa: E501

        This endpoint is accessible only by an admin  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_role_with_http_info(akeyless_uam_access_creds, body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str akeyless_uam_access_creds: Temporary credentials for accessing the endpoint (required)
        :param SetRoleRequestParams body: Params for create or update role request. (required)
        :param str akeyless_request_id: Request Id for logging
        :param str akeyless_client_id: Client Id for logging
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['akeyless_uam_access_creds', 'body', 'akeyless_request_id', 'akeyless_client_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_role" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'akeyless_uam_access_creds' is set
        if ('akeyless_uam_access_creds' not in params or
                params['akeyless_uam_access_creds'] is None):
            raise ValueError("Missing the required parameter `akeyless_uam_access_creds` when calling `create_role`")  # noqa: E501
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `create_role`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}
        if 'akeyless_request_id' in params:
            header_params['AkeylessRequestId'] = params['akeyless_request_id']  # noqa: E501
        if 'akeyless_client_id' in params:
            header_params['AkeylessClientId'] = params['akeyless_client_id']  # noqa: E501
        if 'akeyless_uam_access_creds' in params:
            header_params['AkeylessUAM-AccessCreds'] = params['akeyless_uam_access_creds']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/role', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_role_auth_method_assoc(self, akeyless_uam_access_creds, role_name, associated_name, **kwargs):  # noqa: E501
        """Add an association between a role and an auth method.  # noqa: E501

        This endpoint is accessible only by an admin  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_role_auth_method_assoc(akeyless_uam_access_creds, role_name, associated_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str akeyless_uam_access_creds: Temporary credentials for accessing the endpoint (required)
        :param str role_name: The role name to be associated (required)
        :param str associated_name: The auth method name to be associated. (required)
        :param str akeyless_request_id: Request Id for logging
        :param str akeyless_client_id: Client Id for logging
        :param str sub_claims_base64: A base64 of a key values map in a json format with restricted sub claims.
        :return: CreateRoleAuthMethodAssocReplyObj
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_role_auth_method_assoc_with_http_info(akeyless_uam_access_creds, role_name, associated_name, **kwargs)  # noqa: E501
        else:
            (data) = self.create_role_auth_method_assoc_with_http_info(akeyless_uam_access_creds, role_name, associated_name, **kwargs)  # noqa: E501
            return data

    def create_role_auth_method_assoc_with_http_info(self, akeyless_uam_access_creds, role_name, associated_name, **kwargs):  # noqa: E501
        """Add an association between a role and an auth method.  # noqa: E501

        This endpoint is accessible only by an admin  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_role_auth_method_assoc_with_http_info(akeyless_uam_access_creds, role_name, associated_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str akeyless_uam_access_creds: Temporary credentials for accessing the endpoint (required)
        :param str role_name: The role name to be associated (required)
        :param str associated_name: The auth method name to be associated. (required)
        :param str akeyless_request_id: Request Id for logging
        :param str akeyless_client_id: Client Id for logging
        :param str sub_claims_base64: A base64 of a key values map in a json format with restricted sub claims.
        :return: CreateRoleAuthMethodAssocReplyObj
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['akeyless_uam_access_creds', 'role_name', 'associated_name', 'akeyless_request_id', 'akeyless_client_id', 'sub_claims_base64']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_role_auth_method_assoc" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'akeyless_uam_access_creds' is set
        if ('akeyless_uam_access_creds' not in params or
                params['akeyless_uam_access_creds'] is None):
            raise ValueError("Missing the required parameter `akeyless_uam_access_creds` when calling `create_role_auth_method_assoc`")  # noqa: E501
        # verify the required parameter 'role_name' is set
        if ('role_name' not in params or
                params['role_name'] is None):
            raise ValueError("Missing the required parameter `role_name` when calling `create_role_auth_method_assoc`")  # noqa: E501
        # verify the required parameter 'associated_name' is set
        if ('associated_name' not in params or
                params['associated_name'] is None):
            raise ValueError("Missing the required parameter `associated_name` when calling `create_role_auth_method_assoc`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'role_name' in params:
            query_params.append(('role_name', params['role_name']))  # noqa: E501
        if 'associated_name' in params:
            query_params.append(('associated_name', params['associated_name']))  # noqa: E501
        if 'sub_claims_base64' in params:
            query_params.append(('sub_claims_base64', params['sub_claims_base64']))  # noqa: E501

        header_params = {}
        if 'akeyless_request_id' in params:
            header_params['AkeylessRequestId'] = params['akeyless_request_id']  # noqa: E501
        if 'akeyless_client_id' in params:
            header_params['AkeylessClientId'] = params['akeyless_client_id']  # noqa: E501
        if 'akeyless_uam_access_creds' in params:
            header_params['AkeylessUAM-AccessCreds'] = params['akeyless_uam_access_creds']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/role-auth-method-assoc', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CreateRoleAuthMethodAssocReplyObj',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_access(self, akeyless_credentials, access_id, **kwargs):  # noqa: E501
        """Deleting an existing access.  # noqa: E501

        This endpoint is accessible only by services that have a permission to access Auth for managing their accesses for their clients.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_access(akeyless_credentials, access_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str akeyless_credentials: Temporary credentials for accessing the endpoint (required)
        :param str access_id: Access id. (required)
        :param str akeyless_request_id: Request Id for logging
        :param str akeyless_client_id: Client Id for logging
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_access_with_http_info(akeyless_credentials, access_id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_access_with_http_info(akeyless_credentials, access_id, **kwargs)  # noqa: E501
            return data

    def delete_access_with_http_info(self, akeyless_credentials, access_id, **kwargs):  # noqa: E501
        """Deleting an existing access.  # noqa: E501

        This endpoint is accessible only by services that have a permission to access Auth for managing their accesses for their clients.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_access_with_http_info(akeyless_credentials, access_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str akeyless_credentials: Temporary credentials for accessing the endpoint (required)
        :param str access_id: Access id. (required)
        :param str akeyless_request_id: Request Id for logging
        :param str akeyless_client_id: Client Id for logging
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['akeyless_credentials', 'access_id', 'akeyless_request_id', 'akeyless_client_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_access" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'akeyless_credentials' is set
        if ('akeyless_credentials' not in params or
                params['akeyless_credentials'] is None):
            raise ValueError("Missing the required parameter `akeyless_credentials` when calling `delete_access`")  # noqa: E501
        # verify the required parameter 'access_id' is set
        if ('access_id' not in params or
                params['access_id'] is None):
            raise ValueError("Missing the required parameter `access_id` when calling `delete_access`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'access_id' in params:
            path_params['access_id'] = params['access_id']  # noqa: E501

        query_params = []

        header_params = {}
        if 'akeyless_request_id' in params:
            header_params['AkeylessRequestId'] = params['akeyless_request_id']  # noqa: E501
        if 'akeyless_client_id' in params:
            header_params['AkeylessClientId'] = params['akeyless_client_id']  # noqa: E501
        if 'akeyless_credentials' in params:
            header_params['Akeyless-Credentials'] = params['akeyless_credentials']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/access/{access_id}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_auth_method(self, akeyless_uam_access_creds, auth_method_name, **kwargs):  # noqa: E501
        """Deleting an existing auth method from the account.  # noqa: E501

        This endpoint is accessible only by an admin  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_auth_method(akeyless_uam_access_creds, auth_method_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str akeyless_uam_access_creds: Temporary credentials for accessing the endpoint (required)
        :param str auth_method_name: Auth method name. (required)
        :param str akeyless_request_id: Request Id for logging
        :param str akeyless_client_id: Client Id for logging
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_auth_method_with_http_info(akeyless_uam_access_creds, auth_method_name, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_auth_method_with_http_info(akeyless_uam_access_creds, auth_method_name, **kwargs)  # noqa: E501
            return data

    def delete_auth_method_with_http_info(self, akeyless_uam_access_creds, auth_method_name, **kwargs):  # noqa: E501
        """Deleting an existing auth method from the account.  # noqa: E501

        This endpoint is accessible only by an admin  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_auth_method_with_http_info(akeyless_uam_access_creds, auth_method_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str akeyless_uam_access_creds: Temporary credentials for accessing the endpoint (required)
        :param str auth_method_name: Auth method name. (required)
        :param str akeyless_request_id: Request Id for logging
        :param str akeyless_client_id: Client Id for logging
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['akeyless_uam_access_creds', 'auth_method_name', 'akeyless_request_id', 'akeyless_client_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_auth_method" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'akeyless_uam_access_creds' is set
        if ('akeyless_uam_access_creds' not in params or
                params['akeyless_uam_access_creds'] is None):
            raise ValueError("Missing the required parameter `akeyless_uam_access_creds` when calling `delete_auth_method`")  # noqa: E501
        # verify the required parameter 'auth_method_name' is set
        if ('auth_method_name' not in params or
                params['auth_method_name'] is None):
            raise ValueError("Missing the required parameter `auth_method_name` when calling `delete_auth_method`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'auth_method_name' in params:
            path_params['auth_method_name'] = params['auth_method_name']  # noqa: E501

        query_params = []

        header_params = {}
        if 'akeyless_request_id' in params:
            header_params['AkeylessRequestId'] = params['akeyless_request_id']  # noqa: E501
        if 'akeyless_client_id' in params:
            header_params['AkeylessClientId'] = params['akeyless_client_id']  # noqa: E501
        if 'akeyless_uam_access_creds' in params:
            header_params['AkeylessUAM-AccessCreds'] = params['akeyless_uam_access_creds']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/auth-method/{auth_method_name}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_item(self, akeyless_uam_access_creds, item_name, **kwargs):  # noqa: E501
        """Deleting an existing item from the account.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_item(akeyless_uam_access_creds, item_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str akeyless_uam_access_creds: Temporary credentials for accessing the endpoint (required)
        :param str item_name: Item name (including the path to the item). (required)
        :param str akeyless_request_id: Request Id for logging
        :param str akeyless_client_id: Client Id for logging
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_item_with_http_info(akeyless_uam_access_creds, item_name, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_item_with_http_info(akeyless_uam_access_creds, item_name, **kwargs)  # noqa: E501
            return data

    def delete_item_with_http_info(self, akeyless_uam_access_creds, item_name, **kwargs):  # noqa: E501
        """Deleting an existing item from the account.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_item_with_http_info(akeyless_uam_access_creds, item_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str akeyless_uam_access_creds: Temporary credentials for accessing the endpoint (required)
        :param str item_name: Item name (including the path to the item). (required)
        :param str akeyless_request_id: Request Id for logging
        :param str akeyless_client_id: Client Id for logging
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['akeyless_uam_access_creds', 'item_name', 'akeyless_request_id', 'akeyless_client_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_item" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'akeyless_uam_access_creds' is set
        if ('akeyless_uam_access_creds' not in params or
                params['akeyless_uam_access_creds'] is None):
            raise ValueError("Missing the required parameter `akeyless_uam_access_creds` when calling `delete_item`")  # noqa: E501
        # verify the required parameter 'item_name' is set
        if ('item_name' not in params or
                params['item_name'] is None):
            raise ValueError("Missing the required parameter `item_name` when calling `delete_item`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'item_name' in params:
            query_params.append(('item_name', params['item_name']))  # noqa: E501

        header_params = {}
        if 'akeyless_request_id' in params:
            header_params['AkeylessRequestId'] = params['akeyless_request_id']  # noqa: E501
        if 'akeyless_client_id' in params:
            header_params['AkeylessClientId'] = params['akeyless_client_id']  # noqa: E501
        if 'akeyless_uam_access_creds' in params:
            header_params['AkeylessUAM-AccessCreds'] = params['akeyless_uam_access_creds']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/item', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_role(self, akeyless_uam_access_creds, role_name, **kwargs):  # noqa: E501
        """Deleting an existing role from the account.  # noqa: E501

        This endpoint is accessible only by an admin  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_role(akeyless_uam_access_creds, role_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str akeyless_uam_access_creds: Temporary credentials for accessing the endpoint (required)
        :param str role_name: Role name. (required)
        :param str akeyless_request_id: Request Id for logging
        :param str akeyless_client_id: Client Id for logging
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_role_with_http_info(akeyless_uam_access_creds, role_name, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_role_with_http_info(akeyless_uam_access_creds, role_name, **kwargs)  # noqa: E501
            return data

    def delete_role_with_http_info(self, akeyless_uam_access_creds, role_name, **kwargs):  # noqa: E501
        """Deleting an existing role from the account.  # noqa: E501

        This endpoint is accessible only by an admin  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_role_with_http_info(akeyless_uam_access_creds, role_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str akeyless_uam_access_creds: Temporary credentials for accessing the endpoint (required)
        :param str role_name: Role name. (required)
        :param str akeyless_request_id: Request Id for logging
        :param str akeyless_client_id: Client Id for logging
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['akeyless_uam_access_creds', 'role_name', 'akeyless_request_id', 'akeyless_client_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_role" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'akeyless_uam_access_creds' is set
        if ('akeyless_uam_access_creds' not in params or
                params['akeyless_uam_access_creds'] is None):
            raise ValueError("Missing the required parameter `akeyless_uam_access_creds` when calling `delete_role`")  # noqa: E501
        # verify the required parameter 'role_name' is set
        if ('role_name' not in params or
                params['role_name'] is None):
            raise ValueError("Missing the required parameter `role_name` when calling `delete_role`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'role_name' in params:
            path_params['role_name'] = params['role_name']  # noqa: E501

        query_params = []

        header_params = {}
        if 'akeyless_request_id' in params:
            header_params['AkeylessRequestId'] = params['akeyless_request_id']  # noqa: E501
        if 'akeyless_client_id' in params:
            header_params['AkeylessClientId'] = params['akeyless_client_id']  # noqa: E501
        if 'akeyless_uam_access_creds' in params:
            header_params['AkeylessUAM-AccessCreds'] = params['akeyless_uam_access_creds']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/role/{role_name}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_role_auth_method_assoc(self, akeyless_uam_access_creds, assoc_id, **kwargs):  # noqa: E501
        """Deleting an association between a role and an auth method.  # noqa: E501

        This endpoint is accessible only by an admin  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_role_auth_method_assoc(akeyless_uam_access_creds, assoc_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str akeyless_uam_access_creds: Temporary credentials for accessing the endpoint (required)
        :param str assoc_id: The association id to be deleted (required)
        :param str akeyless_request_id: Request Id for logging
        :param str akeyless_client_id: Client Id for logging
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_role_auth_method_assoc_with_http_info(akeyless_uam_access_creds, assoc_id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_role_auth_method_assoc_with_http_info(akeyless_uam_access_creds, assoc_id, **kwargs)  # noqa: E501
            return data

    def delete_role_auth_method_assoc_with_http_info(self, akeyless_uam_access_creds, assoc_id, **kwargs):  # noqa: E501
        """Deleting an association between a role and an auth method.  # noqa: E501

        This endpoint is accessible only by an admin  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_role_auth_method_assoc_with_http_info(akeyless_uam_access_creds, assoc_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str akeyless_uam_access_creds: Temporary credentials for accessing the endpoint (required)
        :param str assoc_id: The association id to be deleted (required)
        :param str akeyless_request_id: Request Id for logging
        :param str akeyless_client_id: Client Id for logging
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['akeyless_uam_access_creds', 'assoc_id', 'akeyless_request_id', 'akeyless_client_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_role_auth_method_assoc" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'akeyless_uam_access_creds' is set
        if ('akeyless_uam_access_creds' not in params or
                params['akeyless_uam_access_creds'] is None):
            raise ValueError("Missing the required parameter `akeyless_uam_access_creds` when calling `delete_role_auth_method_assoc`")  # noqa: E501
        # verify the required parameter 'assoc_id' is set
        if ('assoc_id' not in params or
                params['assoc_id'] is None):
            raise ValueError("Missing the required parameter `assoc_id` when calling `delete_role_auth_method_assoc`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'assoc_id' in params:
            query_params.append(('assoc_id', params['assoc_id']))  # noqa: E501

        header_params = {}
        if 'akeyless_request_id' in params:
            header_params['AkeylessRequestId'] = params['akeyless_request_id']  # noqa: E501
        if 'akeyless_client_id' in params:
            header_params['AkeylessClientId'] = params['akeyless_client_id']  # noqa: E501
        if 'akeyless_uam_access_creds' in params:
            header_params['AkeylessUAM-AccessCreds'] = params['akeyless_uam_access_creds']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/role-auth-method-assoc', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_access(self, akeyless_credentials, access_id, **kwargs):  # noqa: E501
        """Getting an existing access.  # noqa: E501

        This endpoint is accessible only by services that have a permission to access Auth for managing their accesses for their clients.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_access(akeyless_credentials, access_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str akeyless_credentials: Temporary credentials for accessing the endpoint (required)
        :param str access_id: Access id. (required)
        :param str akeyless_request_id: Request Id for logging
        :param str akeyless_client_id: Client Id for logging
        :return: GetAccessReplyObj
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_access_with_http_info(akeyless_credentials, access_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_access_with_http_info(akeyless_credentials, access_id, **kwargs)  # noqa: E501
            return data

    def get_access_with_http_info(self, akeyless_credentials, access_id, **kwargs):  # noqa: E501
        """Getting an existing access.  # noqa: E501

        This endpoint is accessible only by services that have a permission to access Auth for managing their accesses for their clients.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_access_with_http_info(akeyless_credentials, access_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str akeyless_credentials: Temporary credentials for accessing the endpoint (required)
        :param str access_id: Access id. (required)
        :param str akeyless_request_id: Request Id for logging
        :param str akeyless_client_id: Client Id for logging
        :return: GetAccessReplyObj
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['akeyless_credentials', 'access_id', 'akeyless_request_id', 'akeyless_client_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_access" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'akeyless_credentials' is set
        if ('akeyless_credentials' not in params or
                params['akeyless_credentials'] is None):
            raise ValueError("Missing the required parameter `akeyless_credentials` when calling `get_access`")  # noqa: E501
        # verify the required parameter 'access_id' is set
        if ('access_id' not in params or
                params['access_id'] is None):
            raise ValueError("Missing the required parameter `access_id` when calling `get_access`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'access_id' in params:
            path_params['access_id'] = params['access_id']  # noqa: E501

        query_params = []

        header_params = {}
        if 'akeyless_request_id' in params:
            header_params['AkeylessRequestId'] = params['akeyless_request_id']  # noqa: E501
        if 'akeyless_client_id' in params:
            header_params['AkeylessClientId'] = params['akeyless_client_id']  # noqa: E501
        if 'akeyless_credentials' in params:
            header_params['Akeyless-Credentials'] = params['akeyless_credentials']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/access/{access_id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='GetAccessReplyObj',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_accesses(self, akeyless_credentials, **kwargs):  # noqa: E501
        """Geting a list of accesses  # noqa: E501

        This endpoint is accessible only by services that have a permission to access Auth for managing their accesses for their clients.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_accesses(akeyless_credentials, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str akeyless_credentials: Temporary credentials for accessing the endpoint (required)
        :param str akeyless_request_id: Request Id for logging
        :param str akeyless_client_id: Client Id for logging
        :param list[str] filter_keys: Keys array of fields in the access attaches.
        :param list[str] filter_values: Values array of fields in the access attaches.
        :param bool include_expired:
        :return: GetAccessesReplyObj
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_accesses_with_http_info(akeyless_credentials, **kwargs)  # noqa: E501
        else:
            (data) = self.get_accesses_with_http_info(akeyless_credentials, **kwargs)  # noqa: E501
            return data

    def get_accesses_with_http_info(self, akeyless_credentials, **kwargs):  # noqa: E501
        """Geting a list of accesses  # noqa: E501

        This endpoint is accessible only by services that have a permission to access Auth for managing their accesses for their clients.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_accesses_with_http_info(akeyless_credentials, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str akeyless_credentials: Temporary credentials for accessing the endpoint (required)
        :param str akeyless_request_id: Request Id for logging
        :param str akeyless_client_id: Client Id for logging
        :param list[str] filter_keys: Keys array of fields in the access attaches.
        :param list[str] filter_values: Values array of fields in the access attaches.
        :param bool include_expired:
        :return: GetAccessesReplyObj
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['akeyless_credentials', 'akeyless_request_id', 'akeyless_client_id', 'filter_keys', 'filter_values', 'include_expired']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_accesses" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'akeyless_credentials' is set
        if ('akeyless_credentials' not in params or
                params['akeyless_credentials'] is None):
            raise ValueError("Missing the required parameter `akeyless_credentials` when calling `get_accesses`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'filter_keys' in params:
            query_params.append(('filter_keys', params['filter_keys']))  # noqa: E501
            collection_formats['filter_keys'] = 'multi'  # noqa: E501
        if 'filter_values' in params:
            query_params.append(('filter_values', params['filter_values']))  # noqa: E501
            collection_formats['filter_values'] = 'multi'  # noqa: E501
        if 'include_expired' in params:
            query_params.append(('include_expired', params['include_expired']))  # noqa: E501

        header_params = {}
        if 'akeyless_request_id' in params:
            header_params['AkeylessRequestId'] = params['akeyless_request_id']  # noqa: E501
        if 'akeyless_client_id' in params:
            header_params['AkeylessClientId'] = params['akeyless_client_id']  # noqa: E501
        if 'akeyless_credentials' in params:
            header_params['Akeyless-Credentials'] = params['akeyless_credentials']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/accesses', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='GetAccessesReplyObj',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_account_auth_methods(self, akeyless_uam_access_creds, **kwargs):  # noqa: E501
        """Get All the existing auth methods in the account.  # noqa: E501

        This endpoint is accessible only by an admin  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_account_auth_methods(akeyless_uam_access_creds, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str akeyless_uam_access_creds: Temporary credentials for accessing the endpoint (required)
        :param str akeyless_request_id: Request Id for logging
        :param str akeyless_client_id: Client Id for logging
        :return: GetAccountAuthMethodsReplyObj
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_account_auth_methods_with_http_info(akeyless_uam_access_creds, **kwargs)  # noqa: E501
        else:
            (data) = self.get_account_auth_methods_with_http_info(akeyless_uam_access_creds, **kwargs)  # noqa: E501
            return data

    def get_account_auth_methods_with_http_info(self, akeyless_uam_access_creds, **kwargs):  # noqa: E501
        """Get All the existing auth methods in the account.  # noqa: E501

        This endpoint is accessible only by an admin  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_account_auth_methods_with_http_info(akeyless_uam_access_creds, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str akeyless_uam_access_creds: Temporary credentials for accessing the endpoint (required)
        :param str akeyless_request_id: Request Id for logging
        :param str akeyless_client_id: Client Id for logging
        :return: GetAccountAuthMethodsReplyObj
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['akeyless_uam_access_creds', 'akeyless_request_id', 'akeyless_client_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_account_auth_methods" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'akeyless_uam_access_creds' is set
        if ('akeyless_uam_access_creds' not in params or
                params['akeyless_uam_access_creds'] is None):
            raise ValueError("Missing the required parameter `akeyless_uam_access_creds` when calling `get_account_auth_methods`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}
        if 'akeyless_request_id' in params:
            header_params['AkeylessRequestId'] = params['akeyless_request_id']  # noqa: E501
        if 'akeyless_client_id' in params:
            header_params['AkeylessClientId'] = params['akeyless_client_id']  # noqa: E501
        if 'akeyless_uam_access_creds' in params:
            header_params['AkeylessUAM-AccessCreds'] = params['akeyless_uam_access_creds']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/auth-methods', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='GetAccountAuthMethodsReplyObj',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_account_details(self, akeyless_uam_access_creds, **kwargs):  # noqa: E501
        """Get account details.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_account_details(akeyless_uam_access_creds, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str akeyless_uam_access_creds: Temporary credentials for accessing the endpoint (required)
        :param str akeyless_request_id: Request Id for logging
        :param str akeyless_client_id: Client Id for logging
        :return: GetAccountDetailsReplyObj
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_account_details_with_http_info(akeyless_uam_access_creds, **kwargs)  # noqa: E501
        else:
            (data) = self.get_account_details_with_http_info(akeyless_uam_access_creds, **kwargs)  # noqa: E501
            return data

    def get_account_details_with_http_info(self, akeyless_uam_access_creds, **kwargs):  # noqa: E501
        """Get account details.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_account_details_with_http_info(akeyless_uam_access_creds, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str akeyless_uam_access_creds: Temporary credentials for accessing the endpoint (required)
        :param str akeyless_request_id: Request Id for logging
        :param str akeyless_client_id: Client Id for logging
        :return: GetAccountDetailsReplyObj
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['akeyless_uam_access_creds', 'akeyless_request_id', 'akeyless_client_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_account_details" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'akeyless_uam_access_creds' is set
        if ('akeyless_uam_access_creds' not in params or
                params['akeyless_uam_access_creds'] is None):
            raise ValueError("Missing the required parameter `akeyless_uam_access_creds` when calling `get_account_details`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}
        if 'akeyless_request_id' in params:
            header_params['AkeylessRequestId'] = params['akeyless_request_id']  # noqa: E501
        if 'akeyless_client_id' in params:
            header_params['AkeylessClientId'] = params['akeyless_client_id']  # noqa: E501
        if 'akeyless_uam_access_creds' in params:
            header_params['AkeylessUAM-AccessCreds'] = params['akeyless_uam_access_creds']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/account/', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='GetAccountDetailsReplyObj',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_account_roles(self, akeyless_uam_access_creds, **kwargs):  # noqa: E501
        """Get All the existing roles in the account.  # noqa: E501

        This endpoint is accessible only by an admin  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_account_roles(akeyless_uam_access_creds, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str akeyless_uam_access_creds: Temporary credentials for accessing the endpoint (required)
        :param str akeyless_request_id: Request Id for logging
        :param str akeyless_client_id: Client Id for logging
        :return: GetAccountRolesReplyObj
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_account_roles_with_http_info(akeyless_uam_access_creds, **kwargs)  # noqa: E501
        else:
            (data) = self.get_account_roles_with_http_info(akeyless_uam_access_creds, **kwargs)  # noqa: E501
            return data

    def get_account_roles_with_http_info(self, akeyless_uam_access_creds, **kwargs):  # noqa: E501
        """Get All the existing roles in the account.  # noqa: E501

        This endpoint is accessible only by an admin  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_account_roles_with_http_info(akeyless_uam_access_creds, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str akeyless_uam_access_creds: Temporary credentials for accessing the endpoint (required)
        :param str akeyless_request_id: Request Id for logging
        :param str akeyless_client_id: Client Id for logging
        :return: GetAccountRolesReplyObj
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['akeyless_uam_access_creds', 'akeyless_request_id', 'akeyless_client_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_account_roles" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'akeyless_uam_access_creds' is set
        if ('akeyless_uam_access_creds' not in params or
                params['akeyless_uam_access_creds'] is None):
            raise ValueError("Missing the required parameter `akeyless_uam_access_creds` when calling `get_account_roles`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}
        if 'akeyless_request_id' in params:
            header_params['AkeylessRequestId'] = params['akeyless_request_id']  # noqa: E501
        if 'akeyless_client_id' in params:
            header_params['AkeylessClientId'] = params['akeyless_client_id']  # noqa: E501
        if 'akeyless_uam_access_creds' in params:
            header_params['AkeylessUAM-AccessCreds'] = params['akeyless_uam_access_creds']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/roles', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='GetAccountRolesReplyObj',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_auth_method(self, akeyless_uam_access_creds, auth_method_name, **kwargs):  # noqa: E501
        """Get auth method details.  # noqa: E501

        This endpoint is accessible only by an admin  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_auth_method(akeyless_uam_access_creds, auth_method_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str akeyless_uam_access_creds: Temporary credentials for accessing the endpoint (required)
        :param str auth_method_name: Auth method name. (required)
        :param str akeyless_request_id: Request Id for logging
        :param str akeyless_client_id: Client Id for logging
        :return: GetAuthMethodReplyObj
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_auth_method_with_http_info(akeyless_uam_access_creds, auth_method_name, **kwargs)  # noqa: E501
        else:
            (data) = self.get_auth_method_with_http_info(akeyless_uam_access_creds, auth_method_name, **kwargs)  # noqa: E501
            return data

    def get_auth_method_with_http_info(self, akeyless_uam_access_creds, auth_method_name, **kwargs):  # noqa: E501
        """Get auth method details.  # noqa: E501

        This endpoint is accessible only by an admin  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_auth_method_with_http_info(akeyless_uam_access_creds, auth_method_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str akeyless_uam_access_creds: Temporary credentials for accessing the endpoint (required)
        :param str auth_method_name: Auth method name. (required)
        :param str akeyless_request_id: Request Id for logging
        :param str akeyless_client_id: Client Id for logging
        :return: GetAuthMethodReplyObj
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['akeyless_uam_access_creds', 'auth_method_name', 'akeyless_request_id', 'akeyless_client_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_auth_method" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'akeyless_uam_access_creds' is set
        if ('akeyless_uam_access_creds' not in params or
                params['akeyless_uam_access_creds'] is None):
            raise ValueError("Missing the required parameter `akeyless_uam_access_creds` when calling `get_auth_method`")  # noqa: E501
        # verify the required parameter 'auth_method_name' is set
        if ('auth_method_name' not in params or
                params['auth_method_name'] is None):
            raise ValueError("Missing the required parameter `auth_method_name` when calling `get_auth_method`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'auth_method_name' in params:
            path_params['auth_method_name'] = params['auth_method_name']  # noqa: E501

        query_params = []

        header_params = {}
        if 'akeyless_request_id' in params:
            header_params['AkeylessRequestId'] = params['akeyless_request_id']  # noqa: E501
        if 'akeyless_client_id' in params:
            header_params['AkeylessClientId'] = params['akeyless_client_id']  # noqa: E501
        if 'akeyless_uam_access_creds' in params:
            header_params['AkeylessUAM-AccessCreds'] = params['akeyless_uam_access_creds']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/auth-method/{auth_method_name}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='GetAuthMethodReplyObj',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_auth_status(self, **kwargs):  # noqa: E501
        """get_auth_status  # noqa: E501

        Get Auth server status  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_auth_status(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str akeyless_request_id: Request Id for logging
        :param str akeyless_client_id: Client Id for logging
        :return: AuthStatusReplyObj
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_auth_status_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_auth_status_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_auth_status_with_http_info(self, **kwargs):  # noqa: E501
        """get_auth_status  # noqa: E501

        Get Auth server status  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_auth_status_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str akeyless_request_id: Request Id for logging
        :param str akeyless_client_id: Client Id for logging
        :return: AuthStatusReplyObj
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['akeyless_request_id', 'akeyless_client_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_auth_status" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}
        if 'akeyless_request_id' in params:
            header_params['AkeylessRequestId'] = params['akeyless_request_id']  # noqa: E501
        if 'akeyless_client_id' in params:
            header_params['AkeylessClientId'] = params['akeyless_client_id']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/auth-status', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='AuthStatusReplyObj',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_dynamic_secret_mq_access(self, item_name, **kwargs):  # noqa: E501
        """Get a signed request to receive messages from a Message Queue of a Dynamic Secret.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_dynamic_secret_mq_access(item_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str item_name: The dynamic secret item name (including the path to the item) (required)
        :param int wait_time_seconds: The duration (in seconds) for which the receive message request to the MQ waits for a message to arrive in the queue before returning. If a message is available, the call returns sooner than WaitTimeSeconds. If no messages are available and the wait time expires, the call returns successfully with an empty list of messages.
        :param int creds_expiry: The requested expiration time of the temporary credentials in minutes.
        :return: DynamicSecretMQAccessReplyObj
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_dynamic_secret_mq_access_with_http_info(item_name, **kwargs)  # noqa: E501
        else:
            (data) = self.get_dynamic_secret_mq_access_with_http_info(item_name, **kwargs)  # noqa: E501
            return data

    def get_dynamic_secret_mq_access_with_http_info(self, item_name, **kwargs):  # noqa: E501
        """Get a signed request to receive messages from a Message Queue of a Dynamic Secret.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_dynamic_secret_mq_access_with_http_info(item_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str item_name: The dynamic secret item name (including the path to the item) (required)
        :param int wait_time_seconds: The duration (in seconds) for which the receive message request to the MQ waits for a message to arrive in the queue before returning. If a message is available, the call returns sooner than WaitTimeSeconds. If no messages are available and the wait time expires, the call returns successfully with an empty list of messages.
        :param int creds_expiry: The requested expiration time of the temporary credentials in minutes.
        :return: DynamicSecretMQAccessReplyObj
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['item_name', 'wait_time_seconds', 'creds_expiry']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_dynamic_secret_mq_access" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'item_name' is set
        if ('item_name' not in params or
                params['item_name'] is None):
            raise ValueError("Missing the required parameter `item_name` when calling `get_dynamic_secret_mq_access`")  # noqa: E501

        if 'wait_time_seconds' in params and params['wait_time_seconds'] > 20:  # noqa: E501
            raise ValueError("Invalid value for parameter `wait_time_seconds` when calling `get_dynamic_secret_mq_access`, must be a value less than or equal to `20`")  # noqa: E501
        if 'wait_time_seconds' in params and params['wait_time_seconds'] < 0:  # noqa: E501
            raise ValueError("Invalid value for parameter `wait_time_seconds` when calling `get_dynamic_secret_mq_access`, must be a value greater than or equal to `0`")  # noqa: E501
        if 'creds_expiry' in params and params['creds_expiry'] > 60:  # noqa: E501
            raise ValueError("Invalid value for parameter `creds_expiry` when calling `get_dynamic_secret_mq_access`, must be a value less than or equal to `60`")  # noqa: E501
        if 'creds_expiry' in params and params['creds_expiry'] < 2:  # noqa: E501
            raise ValueError("Invalid value for parameter `creds_expiry` when calling `get_dynamic_secret_mq_access`, must be a value greater than or equal to `2`")  # noqa: E501
        collection_formats = {}

        path_params = {}

        query_params = []
        if 'item_name' in params:
            query_params.append(('item_name', params['item_name']))  # noqa: E501
        if 'wait_time_seconds' in params:
            query_params.append(('wait_time_seconds', params['wait_time_seconds']))  # noqa: E501
        if 'creds_expiry' in params:
            query_params.append(('creds_expiry', params['creds_expiry']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/dynamic-secret-mq-access', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='DynamicSecretMQAccessReplyObj',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_dynamic_secret_producer_creds(self, item_name, dynamic_secret_value_id, consumer_protection_key_derivation_creds, message_receipt_handle, **kwargs):  # noqa: E501
        """Get a dynamic secret producer derivation credentials.  # noqa: E501

        This endpoint is used by the dynamic secret producer that listens to encrypt the new dynamic secret value.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_dynamic_secret_producer_creds(item_name, dynamic_secret_value_id, consumer_protection_key_derivation_creds, message_receipt_handle, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str item_name: The dynamic secret item name (including the path to the item) (required)
        :param str dynamic_secret_value_id: The ID of the new dynamic secret value to be encrypt (required)
        :param str consumer_protection_key_derivation_creds: The credentials issued when preparing for the new value. The consumer that pull the dynamic secret value received them on the prepareDynamicSecretValue request and the dynamic secret producer that encrypt and push the value received them from the dynamic secret message queue. (required)
        :param str message_receipt_handle: The receipt handle received from the dynamic secret MQ (required)
        :param int creds_expiry: The requested expiration time of the temporary credentials in minutes.
        :return: DynamicSecretProducerCredsReplyObj
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_dynamic_secret_producer_creds_with_http_info(item_name, dynamic_secret_value_id, consumer_protection_key_derivation_creds, message_receipt_handle, **kwargs)  # noqa: E501
        else:
            (data) = self.get_dynamic_secret_producer_creds_with_http_info(item_name, dynamic_secret_value_id, consumer_protection_key_derivation_creds, message_receipt_handle, **kwargs)  # noqa: E501
            return data

    def get_dynamic_secret_producer_creds_with_http_info(self, item_name, dynamic_secret_value_id, consumer_protection_key_derivation_creds, message_receipt_handle, **kwargs):  # noqa: E501
        """Get a dynamic secret producer derivation credentials.  # noqa: E501

        This endpoint is used by the dynamic secret producer that listens to encrypt the new dynamic secret value.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_dynamic_secret_producer_creds_with_http_info(item_name, dynamic_secret_value_id, consumer_protection_key_derivation_creds, message_receipt_handle, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str item_name: The dynamic secret item name (including the path to the item) (required)
        :param str dynamic_secret_value_id: The ID of the new dynamic secret value to be encrypt (required)
        :param str consumer_protection_key_derivation_creds: The credentials issued when preparing for the new value. The consumer that pull the dynamic secret value received them on the prepareDynamicSecretValue request and the dynamic secret producer that encrypt and push the value received them from the dynamic secret message queue. (required)
        :param str message_receipt_handle: The receipt handle received from the dynamic secret MQ (required)
        :param int creds_expiry: The requested expiration time of the temporary credentials in minutes.
        :return: DynamicSecretProducerCredsReplyObj
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['item_name', 'dynamic_secret_value_id', 'consumer_protection_key_derivation_creds', 'message_receipt_handle', 'creds_expiry']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_dynamic_secret_producer_creds" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'item_name' is set
        if ('item_name' not in params or
                params['item_name'] is None):
            raise ValueError("Missing the required parameter `item_name` when calling `get_dynamic_secret_producer_creds`")  # noqa: E501
        # verify the required parameter 'dynamic_secret_value_id' is set
        if ('dynamic_secret_value_id' not in params or
                params['dynamic_secret_value_id'] is None):
            raise ValueError("Missing the required parameter `dynamic_secret_value_id` when calling `get_dynamic_secret_producer_creds`")  # noqa: E501
        # verify the required parameter 'consumer_protection_key_derivation_creds' is set
        if ('consumer_protection_key_derivation_creds' not in params or
                params['consumer_protection_key_derivation_creds'] is None):
            raise ValueError("Missing the required parameter `consumer_protection_key_derivation_creds` when calling `get_dynamic_secret_producer_creds`")  # noqa: E501
        # verify the required parameter 'message_receipt_handle' is set
        if ('message_receipt_handle' not in params or
                params['message_receipt_handle'] is None):
            raise ValueError("Missing the required parameter `message_receipt_handle` when calling `get_dynamic_secret_producer_creds`")  # noqa: E501

        if 'creds_expiry' in params and params['creds_expiry'] > 60:  # noqa: E501
            raise ValueError("Invalid value for parameter `creds_expiry` when calling `get_dynamic_secret_producer_creds`, must be a value less than or equal to `60`")  # noqa: E501
        if 'creds_expiry' in params and params['creds_expiry'] < 2:  # noqa: E501
            raise ValueError("Invalid value for parameter `creds_expiry` when calling `get_dynamic_secret_producer_creds`, must be a value greater than or equal to `2`")  # noqa: E501
        collection_formats = {}

        path_params = {}

        query_params = []
        if 'item_name' in params:
            query_params.append(('item_name', params['item_name']))  # noqa: E501
        if 'dynamic_secret_value_id' in params:
            query_params.append(('dynamic_secret_value_id', params['dynamic_secret_value_id']))  # noqa: E501
        if 'consumer_protection_key_derivation_creds' in params:
            query_params.append(('consumer_protection_key_derivation_creds', params['consumer_protection_key_derivation_creds']))  # noqa: E501
        if 'message_receipt_handle' in params:
            query_params.append(('message_receipt_handle', params['message_receipt_handle']))  # noqa: E501
        if 'creds_expiry' in params:
            query_params.append(('creds_expiry', params['creds_expiry']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/dynamic-secret-producer-cred', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='DynamicSecretProducerCredsReplyObj',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_item(self, akeyless_uam_access_creds, item_name, **kwargs):  # noqa: E501
        """Get item details.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_item(akeyless_uam_access_creds, item_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str akeyless_uam_access_creds: Temporary credentials for accessing the endpoint (required)
        :param str item_name: Item name (including the path to the item). (required)
        :param str akeyless_request_id: Request Id for logging
        :param str akeyless_client_id: Client Id for logging
        :param int item_version: The item version (for item attributes that are unique to each version). If it is empty, the item attributes of the latest version will be returned
        :return: GetItemReplyObj
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_item_with_http_info(akeyless_uam_access_creds, item_name, **kwargs)  # noqa: E501
        else:
            (data) = self.get_item_with_http_info(akeyless_uam_access_creds, item_name, **kwargs)  # noqa: E501
            return data

    def get_item_with_http_info(self, akeyless_uam_access_creds, item_name, **kwargs):  # noqa: E501
        """Get item details.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_item_with_http_info(akeyless_uam_access_creds, item_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str akeyless_uam_access_creds: Temporary credentials for accessing the endpoint (required)
        :param str item_name: Item name (including the path to the item). (required)
        :param str akeyless_request_id: Request Id for logging
        :param str akeyless_client_id: Client Id for logging
        :param int item_version: The item version (for item attributes that are unique to each version). If it is empty, the item attributes of the latest version will be returned
        :return: GetItemReplyObj
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['akeyless_uam_access_creds', 'item_name', 'akeyless_request_id', 'akeyless_client_id', 'item_version']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_item" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'akeyless_uam_access_creds' is set
        if ('akeyless_uam_access_creds' not in params or
                params['akeyless_uam_access_creds'] is None):
            raise ValueError("Missing the required parameter `akeyless_uam_access_creds` when calling `get_item`")  # noqa: E501
        # verify the required parameter 'item_name' is set
        if ('item_name' not in params or
                params['item_name'] is None):
            raise ValueError("Missing the required parameter `item_name` when calling `get_item`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'item_name' in params:
            query_params.append(('item_name', params['item_name']))  # noqa: E501
        if 'item_version' in params:
            query_params.append(('item_version', params['item_version']))  # noqa: E501

        header_params = {}
        if 'akeyless_request_id' in params:
            header_params['AkeylessRequestId'] = params['akeyless_request_id']  # noqa: E501
        if 'akeyless_client_id' in params:
            header_params['AkeylessClientId'] = params['akeyless_client_id']  # noqa: E501
        if 'akeyless_uam_access_creds' in params:
            header_params['AkeylessUAM-AccessCreds'] = params['akeyless_uam_access_creds']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/item', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='GetItemReplyObj',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_item_derivation_creds(self, akeyless_uam_access_creds, item_name, **kwargs):  # noqa: E501
        """Get temporary access credentials to KFM instances for item's fragments derivation.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_item_derivation_creds(akeyless_uam_access_creds, item_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str akeyless_uam_access_creds: Temporary credentials for accessing the endpoint (required)
        :param str item_name: The item name for derivation (including the path to the item) (required)
        :param str akeyless_request_id: Request Id for logging
        :param str akeyless_client_id: Client Id for logging
        :param int item_version: The item version. If it is empty, the derivation credentials will be returned for the latest item version
        :param str restricted_derivation_data: In case not empty, the derivation credentials will be restricted only to this derivation data
        :param int creds_expiry: The requested expiration time of the temporary credentials in minutes.
        :return: DerivationCredsReplyObj
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_item_derivation_creds_with_http_info(akeyless_uam_access_creds, item_name, **kwargs)  # noqa: E501
        else:
            (data) = self.get_item_derivation_creds_with_http_info(akeyless_uam_access_creds, item_name, **kwargs)  # noqa: E501
            return data

    def get_item_derivation_creds_with_http_info(self, akeyless_uam_access_creds, item_name, **kwargs):  # noqa: E501
        """Get temporary access credentials to KFM instances for item's fragments derivation.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_item_derivation_creds_with_http_info(akeyless_uam_access_creds, item_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str akeyless_uam_access_creds: Temporary credentials for accessing the endpoint (required)
        :param str item_name: The item name for derivation (including the path to the item) (required)
        :param str akeyless_request_id: Request Id for logging
        :param str akeyless_client_id: Client Id for logging
        :param int item_version: The item version. If it is empty, the derivation credentials will be returned for the latest item version
        :param str restricted_derivation_data: In case not empty, the derivation credentials will be restricted only to this derivation data
        :param int creds_expiry: The requested expiration time of the temporary credentials in minutes.
        :return: DerivationCredsReplyObj
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['akeyless_uam_access_creds', 'item_name', 'akeyless_request_id', 'akeyless_client_id', 'item_version', 'restricted_derivation_data', 'creds_expiry']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_item_derivation_creds" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'akeyless_uam_access_creds' is set
        if ('akeyless_uam_access_creds' not in params or
                params['akeyless_uam_access_creds'] is None):
            raise ValueError("Missing the required parameter `akeyless_uam_access_creds` when calling `get_item_derivation_creds`")  # noqa: E501
        # verify the required parameter 'item_name' is set
        if ('item_name' not in params or
                params['item_name'] is None):
            raise ValueError("Missing the required parameter `item_name` when calling `get_item_derivation_creds`")  # noqa: E501

        if 'creds_expiry' in params and params['creds_expiry'] > 60:  # noqa: E501
            raise ValueError("Invalid value for parameter `creds_expiry` when calling `get_item_derivation_creds`, must be a value less than or equal to `60`")  # noqa: E501
        if 'creds_expiry' in params and params['creds_expiry'] < 2:  # noqa: E501
            raise ValueError("Invalid value for parameter `creds_expiry` when calling `get_item_derivation_creds`, must be a value greater than or equal to `2`")  # noqa: E501
        collection_formats = {}

        path_params = {}

        query_params = []
        if 'item_name' in params:
            query_params.append(('item_name', params['item_name']))  # noqa: E501
        if 'item_version' in params:
            query_params.append(('item_version', params['item_version']))  # noqa: E501
        if 'restricted_derivation_data' in params:
            query_params.append(('restricted_derivation_data', params['restricted_derivation_data']))  # noqa: E501
        if 'creds_expiry' in params:
            query_params.append(('creds_expiry', params['creds_expiry']))  # noqa: E501

        header_params = {}
        if 'akeyless_request_id' in params:
            header_params['AkeylessRequestId'] = params['akeyless_request_id']  # noqa: E501
        if 'akeyless_client_id' in params:
            header_params['AkeylessClientId'] = params['akeyless_client_id']  # noqa: E501
        if 'akeyless_uam_access_creds' in params:
            header_params['AkeylessUAM-AccessCreds'] = params['akeyless_uam_access_creds']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/derivation-creds', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='DerivationCredsReplyObj',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_public_signing_key(self, signing_key_id, **kwargs):  # noqa: E501
        """Getting the public part of the key used by Auth to sign the temporary access credentials.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_public_signing_key(signing_key_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str signing_key_id: The ID of the key used by Auth to sign the temporary access credentials. (required)
        :return: PublicSigningKeyReplyObj
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_public_signing_key_with_http_info(signing_key_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_public_signing_key_with_http_info(signing_key_id, **kwargs)  # noqa: E501
            return data

    def get_public_signing_key_with_http_info(self, signing_key_id, **kwargs):  # noqa: E501
        """Getting the public part of the key used by Auth to sign the temporary access credentials.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_public_signing_key_with_http_info(signing_key_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str signing_key_id: The ID of the key used by Auth to sign the temporary access credentials. (required)
        :return: PublicSigningKeyReplyObj
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['signing_key_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_public_signing_key" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'signing_key_id' is set
        if ('signing_key_id' not in params or
                params['signing_key_id'] is None):
            raise ValueError("Missing the required parameter `signing_key_id` when calling `get_public_signing_key`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'signing_key_id' in params:
            path_params['signing_key_id'] = params['signing_key_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/public-signing-key/{signing_key_id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PublicSigningKeyReplyObj',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_role(self, akeyless_uam_access_creds, role_name, **kwargs):  # noqa: E501
        """Get role details.  # noqa: E501

        This endpoint is accessible only by an admin  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_role(akeyless_uam_access_creds, role_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str akeyless_uam_access_creds: Temporary credentials for accessing the endpoint (required)
        :param str role_name: Role name. (required)
        :param str akeyless_request_id: Request Id for logging
        :param str akeyless_client_id: Client Id for logging
        :return: GetRoleReplyObj
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_role_with_http_info(akeyless_uam_access_creds, role_name, **kwargs)  # noqa: E501
        else:
            (data) = self.get_role_with_http_info(akeyless_uam_access_creds, role_name, **kwargs)  # noqa: E501
            return data

    def get_role_with_http_info(self, akeyless_uam_access_creds, role_name, **kwargs):  # noqa: E501
        """Get role details.  # noqa: E501

        This endpoint is accessible only by an admin  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_role_with_http_info(akeyless_uam_access_creds, role_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str akeyless_uam_access_creds: Temporary credentials for accessing the endpoint (required)
        :param str role_name: Role name. (required)
        :param str akeyless_request_id: Request Id for logging
        :param str akeyless_client_id: Client Id for logging
        :return: GetRoleReplyObj
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['akeyless_uam_access_creds', 'role_name', 'akeyless_request_id', 'akeyless_client_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_role" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'akeyless_uam_access_creds' is set
        if ('akeyless_uam_access_creds' not in params or
                params['akeyless_uam_access_creds'] is None):
            raise ValueError("Missing the required parameter `akeyless_uam_access_creds` when calling `get_role`")  # noqa: E501
        # verify the required parameter 'role_name' is set
        if ('role_name' not in params or
                params['role_name'] is None):
            raise ValueError("Missing the required parameter `role_name` when calling `get_role`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'role_name' in params:
            path_params['role_name'] = params['role_name']  # noqa: E501

        query_params = []

        header_params = {}
        if 'akeyless_request_id' in params:
            header_params['AkeylessRequestId'] = params['akeyless_request_id']  # noqa: E501
        if 'akeyless_client_id' in params:
            header_params['AkeylessClientId'] = params['akeyless_client_id']  # noqa: E501
        if 'akeyless_uam_access_creds' in params:
            header_params['AkeylessUAM-AccessCreds'] = params['akeyless_uam_access_creds']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/role/{role_name}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='GetRoleReplyObj',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_rsa_key_decrypt_creds(self, akeyless_uam_access_creds, item_name, **kwargs):  # noqa: E501
        """Get temporary access credentials to KFM instances for RSA key fragments decryption.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_rsa_key_decrypt_creds(akeyless_uam_access_creds, item_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str akeyless_uam_access_creds: Temporary credentials for accessing the endpoint (required)
        :param str item_name: The item name for decrypt operation (including the path to the item) (required)
        :param str akeyless_request_id: Request Id for logging
        :param str akeyless_client_id: Client Id for logging
        :param int item_version: The item version. If it is empty, the RSA decrypt credentials will be returned for the latest item version
        :param str restricted_cipher: In case not empty, the RSA decrypt credentials will be restricted only to this cipher
        :param int creds_expiry: The requested expiration time of the temporary credentials in minutes.
        :return: RSADecryptCredsReplyObj
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_rsa_key_decrypt_creds_with_http_info(akeyless_uam_access_creds, item_name, **kwargs)  # noqa: E501
        else:
            (data) = self.get_rsa_key_decrypt_creds_with_http_info(akeyless_uam_access_creds, item_name, **kwargs)  # noqa: E501
            return data

    def get_rsa_key_decrypt_creds_with_http_info(self, akeyless_uam_access_creds, item_name, **kwargs):  # noqa: E501
        """Get temporary access credentials to KFM instances for RSA key fragments decryption.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_rsa_key_decrypt_creds_with_http_info(akeyless_uam_access_creds, item_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str akeyless_uam_access_creds: Temporary credentials for accessing the endpoint (required)
        :param str item_name: The item name for decrypt operation (including the path to the item) (required)
        :param str akeyless_request_id: Request Id for logging
        :param str akeyless_client_id: Client Id for logging
        :param int item_version: The item version. If it is empty, the RSA decrypt credentials will be returned for the latest item version
        :param str restricted_cipher: In case not empty, the RSA decrypt credentials will be restricted only to this cipher
        :param int creds_expiry: The requested expiration time of the temporary credentials in minutes.
        :return: RSADecryptCredsReplyObj
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['akeyless_uam_access_creds', 'item_name', 'akeyless_request_id', 'akeyless_client_id', 'item_version', 'restricted_cipher', 'creds_expiry']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_rsa_key_decrypt_creds" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'akeyless_uam_access_creds' is set
        if ('akeyless_uam_access_creds' not in params or
                params['akeyless_uam_access_creds'] is None):
            raise ValueError("Missing the required parameter `akeyless_uam_access_creds` when calling `get_rsa_key_decrypt_creds`")  # noqa: E501
        # verify the required parameter 'item_name' is set
        if ('item_name' not in params or
                params['item_name'] is None):
            raise ValueError("Missing the required parameter `item_name` when calling `get_rsa_key_decrypt_creds`")  # noqa: E501

        if 'creds_expiry' in params and params['creds_expiry'] > 60:  # noqa: E501
            raise ValueError("Invalid value for parameter `creds_expiry` when calling `get_rsa_key_decrypt_creds`, must be a value less than or equal to `60`")  # noqa: E501
        if 'creds_expiry' in params and params['creds_expiry'] < 2:  # noqa: E501
            raise ValueError("Invalid value for parameter `creds_expiry` when calling `get_rsa_key_decrypt_creds`, must be a value greater than or equal to `2`")  # noqa: E501
        collection_formats = {}

        path_params = {}

        query_params = []
        if 'item_name' in params:
            query_params.append(('item_name', params['item_name']))  # noqa: E501
        if 'item_version' in params:
            query_params.append(('item_version', params['item_version']))  # noqa: E501
        if 'restricted_cipher' in params:
            query_params.append(('restricted_cipher', params['restricted_cipher']))  # noqa: E501
        if 'creds_expiry' in params:
            query_params.append(('creds_expiry', params['creds_expiry']))  # noqa: E501

        header_params = {}
        if 'akeyless_request_id' in params:
            header_params['AkeylessRequestId'] = params['akeyless_request_id']  # noqa: E501
        if 'akeyless_client_id' in params:
            header_params['AkeylessClientId'] = params['akeyless_client_id']  # noqa: E501
        if 'akeyless_uam_access_creds' in params:
            header_params['AkeylessUAM-AccessCreds'] = params['akeyless_uam_access_creds']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/rsa-decrypt-creds', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='RSADecryptCredsReplyObj',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_secret_access_creds(self, akeyless_uam_access_creds, item_name, **kwargs):  # noqa: E501
        """get_secret_access_creds  # noqa: E501

        Get temporary access credentials to KFM instances for secret protection key derivation and the encrypted secret value.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_secret_access_creds(akeyless_uam_access_creds, item_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str akeyless_uam_access_creds: Temporary credentials for accessing the endpoint (required)
        :param str item_name: The secret item name (including the path to the item) (required)
        :param str akeyless_request_id: Request Id for logging
        :param str akeyless_client_id: Client Id for logging
        :param int item_version: The secret item version. If it is empty, the credentials will be returned for the latest secret item version
        :param int creds_expiry: The requested expiration time of the temporary credentials in minutes.
        :return: SecretAccessCredsReplyObj
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_secret_access_creds_with_http_info(akeyless_uam_access_creds, item_name, **kwargs)  # noqa: E501
        else:
            (data) = self.get_secret_access_creds_with_http_info(akeyless_uam_access_creds, item_name, **kwargs)  # noqa: E501
            return data

    def get_secret_access_creds_with_http_info(self, akeyless_uam_access_creds, item_name, **kwargs):  # noqa: E501
        """get_secret_access_creds  # noqa: E501

        Get temporary access credentials to KFM instances for secret protection key derivation and the encrypted secret value.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_secret_access_creds_with_http_info(akeyless_uam_access_creds, item_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str akeyless_uam_access_creds: Temporary credentials for accessing the endpoint (required)
        :param str item_name: The secret item name (including the path to the item) (required)
        :param str akeyless_request_id: Request Id for logging
        :param str akeyless_client_id: Client Id for logging
        :param int item_version: The secret item version. If it is empty, the credentials will be returned for the latest secret item version
        :param int creds_expiry: The requested expiration time of the temporary credentials in minutes.
        :return: SecretAccessCredsReplyObj
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['akeyless_uam_access_creds', 'item_name', 'akeyless_request_id', 'akeyless_client_id', 'item_version', 'creds_expiry']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_secret_access_creds" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'akeyless_uam_access_creds' is set
        if ('akeyless_uam_access_creds' not in params or
                params['akeyless_uam_access_creds'] is None):
            raise ValueError("Missing the required parameter `akeyless_uam_access_creds` when calling `get_secret_access_creds`")  # noqa: E501
        # verify the required parameter 'item_name' is set
        if ('item_name' not in params or
                params['item_name'] is None):
            raise ValueError("Missing the required parameter `item_name` when calling `get_secret_access_creds`")  # noqa: E501

        if 'creds_expiry' in params and params['creds_expiry'] > 60:  # noqa: E501
            raise ValueError("Invalid value for parameter `creds_expiry` when calling `get_secret_access_creds`, must be a value less than or equal to `60`")  # noqa: E501
        if 'creds_expiry' in params and params['creds_expiry'] < 2:  # noqa: E501
            raise ValueError("Invalid value for parameter `creds_expiry` when calling `get_secret_access_creds`, must be a value greater than or equal to `2`")  # noqa: E501
        collection_formats = {}

        path_params = {}

        query_params = []
        if 'item_name' in params:
            query_params.append(('item_name', params['item_name']))  # noqa: E501
        if 'item_version' in params:
            query_params.append(('item_version', params['item_version']))  # noqa: E501
        if 'creds_expiry' in params:
            query_params.append(('creds_expiry', params['creds_expiry']))  # noqa: E501

        header_params = {}
        if 'akeyless_request_id' in params:
            header_params['AkeylessRequestId'] = params['akeyless_request_id']  # noqa: E501
        if 'akeyless_client_id' in params:
            header_params['AkeylessClientId'] = params['akeyless_client_id']  # noqa: E501
        if 'akeyless_uam_access_creds' in params:
            header_params['AkeylessUAM-AccessCreds'] = params['akeyless_uam_access_creds']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/secret-access-creds', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='SecretAccessCredsReplyObj',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_ssh_cert_issuer_access_creds(self, item_name, client_pub_key, username, **kwargs):  # noqa: E501
        """Get temporary access credentials to KFM instances for signing a specific SSH certificate.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_ssh_cert_issuer_access_creds(item_name, client_pub_key, username, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str item_name: The SSH Cert Issuer item name (including the path to the item) (required)
        :param str client_pub_key: The client SSH public key to be included in the certificate (base64 format) (required)
        :param str username: The required username that the certificate should be signed for (required)
        :param int creds_expiry: The requested expiration time of the temporary credentials in minutes.
        :return: SSHCertIssuerAccessCredsReplyObj
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_ssh_cert_issuer_access_creds_with_http_info(item_name, client_pub_key, username, **kwargs)  # noqa: E501
        else:
            (data) = self.get_ssh_cert_issuer_access_creds_with_http_info(item_name, client_pub_key, username, **kwargs)  # noqa: E501
            return data

    def get_ssh_cert_issuer_access_creds_with_http_info(self, item_name, client_pub_key, username, **kwargs):  # noqa: E501
        """Get temporary access credentials to KFM instances for signing a specific SSH certificate.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_ssh_cert_issuer_access_creds_with_http_info(item_name, client_pub_key, username, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str item_name: The SSH Cert Issuer item name (including the path to the item) (required)
        :param str client_pub_key: The client SSH public key to be included in the certificate (base64 format) (required)
        :param str username: The required username that the certificate should be signed for (required)
        :param int creds_expiry: The requested expiration time of the temporary credentials in minutes.
        :return: SSHCertIssuerAccessCredsReplyObj
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['item_name', 'client_pub_key', 'username', 'creds_expiry']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_ssh_cert_issuer_access_creds" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'item_name' is set
        if ('item_name' not in params or
                params['item_name'] is None):
            raise ValueError("Missing the required parameter `item_name` when calling `get_ssh_cert_issuer_access_creds`")  # noqa: E501
        # verify the required parameter 'client_pub_key' is set
        if ('client_pub_key' not in params or
                params['client_pub_key'] is None):
            raise ValueError("Missing the required parameter `client_pub_key` when calling `get_ssh_cert_issuer_access_creds`")  # noqa: E501
        # verify the required parameter 'username' is set
        if ('username' not in params or
                params['username'] is None):
            raise ValueError("Missing the required parameter `username` when calling `get_ssh_cert_issuer_access_creds`")  # noqa: E501

        if 'creds_expiry' in params and params['creds_expiry'] > 60:  # noqa: E501
            raise ValueError("Invalid value for parameter `creds_expiry` when calling `get_ssh_cert_issuer_access_creds`, must be a value less than or equal to `60`")  # noqa: E501
        if 'creds_expiry' in params and params['creds_expiry'] < 2:  # noqa: E501
            raise ValueError("Invalid value for parameter `creds_expiry` when calling `get_ssh_cert_issuer_access_creds`, must be a value greater than or equal to `2`")  # noqa: E501
        collection_formats = {}

        path_params = {}

        query_params = []
        if 'item_name' in params:
            query_params.append(('item_name', params['item_name']))  # noqa: E501
        if 'client_pub_key' in params:
            query_params.append(('client_pub_key', params['client_pub_key']))  # noqa: E501
        if 'username' in params:
            query_params.append(('username', params['username']))  # noqa: E501
        if 'creds_expiry' in params:
            query_params.append(('creds_expiry', params['creds_expiry']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/ssh-cert-issuer-access-creds', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='SSHCertIssuerAccessCredsReplyObj',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_status(self, **kwargs):  # noqa: E501
        """get_status  # noqa: E501

        Get UAM server status  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_status(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str akeyless_request_id: Request Id for logging
        :param str akeyless_client_id: Client Id for logging
        :return: UAMStatusReplyObj
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_status_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_status_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_status_with_http_info(self, **kwargs):  # noqa: E501
        """get_status  # noqa: E501

        Get UAM server status  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_status_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str akeyless_request_id: Request Id for logging
        :param str akeyless_client_id: Client Id for logging
        :return: UAMStatusReplyObj
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['akeyless_request_id', 'akeyless_client_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_status" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}
        if 'akeyless_request_id' in params:
            header_params['AkeylessRequestId'] = params['akeyless_request_id']  # noqa: E501
        if 'akeyless_client_id' in params:
            header_params['AkeylessClientId'] = params['akeyless_client_id']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/status', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='UAMStatusReplyObj',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_time(self, **kwargs):  # noqa: E501
        """get_time  # noqa: E501

        Get Auth server time  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_time(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str akeyless_request_id: Request Id for logging
        :param str akeyless_client_id: Client Id for logging
        :return: TimeReplyObj
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_time_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_time_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_time_with_http_info(self, **kwargs):  # noqa: E501
        """get_time  # noqa: E501

        Get Auth server time  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_time_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str akeyless_request_id: Request Id for logging
        :param str akeyless_client_id: Client Id for logging
        :return: TimeReplyObj
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['akeyless_request_id', 'akeyless_client_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_time" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}
        if 'akeyless_request_id' in params:
            header_params['AkeylessRequestId'] = params['akeyless_request_id']  # noqa: E501
        if 'akeyless_client_id' in params:
            header_params['AkeylessClientId'] = params['akeyless_client_id']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/time', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='TimeReplyObj',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_upload_rsa_key_creds(self, akeyless_uam_access_creds, item_name, item_type, public_value, split_level, **kwargs):  # noqa: E501
        """Get temporary access credentials to upload RSA private key fragments into KFMs instances.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_upload_rsa_key_creds(akeyless_uam_access_creds, item_name, item_type, public_value, split_level, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str akeyless_uam_access_creds: Temporary credentials for accessing the endpoint (required)
        :param str item_name: The RSA key name (including the path to the item). (required)
        :param str item_type: The RSA key type Types available are: [KEY_RSA1024, KEY_RSA2048] (required)
        :param str public_value: The value of the RSA public key . (required)
        :param int split_level: The splitting level represent the number of fragments that the key will be split into. (required)
        :param str akeyless_request_id: Request Id for logging
        :param str akeyless_client_id: Client Id for logging
        :param str certificates: The certificates associated with the RSA key.
        :param str item_metadata: The metadata about the key.
        :param str customer_fragment_id: The customer fragment ID associated with this item (if any).
        :param int creds_expiry: The requested expiration time of the temporary credentials in minutes.
        :return: UploadRSAKeyCredsReplyObj
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_upload_rsa_key_creds_with_http_info(akeyless_uam_access_creds, item_name, item_type, public_value, split_level, **kwargs)  # noqa: E501
        else:
            (data) = self.get_upload_rsa_key_creds_with_http_info(akeyless_uam_access_creds, item_name, item_type, public_value, split_level, **kwargs)  # noqa: E501
            return data

    def get_upload_rsa_key_creds_with_http_info(self, akeyless_uam_access_creds, item_name, item_type, public_value, split_level, **kwargs):  # noqa: E501
        """Get temporary access credentials to upload RSA private key fragments into KFMs instances.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_upload_rsa_key_creds_with_http_info(akeyless_uam_access_creds, item_name, item_type, public_value, split_level, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str akeyless_uam_access_creds: Temporary credentials for accessing the endpoint (required)
        :param str item_name: The RSA key name (including the path to the item). (required)
        :param str item_type: The RSA key type Types available are: [KEY_RSA1024, KEY_RSA2048] (required)
        :param str public_value: The value of the RSA public key . (required)
        :param int split_level: The splitting level represent the number of fragments that the key will be split into. (required)
        :param str akeyless_request_id: Request Id for logging
        :param str akeyless_client_id: Client Id for logging
        :param str certificates: The certificates associated with the RSA key.
        :param str item_metadata: The metadata about the key.
        :param str customer_fragment_id: The customer fragment ID associated with this item (if any).
        :param int creds_expiry: The requested expiration time of the temporary credentials in minutes.
        :return: UploadRSAKeyCredsReplyObj
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['akeyless_uam_access_creds', 'item_name', 'item_type', 'public_value', 'split_level', 'akeyless_request_id', 'akeyless_client_id', 'certificates', 'item_metadata', 'customer_fragment_id', 'creds_expiry']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_upload_rsa_key_creds" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'akeyless_uam_access_creds' is set
        if ('akeyless_uam_access_creds' not in params or
                params['akeyless_uam_access_creds'] is None):
            raise ValueError("Missing the required parameter `akeyless_uam_access_creds` when calling `get_upload_rsa_key_creds`")  # noqa: E501
        # verify the required parameter 'item_name' is set
        if ('item_name' not in params or
                params['item_name'] is None):
            raise ValueError("Missing the required parameter `item_name` when calling `get_upload_rsa_key_creds`")  # noqa: E501
        # verify the required parameter 'item_type' is set
        if ('item_type' not in params or
                params['item_type'] is None):
            raise ValueError("Missing the required parameter `item_type` when calling `get_upload_rsa_key_creds`")  # noqa: E501
        # verify the required parameter 'public_value' is set
        if ('public_value' not in params or
                params['public_value'] is None):
            raise ValueError("Missing the required parameter `public_value` when calling `get_upload_rsa_key_creds`")  # noqa: E501
        # verify the required parameter 'split_level' is set
        if ('split_level' not in params or
                params['split_level'] is None):
            raise ValueError("Missing the required parameter `split_level` when calling `get_upload_rsa_key_creds`")  # noqa: E501

        if 'creds_expiry' in params and params['creds_expiry'] > 60:  # noqa: E501
            raise ValueError("Invalid value for parameter `creds_expiry` when calling `get_upload_rsa_key_creds`, must be a value less than or equal to `60`")  # noqa: E501
        if 'creds_expiry' in params and params['creds_expiry'] < 2:  # noqa: E501
            raise ValueError("Invalid value for parameter `creds_expiry` when calling `get_upload_rsa_key_creds`, must be a value greater than or equal to `2`")  # noqa: E501
        collection_formats = {}

        path_params = {}

        query_params = []
        if 'item_name' in params:
            query_params.append(('item_name', params['item_name']))  # noqa: E501
        if 'item_type' in params:
            query_params.append(('item_type', params['item_type']))  # noqa: E501
        if 'public_value' in params:
            query_params.append(('public_value', params['public_value']))  # noqa: E501
        if 'certificates' in params:
            query_params.append(('certificates', params['certificates']))  # noqa: E501
        if 'item_metadata' in params:
            query_params.append(('item_metadata', params['item_metadata']))  # noqa: E501
        if 'split_level' in params:
            query_params.append(('split_level', params['split_level']))  # noqa: E501
        if 'customer_fragment_id' in params:
            query_params.append(('customer_fragment_id', params['customer_fragment_id']))  # noqa: E501
        if 'creds_expiry' in params:
            query_params.append(('creds_expiry', params['creds_expiry']))  # noqa: E501

        header_params = {}
        if 'akeyless_request_id' in params:
            header_params['AkeylessRequestId'] = params['akeyless_request_id']  # noqa: E501
        if 'akeyless_client_id' in params:
            header_params['AkeylessClientId'] = params['akeyless_client_id']  # noqa: E501
        if 'akeyless_uam_access_creds' in params:
            header_params['AkeylessUAM-AccessCreds'] = params['akeyless_uam_access_creds']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/upload-rsa-key-creds', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='UploadRSAKeyCredsReplyObj',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_upload_secret_creds(self, akeyless_uam_access_creds, secret_name, **kwargs):  # noqa: E501
        """Get temporary access credentials to KFM instances to produce the derived protection key of the secret.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_upload_secret_creds(akeyless_uam_access_creds, secret_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str akeyless_uam_access_creds: Temporary credentials for accessing the endpoint (required)
        :param str secret_name: The secret name. (required)
        :param str akeyless_request_id: Request Id for logging
        :param str akeyless_client_id: Client Id for logging
        :param str protection_key_name: The name of the key that will be used to encrypt the secret. If not provided, the account default secret key will be used.
        :param int creds_expiry: The requested expiration time of the temporary credentials in minutes.
        :return: DerivationCredsReplyObj
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_upload_secret_creds_with_http_info(akeyless_uam_access_creds, secret_name, **kwargs)  # noqa: E501
        else:
            (data) = self.get_upload_secret_creds_with_http_info(akeyless_uam_access_creds, secret_name, **kwargs)  # noqa: E501
            return data

    def get_upload_secret_creds_with_http_info(self, akeyless_uam_access_creds, secret_name, **kwargs):  # noqa: E501
        """Get temporary access credentials to KFM instances to produce the derived protection key of the secret.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_upload_secret_creds_with_http_info(akeyless_uam_access_creds, secret_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str akeyless_uam_access_creds: Temporary credentials for accessing the endpoint (required)
        :param str secret_name: The secret name. (required)
        :param str akeyless_request_id: Request Id for logging
        :param str akeyless_client_id: Client Id for logging
        :param str protection_key_name: The name of the key that will be used to encrypt the secret. If not provided, the account default secret key will be used.
        :param int creds_expiry: The requested expiration time of the temporary credentials in minutes.
        :return: DerivationCredsReplyObj
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['akeyless_uam_access_creds', 'secret_name', 'akeyless_request_id', 'akeyless_client_id', 'protection_key_name', 'creds_expiry']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_upload_secret_creds" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'akeyless_uam_access_creds' is set
        if ('akeyless_uam_access_creds' not in params or
                params['akeyless_uam_access_creds'] is None):
            raise ValueError("Missing the required parameter `akeyless_uam_access_creds` when calling `get_upload_secret_creds`")  # noqa: E501
        # verify the required parameter 'secret_name' is set
        if ('secret_name' not in params or
                params['secret_name'] is None):
            raise ValueError("Missing the required parameter `secret_name` when calling `get_upload_secret_creds`")  # noqa: E501

        if 'creds_expiry' in params and params['creds_expiry'] > 60:  # noqa: E501
            raise ValueError("Invalid value for parameter `creds_expiry` when calling `get_upload_secret_creds`, must be a value less than or equal to `60`")  # noqa: E501
        if 'creds_expiry' in params and params['creds_expiry'] < 2:  # noqa: E501
            raise ValueError("Invalid value for parameter `creds_expiry` when calling `get_upload_secret_creds`, must be a value greater than or equal to `2`")  # noqa: E501
        collection_formats = {}

        path_params = {}

        query_params = []
        if 'secret_name' in params:
            query_params.append(('secret_name', params['secret_name']))  # noqa: E501
        if 'protection_key_name' in params:
            query_params.append(('protection_key_name', params['protection_key_name']))  # noqa: E501
        if 'creds_expiry' in params:
            query_params.append(('creds_expiry', params['creds_expiry']))  # noqa: E501

        header_params = {}
        if 'akeyless_request_id' in params:
            header_params['AkeylessRequestId'] = params['akeyless_request_id']  # noqa: E501
        if 'akeyless_client_id' in params:
            header_params['AkeylessClientId'] = params['akeyless_client_id']  # noqa: E501
        if 'akeyless_uam_access_creds' in params:
            header_params['AkeylessUAM-AccessCreds'] = params['akeyless_uam_access_creds']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/upload-secret-creds', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='DerivationCredsReplyObj',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def list_items(self, akeyless_uam_access_creds, **kwargs):  # noqa: E501
        """List all the accessible items.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_items(akeyless_uam_access_creds, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str akeyless_uam_access_creds: Temporary credentials for accessing the endpoint (required)
        :param str akeyless_request_id: Request Id for logging
        :param str akeyless_client_id: Client Id for logging
        :param str item_types: The item types list of the requested items . In case it is empty, all types of items will be returned. The format of the item types list is a comma-separated list of a valid item types. Valid opinions are - \"AES128GCM,AES256GCM,AES128SIV,AES256SIV,RSA1024,RSA2048,STATIC_SECRET,DYNAMIC_SECRE,SSH_CERT_ISSUERT\"
        :return: ListItemsReplyObj
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.list_items_with_http_info(akeyless_uam_access_creds, **kwargs)  # noqa: E501
        else:
            (data) = self.list_items_with_http_info(akeyless_uam_access_creds, **kwargs)  # noqa: E501
            return data

    def list_items_with_http_info(self, akeyless_uam_access_creds, **kwargs):  # noqa: E501
        """List all the accessible items.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_items_with_http_info(akeyless_uam_access_creds, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str akeyless_uam_access_creds: Temporary credentials for accessing the endpoint (required)
        :param str akeyless_request_id: Request Id for logging
        :param str akeyless_client_id: Client Id for logging
        :param str item_types: The item types list of the requested items . In case it is empty, all types of items will be returned. The format of the item types list is a comma-separated list of a valid item types. Valid opinions are - \"AES128GCM,AES256GCM,AES128SIV,AES256SIV,RSA1024,RSA2048,STATIC_SECRET,DYNAMIC_SECRE,SSH_CERT_ISSUERT\"
        :return: ListItemsReplyObj
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['akeyless_uam_access_creds', 'akeyless_request_id', 'akeyless_client_id', 'item_types']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_items" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'akeyless_uam_access_creds' is set
        if ('akeyless_uam_access_creds' not in params or
                params['akeyless_uam_access_creds'] is None):
            raise ValueError("Missing the required parameter `akeyless_uam_access_creds` when calling `list_items`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'item_types' in params:
            query_params.append(('item_types', params['item_types']))  # noqa: E501

        header_params = {}
        if 'akeyless_request_id' in params:
            header_params['AkeylessRequestId'] = params['akeyless_request_id']  # noqa: E501
        if 'akeyless_client_id' in params:
            header_params['AkeylessClientId'] = params['akeyless_client_id']  # noqa: E501
        if 'akeyless_uam_access_creds' in params:
            header_params['AkeylessUAM-AccessCreds'] = params['akeyless_uam_access_creds']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/items', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ListItemsReplyObj',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def list_items_in_path(self, akeyless_uam_access_creds, path, **kwargs):  # noqa: E501
        """List items at the given path.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_items_in_path(akeyless_uam_access_creds, path, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str akeyless_uam_access_creds: Temporary credentials for accessing the endpoint (required)
        :param str path: The path from which the list of the items and folders is returned (required)
        :param str akeyless_request_id: Request Id for logging
        :param str akeyless_client_id: Client Id for logging
        :param str item_types: The item types list of the requested items . In case it is empty, all types of items will be returned. The format of the item types list is a comma-separated list of a valid item types. Valid opinions are - \"AES128GCM,AES256GCM,AES128SIV,AES256SIV,RSA1024,RSA2048,STATIC_SECRET,DYNAMIC_SECRET,DYNAMIC_SECRET,SSH_CERT_ISSUER\"
        :param bool includes_folders: Include in the list the folders in the requested path
        :return: ListItemsInPathReplyObj
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.list_items_in_path_with_http_info(akeyless_uam_access_creds, path, **kwargs)  # noqa: E501
        else:
            (data) = self.list_items_in_path_with_http_info(akeyless_uam_access_creds, path, **kwargs)  # noqa: E501
            return data

    def list_items_in_path_with_http_info(self, akeyless_uam_access_creds, path, **kwargs):  # noqa: E501
        """List items at the given path.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_items_in_path_with_http_info(akeyless_uam_access_creds, path, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str akeyless_uam_access_creds: Temporary credentials for accessing the endpoint (required)
        :param str path: The path from which the list of the items and folders is returned (required)
        :param str akeyless_request_id: Request Id for logging
        :param str akeyless_client_id: Client Id for logging
        :param str item_types: The item types list of the requested items . In case it is empty, all types of items will be returned. The format of the item types list is a comma-separated list of a valid item types. Valid opinions are - \"AES128GCM,AES256GCM,AES128SIV,AES256SIV,RSA1024,RSA2048,STATIC_SECRET,DYNAMIC_SECRET,DYNAMIC_SECRET,SSH_CERT_ISSUER\"
        :param bool includes_folders: Include in the list the folders in the requested path
        :return: ListItemsInPathReplyObj
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['akeyless_uam_access_creds', 'path', 'akeyless_request_id', 'akeyless_client_id', 'item_types', 'includes_folders']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_items_in_path" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'akeyless_uam_access_creds' is set
        if ('akeyless_uam_access_creds' not in params or
                params['akeyless_uam_access_creds'] is None):
            raise ValueError("Missing the required parameter `akeyless_uam_access_creds` when calling `list_items_in_path`")  # noqa: E501
        # verify the required parameter 'path' is set
        if ('path' not in params or
                params['path'] is None):
            raise ValueError("Missing the required parameter `path` when calling `list_items_in_path`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'path' in params:
            query_params.append(('path', params['path']))  # noqa: E501
        if 'item_types' in params:
            query_params.append(('item_types', params['item_types']))  # noqa: E501
        if 'includes_folders' in params:
            query_params.append(('includes_folders', params['includes_folders']))  # noqa: E501

        header_params = {}
        if 'akeyless_request_id' in params:
            header_params['AkeylessRequestId'] = params['akeyless_request_id']  # noqa: E501
        if 'akeyless_client_id' in params:
            header_params['AkeylessClientId'] = params['akeyless_client_id']  # noqa: E501
        if 'akeyless_uam_access_creds' in params:
            header_params['AkeylessUAM-AccessCreds'] = params['akeyless_uam_access_creds']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/items-in-path', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ListItemsInPathReplyObj',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def prepare_dynamic_secret_value(self, item_name, dynamic_secret_val_preparation_data, **kwargs):  # noqa: E501
        """Get the new dynamic secret ID to be pull and derivation credentials to decrypt the new dynamic secret value.  # noqa: E501

        After the prepareDynamicSecretValue request, the consumer must perform a pullDynamicSecretValue request in order to receive the new value (wait about half a second between the prepareDynamicSecretValue request and the first pullDynamicSecretValue request, since it takes time for the dynamic secret producer to receive the request for a new dynamic secret value and to push a new one).  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.prepare_dynamic_secret_value(item_name, dynamic_secret_val_preparation_data, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str item_name: The dynamic secret item name (including the path to the item) (required)
        :param str dynamic_secret_val_preparation_data: An attached data by the client about the dynamic secret value preparation request (required)
        :param int creds_expiry: The requested expiration time of the temporary credentials in minutes.
        :return: PrepareDynamicSecretValueReplyObj
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.prepare_dynamic_secret_value_with_http_info(item_name, dynamic_secret_val_preparation_data, **kwargs)  # noqa: E501
        else:
            (data) = self.prepare_dynamic_secret_value_with_http_info(item_name, dynamic_secret_val_preparation_data, **kwargs)  # noqa: E501
            return data

    def prepare_dynamic_secret_value_with_http_info(self, item_name, dynamic_secret_val_preparation_data, **kwargs):  # noqa: E501
        """Get the new dynamic secret ID to be pull and derivation credentials to decrypt the new dynamic secret value.  # noqa: E501

        After the prepareDynamicSecretValue request, the consumer must perform a pullDynamicSecretValue request in order to receive the new value (wait about half a second between the prepareDynamicSecretValue request and the first pullDynamicSecretValue request, since it takes time for the dynamic secret producer to receive the request for a new dynamic secret value and to push a new one).  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.prepare_dynamic_secret_value_with_http_info(item_name, dynamic_secret_val_preparation_data, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str item_name: The dynamic secret item name (including the path to the item) (required)
        :param str dynamic_secret_val_preparation_data: An attached data by the client about the dynamic secret value preparation request (required)
        :param int creds_expiry: The requested expiration time of the temporary credentials in minutes.
        :return: PrepareDynamicSecretValueReplyObj
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['item_name', 'dynamic_secret_val_preparation_data', 'creds_expiry']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method prepare_dynamic_secret_value" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'item_name' is set
        if ('item_name' not in params or
                params['item_name'] is None):
            raise ValueError("Missing the required parameter `item_name` when calling `prepare_dynamic_secret_value`")  # noqa: E501
        # verify the required parameter 'dynamic_secret_val_preparation_data' is set
        if ('dynamic_secret_val_preparation_data' not in params or
                params['dynamic_secret_val_preparation_data'] is None):
            raise ValueError("Missing the required parameter `dynamic_secret_val_preparation_data` when calling `prepare_dynamic_secret_value`")  # noqa: E501

        if 'creds_expiry' in params and params['creds_expiry'] > 60:  # noqa: E501
            raise ValueError("Invalid value for parameter `creds_expiry` when calling `prepare_dynamic_secret_value`, must be a value less than or equal to `60`")  # noqa: E501
        if 'creds_expiry' in params and params['creds_expiry'] < 2:  # noqa: E501
            raise ValueError("Invalid value for parameter `creds_expiry` when calling `prepare_dynamic_secret_value`, must be a value greater than or equal to `2`")  # noqa: E501
        collection_formats = {}

        path_params = {}

        query_params = []
        if 'item_name' in params:
            query_params.append(('item_name', params['item_name']))  # noqa: E501
        if 'dynamic_secret_val_preparation_data' in params:
            query_params.append(('dynamic_secret_val_preparation_data', params['dynamic_secret_val_preparation_data']))  # noqa: E501
        if 'creds_expiry' in params:
            query_params.append(('creds_expiry', params['creds_expiry']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/prepare-dynamic-secret-value', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PrepareDynamicSecretValueReplyObj',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def pull_dynamic_secret_value(self, item_name, dynamic_secret_value_id, consumer_protection_key_derivation_creds, **kwargs):  # noqa: E501
        """Pull a new dynamic secret value on demand.  # noqa: E501

        This endpoint is used by the consumer after call the prepareDynamicSecretValue request. There may be a situation where the request to pull the dynamic secret value comes before the producer has push the new value. so that the consumer must make the pull request several times until the pushDynamicSecretValue process is completed by the producer (wait about half a second between each pull request).  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.pull_dynamic_secret_value(item_name, dynamic_secret_value_id, consumer_protection_key_derivation_creds, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str item_name: The dynamic secret item name (including the path to the item) (required)
        :param str dynamic_secret_value_id: The ID of the new dynamic secret value to be pull (required)
        :param str consumer_protection_key_derivation_creds: The credentials issued when preparing for the new value. The consumer that pull the dynamic secret value received them on the prepareDynamicSecretValue request. (required)
        :return: PullDynamicSecretValueReplyObj
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.pull_dynamic_secret_value_with_http_info(item_name, dynamic_secret_value_id, consumer_protection_key_derivation_creds, **kwargs)  # noqa: E501
        else:
            (data) = self.pull_dynamic_secret_value_with_http_info(item_name, dynamic_secret_value_id, consumer_protection_key_derivation_creds, **kwargs)  # noqa: E501
            return data

    def pull_dynamic_secret_value_with_http_info(self, item_name, dynamic_secret_value_id, consumer_protection_key_derivation_creds, **kwargs):  # noqa: E501
        """Pull a new dynamic secret value on demand.  # noqa: E501

        This endpoint is used by the consumer after call the prepareDynamicSecretValue request. There may be a situation where the request to pull the dynamic secret value comes before the producer has push the new value. so that the consumer must make the pull request several times until the pushDynamicSecretValue process is completed by the producer (wait about half a second between each pull request).  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.pull_dynamic_secret_value_with_http_info(item_name, dynamic_secret_value_id, consumer_protection_key_derivation_creds, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str item_name: The dynamic secret item name (including the path to the item) (required)
        :param str dynamic_secret_value_id: The ID of the new dynamic secret value to be pull (required)
        :param str consumer_protection_key_derivation_creds: The credentials issued when preparing for the new value. The consumer that pull the dynamic secret value received them on the prepareDynamicSecretValue request. (required)
        :return: PullDynamicSecretValueReplyObj
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['item_name', 'dynamic_secret_value_id', 'consumer_protection_key_derivation_creds']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method pull_dynamic_secret_value" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'item_name' is set
        if ('item_name' not in params or
                params['item_name'] is None):
            raise ValueError("Missing the required parameter `item_name` when calling `pull_dynamic_secret_value`")  # noqa: E501
        # verify the required parameter 'dynamic_secret_value_id' is set
        if ('dynamic_secret_value_id' not in params or
                params['dynamic_secret_value_id'] is None):
            raise ValueError("Missing the required parameter `dynamic_secret_value_id` when calling `pull_dynamic_secret_value`")  # noqa: E501
        # verify the required parameter 'consumer_protection_key_derivation_creds' is set
        if ('consumer_protection_key_derivation_creds' not in params or
                params['consumer_protection_key_derivation_creds'] is None):
            raise ValueError("Missing the required parameter `consumer_protection_key_derivation_creds` when calling `pull_dynamic_secret_value`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'item_name' in params:
            query_params.append(('item_name', params['item_name']))  # noqa: E501
        if 'dynamic_secret_value_id' in params:
            query_params.append(('dynamic_secret_value_id', params['dynamic_secret_value_id']))  # noqa: E501
        if 'consumer_protection_key_derivation_creds' in params:
            query_params.append(('consumer_protection_key_derivation_creds', params['consumer_protection_key_derivation_creds']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/pull-dynamic-secret-value', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PullDynamicSecretValueReplyObj',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def push_dynamic_secret_value(self, item_name, message_receipt_handle, dynamic_secret_value_id, dynamic_secret_value, producer_protection_key_derivation_creds, **kwargs):  # noqa: E501
        """Push a new dynamic secret value on demand.  # noqa: E501

        This endpoint is used by the dynamic secret producer that listens to a dynamic secret message queue and create temporary value on demand and pushes it here to be stored for a few seconds until it is pulled by the client.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.push_dynamic_secret_value(item_name, message_receipt_handle, dynamic_secret_value_id, dynamic_secret_value, producer_protection_key_derivation_creds, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str item_name: The dynamic secret item name (including the path to the item) (required)
        :param str message_receipt_handle: The receipt handle received from the dynamic secret MQ (required)
        :param str dynamic_secret_value_id: The ID of the new dynamic secret value to be pull (required)
        :param str dynamic_secret_value: The dynamic secret value (required)
        :param str producer_protection_key_derivation_creds: for the dynamic secret value producer credentials. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.push_dynamic_secret_value_with_http_info(item_name, message_receipt_handle, dynamic_secret_value_id, dynamic_secret_value, producer_protection_key_derivation_creds, **kwargs)  # noqa: E501
        else:
            (data) = self.push_dynamic_secret_value_with_http_info(item_name, message_receipt_handle, dynamic_secret_value_id, dynamic_secret_value, producer_protection_key_derivation_creds, **kwargs)  # noqa: E501
            return data

    def push_dynamic_secret_value_with_http_info(self, item_name, message_receipt_handle, dynamic_secret_value_id, dynamic_secret_value, producer_protection_key_derivation_creds, **kwargs):  # noqa: E501
        """Push a new dynamic secret value on demand.  # noqa: E501

        This endpoint is used by the dynamic secret producer that listens to a dynamic secret message queue and create temporary value on demand and pushes it here to be stored for a few seconds until it is pulled by the client.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.push_dynamic_secret_value_with_http_info(item_name, message_receipt_handle, dynamic_secret_value_id, dynamic_secret_value, producer_protection_key_derivation_creds, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str item_name: The dynamic secret item name (including the path to the item) (required)
        :param str message_receipt_handle: The receipt handle received from the dynamic secret MQ (required)
        :param str dynamic_secret_value_id: The ID of the new dynamic secret value to be pull (required)
        :param str dynamic_secret_value: The dynamic secret value (required)
        :param str producer_protection_key_derivation_creds: for the dynamic secret value producer credentials. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['item_name', 'message_receipt_handle', 'dynamic_secret_value_id', 'dynamic_secret_value', 'producer_protection_key_derivation_creds']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method push_dynamic_secret_value" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'item_name' is set
        if ('item_name' not in params or
                params['item_name'] is None):
            raise ValueError("Missing the required parameter `item_name` when calling `push_dynamic_secret_value`")  # noqa: E501
        # verify the required parameter 'message_receipt_handle' is set
        if ('message_receipt_handle' not in params or
                params['message_receipt_handle'] is None):
            raise ValueError("Missing the required parameter `message_receipt_handle` when calling `push_dynamic_secret_value`")  # noqa: E501
        # verify the required parameter 'dynamic_secret_value_id' is set
        if ('dynamic_secret_value_id' not in params or
                params['dynamic_secret_value_id'] is None):
            raise ValueError("Missing the required parameter `dynamic_secret_value_id` when calling `push_dynamic_secret_value`")  # noqa: E501
        # verify the required parameter 'dynamic_secret_value' is set
        if ('dynamic_secret_value' not in params or
                params['dynamic_secret_value'] is None):
            raise ValueError("Missing the required parameter `dynamic_secret_value` when calling `push_dynamic_secret_value`")  # noqa: E501
        # verify the required parameter 'producer_protection_key_derivation_creds' is set
        if ('producer_protection_key_derivation_creds' not in params or
                params['producer_protection_key_derivation_creds'] is None):
            raise ValueError("Missing the required parameter `producer_protection_key_derivation_creds` when calling `push_dynamic_secret_value`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'item_name' in params:
            query_params.append(('item_name', params['item_name']))  # noqa: E501
        if 'message_receipt_handle' in params:
            query_params.append(('message_receipt_handle', params['message_receipt_handle']))  # noqa: E501
        if 'dynamic_secret_value_id' in params:
            query_params.append(('dynamic_secret_value_id', params['dynamic_secret_value_id']))  # noqa: E501
        if 'dynamic_secret_value' in params:
            query_params.append(('dynamic_secret_value', params['dynamic_secret_value']))  # noqa: E501
        if 'producer_protection_key_derivation_creds' in params:
            query_params.append(('producer_protection_key_derivation_creds', params['producer_protection_key_derivation_creds']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/push-dynamic-secret-value', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def reset_access_key(self, **kwargs):  # noqa: E501
        """Getting a validation number to reset an admin account's access key.  # noqa: E501

        This endpoint is accessible to all clients.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.reset_access_key(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.reset_access_key_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.reset_access_key_with_http_info(**kwargs)  # noqa: E501
            return data

    def reset_access_key_with_http_info(self, **kwargs):  # noqa: E501
        """Getting a validation number to reset an admin account's access key.  # noqa: E501

        This endpoint is accessible to all clients.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.reset_access_key_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method reset_access_key" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/reset-access-key', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def reset_access_key_0(self, **kwargs):  # noqa: E501
        """Getting temporary access credentials to reset an account's access key. The UAM service will use these credentials to update the account's api key auth method.  # noqa: E501

        This endpoint is accessible to all clients  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.reset_access_key_0(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: CredentialsReplyObj
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.reset_access_key_0_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.reset_access_key_0_with_http_info(**kwargs)  # noqa: E501
            return data

    def reset_access_key_0_with_http_info(self, **kwargs):  # noqa: E501
        """Getting temporary access credentials to reset an account's access key. The UAM service will use these credentials to update the account's api key auth method.  # noqa: E501

        This endpoint is accessible to all clients  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.reset_access_key_0_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: CredentialsReplyObj
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method reset_access_key_0" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/reset-access-key', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CredentialsReplyObj',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def reset_admin_account_access_key(self, **kwargs):  # noqa: E501
        """Reset admin account access key.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.reset_admin_account_access_key(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: AccountReplyObj
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.reset_admin_account_access_key_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.reset_admin_account_access_key_with_http_info(**kwargs)  # noqa: E501
            return data

    def reset_admin_account_access_key_with_http_info(self, **kwargs):  # noqa: E501
        """Reset admin account access key.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.reset_admin_account_access_key_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: AccountReplyObj
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method reset_admin_account_access_key" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/reset-admin-account-access-key', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='AccountReplyObj',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def set_uam_access_creds(self, akeyless_auth_creds, body, **kwargs):  # noqa: E501
        """Getting temporary access credentials to add a new access or to update an existing access in an UAM account. The UAM service will use this credentials to create/update an access to be used for accessing key fragments.  # noqa: E501

        This endpoint is accessible only by services that have a permission to access Auth for managing their accesses for their clients.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.set_uam_access_creds(akeyless_auth_creds, body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str akeyless_auth_creds: Temporary credentials for accessing the endpoint (required)
        :param SetUAMAccessCredsParams body: Access params. (required)
        :param str akeyless_request_id: Request Id for logging
        :param str akeyless_client_id: Client Id for logging
        :return: CredentialsReplyObj
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.set_uam_access_creds_with_http_info(akeyless_auth_creds, body, **kwargs)  # noqa: E501
        else:
            (data) = self.set_uam_access_creds_with_http_info(akeyless_auth_creds, body, **kwargs)  # noqa: E501
            return data

    def set_uam_access_creds_with_http_info(self, akeyless_auth_creds, body, **kwargs):  # noqa: E501
        """Getting temporary access credentials to add a new access or to update an existing access in an UAM account. The UAM service will use this credentials to create/update an access to be used for accessing key fragments.  # noqa: E501

        This endpoint is accessible only by services that have a permission to access Auth for managing their accesses for their clients.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.set_uam_access_creds_with_http_info(akeyless_auth_creds, body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str akeyless_auth_creds: Temporary credentials for accessing the endpoint (required)
        :param SetUAMAccessCredsParams body: Access params. (required)
        :param str akeyless_request_id: Request Id for logging
        :param str akeyless_client_id: Client Id for logging
        :return: CredentialsReplyObj
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['akeyless_auth_creds', 'body', 'akeyless_request_id', 'akeyless_client_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method set_uam_access_creds" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'akeyless_auth_creds' is set
        if ('akeyless_auth_creds' not in params or
                params['akeyless_auth_creds'] is None):
            raise ValueError("Missing the required parameter `akeyless_auth_creds` when calling `set_uam_access_creds`")  # noqa: E501
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `set_uam_access_creds`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}
        if 'akeyless_request_id' in params:
            header_params['AkeylessRequestId'] = params['akeyless_request_id']  # noqa: E501
        if 'akeyless_client_id' in params:
            header_params['AkeylessClientId'] = params['akeyless_client_id']  # noqa: E501
        if 'akeyless_auth_creds' in params:
            header_params['AkeylessAuthCreds'] = params['akeyless_auth_creds']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/set-uam-access-creds', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CredentialsReplyObj',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_access(self, akeyless_credentials, body, access_id, **kwargs):  # noqa: E501
        """Updating an existing access  # noqa: E501

        This endpoint is accessible only by services that have a permission to access Auth for managing their accesses for their clients.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_access(akeyless_credentials, body, access_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str akeyless_credentials: Temporary credentials for accessing the endpoint (required)
        :param AccessParams body: Access rules and attaches. (required)
        :param str access_id: Access id. (required)
        :param str akeyless_request_id: Request Id for logging
        :param str akeyless_client_id: Client Id for logging
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_access_with_http_info(akeyless_credentials, body, access_id, **kwargs)  # noqa: E501
        else:
            (data) = self.update_access_with_http_info(akeyless_credentials, body, access_id, **kwargs)  # noqa: E501
            return data

    def update_access_with_http_info(self, akeyless_credentials, body, access_id, **kwargs):  # noqa: E501
        """Updating an existing access  # noqa: E501

        This endpoint is accessible only by services that have a permission to access Auth for managing their accesses for their clients.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_access_with_http_info(akeyless_credentials, body, access_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str akeyless_credentials: Temporary credentials for accessing the endpoint (required)
        :param AccessParams body: Access rules and attaches. (required)
        :param str access_id: Access id. (required)
        :param str akeyless_request_id: Request Id for logging
        :param str akeyless_client_id: Client Id for logging
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['akeyless_credentials', 'body', 'access_id', 'akeyless_request_id', 'akeyless_client_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_access" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'akeyless_credentials' is set
        if ('akeyless_credentials' not in params or
                params['akeyless_credentials'] is None):
            raise ValueError("Missing the required parameter `akeyless_credentials` when calling `update_access`")  # noqa: E501
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `update_access`")  # noqa: E501
        # verify the required parameter 'access_id' is set
        if ('access_id' not in params or
                params['access_id'] is None):
            raise ValueError("Missing the required parameter `access_id` when calling `update_access`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'access_id' in params:
            path_params['access_id'] = params['access_id']  # noqa: E501

        query_params = []

        header_params = {}
        if 'akeyless_request_id' in params:
            header_params['AkeylessRequestId'] = params['akeyless_request_id']  # noqa: E501
        if 'akeyless_client_id' in params:
            header_params['AkeylessClientId'] = params['akeyless_client_id']  # noqa: E501
        if 'akeyless_credentials' in params:
            header_params['Akeyless-Credentials'] = params['akeyless_credentials']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/access/{access_id}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_auth_method(self, akeyless_uam_access_creds, akeyless_set_auth_method_creds, new_auth_method_name, auth_method_name, **kwargs):  # noqa: E501
        """Updating an existing auth method in the account  # noqa: E501

        This endpoint is accessible only by an admin  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_auth_method(akeyless_uam_access_creds, akeyless_set_auth_method_creds, new_auth_method_name, auth_method_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str akeyless_uam_access_creds: Temporary credentials for accessing the endpoint (required)
        :param str akeyless_set_auth_method_creds: Temporary credentials for accessing the endpoint (required)
        :param str new_auth_method_name: The auth method name to be created (in case of update auth method, this is the new auth method name that will replace the existing one) (required)
        :param str auth_method_name: Auth method name. (required)
        :param str akeyless_request_id: Request Id for logging
        :param str akeyless_client_id: Client Id for logging
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_auth_method_with_http_info(akeyless_uam_access_creds, akeyless_set_auth_method_creds, new_auth_method_name, auth_method_name, **kwargs)  # noqa: E501
        else:
            (data) = self.update_auth_method_with_http_info(akeyless_uam_access_creds, akeyless_set_auth_method_creds, new_auth_method_name, auth_method_name, **kwargs)  # noqa: E501
            return data

    def update_auth_method_with_http_info(self, akeyless_uam_access_creds, akeyless_set_auth_method_creds, new_auth_method_name, auth_method_name, **kwargs):  # noqa: E501
        """Updating an existing auth method in the account  # noqa: E501

        This endpoint is accessible only by an admin  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_auth_method_with_http_info(akeyless_uam_access_creds, akeyless_set_auth_method_creds, new_auth_method_name, auth_method_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str akeyless_uam_access_creds: Temporary credentials for accessing the endpoint (required)
        :param str akeyless_set_auth_method_creds: Temporary credentials for accessing the endpoint (required)
        :param str new_auth_method_name: The auth method name to be created (in case of update auth method, this is the new auth method name that will replace the existing one) (required)
        :param str auth_method_name: Auth method name. (required)
        :param str akeyless_request_id: Request Id for logging
        :param str akeyless_client_id: Client Id for logging
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['akeyless_uam_access_creds', 'akeyless_set_auth_method_creds', 'new_auth_method_name', 'auth_method_name', 'akeyless_request_id', 'akeyless_client_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_auth_method" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'akeyless_uam_access_creds' is set
        if ('akeyless_uam_access_creds' not in params or
                params['akeyless_uam_access_creds'] is None):
            raise ValueError("Missing the required parameter `akeyless_uam_access_creds` when calling `update_auth_method`")  # noqa: E501
        # verify the required parameter 'akeyless_set_auth_method_creds' is set
        if ('akeyless_set_auth_method_creds' not in params or
                params['akeyless_set_auth_method_creds'] is None):
            raise ValueError("Missing the required parameter `akeyless_set_auth_method_creds` when calling `update_auth_method`")  # noqa: E501
        # verify the required parameter 'new_auth_method_name' is set
        if ('new_auth_method_name' not in params or
                params['new_auth_method_name'] is None):
            raise ValueError("Missing the required parameter `new_auth_method_name` when calling `update_auth_method`")  # noqa: E501
        # verify the required parameter 'auth_method_name' is set
        if ('auth_method_name' not in params or
                params['auth_method_name'] is None):
            raise ValueError("Missing the required parameter `auth_method_name` when calling `update_auth_method`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'auth_method_name' in params:
            path_params['auth_method_name'] = params['auth_method_name']  # noqa: E501

        query_params = []
        if 'new_auth_method_name' in params:
            query_params.append(('new_auth_method_name', params['new_auth_method_name']))  # noqa: E501

        header_params = {}
        if 'akeyless_request_id' in params:
            header_params['AkeylessRequestId'] = params['akeyless_request_id']  # noqa: E501
        if 'akeyless_client_id' in params:
            header_params['AkeylessClientId'] = params['akeyless_client_id']  # noqa: E501
        if 'akeyless_uam_access_creds' in params:
            header_params['AkeylessUAM-AccessCreds'] = params['akeyless_uam_access_creds']  # noqa: E501
        if 'akeyless_set_auth_method_creds' in params:
            header_params['Akeyless-SetAuthMethodCreds'] = params['akeyless_set_auth_method_creds']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/auth-method/{auth_method_name}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_item(self, akeyless_uam_access_creds, item_name, new_item_name, **kwargs):  # noqa: E501
        """update_item  # noqa: E501

        Updating an existing item in the account  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_item(akeyless_uam_access_creds, item_name, new_item_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str akeyless_uam_access_creds: Temporary credentials for accessing the endpoint (required)
        :param str item_name: Current item name to be updated (including the path to the item). (required)
        :param str new_item_name: The new item name (including the path to the item) that will replace the existing one (required)
        :param str akeyless_request_id: Request Id for logging
        :param str akeyless_client_id: Client Id for logging
        :param str item_metadata: The metadata about the item.
        :param int item_version: The item version to be updated. this parameter relevant only when updating a version-dependent attribute of the item (for example a secret encrypted value in case of secret item).  If it is empty, the item attributes of the latest version will be updated.
        :param str upload_secret_creds: The credentials to upload a secret. this parameter relevant only when updating a secret. This parameter will be used to extract the protection key and the derivation data that used to encrypt the secret.
        :param str secret_enc_val: The encrypted secret value. this parameter relevant only when updating a secret. This parameter should contain the encrypted secret that is encrypted using the protection key.
        :param str signer_key_name: The name of the key that will be used to singing the ssh certificate. This parameter relevant and required only in case of create a new ssh cert issuer.
        :param SetItemRequestBodyParams body: Body params for create or update an item.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_item_with_http_info(akeyless_uam_access_creds, item_name, new_item_name, **kwargs)  # noqa: E501
        else:
            (data) = self.update_item_with_http_info(akeyless_uam_access_creds, item_name, new_item_name, **kwargs)  # noqa: E501
            return data

    def update_item_with_http_info(self, akeyless_uam_access_creds, item_name, new_item_name, **kwargs):  # noqa: E501
        """update_item  # noqa: E501

        Updating an existing item in the account  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_item_with_http_info(akeyless_uam_access_creds, item_name, new_item_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str akeyless_uam_access_creds: Temporary credentials for accessing the endpoint (required)
        :param str item_name: Current item name to be updated (including the path to the item). (required)
        :param str new_item_name: The new item name (including the path to the item) that will replace the existing one (required)
        :param str akeyless_request_id: Request Id for logging
        :param str akeyless_client_id: Client Id for logging
        :param str item_metadata: The metadata about the item.
        :param int item_version: The item version to be updated. this parameter relevant only when updating a version-dependent attribute of the item (for example a secret encrypted value in case of secret item).  If it is empty, the item attributes of the latest version will be updated.
        :param str upload_secret_creds: The credentials to upload a secret. this parameter relevant only when updating a secret. This parameter will be used to extract the protection key and the derivation data that used to encrypt the secret.
        :param str secret_enc_val: The encrypted secret value. this parameter relevant only when updating a secret. This parameter should contain the encrypted secret that is encrypted using the protection key.
        :param str signer_key_name: The name of the key that will be used to singing the ssh certificate. This parameter relevant and required only in case of create a new ssh cert issuer.
        :param SetItemRequestBodyParams body: Body params for create or update an item.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['akeyless_uam_access_creds', 'item_name', 'new_item_name', 'akeyless_request_id', 'akeyless_client_id', 'item_metadata', 'item_version', 'upload_secret_creds', 'secret_enc_val', 'signer_key_name', 'body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_item" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'akeyless_uam_access_creds' is set
        if ('akeyless_uam_access_creds' not in params or
                params['akeyless_uam_access_creds'] is None):
            raise ValueError("Missing the required parameter `akeyless_uam_access_creds` when calling `update_item`")  # noqa: E501
        # verify the required parameter 'item_name' is set
        if ('item_name' not in params or
                params['item_name'] is None):
            raise ValueError("Missing the required parameter `item_name` when calling `update_item`")  # noqa: E501
        # verify the required parameter 'new_item_name' is set
        if ('new_item_name' not in params or
                params['new_item_name'] is None):
            raise ValueError("Missing the required parameter `new_item_name` when calling `update_item`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'item_name' in params:
            query_params.append(('item_name', params['item_name']))  # noqa: E501
        if 'new_item_name' in params:
            query_params.append(('new_item_name', params['new_item_name']))  # noqa: E501
        if 'item_metadata' in params:
            query_params.append(('item_metadata', params['item_metadata']))  # noqa: E501
        if 'item_version' in params:
            query_params.append(('item_version', params['item_version']))  # noqa: E501
        if 'upload_secret_creds' in params:
            query_params.append(('upload_secret_creds', params['upload_secret_creds']))  # noqa: E501
        if 'secret_enc_val' in params:
            query_params.append(('secret_enc_val', params['secret_enc_val']))  # noqa: E501
        if 'signer_key_name' in params:
            query_params.append(('signer_key_name', params['signer_key_name']))  # noqa: E501

        header_params = {}
        if 'akeyless_request_id' in params:
            header_params['AkeylessRequestId'] = params['akeyless_request_id']  # noqa: E501
        if 'akeyless_client_id' in params:
            header_params['AkeylessClientId'] = params['akeyless_client_id']  # noqa: E501
        if 'akeyless_uam_access_creds' in params:
            header_params['AkeylessUAM-AccessCreds'] = params['akeyless_uam_access_creds']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/item', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_role(self, akeyless_uam_access_creds, body, role_name, **kwargs):  # noqa: E501
        """Updating an existing role in the account  # noqa: E501

        This endpoint is accessible only by an admin  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_role(akeyless_uam_access_creds, body, role_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str akeyless_uam_access_creds: Temporary credentials for accessing the endpoint (required)
        :param SetRoleRequestParams body: Params for create or update role request. (required)
        :param str role_name: Role name. (required)
        :param str akeyless_request_id: Request Id for logging
        :param str akeyless_client_id: Client Id for logging
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_role_with_http_info(akeyless_uam_access_creds, body, role_name, **kwargs)  # noqa: E501
        else:
            (data) = self.update_role_with_http_info(akeyless_uam_access_creds, body, role_name, **kwargs)  # noqa: E501
            return data

    def update_role_with_http_info(self, akeyless_uam_access_creds, body, role_name, **kwargs):  # noqa: E501
        """Updating an existing role in the account  # noqa: E501

        This endpoint is accessible only by an admin  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_role_with_http_info(akeyless_uam_access_creds, body, role_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str akeyless_uam_access_creds: Temporary credentials for accessing the endpoint (required)
        :param SetRoleRequestParams body: Params for create or update role request. (required)
        :param str role_name: Role name. (required)
        :param str akeyless_request_id: Request Id for logging
        :param str akeyless_client_id: Client Id for logging
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['akeyless_uam_access_creds', 'body', 'role_name', 'akeyless_request_id', 'akeyless_client_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_role" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'akeyless_uam_access_creds' is set
        if ('akeyless_uam_access_creds' not in params or
                params['akeyless_uam_access_creds'] is None):
            raise ValueError("Missing the required parameter `akeyless_uam_access_creds` when calling `update_role`")  # noqa: E501
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `update_role`")  # noqa: E501
        # verify the required parameter 'role_name' is set
        if ('role_name' not in params or
                params['role_name'] is None):
            raise ValueError("Missing the required parameter `role_name` when calling `update_role`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'role_name' in params:
            path_params['role_name'] = params['role_name']  # noqa: E501

        query_params = []

        header_params = {}
        if 'akeyless_request_id' in params:
            header_params['AkeylessRequestId'] = params['akeyless_request_id']  # noqa: E501
        if 'akeyless_client_id' in params:
            header_params['AkeylessClientId'] = params['akeyless_client_id']  # noqa: E501
        if 'akeyless_uam_access_creds' in params:
            header_params['AkeylessUAM-AccessCreds'] = params['akeyless_uam_access_creds']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/role/{role_name}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def validate_account(self, customer_email, validation_number, **kwargs):  # noqa: E501
        """Request new validation number.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.validate_account(customer_email, validation_number, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str customer_email: The customer email (required)
        :param str validation_number: The validation number (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.validate_account_with_http_info(customer_email, validation_number, **kwargs)  # noqa: E501
        else:
            (data) = self.validate_account_with_http_info(customer_email, validation_number, **kwargs)  # noqa: E501
            return data

    def validate_account_with_http_info(self, customer_email, validation_number, **kwargs):  # noqa: E501
        """Request new validation number.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.validate_account_with_http_info(customer_email, validation_number, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str customer_email: The customer email (required)
        :param str validation_number: The validation number (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['customer_email', 'validation_number']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method validate_account" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'customer_email' is set
        if ('customer_email' not in params or
                params['customer_email'] is None):
            raise ValueError("Missing the required parameter `customer_email` when calling `validate_account`")  # noqa: E501
        # verify the required parameter 'validation_number' is set
        if ('validation_number' not in params or
                params['validation_number'] is None):
            raise ValueError("Missing the required parameter `validation_number` when calling `validate_account`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'customer_email' in params:
            query_params.append(('customer_email', params['customer_email']))  # noqa: E501
        if 'validation_number' in params:
            query_params.append(('validation_number', params['validation_number']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/account-validation', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def validate_account_0(self, customer_email, validation_number, **kwargs):  # noqa: E501
        """Request new validation number.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.validate_account_0(customer_email, validation_number, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str customer_email: The customer email (required)
        :param str validation_number: The validation number (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.validate_account_0_with_http_info(customer_email, validation_number, **kwargs)  # noqa: E501
        else:
            (data) = self.validate_account_0_with_http_info(customer_email, validation_number, **kwargs)  # noqa: E501
            return data

    def validate_account_0_with_http_info(self, customer_email, validation_number, **kwargs):  # noqa: E501
        """Request new validation number.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.validate_account_0_with_http_info(customer_email, validation_number, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str customer_email: The customer email (required)
        :param str validation_number: The validation number (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['customer_email', 'validation_number']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method validate_account_0" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'customer_email' is set
        if ('customer_email' not in params or
                params['customer_email'] is None):
            raise ValueError("Missing the required parameter `customer_email` when calling `validate_account_0`")  # noqa: E501
        # verify the required parameter 'validation_number' is set
        if ('validation_number' not in params or
                params['validation_number'] is None):
            raise ValueError("Missing the required parameter `validation_number` when calling `validate_account_0`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'customer_email' in params:
            query_params.append(('customer_email', params['customer_email']))  # noqa: E501
        if 'validation_number' in params:
            query_params.append(('validation_number', params['validation_number']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/account-validation', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def validate_client_credentials(self, akeyless_credentials, client_credentials, **kwargs):  # noqa: E501
        """Validate client credentials  # noqa: E501

        Allows the services to validate the temporary access credentials that received from their clients.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.validate_client_credentials(akeyless_credentials, client_credentials, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str akeyless_credentials: Temporary credentials for accessing the endpoint (required)
        :param str client_credentials: Temporary credentials for validation (required)
        :param str akeyless_request_id: Request Id for logging
        :param str akeyless_client_id: Client Id for logging
        :return: ValidateClientCredsReplyObj
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.validate_client_credentials_with_http_info(akeyless_credentials, client_credentials, **kwargs)  # noqa: E501
        else:
            (data) = self.validate_client_credentials_with_http_info(akeyless_credentials, client_credentials, **kwargs)  # noqa: E501
            return data

    def validate_client_credentials_with_http_info(self, akeyless_credentials, client_credentials, **kwargs):  # noqa: E501
        """Validate client credentials  # noqa: E501

        Allows the services to validate the temporary access credentials that received from their clients.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.validate_client_credentials_with_http_info(akeyless_credentials, client_credentials, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str akeyless_credentials: Temporary credentials for accessing the endpoint (required)
        :param str client_credentials: Temporary credentials for validation (required)
        :param str akeyless_request_id: Request Id for logging
        :param str akeyless_client_id: Client Id for logging
        :return: ValidateClientCredsReplyObj
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['akeyless_credentials', 'client_credentials', 'akeyless_request_id', 'akeyless_client_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method validate_client_credentials" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'akeyless_credentials' is set
        if ('akeyless_credentials' not in params or
                params['akeyless_credentials'] is None):
            raise ValueError("Missing the required parameter `akeyless_credentials` when calling `validate_client_credentials`")  # noqa: E501
        # verify the required parameter 'client_credentials' is set
        if ('client_credentials' not in params or
                params['client_credentials'] is None):
            raise ValueError("Missing the required parameter `client_credentials` when calling `validate_client_credentials`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'client_credentials' in params:
            query_params.append(('client_credentials', params['client_credentials']))  # noqa: E501

        header_params = {}
        if 'akeyless_request_id' in params:
            header_params['AkeylessRequestId'] = params['akeyless_request_id']  # noqa: E501
        if 'akeyless_client_id' in params:
            header_params['AkeylessClientId'] = params['akeyless_client_id']  # noqa: E501
        if 'akeyless_credentials' in params:
            header_params['Akeyless-Credentials'] = params['akeyless_credentials']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/validate-client-credentials', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ValidateClientCredsReplyObj',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
