# coding: utf-8

"""
    UAM - Application API

    UAM manages client accounts and allows each client to define items, roles and auth methods. The core operations of UAM are as follows: Creating new accounts. For each account: Creating items. Adding new auth methods Adding new roles creating roles - auth methods association. Returning the key's metadata together with temporary access credentials in order to access the key fragments.  # noqa: E501

    OpenAPI spec version: 0.1.0
    Contact: refael@akeyless-security.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six

from akeyless_uam_api.models.api_key_access_rules import APIKeyAccessRules  # noqa: F401,E501
from akeyless_uam_api.models.azure_ad_access_rules import AzureADAccessRules  # noqa: F401,E501
from akeyless_uam_api.models.ldap_access_rules import LdapAccessRules  # noqa: F401,E501
from akeyless_uam_api.models.o_auth2_access_rules import OAuth2AccessRules  # noqa: F401,E501
from akeyless_uam_api.models.saml_access_rules import SamlAccessRules  # noqa: F401,E501


class AccessRules(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'api_key_access_rules': 'APIKeyAccessRules',
        'azure_ad_access_rules': 'AzureADAccessRules',
        'cidr_whitelist': 'str',
        'ldap_access_rules': 'LdapAccessRules',
        'oauth2_access_rules': 'OAuth2AccessRules',
        'saml_access_rules': 'SamlAccessRules'
    }

    attribute_map = {
        'api_key_access_rules': 'api_key_access_rules',
        'azure_ad_access_rules': 'azure_ad_access_rules',
        'cidr_whitelist': 'cidr_whitelist',
        'ldap_access_rules': 'ldap_access_rules',
        'oauth2_access_rules': 'oauth2_access_rules',
        'saml_access_rules': 'saml_access_rules'
    }

    def __init__(self, api_key_access_rules=None, azure_ad_access_rules=None, cidr_whitelist=None, ldap_access_rules=None, oauth2_access_rules=None, saml_access_rules=None):  # noqa: E501
        """AccessRules - a model defined in Swagger"""  # noqa: E501

        self._api_key_access_rules = None
        self._azure_ad_access_rules = None
        self._cidr_whitelist = None
        self._ldap_access_rules = None
        self._oauth2_access_rules = None
        self._saml_access_rules = None
        self.discriminator = None

        if api_key_access_rules is not None:
            self.api_key_access_rules = api_key_access_rules
        if azure_ad_access_rules is not None:
            self.azure_ad_access_rules = azure_ad_access_rules
        if cidr_whitelist is not None:
            self.cidr_whitelist = cidr_whitelist
        if ldap_access_rules is not None:
            self.ldap_access_rules = ldap_access_rules
        if oauth2_access_rules is not None:
            self.oauth2_access_rules = oauth2_access_rules
        if saml_access_rules is not None:
            self.saml_access_rules = saml_access_rules

    @property
    def api_key_access_rules(self):
        """Gets the api_key_access_rules of this AccessRules.  # noqa: E501


        :return: The api_key_access_rules of this AccessRules.  # noqa: E501
        :rtype: APIKeyAccessRules
        """
        return self._api_key_access_rules

    @api_key_access_rules.setter
    def api_key_access_rules(self, api_key_access_rules):
        """Sets the api_key_access_rules of this AccessRules.


        :param api_key_access_rules: The api_key_access_rules of this AccessRules.  # noqa: E501
        :type: APIKeyAccessRules
        """

        self._api_key_access_rules = api_key_access_rules

    @property
    def azure_ad_access_rules(self):
        """Gets the azure_ad_access_rules of this AccessRules.  # noqa: E501


        :return: The azure_ad_access_rules of this AccessRules.  # noqa: E501
        :rtype: AzureADAccessRules
        """
        return self._azure_ad_access_rules

    @azure_ad_access_rules.setter
    def azure_ad_access_rules(self, azure_ad_access_rules):
        """Sets the azure_ad_access_rules of this AccessRules.


        :param azure_ad_access_rules: The azure_ad_access_rules of this AccessRules.  # noqa: E501
        :type: AzureADAccessRules
        """

        self._azure_ad_access_rules = azure_ad_access_rules

    @property
    def cidr_whitelist(self):
        """Gets the cidr_whitelist of this AccessRules.  # noqa: E501

        CIDR Whitelisting. Only requests from the ip addresses that match the CIDR list will be able to obtain temporary access credentials. The format of the CIDR list is a comma-separated list of valid CIDRs.The list length is limited to 10 CIDRs. In the case of an empty string there will be no restriction of IP addresses.  # noqa: E501

        :return: The cidr_whitelist of this AccessRules.  # noqa: E501
        :rtype: str
        """
        return self._cidr_whitelist

    @cidr_whitelist.setter
    def cidr_whitelist(self, cidr_whitelist):
        """Sets the cidr_whitelist of this AccessRules.

        CIDR Whitelisting. Only requests from the ip addresses that match the CIDR list will be able to obtain temporary access credentials. The format of the CIDR list is a comma-separated list of valid CIDRs.The list length is limited to 10 CIDRs. In the case of an empty string there will be no restriction of IP addresses.  # noqa: E501

        :param cidr_whitelist: The cidr_whitelist of this AccessRules.  # noqa: E501
        :type: str
        """

        self._cidr_whitelist = cidr_whitelist

    @property
    def ldap_access_rules(self):
        """Gets the ldap_access_rules of this AccessRules.  # noqa: E501


        :return: The ldap_access_rules of this AccessRules.  # noqa: E501
        :rtype: LdapAccessRules
        """
        return self._ldap_access_rules

    @ldap_access_rules.setter
    def ldap_access_rules(self, ldap_access_rules):
        """Sets the ldap_access_rules of this AccessRules.


        :param ldap_access_rules: The ldap_access_rules of this AccessRules.  # noqa: E501
        :type: LdapAccessRules
        """

        self._ldap_access_rules = ldap_access_rules

    @property
    def oauth2_access_rules(self):
        """Gets the oauth2_access_rules of this AccessRules.  # noqa: E501


        :return: The oauth2_access_rules of this AccessRules.  # noqa: E501
        :rtype: OAuth2AccessRules
        """
        return self._oauth2_access_rules

    @oauth2_access_rules.setter
    def oauth2_access_rules(self, oauth2_access_rules):
        """Sets the oauth2_access_rules of this AccessRules.


        :param oauth2_access_rules: The oauth2_access_rules of this AccessRules.  # noqa: E501
        :type: OAuth2AccessRules
        """

        self._oauth2_access_rules = oauth2_access_rules

    @property
    def saml_access_rules(self):
        """Gets the saml_access_rules of this AccessRules.  # noqa: E501


        :return: The saml_access_rules of this AccessRules.  # noqa: E501
        :rtype: SamlAccessRules
        """
        return self._saml_access_rules

    @saml_access_rules.setter
    def saml_access_rules(self, saml_access_rules):
        """Sets the saml_access_rules of this AccessRules.


        :param saml_access_rules: The saml_access_rules of this AccessRules.  # noqa: E501
        :type: SamlAccessRules
        """

        self._saml_access_rules = saml_access_rules

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(AccessRules, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, AccessRules):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
