# coding: utf-8

"""
    UAM - Application API

    UAM manages client accounts and allows each client to define items, roles and auth methods. The core operations of UAM are as follows: Creating new accounts. For each account: Creating items. Adding new auth methods Adding new roles creating roles - auth methods association. Returning the key's metadata together with temporary access credentials in order to access the key fragments.  # noqa: E501

    OpenAPI spec version: 0.1.0
    Contact: refael@akeyless-security.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six

from akeyless_uam_api.models.dynamic_secret_message_queue_info import DynamicSecretMessageQueueInfo  # noqa: F401,E501
from akeyless_uam_api.models.fragments_derivations_creds import FragmentsDerivationsCreds  # noqa: F401,E501


class PrepareDynamicSecretValueReplyObj(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'consumer_protection_key_derivation_creds': 'FragmentsDerivationsCreds',
        'dynamic_secret_val_preparation_data': 'str',
        'dynamic_secret_value_id': 'str',
        'mq_info': 'DynamicSecretMessageQueueInfo'
    }

    attribute_map = {
        'consumer_protection_key_derivation_creds': 'consumer_protection_key_derivation_creds',
        'dynamic_secret_val_preparation_data': 'dynamic_secret_val_preparation_data',
        'dynamic_secret_value_id': 'dynamic_secret_value_id',
        'mq_info': 'mq_info'
    }

    def __init__(self, consumer_protection_key_derivation_creds=None, dynamic_secret_val_preparation_data=None, dynamic_secret_value_id=None, mq_info=None):  # noqa: E501
        """PrepareDynamicSecretValueReplyObj - a model defined in Swagger"""  # noqa: E501

        self._consumer_protection_key_derivation_creds = None
        self._dynamic_secret_val_preparation_data = None
        self._dynamic_secret_value_id = None
        self._mq_info = None
        self.discriminator = None

        if consumer_protection_key_derivation_creds is not None:
            self.consumer_protection_key_derivation_creds = consumer_protection_key_derivation_creds
        if dynamic_secret_val_preparation_data is not None:
            self.dynamic_secret_val_preparation_data = dynamic_secret_val_preparation_data
        if dynamic_secret_value_id is not None:
            self.dynamic_secret_value_id = dynamic_secret_value_id
        if mq_info is not None:
            self.mq_info = mq_info

    @property
    def consumer_protection_key_derivation_creds(self):
        """Gets the consumer_protection_key_derivation_creds of this PrepareDynamicSecretValueReplyObj.  # noqa: E501


        :return: The consumer_protection_key_derivation_creds of this PrepareDynamicSecretValueReplyObj.  # noqa: E501
        :rtype: FragmentsDerivationsCreds
        """
        return self._consumer_protection_key_derivation_creds

    @consumer_protection_key_derivation_creds.setter
    def consumer_protection_key_derivation_creds(self, consumer_protection_key_derivation_creds):
        """Sets the consumer_protection_key_derivation_creds of this PrepareDynamicSecretValueReplyObj.


        :param consumer_protection_key_derivation_creds: The consumer_protection_key_derivation_creds of this PrepareDynamicSecretValueReplyObj.  # noqa: E501
        :type: FragmentsDerivationsCreds
        """

        self._consumer_protection_key_derivation_creds = consumer_protection_key_derivation_creds

    @property
    def dynamic_secret_val_preparation_data(self):
        """Gets the dynamic_secret_val_preparation_data of this PrepareDynamicSecretValueReplyObj.  # noqa: E501

        An attached data by the client about the dynamic secret value preparation request  # noqa: E501

        :return: The dynamic_secret_val_preparation_data of this PrepareDynamicSecretValueReplyObj.  # noqa: E501
        :rtype: str
        """
        return self._dynamic_secret_val_preparation_data

    @dynamic_secret_val_preparation_data.setter
    def dynamic_secret_val_preparation_data(self, dynamic_secret_val_preparation_data):
        """Sets the dynamic_secret_val_preparation_data of this PrepareDynamicSecretValueReplyObj.

        An attached data by the client about the dynamic secret value preparation request  # noqa: E501

        :param dynamic_secret_val_preparation_data: The dynamic_secret_val_preparation_data of this PrepareDynamicSecretValueReplyObj.  # noqa: E501
        :type: str
        """

        self._dynamic_secret_val_preparation_data = dynamic_secret_val_preparation_data

    @property
    def dynamic_secret_value_id(self):
        """Gets the dynamic_secret_value_id of this PrepareDynamicSecretValueReplyObj.  # noqa: E501

        The ID of the new dynamic secret value to be pull  # noqa: E501

        :return: The dynamic_secret_value_id of this PrepareDynamicSecretValueReplyObj.  # noqa: E501
        :rtype: str
        """
        return self._dynamic_secret_value_id

    @dynamic_secret_value_id.setter
    def dynamic_secret_value_id(self, dynamic_secret_value_id):
        """Sets the dynamic_secret_value_id of this PrepareDynamicSecretValueReplyObj.

        The ID of the new dynamic secret value to be pull  # noqa: E501

        :param dynamic_secret_value_id: The dynamic_secret_value_id of this PrepareDynamicSecretValueReplyObj.  # noqa: E501
        :type: str
        """

        self._dynamic_secret_value_id = dynamic_secret_value_id

    @property
    def mq_info(self):
        """Gets the mq_info of this PrepareDynamicSecretValueReplyObj.  # noqa: E501


        :return: The mq_info of this PrepareDynamicSecretValueReplyObj.  # noqa: E501
        :rtype: DynamicSecretMessageQueueInfo
        """
        return self._mq_info

    @mq_info.setter
    def mq_info(self, mq_info):
        """Sets the mq_info of this PrepareDynamicSecretValueReplyObj.


        :param mq_info: The mq_info of this PrepareDynamicSecretValueReplyObj.  # noqa: E501
        :type: DynamicSecretMessageQueueInfo
        """

        self._mq_info = mq_info

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(PrepareDynamicSecretValueReplyObj, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, PrepareDynamicSecretValueReplyObj):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
