# coding: utf-8

"""
    UAM - Application API

    UAM manages client accounts and allows each client to define items, roles and auth methods. The core operations of UAM are as follows: Creating new accounts. For each account: Creating items. Adding new auth methods Adding new roles creating roles - auth methods association. Returning the key's metadata together with temporary access credentials in order to access the key fragments.  # noqa: E501

    OpenAPI spec version: 0.1.0
    Contact: refael@akeyless-security.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six


class PullDynamicSecretValueReplyObj(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'dynamic_secret_value': 'str',
        'dynamic_secret_value_id': 'str'
    }

    attribute_map = {
        'dynamic_secret_value': 'dynamic_secret_value',
        'dynamic_secret_value_id': 'dynamic_secret_value_id'
    }

    def __init__(self, dynamic_secret_value=None, dynamic_secret_value_id=None):  # noqa: E501
        """PullDynamicSecretValueReplyObj - a model defined in Swagger"""  # noqa: E501

        self._dynamic_secret_value = None
        self._dynamic_secret_value_id = None
        self.discriminator = None

        if dynamic_secret_value is not None:
            self.dynamic_secret_value = dynamic_secret_value
        if dynamic_secret_value_id is not None:
            self.dynamic_secret_value_id = dynamic_secret_value_id

    @property
    def dynamic_secret_value(self):
        """Gets the dynamic_secret_value of this PullDynamicSecretValueReplyObj.  # noqa: E501

        The dynamic secret value that created on demand.  # noqa: E501

        :return: The dynamic_secret_value of this PullDynamicSecretValueReplyObj.  # noqa: E501
        :rtype: str
        """
        return self._dynamic_secret_value

    @dynamic_secret_value.setter
    def dynamic_secret_value(self, dynamic_secret_value):
        """Sets the dynamic_secret_value of this PullDynamicSecretValueReplyObj.

        The dynamic secret value that created on demand.  # noqa: E501

        :param dynamic_secret_value: The dynamic_secret_value of this PullDynamicSecretValueReplyObj.  # noqa: E501
        :type: str
        """

        self._dynamic_secret_value = dynamic_secret_value

    @property
    def dynamic_secret_value_id(self):
        """Gets the dynamic_secret_value_id of this PullDynamicSecretValueReplyObj.  # noqa: E501

        The ID of the new dynamic secret value  # noqa: E501

        :return: The dynamic_secret_value_id of this PullDynamicSecretValueReplyObj.  # noqa: E501
        :rtype: str
        """
        return self._dynamic_secret_value_id

    @dynamic_secret_value_id.setter
    def dynamic_secret_value_id(self, dynamic_secret_value_id):
        """Sets the dynamic_secret_value_id of this PullDynamicSecretValueReplyObj.

        The ID of the new dynamic secret value  # noqa: E501

        :param dynamic_secret_value_id: The dynamic_secret_value_id of this PullDynamicSecretValueReplyObj.  # noqa: E501
        :type: str
        """

        self._dynamic_secret_value_id = dynamic_secret_value_id

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(PullDynamicSecretValueReplyObj, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, PullDynamicSecretValueReplyObj):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
