# coding: utf-8

"""
    UAM - Application API

    UAM manages client accounts and allows each client to define items, roles and auth methods. The core operations of UAM are as follows: Creating new accounts. For each account: Creating items. Adding new auth methods Adding new roles creating roles - auth methods association. Returning the key's metadata together with temporary access credentials in order to access the key fragments.  # noqa: E501

    OpenAPI spec version: 0.1.0
    Contact: refael@akeyless-security.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six

from akeyless_uam_api.models.rsa_decrypt_creds import RSADecryptCreds  # noqa: F401,E501
from akeyless_uam_api.models.ssh_certificate_params import SSHCertificateParams  # noqa: F401,E501


class SSHCertIssuerAccessCredsReplyObj(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'certificate_params': 'SSHCertificateParams',
        'item_id': 'int',
        'item_name': 'str',
        'item_type': 'str',
        'item_version': 'int',
        'key_signing_creds': 'RSADecryptCreds'
    }

    attribute_map = {
        'certificate_params': 'certificate_params',
        'item_id': 'item_id',
        'item_name': 'item_name',
        'item_type': 'item_type',
        'item_version': 'item_version',
        'key_signing_creds': 'key_signing_creds'
    }

    def __init__(self, certificate_params=None, item_id=None, item_name=None, item_type=None, item_version=None, key_signing_creds=None):  # noqa: E501
        """SSHCertIssuerAccessCredsReplyObj - a model defined in Swagger"""  # noqa: E501

        self._certificate_params = None
        self._item_id = None
        self._item_name = None
        self._item_type = None
        self._item_version = None
        self._key_signing_creds = None
        self.discriminator = None

        if certificate_params is not None:
            self.certificate_params = certificate_params
        if item_id is not None:
            self.item_id = item_id
        if item_name is not None:
            self.item_name = item_name
        if item_type is not None:
            self.item_type = item_type
        if item_version is not None:
            self.item_version = item_version
        if key_signing_creds is not None:
            self.key_signing_creds = key_signing_creds

    @property
    def certificate_params(self):
        """Gets the certificate_params of this SSHCertIssuerAccessCredsReplyObj.  # noqa: E501


        :return: The certificate_params of this SSHCertIssuerAccessCredsReplyObj.  # noqa: E501
        :rtype: SSHCertificateParams
        """
        return self._certificate_params

    @certificate_params.setter
    def certificate_params(self, certificate_params):
        """Sets the certificate_params of this SSHCertIssuerAccessCredsReplyObj.


        :param certificate_params: The certificate_params of this SSHCertIssuerAccessCredsReplyObj.  # noqa: E501
        :type: SSHCertificateParams
        """

        self._certificate_params = certificate_params

    @property
    def item_id(self):
        """Gets the item_id of this SSHCertIssuerAccessCredsReplyObj.  # noqa: E501


        :return: The item_id of this SSHCertIssuerAccessCredsReplyObj.  # noqa: E501
        :rtype: int
        """
        return self._item_id

    @item_id.setter
    def item_id(self, item_id):
        """Sets the item_id of this SSHCertIssuerAccessCredsReplyObj.


        :param item_id: The item_id of this SSHCertIssuerAccessCredsReplyObj.  # noqa: E501
        :type: int
        """

        self._item_id = item_id

    @property
    def item_name(self):
        """Gets the item_name of this SSHCertIssuerAccessCredsReplyObj.  # noqa: E501

        The name, id, version and type of the ssh cert issuer item  # noqa: E501

        :return: The item_name of this SSHCertIssuerAccessCredsReplyObj.  # noqa: E501
        :rtype: str
        """
        return self._item_name

    @item_name.setter
    def item_name(self, item_name):
        """Sets the item_name of this SSHCertIssuerAccessCredsReplyObj.

        The name, id, version and type of the ssh cert issuer item  # noqa: E501

        :param item_name: The item_name of this SSHCertIssuerAccessCredsReplyObj.  # noqa: E501
        :type: str
        """

        self._item_name = item_name

    @property
    def item_type(self):
        """Gets the item_type of this SSHCertIssuerAccessCredsReplyObj.  # noqa: E501


        :return: The item_type of this SSHCertIssuerAccessCredsReplyObj.  # noqa: E501
        :rtype: str
        """
        return self._item_type

    @item_type.setter
    def item_type(self, item_type):
        """Sets the item_type of this SSHCertIssuerAccessCredsReplyObj.


        :param item_type: The item_type of this SSHCertIssuerAccessCredsReplyObj.  # noqa: E501
        :type: str
        """

        self._item_type = item_type

    @property
    def item_version(self):
        """Gets the item_version of this SSHCertIssuerAccessCredsReplyObj.  # noqa: E501


        :return: The item_version of this SSHCertIssuerAccessCredsReplyObj.  # noqa: E501
        :rtype: int
        """
        return self._item_version

    @item_version.setter
    def item_version(self, item_version):
        """Sets the item_version of this SSHCertIssuerAccessCredsReplyObj.


        :param item_version: The item_version of this SSHCertIssuerAccessCredsReplyObj.  # noqa: E501
        :type: int
        """

        self._item_version = item_version

    @property
    def key_signing_creds(self):
        """Gets the key_signing_creds of this SSHCertIssuerAccessCredsReplyObj.  # noqa: E501


        :return: The key_signing_creds of this SSHCertIssuerAccessCredsReplyObj.  # noqa: E501
        :rtype: RSADecryptCreds
        """
        return self._key_signing_creds

    @key_signing_creds.setter
    def key_signing_creds(self, key_signing_creds):
        """Sets the key_signing_creds of this SSHCertIssuerAccessCredsReplyObj.


        :param key_signing_creds: The key_signing_creds of this SSHCertIssuerAccessCredsReplyObj.  # noqa: E501
        :type: RSADecryptCreds
        """

        self._key_signing_creds = key_signing_creds

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(SSHCertIssuerAccessCredsReplyObj, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, SSHCertIssuerAccessCredsReplyObj):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
