# coding: utf-8

"""
    UAM - Application API

    UAM manages client accounts and allows each client to define items, roles and auth methods. The core operations of UAM are as follows: Creating new accounts. For each account: Creating items. Adding new auth methods Adding new roles creating roles - auth methods association. Returning the key's metadata together with temporary access credentials in order to access the key fragments.  # noqa: E501

    OpenAPI spec version: 0.1.0
    Contact: refael@akeyless-security.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from __future__ import absolute_import

import unittest

import akeyless_uam_api
from akeyless_uam_api.api.default_api import DefaultApi  # noqa: E501
from akeyless_uam_api.rest import ApiException


class TestDefaultApi(unittest.TestCase):
    """DefaultApi unit test stubs"""

    def setUp(self):
        self.api = akeyless_uam_api.api.default_api.DefaultApi()  # noqa: E501

    def tearDown(self):
        pass

    def test_authenticate(self):
        """Test case for authenticate

        Return a temporary access credentials  # noqa: E501
        """
        pass

    def test_authenticate_uam(self):
        """Test case for authenticate_uam

        Return a combination of three temporary access credentials for accessing Auth, UAM and KFMs instances.  # noqa: E501
        """
        pass

    def test_create_access(self):
        """Test case for create_access

        Creating a new access.  # noqa: E501
        """
        pass

    def test_create_account(self):
        """Test case for create_account

        Create new account.  # noqa: E501
        """
        pass

    def test_create_account_creds(self):
        """Test case for create_account_creds

        Getting temporary access credentials to create new account in the UAM service. The UAM service will use this credentials to create an access to be used for accessing the account  # noqa: E501
        """
        pass

    def test_create_auth_method(self):
        """Test case for create_auth_method

        Add a new auth method to the account.  # noqa: E501
        """
        pass

    def test_create_item(self):
        """Test case for create_item

        Add a new item to the account.  # noqa: E501
        """
        pass

    def test_create_role(self):
        """Test case for create_role

        Add a new role to the account.  # noqa: E501
        """
        pass

    def test_create_role_auth_method_assoc(self):
        """Test case for create_role_auth_method_assoc

        Add an association between a role and an auth method.  # noqa: E501
        """
        pass

    def test_delete_access(self):
        """Test case for delete_access

        Deleting an existing access.  # noqa: E501
        """
        pass

    def test_delete_auth_method(self):
        """Test case for delete_auth_method

        Deleting an existing auth method from the account.  # noqa: E501
        """
        pass

    def test_delete_item(self):
        """Test case for delete_item

        Deleting an existing item from the account.  # noqa: E501
        """
        pass

    def test_delete_role(self):
        """Test case for delete_role

        Deleting an existing role from the account.  # noqa: E501
        """
        pass

    def test_delete_role_auth_method_assoc(self):
        """Test case for delete_role_auth_method_assoc

        Deleting an association between a role and an auth method.  # noqa: E501
        """
        pass

    def test_get_access(self):
        """Test case for get_access

        Getting an existing access.  # noqa: E501
        """
        pass

    def test_get_accesses(self):
        """Test case for get_accesses

        Geting a list of accesses  # noqa: E501
        """
        pass

    def test_get_account_auth_methods(self):
        """Test case for get_account_auth_methods

        Get All the existing auth methods in the account.  # noqa: E501
        """
        pass

    def test_get_account_details(self):
        """Test case for get_account_details

        Get account details.  # noqa: E501
        """
        pass

    def test_get_account_roles(self):
        """Test case for get_account_roles

        Get All the existing roles in the account.  # noqa: E501
        """
        pass

    def test_get_auth_method(self):
        """Test case for get_auth_method

        Get auth method details.  # noqa: E501
        """
        pass

    def test_get_auth_status(self):
        """Test case for get_auth_status

        """
        pass

    def test_get_dynamic_secret_mq_access(self):
        """Test case for get_dynamic_secret_mq_access

        Get a signed request to receive messages from a Message Queue of a Dynamic Secret.  # noqa: E501
        """
        pass

    def test_get_dynamic_secret_producer_creds(self):
        """Test case for get_dynamic_secret_producer_creds

        Get a dynamic secret producer derivation credentials.  # noqa: E501
        """
        pass

    def test_get_item(self):
        """Test case for get_item

        Get item details.  # noqa: E501
        """
        pass

    def test_get_item_derivation_creds(self):
        """Test case for get_item_derivation_creds

        Get temporary access credentials to KFM instances for item's fragments derivation.  # noqa: E501
        """
        pass

    def test_get_public_signing_key(self):
        """Test case for get_public_signing_key

        Getting the public part of the key used by Auth to sign the temporary access credentials.  # noqa: E501
        """
        pass

    def test_get_role(self):
        """Test case for get_role

        Get role details.  # noqa: E501
        """
        pass

    def test_get_rsa_key_decrypt_creds(self):
        """Test case for get_rsa_key_decrypt_creds

        Get temporary access credentials to KFM instances for RSA key fragments decryption.  # noqa: E501
        """
        pass

    def test_get_secret_access_creds(self):
        """Test case for get_secret_access_creds

        """
        pass

    def test_get_ssh_cert_issuer_access_creds(self):
        """Test case for get_ssh_cert_issuer_access_creds

        Get temporary access credentials to KFM instances for signing a specific SSH certificate.  # noqa: E501
        """
        pass

    def test_get_status(self):
        """Test case for get_status

        """
        pass

    def test_get_time(self):
        """Test case for get_time

        """
        pass

    def test_get_upload_rsa_key_creds(self):
        """Test case for get_upload_rsa_key_creds

        Get temporary access credentials to upload RSA private key fragments into KFMs instances.  # noqa: E501
        """
        pass

    def test_get_upload_secret_creds(self):
        """Test case for get_upload_secret_creds

        Get temporary access credentials to KFM instances to produce the derived protection key of the secret.  # noqa: E501
        """
        pass

    def test_list_items(self):
        """Test case for list_items

        List all the accessible items.  # noqa: E501
        """
        pass

    def test_list_items_in_path(self):
        """Test case for list_items_in_path

        List items at the given path.  # noqa: E501
        """
        pass

    def test_prepare_dynamic_secret_value(self):
        """Test case for prepare_dynamic_secret_value

        Get the new dynamic secret ID to be pull and derivation credentials to decrypt the new dynamic secret value.  # noqa: E501
        """
        pass

    def test_pull_dynamic_secret_value(self):
        """Test case for pull_dynamic_secret_value

        Pull a new dynamic secret value on demand.  # noqa: E501
        """
        pass

    def test_push_dynamic_secret_value(self):
        """Test case for push_dynamic_secret_value

        Push a new dynamic secret value on demand.  # noqa: E501
        """
        pass

    def test_reset_access_key(self):
        """Test case for reset_access_key

        Getting a validation number to reset an admin account's access key.  # noqa: E501
        """
        pass

    def test_reset_access_key_0(self):
        """Test case for reset_access_key_0

        Getting temporary access credentials to reset an account's access key. The UAM service will use these credentials to update the account's api key auth method.  # noqa: E501
        """
        pass

    def test_reset_admin_account_access_key(self):
        """Test case for reset_admin_account_access_key

        Reset admin account access key.  # noqa: E501
        """
        pass

    def test_set_uam_access_creds(self):
        """Test case for set_uam_access_creds

        Getting temporary access credentials to add a new access or to update an existing access in an UAM account. The UAM service will use this credentials to create/update an access to be used for accessing key fragments.  # noqa: E501
        """
        pass

    def test_update_access(self):
        """Test case for update_access

        Updating an existing access  # noqa: E501
        """
        pass

    def test_update_auth_method(self):
        """Test case for update_auth_method

        Updating an existing auth method in the account  # noqa: E501
        """
        pass

    def test_update_item(self):
        """Test case for update_item

        """
        pass

    def test_update_role(self):
        """Test case for update_role

        Updating an existing role in the account  # noqa: E501
        """
        pass

    def test_validate_account(self):
        """Test case for validate_account

        Request new validation number.  # noqa: E501
        """
        pass

    def test_validate_account_0(self):
        """Test case for validate_account_0

        Request new validation number.  # noqa: E501
        """
        pass

    def test_validate_client_credentials(self):
        """Test case for validate_client_credentials

        Validate client credentials  # noqa: E501
        """
        pass


if __name__ == '__main__':
    unittest.main()
