# -*- coding: utf-8 -*-
from setuptools import setup

package_dir = \
{'': 'src'}

packages = \
['dbt_osmosis', 'dbt_osmosis.exceptions', 'dbt_osmosis.utils']

package_data = \
{'': ['*']}

install_requires = \
['click>=8.0.1,<9.0.0',
 'dbt>=0.20.2,<0.21.0',
 'rich>=10.11.0,<11.0.0',
 'ruamel.yaml>=0.17.16,<0.18.0']

entry_points = \
{'console_scripts': ['dbt-osmosis = dbt_osmosis.main:cli']}

setup_kwargs = {
    'name': 'dbt-osmosis',
    'version': '0.2.1',
    'description': 'This package serves to cascadingly populate column level documentation, build & conform schema files, and audit coverage.',
    'long_description': '# dbt-osmosis\n\n<!--![GitHub Actions](https://github.com/z3z1ma/dbt-osmosis/actions/workflows/master.yml/badge.svg)-->\n\n<!--![PyPI](https://img.shields.io/pypi/v/dbt-osmosis)-->\n\n<!--![Downloads](https://pepy.tech/badge/dbt-osmosis)-->\n\n![License: Apache 2.0](https://img.shields.io/badge/License-Apache_2.0-green.svg)\n\n![black](https://img.shields.io/badge/code%20style-black-000000.svg)\n\n## Primary Objectives\nFirst and foremost, we want dbt documentation to retain a DRY principle. Every time we repeat ourselves, we waste our time. 80% of documentation is often a matter of inheritance and continued passing down of columns from parent models to children. they need not be redocumented if there has been no mutation. Second, we want to standardize ways that we all organize our schema files which hold the fruits of our documentation. We should be able to enforce a standard on a per directory basis and jump between layouts at will as certain folder scale up the number of models or scale down. Lastly, and tangential to the first objective, we want to understand column level lineage and automate impact analysis.\n\n\n## How to Use\n\ndbt-osmosis is ready to use as-is. To get familiar, you should run it on a fresh branch and ensure everything is backed in source control. Enjoy!\n\nTo use dbt-osmosis, simply run the following:\n\n```bash\n# Install\npip install dbt-osmosis\n# Alternatively\npipx install dbt-osmosis\n\n\n# This command executes all tasks in preferred order and is usually all you need\ndbt-osmosis run --project-dir /path/to/dbt/project --target prod\n\n\n# Inherit documentation in staging/salesforce/ & sync schema yaml columns with database columns\ndbt-osmosis document --project-dir /path/to/dbt/project --target prod --fqn staging.salesforce\n\n\n# Reorganize marts/operations/ & inject undocumented models into schema files or create new schema files as needed\ndbt-osmosis compose --project-dir /path/to/dbt/project --target prod --fqn marts.operations\n```\n\n## Roadmap\n\nThese features are being actively developed and will be merged into the next few minor releases\n\n1. Complete build out of `sources` tools.\n2. Add `--min-cov` flag to audit task\n3. Add interactive documentation flag that engages user to documents ONLY progenitors and novel columns for a subset of models (the most optimized path to full documentation coverage feasible)\n4. Add `impact` command that allows us to leverage our resolved column level progenitors for ad hoc impact analysis\n\n## Features\n\n### Standardize organization of schema files (and provide ability to define and conform with code)\n\n- Config can be set on per directory basis if desired utilizing `dbt_project.yml`, all models which are processed require direct or inherited config `+dbt-osmosis:`. If even one dir is missing the config, we close gracefully and inform user to update dbt_project.yml. No assumed defaults. Placing our config under your dbt project name in `models:` is enough to set a default for the project since the config applies to all subdirectories. \n\n    Note: You can **change these configs as often as you like** or try them all, dbt-osmosis will take care of restructuring your project schema files-- _no human effort required_. \n\n    A directory can be configured to conform to any one of the following standards:\n\n    - Can be one schema file to one model file sharing the same name and directory ie. \n\n            staging/\n                stg_order.sql\n                stg_order.yml\n                stg_customer.sql\n                stg_customer.yml\n\n        - `+dbt-osmosis: "model.yml"`\n\n    - Can be one schema file per directory wherever model files reside named schema.yml, ie.\n\n            staging/\n                stg_order.sql\n                stg_customer.sql\n                schema.yml\n\n        - `+dbt-osmosis: "schema.yml"`\n    - Can be one schema file per directory wherever model files reside named after its containing folder, ie. \n\n            staging/\n                stg_order.sql\n                stg_customer.sql\n                staging.yml\n\n        - `+dbt-osmosis: "folder.yml"`\n\n    - Can be one schema file to one model file sharing the same name _nested_ in a schema subdir wherever model files reside, ie. \n\n            staging/\n                stg_order.sql\n                stg_customer.sql\n                schema/\n                    stg_order.yml\n                    stg_customer.yml\n\n        - `+dbt-osmosis: "schema/model.yml"`\n\n### Build and Inject Non-documented models\n\n- Injected models will automatically conform to above config per directory based on location of model file. \n\n- This means you can focus fully on modelling; and documentation, including yaml updates or creation, will automatically follow at any time with simple invocation of dbt-osmosis\n\n### Propagate existing column level documentation downward to children\n\n- Build column level knowledge graph accumulated and updated from furthest identifiable origin (ancestors) to immediate parents\n\n- Will automatically populate undocumented columns of the same name with passed down knowledge accumulated within the context of the models upstream dependency tree\n\n- This means you can freely generate models and all columns you pull into the models SQL that already have been documented will be automatically learned/propagated. Again the focus for analysts is almost fully on modelling and yaml work is an afterthought / less heavy of a manual lift.\n\n### Order Matters\n\nIn a full run [ `dbt-osmosis run` ] we will:\n\n1. Conform dbt project\n    - Configuration lives in `dbt_project.yml` --> we require our config to run, can be at root level of `models:` to apply a default convention to a project \n    or can be folder by folder, follows dbt config resolution where config is overridden by scope. \n    Config is called `+dbt-osmosis: "folder.yml" | "schema.yml" | "model.yml" | "schema/model.yml"`\n2. Bootstrap models to ensure all models exist\n3. Recompile Manifest\n4. Propagate definitions downstream to undocumented models solely within the context of each models dependency tree\n\n\n## New workflows enabled!\n\n1. Build one dbt model or a __bunch__ of them without documenting anything (gasp)\n\n    Run `dbt-osmosis run` or `dbt-osmosis compose && dbt-osmosis document`\n    \n    Sit back and watch as:\n\n    Automatically constructed/updated schema yamls are built with as much of the definitions pre-populated as possible from upstream dependencies \n    \n    Schema yaml(s) are automatically organized in exactly the right directories / style that conform to the easily configurable standard upheld and enforced across your dbt project on a directory by directory basis \n    \n    boom, mic drop\n\n2. Problem reported by stakeholder with data **(WIP)**\n    \n    Identify column\n    \n    Run `dbt-osmosis impact --model orders --column price`\n    \n    Find the originating model and action\n\n3. Need to score our documentation **(WIP)**\n\n    Run `dbt-osmosis audit --docs --min-cov 80`\n\n    Get a curated list of all the documentation to update in your pre-bootstrapped dbt project\n\n    Sip coffee and engage in documentation\n\n4. Add dbt-osmosis to a pre-commit hook to ensure all your analysts are passing down column level documentation & reaching your designated min-coverage',
    'author': 'Falador_wiz1',
    'author_email': 'alex@source.co',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/z3z1ma/dbt-osmosis',
    'package_dir': package_dir,
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'entry_points': entry_points,
    'python_requires': '>=3.8,<4.0',
}


setup(**setup_kwargs)
