"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ManagedInstanceRole = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const constructs_1 = require("constructs");
class ManagedInstanceRole extends constructs_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        var managedPolicies = props.managedPolicies === undefined ? [] : props.managedPolicies;
        let domainJoinEnabled = props.domainJoinEnabled === undefined ||
            props.domainJoinEnabled === true;
        let ssmManagementEnabled = props.ssmManagementEnabled === undefined ||
            props.domainJoinEnabled === undefined ||
            props.domainJoinEnabled === true ||
            props.ssmManagementEnabled === true;
        if (ssmManagementEnabled) {
            managedPolicies.push(aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName('AmazonSSMManagedInstanceCore'));
        }
        ;
        if (domainJoinEnabled) {
            managedPolicies.push(aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName('AmazonSSMDirectoryServiceAccess'));
        }
        ;
        this.role = new aws_cdk_lib_1.aws_iam.Role(this, 'role', {
            assumedBy: new aws_cdk_lib_1.aws_iam.ServicePrincipal('ec2.amazonaws.com'),
            managedPolicies,
        });
        if (props.createInstanceProfile === undefined || props.createInstanceProfile === true) {
            this.instanceProfile = new aws_cdk_lib_1.aws_iam.CfnInstanceProfile(this, 'instanceProfile', {
                roles: [this.role.roleName],
            });
        }
        this.name = this.role.roleName;
        this.arn = this.role.roleArn;
    }
}
exports.ManagedInstanceRole = ManagedInstanceRole;
_a = JSII_RTTI_SYMBOL_1;
ManagedInstanceRole[_a] = { fqn: "@renovosolutions/cdk-library-managed-instance-role.ManagedInstanceRole", version: "2.2.61" };
//# sourceMappingURL=data:application/json;base64,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