# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union
from .. import _utilities, _tables

__all__ = ['TargetGrpcProxy']


class TargetGrpcProxy(pulumi.CustomResource):
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 url_map: Optional[pulumi.Input[str]] = None,
                 validate_for_proxyless: Optional[pulumi.Input[bool]] = None,
                 __props__=None,
                 __name__=None,
                 __opts__=None):
        """
        Represents a Target gRPC Proxy resource. A target gRPC proxy is a component
        of load balancers intended for load balancing gRPC traffic. Global forwarding
        rules reference a target gRPC proxy. The Target gRPC Proxy references
        a URL map which specifies how traffic routes to gRPC backend services.

        To get more information about TargetGrpcProxy, see:

        * [API documentation](https://cloud.google.com/compute/docs/reference/rest/v1/targetGrpcProxies)
        * How-to Guides
            * [Using Target gRPC Proxies](https://cloud.google.com/traffic-director/docs/proxyless-overview)

        ## Example Usage

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] description: An optional description of this resource.
        :param pulumi.Input[str] name: Name of the resource. Provided by the client when the resource
               is created. The name must be 1-63 characters long, and comply
               with RFC1035. Specifically, the name must be 1-63 characters long
               and match the regular expression `a-z?` which
               means the first character must be a lowercase letter, and all
               following characters must be a dash, lowercase letter, or digit,
               except the last character, which cannot be a dash.
        :param pulumi.Input[str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[str] url_map: URL to the UrlMap resource that defines the mapping from URL to
               the BackendService. The protocol field in the BackendService
               must be set to GRPC.
        :param pulumi.Input[bool] validate_for_proxyless: If true, indicates that the BackendServices referenced by
               the urlMap may be accessed by gRPC applications without using
               a sidecar proxy. This will enable configuration checks on urlMap
               and its referenced BackendServices to not allow unsupported features.
               A gRPC application must use "xds:///" scheme in the target URI
               of the service it is connecting to. If false, indicates that the
               BackendServices referenced by the urlMap will be accessed by gRPC
               applications via a sidecar proxy. In this case, a gRPC application
               must not use "xds:///" scheme in the target URI of the service
               it is connecting to
        """
        if __name__ is not None:
            warnings.warn("explicit use of __name__ is deprecated", DeprecationWarning)
            resource_name = __name__
        if __opts__ is not None:
            warnings.warn("explicit use of __opts__ is deprecated, use 'opts' instead", DeprecationWarning)
            opts = __opts__
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = dict()

            __props__['description'] = description
            __props__['name'] = name
            __props__['project'] = project
            __props__['url_map'] = url_map
            __props__['validate_for_proxyless'] = validate_for_proxyless
            __props__['creation_timestamp'] = None
            __props__['fingerprint'] = None
            __props__['self_link'] = None
            __props__['self_link_with_id'] = None
        super(TargetGrpcProxy, __self__).__init__(
            'gcp:compute/targetGrpcProxy:TargetGrpcProxy',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            creation_timestamp: Optional[pulumi.Input[str]] = None,
            description: Optional[pulumi.Input[str]] = None,
            fingerprint: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            project: Optional[pulumi.Input[str]] = None,
            self_link: Optional[pulumi.Input[str]] = None,
            self_link_with_id: Optional[pulumi.Input[str]] = None,
            url_map: Optional[pulumi.Input[str]] = None,
            validate_for_proxyless: Optional[pulumi.Input[bool]] = None) -> 'TargetGrpcProxy':
        """
        Get an existing TargetGrpcProxy resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] creation_timestamp: Creation timestamp in RFC3339 text format.
        :param pulumi.Input[str] description: An optional description of this resource.
        :param pulumi.Input[str] fingerprint: Fingerprint of this resource. A hash of the contents stored in this object. This field is used in optimistic locking.
               This field will be ignored when inserting a TargetGrpcProxy. An up-to-date fingerprint must be provided in order to
               patch/update the TargetGrpcProxy; otherwise, the request will fail with error 412 conditionNotMet. To see the latest
               fingerprint, make a get() request to retrieve the TargetGrpcProxy. A base64-encoded string.
        :param pulumi.Input[str] name: Name of the resource. Provided by the client when the resource
               is created. The name must be 1-63 characters long, and comply
               with RFC1035. Specifically, the name must be 1-63 characters long
               and match the regular expression `a-z?` which
               means the first character must be a lowercase letter, and all
               following characters must be a dash, lowercase letter, or digit,
               except the last character, which cannot be a dash.
        :param pulumi.Input[str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[str] self_link: The URI of the created resource.
        :param pulumi.Input[str] self_link_with_id: Server-defined URL with id for the resource.
        :param pulumi.Input[str] url_map: URL to the UrlMap resource that defines the mapping from URL to
               the BackendService. The protocol field in the BackendService
               must be set to GRPC.
        :param pulumi.Input[bool] validate_for_proxyless: If true, indicates that the BackendServices referenced by
               the urlMap may be accessed by gRPC applications without using
               a sidecar proxy. This will enable configuration checks on urlMap
               and its referenced BackendServices to not allow unsupported features.
               A gRPC application must use "xds:///" scheme in the target URI
               of the service it is connecting to. If false, indicates that the
               BackendServices referenced by the urlMap will be accessed by gRPC
               applications via a sidecar proxy. In this case, a gRPC application
               must not use "xds:///" scheme in the target URI of the service
               it is connecting to
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = dict()

        __props__["creation_timestamp"] = creation_timestamp
        __props__["description"] = description
        __props__["fingerprint"] = fingerprint
        __props__["name"] = name
        __props__["project"] = project
        __props__["self_link"] = self_link
        __props__["self_link_with_id"] = self_link_with_id
        __props__["url_map"] = url_map
        __props__["validate_for_proxyless"] = validate_for_proxyless
        return TargetGrpcProxy(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="creationTimestamp")
    def creation_timestamp(self) -> pulumi.Output[str]:
        """
        Creation timestamp in RFC3339 text format.
        """
        return pulumi.get(self, "creation_timestamp")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        """
        An optional description of this resource.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def fingerprint(self) -> pulumi.Output[str]:
        """
        Fingerprint of this resource. A hash of the contents stored in this object. This field is used in optimistic locking.
        This field will be ignored when inserting a TargetGrpcProxy. An up-to-date fingerprint must be provided in order to
        patch/update the TargetGrpcProxy; otherwise, the request will fail with error 412 conditionNotMet. To see the latest
        fingerprint, make a get() request to retrieve the TargetGrpcProxy. A base64-encoded string.
        """
        return pulumi.get(self, "fingerprint")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Name of the resource. Provided by the client when the resource
        is created. The name must be 1-63 characters long, and comply
        with RFC1035. Specifically, the name must be 1-63 characters long
        and match the regular expression `a-z?` which
        means the first character must be a lowercase letter, and all
        following characters must be a dash, lowercase letter, or digit,
        except the last character, which cannot be a dash.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def project(self) -> pulumi.Output[str]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @property
    @pulumi.getter(name="selfLink")
    def self_link(self) -> pulumi.Output[str]:
        """
        The URI of the created resource.
        """
        return pulumi.get(self, "self_link")

    @property
    @pulumi.getter(name="selfLinkWithId")
    def self_link_with_id(self) -> pulumi.Output[str]:
        """
        Server-defined URL with id for the resource.
        """
        return pulumi.get(self, "self_link_with_id")

    @property
    @pulumi.getter(name="urlMap")
    def url_map(self) -> pulumi.Output[Optional[str]]:
        """
        URL to the UrlMap resource that defines the mapping from URL to
        the BackendService. The protocol field in the BackendService
        must be set to GRPC.
        """
        return pulumi.get(self, "url_map")

    @property
    @pulumi.getter(name="validateForProxyless")
    def validate_for_proxyless(self) -> pulumi.Output[Optional[bool]]:
        """
        If true, indicates that the BackendServices referenced by
        the urlMap may be accessed by gRPC applications without using
        a sidecar proxy. This will enable configuration checks on urlMap
        and its referenced BackendServices to not allow unsupported features.
        A gRPC application must use "xds:///" scheme in the target URI
        of the service it is connecting to. If false, indicates that the
        BackendServices referenced by the urlMap will be accessed by gRPC
        applications via a sidecar proxy. In this case, a gRPC application
        must not use "xds:///" scheme in the target URI of the service
        it is connecting to
        """
        return pulumi.get(self, "validate_for_proxyless")

    def translate_output_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop

    def translate_input_property(self, prop):
        return _tables.SNAKE_TO_CAMEL_CASE_TABLE.get(prop) or prop

