# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union
from .. import _utilities, _tables

__all__ = [
    'GetTensorflowVersionsResult',
    'AwaitableGetTensorflowVersionsResult',
    'get_tensorflow_versions',
]

@pulumi.output_type
class GetTensorflowVersionsResult:
    """
    A collection of values returned by getTensorflowVersions.
    """
    def __init__(__self__, id=None, project=None, versions=None, zone=None):
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if project and not isinstance(project, str):
            raise TypeError("Expected argument 'project' to be a str")
        pulumi.set(__self__, "project", project)
        if versions and not isinstance(versions, list):
            raise TypeError("Expected argument 'versions' to be a list")
        pulumi.set(__self__, "versions", versions)
        if zone and not isinstance(zone, str):
            raise TypeError("Expected argument 'zone' to be a str")
        pulumi.set(__self__, "zone", zone)

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def project(self) -> str:
        return pulumi.get(self, "project")

    @property
    @pulumi.getter
    def versions(self) -> Sequence[str]:
        """
        The list of TensorFlow versions available for the given project and zone.
        """
        return pulumi.get(self, "versions")

    @property
    @pulumi.getter
    def zone(self) -> str:
        return pulumi.get(self, "zone")


class AwaitableGetTensorflowVersionsResult(GetTensorflowVersionsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetTensorflowVersionsResult(
            id=self.id,
            project=self.project,
            versions=self.versions,
            zone=self.zone)


def get_tensorflow_versions(project: Optional[str] = None,
                            zone: Optional[str] = None,
                            opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetTensorflowVersionsResult:
    """
    Get TensorFlow versions available for a project. For more information see the [official documentation](https://cloud.google.com/tpu/docs/) and [API](https://cloud.google.com/tpu/docs/reference/rest/v1/projects.locations.tensorflowVersions).


    :param str project: The project to list versions for. If it
           is not provided, the provider project is used.
    :param str zone: The zone to list versions for. If it
           is not provided, the provider zone is used.
    """
    __args__ = dict()
    __args__['project'] = project
    __args__['zone'] = zone
    if opts is None:
        opts = pulumi.InvokeOptions()
    if opts.version is None:
        opts.version = _utilities.get_version()
    __ret__ = pulumi.runtime.invoke('gcp:tpu/getTensorflowVersions:getTensorflowVersions', __args__, opts=opts, typ=GetTensorflowVersionsResult).value

    return AwaitableGetTensorflowVersionsResult(
        id=__ret__.id,
        project=__ret__.project,
        versions=__ret__.versions,
        zone=__ret__.zone)
