"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const core_1 = require("@aws-cdk/core");
const logs_generated_1 = require("./logs.generated");
/**
 * A filter that extracts information from CloudWatch Logs and emits to CloudWatch Metrics
 */
class MetricFilter extends core_1.Resource {
    constructor(scope, id, props) {
        super(scope, id);
        // It looks odd to map this object to a singleton list, but that's how
        // we're supposed to do it according to the docs.
        //
        // > Currently, you can specify only one metric transformation for
        // > each metric filter. If you want to specify multiple metric
        // > transformations, you must specify multiple metric filters.
        //
        // https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-logs-metricfilter.html
        new logs_generated_1.CfnMetricFilter(this, 'Resource', {
            logGroupName: props.logGroup.logGroupName,
            filterPattern: props.filterPattern.logPatternString,
            metricTransformations: [{
                    metricNamespace: props.metricNamespace,
                    metricName: props.metricName,
                    metricValue: props.metricValue !== undefined ? props.metricValue : '1',
                    defaultValue: props.defaultValue,
                }],
        });
    }
}
exports.MetricFilter = MetricFilter;
//# sourceMappingURL=data:application/json;base64,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