# Allen Institute Software License - This software license is the 2-clause BSD
# license plus a third clause that prohibits redistribution for commercial
# purposes without further permission.
#
# Copyright 2017. Allen Institute. All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are met:
#
# 1. Redistributions of source code must retain the above copyright notice,
# this list of conditions and the following disclaimer.
#
# 2. Redistributions in binary form must reproduce the above copyright notice,
# this list of conditions and the following disclaimer in the documentation
# and/or other materials provided with the distribution.
#
# 3. Redistributions for commercial purposes are not permitted without the
# Allen Institute's written permission.
# For purposes of this license, commercial purposes is the incorporation of the
# Allen Institute's software into anything for which you will charge fees or
# other compensation. Contact terms@alleninstitute.org for commercial licensing
# opportunities.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
# AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE
# LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
# CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
# SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
# INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
# CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
# ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
# POSSIBILITY OF SUCH DAMAGE.
#
from ..api import Api


class SvgApi(Api):

    def __init__(self, base_uri=None):
        super(SvgApi, self).__init__(base_uri)

    def build_query(self, section_image_id, groups=None, download=False):
        '''Build the URL that will fetch meta data for the specified structure.

        Parameters
        ----------
        section_image_id : integer
            Key of the object to be retrieved.
        groups : array of integers
            Keys of the group labels to filter the svg types that are returned.

        Returns
        -------
        url : string
            The constructed URL
        '''
        if download is True:
            endpoint = self.svg_download_endpoint
        else:
            endpoint = self.svg_endpoint

        if groups is None:
            groups = []

        if groups and len(groups) > 0:
            url_params = '?groups=' + ','.join([str(g) for g in groups])
        else:
            url_params = ''

        url = ''.join([endpoint,
                       '/',
                       str(section_image_id),
                       url_params])

        return url

    def download_svg(self,
                     section_image_id,
                     groups=None,
                     file_path=None):
        '''Download the svg file'''
        if file_path is None:
            file_path = '%d.svg' % (section_image_id)

        svg_url = self.build_query(section_image_id, groups, download=True)
        self.retrieve_file_over_http(svg_url, file_path)

    def get_svg(self,
                section_image_id,
                groups=None):
        '''Get the svg document.'''
        svg_url = self.build_query(section_image_id, groups)

        return self.retrieve_xml_over_http(svg_url)
