# Allen Institute Software License - This software license is the 2-clause BSD
# license plus a third clause that prohibits redistribution for commercial
# purposes without further permission.
#
# Copyright 2014-2016. Allen Institute. All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are met:
#
# 1. Redistributions of source code must retain the above copyright notice,
# this list of conditions and the following disclaimer.
#
# 2. Redistributions in binary form must reproduce the above copyright notice,
# this list of conditions and the following disclaimer in the documentation
# and/or other materials provided with the distribution.
#
# 3. Redistributions for commercial purposes are not permitted without the
# Allen Institute's written permission.
# For purposes of this license, commercial purposes is the incorporation of the
# Allen Institute's software into anything for which you will charge fees or
# other compensation. Contact terms@alleninstitute.org for commercial licensing
# opportunities.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
# AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE
# LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
# CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
# SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
# INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
# CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
# ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
# POSSIBILITY OF SUCH DAMAGE.
#
import os
import subprocess as sp
import logging
from .config import Config


def choose_bps_command(command='bps_simple', conf_file=None):
    log = logging.getLogger('allensdk.model.biophys_sim.bps_command')

    log.info("bps command: %s" % (command))

    if conf_file:
        conf_file = os.path.abspath(conf_file)

    if command == 'help':
        print(Config().argparser.parse_args(['--help']))
    elif command == 'nrnivmodl':
        sp.call(['nrnivmodl', 'modfiles'])
    elif command == 'run_simple':
        app_config = Config()
        description = app_config.load(conf_file)
        sys.path.insert(1, description.manifest.get_path('CODE_DIR'))
        (module_name, function_name) = description.data[
            'runs'][0]['main'].split('#')
        run_module(description, module_name, function_name)
    else:
        raise Exception("unknown command %s" % (command))


def run_module(description, module_name, function_name):
    m = __import__(module_name, fromlist=[function_name])
    func = getattr(m, function_name)

    func(description)


# this module is designed to be called from the bps script,
# which may use nrniv which does not pass in command line arguments
# So the configuration file path must be set in an environment variable.
if __name__ == '__main__':
    import sys
    conf_file = None
    argv = sys.argv

    if len(argv) > 1:
        if argv[0] == 'nrniv':
            command = 'run_simple'
        else:
            command = argv[1]
    else:
        command = 'run_simple'

    if len(argv) > 2 and (argv[-1].endswith('.conf') or
                          argv[-1].endswith('.json')):
        conf_file = argv[-1]
    else:
        try:
            conf_file = os.environ['CONF_FILE']
        except:
            pass

    choose_bps_command(command, conf_file)
