from enum import IntFlag


AUDIT_LOG_EVENTS = {
    1: "GUILD_UPDATE",
    10: "CHANNEL_CREATE",
    11: "CHANNEL_UPDATE",
    12: "CHANNEL_DELETE",
    13: "CHANNEL_OVERWRITE_CREATE",
    14: "CHANNEL_OVERWRITE_UPDATE",
    15: "CHANNEL_OVERWRITE_DELETE",
    20: "MEMBER_KICK",
    21: "MEMBER_PRUNE",
    22: "MEMBER_BAN_ADD",
    23: "MEMBER_BAN_REMOVE",
    24: "MEMBER_UPDATE",
    25: "MEMBER_ROLE_UPDATE",
    26: "MEMBER_MOVE",
    27: "MEMBER_DISCONNECT",
    28: "BOT_ADD",
    30: "ROLE_CREATE",
    31: "ROLE_UPDATE",
    32: "ROLE_DELETE",
    40: "INVITE_CREATE",
    41: "INVITE_UPDATE",
    42: "INVITE_DELETE",
    50: "WEBHOOK_CREATE",
    51: "WEBHOOK_UPDATE",
    52: "WEBHOOK_DELETE",
    60: "EMOJI_CREATE",
    61: "EMOJI_UPDATE",
    62: "EMOJI_DELETE",
    72: "MESSAGE_DELETE",
    73: "MESSAGE_BULK_DELETE",
    74: "MESSAGE_PIN",
    75: "MESSAGE_UNPIN",
    80: "INTEGRATION_CREATE",
    81: "INTEGRATION_UPDATE",
    82: "INTEGRATION_DELETE",
}


class GatewayOps(IntFlag):
    DISPATCH = 0
    HEARTBEAT = 1
    IDENTIFY = 2
    PRESENCE_UPDATE = 3
    VOICE_STATE_UPDATE = 4
    RESUME = 6
    RECONNECT = 7
    REQUEST_GUILD_MEMBERS = 8
    INVALID_SESSION = 9
    HELLO = 10
    ACK = 11


class GatewayCloseCodes(IntFlag):
    UNKNOWN_ERROR = 4000
    UNKNOWN_OPCODE = 4001
    DECODE_ERROR = 4002
    NOT_AUTHENTICATED = 4003
    AUTHENTICATION_FAILED = 4004
    ALREADY_AUTHENTICATED = 4005
    INVALID_SEQ = 4007
    RATE_LIMITED = 4008
    SESSION_TIMEOUT = 4009
    INVALID_SHARD = 4010
    SHARDING_REQUIRED = 4011
    INVALID_API_VERSION = 4012
    INVALID_INTENTS = 4013
    DISALLOWED_INTENTS = 4014
