# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union
from .. import _utilities, _tables
from . import outputs

__all__ = [
    'AccessLevelBasic',
    'AccessLevelBasicCondition',
    'AccessLevelBasicConditionDevicePolicy',
    'AccessLevelBasicConditionDevicePolicyOsConstraint',
    'AccessLevelConditionDevicePolicy',
    'AccessLevelConditionDevicePolicyOsConstraint',
    'AccessLevelCustom',
    'AccessLevelCustomExpr',
    'AccessLevelsAccessLevel',
    'AccessLevelsAccessLevelBasic',
    'AccessLevelsAccessLevelBasicCondition',
    'AccessLevelsAccessLevelBasicConditionDevicePolicy',
    'AccessLevelsAccessLevelBasicConditionDevicePolicyOsConstraint',
    'AccessLevelsAccessLevelCustom',
    'AccessLevelsAccessLevelCustomExpr',
    'ServicePerimeterSpec',
    'ServicePerimeterSpecVpcAccessibleServices',
    'ServicePerimeterStatus',
    'ServicePerimeterStatusVpcAccessibleServices',
    'ServicePerimetersServicePerimeter',
    'ServicePerimetersServicePerimeterSpec',
    'ServicePerimetersServicePerimeterSpecVpcAccessibleServices',
    'ServicePerimetersServicePerimeterStatus',
    'ServicePerimetersServicePerimeterStatusVpcAccessibleServices',
]

@pulumi.output_type
class AccessLevelBasic(dict):
    def __init__(__self__, *,
                 conditions: Sequence['outputs.AccessLevelBasicCondition'],
                 combining_function: Optional[str] = None):
        """
        :param Sequence['AccessLevelBasicConditionArgs'] conditions: A set of requirements for the AccessLevel to be granted.
               Structure is documented below.
        :param str combining_function: How the conditions list should be combined to determine if a request
               is granted this AccessLevel. If AND is used, each Condition in
               conditions must be satisfied for the AccessLevel to be applied. If
               OR is used, at least one Condition in conditions must be satisfied
               for the AccessLevel to be applied.
               Default value is `AND`.
               Possible values are `AND` and `OR`.
        """
        pulumi.set(__self__, "conditions", conditions)
        if combining_function is not None:
            pulumi.set(__self__, "combining_function", combining_function)

    @property
    @pulumi.getter
    def conditions(self) -> Sequence['outputs.AccessLevelBasicCondition']:
        """
        A set of requirements for the AccessLevel to be granted.
        Structure is documented below.
        """
        return pulumi.get(self, "conditions")

    @property
    @pulumi.getter(name="combiningFunction")
    def combining_function(self) -> Optional[str]:
        """
        How the conditions list should be combined to determine if a request
        is granted this AccessLevel. If AND is used, each Condition in
        conditions must be satisfied for the AccessLevel to be applied. If
        OR is used, at least one Condition in conditions must be satisfied
        for the AccessLevel to be applied.
        Default value is `AND`.
        Possible values are `AND` and `OR`.
        """
        return pulumi.get(self, "combining_function")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class AccessLevelBasicCondition(dict):
    def __init__(__self__, *,
                 device_policy: Optional['outputs.AccessLevelBasicConditionDevicePolicy'] = None,
                 ip_subnetworks: Optional[Sequence[str]] = None,
                 members: Optional[Sequence[str]] = None,
                 negate: Optional[bool] = None,
                 regions: Optional[Sequence[str]] = None,
                 required_access_levels: Optional[Sequence[str]] = None):
        """
        :param 'AccessLevelBasicConditionDevicePolicyArgs' device_policy: Device specific restrictions, all restrictions must hold for
               the Condition to be true. If not specified, all devices are
               allowed.
               Structure is documented below.
        :param Sequence[str] ip_subnetworks: A list of CIDR block IP subnetwork specification. May be IPv4
               or IPv6.
               Note that for a CIDR IP address block, the specified IP address
               portion must be properly truncated (i.e. all the host bits must
               be zero) or the input is considered malformed. For example,
               "192.0.2.0/24" is accepted but "192.0.2.1/24" is not. Similarly,
               for IPv6, "2001:db8::/32" is accepted whereas "2001:db8::1/32"
               is not. The originating IP of a request must be in one of the
               listed subnets in order for this Condition to be true.
               If empty, all IP addresses are allowed.
        :param Sequence[str] members: An allowed list of members (users, service accounts).
               Using groups is not supported yet.
               The signed-in user originating the request must be a part of one
               of the provided members. If not specified, a request may come
               from any user (logged in/not logged in, not present in any
               groups, etc.).
               Formats: `user:{emailid}`, `serviceAccount:{emailid}`
        :param bool negate: Whether to negate the Condition. If true, the Condition becomes
               a NAND over its non-empty fields, each field must be false for
               the Condition overall to be satisfied. Defaults to false.
        :param Sequence[str] regions: The request must originate from one of the provided
               countries/regions.
               Format: A valid ISO 3166-1 alpha-2 code.
        :param Sequence[str] required_access_levels: A list of other access levels defined in the same Policy,
               referenced by resource name. Referencing an AccessLevel which
               does not exist is an error. All access levels listed must be
               granted for the Condition to be true.
               Format: accessPolicies/{policy_id}/accessLevels/{short_name}
        """
        if device_policy is not None:
            pulumi.set(__self__, "device_policy", device_policy)
        if ip_subnetworks is not None:
            pulumi.set(__self__, "ip_subnetworks", ip_subnetworks)
        if members is not None:
            pulumi.set(__self__, "members", members)
        if negate is not None:
            pulumi.set(__self__, "negate", negate)
        if regions is not None:
            pulumi.set(__self__, "regions", regions)
        if required_access_levels is not None:
            pulumi.set(__self__, "required_access_levels", required_access_levels)

    @property
    @pulumi.getter(name="devicePolicy")
    def device_policy(self) -> Optional['outputs.AccessLevelBasicConditionDevicePolicy']:
        """
        Device specific restrictions, all restrictions must hold for
        the Condition to be true. If not specified, all devices are
        allowed.
        Structure is documented below.
        """
        return pulumi.get(self, "device_policy")

    @property
    @pulumi.getter(name="ipSubnetworks")
    def ip_subnetworks(self) -> Optional[Sequence[str]]:
        """
        A list of CIDR block IP subnetwork specification. May be IPv4
        or IPv6.
        Note that for a CIDR IP address block, the specified IP address
        portion must be properly truncated (i.e. all the host bits must
        be zero) or the input is considered malformed. For example,
        "192.0.2.0/24" is accepted but "192.0.2.1/24" is not. Similarly,
        for IPv6, "2001:db8::/32" is accepted whereas "2001:db8::1/32"
        is not. The originating IP of a request must be in one of the
        listed subnets in order for this Condition to be true.
        If empty, all IP addresses are allowed.
        """
        return pulumi.get(self, "ip_subnetworks")

    @property
    @pulumi.getter
    def members(self) -> Optional[Sequence[str]]:
        """
        An allowed list of members (users, service accounts).
        Using groups is not supported yet.
        The signed-in user originating the request must be a part of one
        of the provided members. If not specified, a request may come
        from any user (logged in/not logged in, not present in any
        groups, etc.).
        Formats: `user:{emailid}`, `serviceAccount:{emailid}`
        """
        return pulumi.get(self, "members")

    @property
    @pulumi.getter
    def negate(self) -> Optional[bool]:
        """
        Whether to negate the Condition. If true, the Condition becomes
        a NAND over its non-empty fields, each field must be false for
        the Condition overall to be satisfied. Defaults to false.
        """
        return pulumi.get(self, "negate")

    @property
    @pulumi.getter
    def regions(self) -> Optional[Sequence[str]]:
        """
        The request must originate from one of the provided
        countries/regions.
        Format: A valid ISO 3166-1 alpha-2 code.
        """
        return pulumi.get(self, "regions")

    @property
    @pulumi.getter(name="requiredAccessLevels")
    def required_access_levels(self) -> Optional[Sequence[str]]:
        """
        A list of other access levels defined in the same Policy,
        referenced by resource name. Referencing an AccessLevel which
        does not exist is an error. All access levels listed must be
        granted for the Condition to be true.
        Format: accessPolicies/{policy_id}/accessLevels/{short_name}
        """
        return pulumi.get(self, "required_access_levels")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class AccessLevelBasicConditionDevicePolicy(dict):
    def __init__(__self__, *,
                 allowed_device_management_levels: Optional[Sequence[str]] = None,
                 allowed_encryption_statuses: Optional[Sequence[str]] = None,
                 os_constraints: Optional[Sequence['outputs.AccessLevelBasicConditionDevicePolicyOsConstraint']] = None,
                 require_admin_approval: Optional[bool] = None,
                 require_corp_owned: Optional[bool] = None,
                 require_screen_lock: Optional[bool] = None):
        """
        :param Sequence[str] allowed_device_management_levels: A list of allowed device management levels.
               An empty list allows all management levels.
               Each value may be one of `MANAGEMENT_UNSPECIFIED`, `NONE`, `BASIC`, and `COMPLETE`.
        :param Sequence[str] allowed_encryption_statuses: A list of allowed encryptions statuses.
               An empty list allows all statuses.
               Each value may be one of `ENCRYPTION_UNSPECIFIED`, `ENCRYPTION_UNSUPPORTED`, `UNENCRYPTED`, and `ENCRYPTED`.
        :param Sequence['AccessLevelBasicConditionDevicePolicyOsConstraintArgs'] os_constraints: A list of allowed OS versions.
               An empty list allows all types and all versions.
               Structure is documented below.
        :param bool require_admin_approval: Whether the device needs to be approved by the customer admin.
        :param bool require_corp_owned: Whether the device needs to be corp owned.
        :param bool require_screen_lock: Whether or not screenlock is required for the DevicePolicy
               to be true. Defaults to false.
        """
        if allowed_device_management_levels is not None:
            pulumi.set(__self__, "allowed_device_management_levels", allowed_device_management_levels)
        if allowed_encryption_statuses is not None:
            pulumi.set(__self__, "allowed_encryption_statuses", allowed_encryption_statuses)
        if os_constraints is not None:
            pulumi.set(__self__, "os_constraints", os_constraints)
        if require_admin_approval is not None:
            pulumi.set(__self__, "require_admin_approval", require_admin_approval)
        if require_corp_owned is not None:
            pulumi.set(__self__, "require_corp_owned", require_corp_owned)
        if require_screen_lock is not None:
            pulumi.set(__self__, "require_screen_lock", require_screen_lock)

    @property
    @pulumi.getter(name="allowedDeviceManagementLevels")
    def allowed_device_management_levels(self) -> Optional[Sequence[str]]:
        """
        A list of allowed device management levels.
        An empty list allows all management levels.
        Each value may be one of `MANAGEMENT_UNSPECIFIED`, `NONE`, `BASIC`, and `COMPLETE`.
        """
        return pulumi.get(self, "allowed_device_management_levels")

    @property
    @pulumi.getter(name="allowedEncryptionStatuses")
    def allowed_encryption_statuses(self) -> Optional[Sequence[str]]:
        """
        A list of allowed encryptions statuses.
        An empty list allows all statuses.
        Each value may be one of `ENCRYPTION_UNSPECIFIED`, `ENCRYPTION_UNSUPPORTED`, `UNENCRYPTED`, and `ENCRYPTED`.
        """
        return pulumi.get(self, "allowed_encryption_statuses")

    @property
    @pulumi.getter(name="osConstraints")
    def os_constraints(self) -> Optional[Sequence['outputs.AccessLevelBasicConditionDevicePolicyOsConstraint']]:
        """
        A list of allowed OS versions.
        An empty list allows all types and all versions.
        Structure is documented below.
        """
        return pulumi.get(self, "os_constraints")

    @property
    @pulumi.getter(name="requireAdminApproval")
    def require_admin_approval(self) -> Optional[bool]:
        """
        Whether the device needs to be approved by the customer admin.
        """
        return pulumi.get(self, "require_admin_approval")

    @property
    @pulumi.getter(name="requireCorpOwned")
    def require_corp_owned(self) -> Optional[bool]:
        """
        Whether the device needs to be corp owned.
        """
        return pulumi.get(self, "require_corp_owned")

    @property
    @pulumi.getter(name="requireScreenLock")
    def require_screen_lock(self) -> Optional[bool]:
        """
        Whether or not screenlock is required for the DevicePolicy
        to be true. Defaults to false.
        """
        return pulumi.get(self, "require_screen_lock")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class AccessLevelBasicConditionDevicePolicyOsConstraint(dict):
    def __init__(__self__, *,
                 os_type: str,
                 minimum_version: Optional[str] = None):
        """
        :param str os_type: The operating system type of the device.
               Possible values are `OS_UNSPECIFIED`, `DESKTOP_MAC`, `DESKTOP_WINDOWS`, `DESKTOP_LINUX`, and `DESKTOP_CHROME_OS`.
        :param str minimum_version: The minimum allowed OS version. If not set, any version
               of this OS satisfies the constraint.
               Format: "major.minor.patch" such as "10.5.301", "9.2.1".
        """
        pulumi.set(__self__, "os_type", os_type)
        if minimum_version is not None:
            pulumi.set(__self__, "minimum_version", minimum_version)

    @property
    @pulumi.getter(name="osType")
    def os_type(self) -> str:
        """
        The operating system type of the device.
        Possible values are `OS_UNSPECIFIED`, `DESKTOP_MAC`, `DESKTOP_WINDOWS`, `DESKTOP_LINUX`, and `DESKTOP_CHROME_OS`.
        """
        return pulumi.get(self, "os_type")

    @property
    @pulumi.getter(name="minimumVersion")
    def minimum_version(self) -> Optional[str]:
        """
        The minimum allowed OS version. If not set, any version
        of this OS satisfies the constraint.
        Format: "major.minor.patch" such as "10.5.301", "9.2.1".
        """
        return pulumi.get(self, "minimum_version")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class AccessLevelConditionDevicePolicy(dict):
    def __init__(__self__, *,
                 allowed_device_management_levels: Optional[Sequence[str]] = None,
                 allowed_encryption_statuses: Optional[Sequence[str]] = None,
                 os_constraints: Optional[Sequence['outputs.AccessLevelConditionDevicePolicyOsConstraint']] = None,
                 require_admin_approval: Optional[bool] = None,
                 require_corp_owned: Optional[bool] = None,
                 require_screen_lock: Optional[bool] = None):
        """
        :param Sequence[str] allowed_device_management_levels: A list of allowed device management levels.
               An empty list allows all management levels.
               Each value may be one of `MANAGEMENT_UNSPECIFIED`, `NONE`, `BASIC`, and `COMPLETE`.
        :param Sequence[str] allowed_encryption_statuses: A list of allowed encryptions statuses.
               An empty list allows all statuses.
               Each value may be one of `ENCRYPTION_UNSPECIFIED`, `ENCRYPTION_UNSUPPORTED`, `UNENCRYPTED`, and `ENCRYPTED`.
        :param Sequence['AccessLevelConditionDevicePolicyOsConstraintArgs'] os_constraints: A list of allowed OS versions.
               An empty list allows all types and all versions.
               Structure is documented below.
        :param bool require_admin_approval: Whether the device needs to be approved by the customer admin.
        :param bool require_corp_owned: Whether the device needs to be corp owned.
        :param bool require_screen_lock: Whether or not screenlock is required for the DevicePolicy
               to be true. Defaults to false.
        """
        if allowed_device_management_levels is not None:
            pulumi.set(__self__, "allowed_device_management_levels", allowed_device_management_levels)
        if allowed_encryption_statuses is not None:
            pulumi.set(__self__, "allowed_encryption_statuses", allowed_encryption_statuses)
        if os_constraints is not None:
            pulumi.set(__self__, "os_constraints", os_constraints)
        if require_admin_approval is not None:
            pulumi.set(__self__, "require_admin_approval", require_admin_approval)
        if require_corp_owned is not None:
            pulumi.set(__self__, "require_corp_owned", require_corp_owned)
        if require_screen_lock is not None:
            pulumi.set(__self__, "require_screen_lock", require_screen_lock)

    @property
    @pulumi.getter(name="allowedDeviceManagementLevels")
    def allowed_device_management_levels(self) -> Optional[Sequence[str]]:
        """
        A list of allowed device management levels.
        An empty list allows all management levels.
        Each value may be one of `MANAGEMENT_UNSPECIFIED`, `NONE`, `BASIC`, and `COMPLETE`.
        """
        return pulumi.get(self, "allowed_device_management_levels")

    @property
    @pulumi.getter(name="allowedEncryptionStatuses")
    def allowed_encryption_statuses(self) -> Optional[Sequence[str]]:
        """
        A list of allowed encryptions statuses.
        An empty list allows all statuses.
        Each value may be one of `ENCRYPTION_UNSPECIFIED`, `ENCRYPTION_UNSUPPORTED`, `UNENCRYPTED`, and `ENCRYPTED`.
        """
        return pulumi.get(self, "allowed_encryption_statuses")

    @property
    @pulumi.getter(name="osConstraints")
    def os_constraints(self) -> Optional[Sequence['outputs.AccessLevelConditionDevicePolicyOsConstraint']]:
        """
        A list of allowed OS versions.
        An empty list allows all types and all versions.
        Structure is documented below.
        """
        return pulumi.get(self, "os_constraints")

    @property
    @pulumi.getter(name="requireAdminApproval")
    def require_admin_approval(self) -> Optional[bool]:
        """
        Whether the device needs to be approved by the customer admin.
        """
        return pulumi.get(self, "require_admin_approval")

    @property
    @pulumi.getter(name="requireCorpOwned")
    def require_corp_owned(self) -> Optional[bool]:
        """
        Whether the device needs to be corp owned.
        """
        return pulumi.get(self, "require_corp_owned")

    @property
    @pulumi.getter(name="requireScreenLock")
    def require_screen_lock(self) -> Optional[bool]:
        """
        Whether or not screenlock is required for the DevicePolicy
        to be true. Defaults to false.
        """
        return pulumi.get(self, "require_screen_lock")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class AccessLevelConditionDevicePolicyOsConstraint(dict):
    def __init__(__self__, *,
                 os_type: str,
                 minimum_version: Optional[str] = None):
        """
        :param str os_type: The operating system type of the device.
               Possible values are `OS_UNSPECIFIED`, `DESKTOP_MAC`, `DESKTOP_WINDOWS`, `DESKTOP_LINUX`, and `DESKTOP_CHROME_OS`.
        :param str minimum_version: The minimum allowed OS version. If not set, any version
               of this OS satisfies the constraint.
               Format: "major.minor.patch" such as "10.5.301", "9.2.1".
        """
        pulumi.set(__self__, "os_type", os_type)
        if minimum_version is not None:
            pulumi.set(__self__, "minimum_version", minimum_version)

    @property
    @pulumi.getter(name="osType")
    def os_type(self) -> str:
        """
        The operating system type of the device.
        Possible values are `OS_UNSPECIFIED`, `DESKTOP_MAC`, `DESKTOP_WINDOWS`, `DESKTOP_LINUX`, and `DESKTOP_CHROME_OS`.
        """
        return pulumi.get(self, "os_type")

    @property
    @pulumi.getter(name="minimumVersion")
    def minimum_version(self) -> Optional[str]:
        """
        The minimum allowed OS version. If not set, any version
        of this OS satisfies the constraint.
        Format: "major.minor.patch" such as "10.5.301", "9.2.1".
        """
        return pulumi.get(self, "minimum_version")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class AccessLevelCustom(dict):
    def __init__(__self__, *,
                 expr: 'outputs.AccessLevelCustomExpr'):
        """
        :param 'AccessLevelCustomExprArgs' expr: Represents a textual expression in the Common Expression Language (CEL) syntax. CEL is a C-like expression language.
               This page details the objects and attributes that are used to the build the CEL expressions for
               custom access levels - https://cloud.google.com/access-context-manager/docs/custom-access-level-spec.
               Structure is documented below.
        """
        pulumi.set(__self__, "expr", expr)

    @property
    @pulumi.getter
    def expr(self) -> 'outputs.AccessLevelCustomExpr':
        """
        Represents a textual expression in the Common Expression Language (CEL) syntax. CEL is a C-like expression language.
        This page details the objects and attributes that are used to the build the CEL expressions for
        custom access levels - https://cloud.google.com/access-context-manager/docs/custom-access-level-spec.
        Structure is documented below.
        """
        return pulumi.get(self, "expr")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class AccessLevelCustomExpr(dict):
    def __init__(__self__, *,
                 expression: str,
                 description: Optional[str] = None,
                 location: Optional[str] = None,
                 title: Optional[str] = None):
        """
        :param str expression: Textual representation of an expression in Common Expression Language syntax.
        :param str description: Description of the expression
        :param str location: String indicating the location of the expression for error reporting, e.g. a file name and a position in the file
        :param str title: Title for the expression, i.e. a short string describing its purpose.
        """
        pulumi.set(__self__, "expression", expression)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if title is not None:
            pulumi.set(__self__, "title", title)

    @property
    @pulumi.getter
    def expression(self) -> str:
        """
        Textual representation of an expression in Common Expression Language syntax.
        """
        return pulumi.get(self, "expression")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        Description of the expression
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def location(self) -> Optional[str]:
        """
        String indicating the location of the expression for error reporting, e.g. a file name and a position in the file
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def title(self) -> Optional[str]:
        """
        Title for the expression, i.e. a short string describing its purpose.
        """
        return pulumi.get(self, "title")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class AccessLevelsAccessLevel(dict):
    def __init__(__self__, *,
                 name: str,
                 title: str,
                 basic: Optional['outputs.AccessLevelsAccessLevelBasic'] = None,
                 custom: Optional['outputs.AccessLevelsAccessLevelCustom'] = None,
                 description: Optional[str] = None):
        """
        :param str name: Resource name for the Access Level. The short_name component must begin
               with a letter and only include alphanumeric and '_'.
               Format: accessPolicies/{policy_id}/accessLevels/{short_name}
        :param str title: Title for the expression, i.e. a short string describing its purpose.
        :param 'AccessLevelsAccessLevelBasicArgs' basic: A set of predefined conditions for the access level and a combining function.
               Structure is documented below.
        :param 'AccessLevelsAccessLevelCustomArgs' custom: Custom access level conditions are set using the Cloud Common Expression Language to represent the necessary conditions for the level to apply to a request.
               See CEL spec at: https://github.com/google/cel-spec.
               Structure is documented below.
        :param str description: Description of the expression
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "title", title)
        if basic is not None:
            pulumi.set(__self__, "basic", basic)
        if custom is not None:
            pulumi.set(__self__, "custom", custom)
        if description is not None:
            pulumi.set(__self__, "description", description)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Resource name for the Access Level. The short_name component must begin
        with a letter and only include alphanumeric and '_'.
        Format: accessPolicies/{policy_id}/accessLevels/{short_name}
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def title(self) -> str:
        """
        Title for the expression, i.e. a short string describing its purpose.
        """
        return pulumi.get(self, "title")

    @property
    @pulumi.getter
    def basic(self) -> Optional['outputs.AccessLevelsAccessLevelBasic']:
        """
        A set of predefined conditions for the access level and a combining function.
        Structure is documented below.
        """
        return pulumi.get(self, "basic")

    @property
    @pulumi.getter
    def custom(self) -> Optional['outputs.AccessLevelsAccessLevelCustom']:
        """
        Custom access level conditions are set using the Cloud Common Expression Language to represent the necessary conditions for the level to apply to a request.
        See CEL spec at: https://github.com/google/cel-spec.
        Structure is documented below.
        """
        return pulumi.get(self, "custom")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        Description of the expression
        """
        return pulumi.get(self, "description")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class AccessLevelsAccessLevelBasic(dict):
    def __init__(__self__, *,
                 conditions: Sequence['outputs.AccessLevelsAccessLevelBasicCondition'],
                 combining_function: Optional[str] = None):
        """
        :param Sequence['AccessLevelsAccessLevelBasicConditionArgs'] conditions: A set of requirements for the AccessLevel to be granted.
               Structure is documented below.
        :param str combining_function: How the conditions list should be combined to determine if a request
               is granted this AccessLevel. If AND is used, each Condition in
               conditions must be satisfied for the AccessLevel to be applied. If
               OR is used, at least one Condition in conditions must be satisfied
               for the AccessLevel to be applied.
               Default value is `AND`.
               Possible values are `AND` and `OR`.
        """
        pulumi.set(__self__, "conditions", conditions)
        if combining_function is not None:
            pulumi.set(__self__, "combining_function", combining_function)

    @property
    @pulumi.getter
    def conditions(self) -> Sequence['outputs.AccessLevelsAccessLevelBasicCondition']:
        """
        A set of requirements for the AccessLevel to be granted.
        Structure is documented below.
        """
        return pulumi.get(self, "conditions")

    @property
    @pulumi.getter(name="combiningFunction")
    def combining_function(self) -> Optional[str]:
        """
        How the conditions list should be combined to determine if a request
        is granted this AccessLevel. If AND is used, each Condition in
        conditions must be satisfied for the AccessLevel to be applied. If
        OR is used, at least one Condition in conditions must be satisfied
        for the AccessLevel to be applied.
        Default value is `AND`.
        Possible values are `AND` and `OR`.
        """
        return pulumi.get(self, "combining_function")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class AccessLevelsAccessLevelBasicCondition(dict):
    def __init__(__self__, *,
                 device_policy: Optional['outputs.AccessLevelsAccessLevelBasicConditionDevicePolicy'] = None,
                 ip_subnetworks: Optional[Sequence[str]] = None,
                 members: Optional[Sequence[str]] = None,
                 negate: Optional[bool] = None,
                 regions: Optional[Sequence[str]] = None,
                 required_access_levels: Optional[Sequence[str]] = None):
        """
        :param 'AccessLevelsAccessLevelBasicConditionDevicePolicyArgs' device_policy: Device specific restrictions, all restrictions must hold for
               the Condition to be true. If not specified, all devices are
               allowed.
               Structure is documented below.
        :param Sequence[str] ip_subnetworks: A list of CIDR block IP subnetwork specification. May be IPv4
               or IPv6.
               Note that for a CIDR IP address block, the specified IP address
               portion must be properly truncated (i.e. all the host bits must
               be zero) or the input is considered malformed. For example,
               "192.0.2.0/24" is accepted but "192.0.2.1/24" is not. Similarly,
               for IPv6, "2001:db8::/32" is accepted whereas "2001:db8::1/32"
               is not. The originating IP of a request must be in one of the
               listed subnets in order for this Condition to be true.
               If empty, all IP addresses are allowed.
        :param Sequence[str] members: An allowed list of members (users, service accounts).
               Using groups is not supported yet.
               The signed-in user originating the request must be a part of one
               of the provided members. If not specified, a request may come
               from any user (logged in/not logged in, not present in any
               groups, etc.).
               Formats: `user:{emailid}`, `serviceAccount:{emailid}`
        :param bool negate: Whether to negate the Condition. If true, the Condition becomes
               a NAND over its non-empty fields, each field must be false for
               the Condition overall to be satisfied. Defaults to false.
        :param Sequence[str] regions: The request must originate from one of the provided
               countries/regions.
               Format: A valid ISO 3166-1 alpha-2 code.
        :param Sequence[str] required_access_levels: A list of other access levels defined in the same Policy,
               referenced by resource name. Referencing an AccessLevel which
               does not exist is an error. All access levels listed must be
               granted for the Condition to be true.
               Format: accessPolicies/{policy_id}/accessLevels/{short_name}
        """
        if device_policy is not None:
            pulumi.set(__self__, "device_policy", device_policy)
        if ip_subnetworks is not None:
            pulumi.set(__self__, "ip_subnetworks", ip_subnetworks)
        if members is not None:
            pulumi.set(__self__, "members", members)
        if negate is not None:
            pulumi.set(__self__, "negate", negate)
        if regions is not None:
            pulumi.set(__self__, "regions", regions)
        if required_access_levels is not None:
            pulumi.set(__self__, "required_access_levels", required_access_levels)

    @property
    @pulumi.getter(name="devicePolicy")
    def device_policy(self) -> Optional['outputs.AccessLevelsAccessLevelBasicConditionDevicePolicy']:
        """
        Device specific restrictions, all restrictions must hold for
        the Condition to be true. If not specified, all devices are
        allowed.
        Structure is documented below.
        """
        return pulumi.get(self, "device_policy")

    @property
    @pulumi.getter(name="ipSubnetworks")
    def ip_subnetworks(self) -> Optional[Sequence[str]]:
        """
        A list of CIDR block IP subnetwork specification. May be IPv4
        or IPv6.
        Note that for a CIDR IP address block, the specified IP address
        portion must be properly truncated (i.e. all the host bits must
        be zero) or the input is considered malformed. For example,
        "192.0.2.0/24" is accepted but "192.0.2.1/24" is not. Similarly,
        for IPv6, "2001:db8::/32" is accepted whereas "2001:db8::1/32"
        is not. The originating IP of a request must be in one of the
        listed subnets in order for this Condition to be true.
        If empty, all IP addresses are allowed.
        """
        return pulumi.get(self, "ip_subnetworks")

    @property
    @pulumi.getter
    def members(self) -> Optional[Sequence[str]]:
        """
        An allowed list of members (users, service accounts).
        Using groups is not supported yet.
        The signed-in user originating the request must be a part of one
        of the provided members. If not specified, a request may come
        from any user (logged in/not logged in, not present in any
        groups, etc.).
        Formats: `user:{emailid}`, `serviceAccount:{emailid}`
        """
        return pulumi.get(self, "members")

    @property
    @pulumi.getter
    def negate(self) -> Optional[bool]:
        """
        Whether to negate the Condition. If true, the Condition becomes
        a NAND over its non-empty fields, each field must be false for
        the Condition overall to be satisfied. Defaults to false.
        """
        return pulumi.get(self, "negate")

    @property
    @pulumi.getter
    def regions(self) -> Optional[Sequence[str]]:
        """
        The request must originate from one of the provided
        countries/regions.
        Format: A valid ISO 3166-1 alpha-2 code.
        """
        return pulumi.get(self, "regions")

    @property
    @pulumi.getter(name="requiredAccessLevels")
    def required_access_levels(self) -> Optional[Sequence[str]]:
        """
        A list of other access levels defined in the same Policy,
        referenced by resource name. Referencing an AccessLevel which
        does not exist is an error. All access levels listed must be
        granted for the Condition to be true.
        Format: accessPolicies/{policy_id}/accessLevels/{short_name}
        """
        return pulumi.get(self, "required_access_levels")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class AccessLevelsAccessLevelBasicConditionDevicePolicy(dict):
    def __init__(__self__, *,
                 allowed_device_management_levels: Optional[Sequence[str]] = None,
                 allowed_encryption_statuses: Optional[Sequence[str]] = None,
                 os_constraints: Optional[Sequence['outputs.AccessLevelsAccessLevelBasicConditionDevicePolicyOsConstraint']] = None,
                 require_admin_approval: Optional[bool] = None,
                 require_corp_owned: Optional[bool] = None,
                 require_screen_lock: Optional[bool] = None):
        """
        :param Sequence[str] allowed_device_management_levels: A list of allowed device management levels.
               An empty list allows all management levels.
               Each value may be one of `MANAGEMENT_UNSPECIFIED`, `NONE`, `BASIC`, and `COMPLETE`.
        :param Sequence[str] allowed_encryption_statuses: A list of allowed encryptions statuses.
               An empty list allows all statuses.
               Each value may be one of `ENCRYPTION_UNSPECIFIED`, `ENCRYPTION_UNSUPPORTED`, `UNENCRYPTED`, and `ENCRYPTED`.
        :param Sequence['AccessLevelsAccessLevelBasicConditionDevicePolicyOsConstraintArgs'] os_constraints: A list of allowed OS versions.
               An empty list allows all types and all versions.
               Structure is documented below.
        :param bool require_admin_approval: Whether the device needs to be approved by the customer admin.
        :param bool require_corp_owned: Whether the device needs to be corp owned.
        :param bool require_screen_lock: Whether or not screenlock is required for the DevicePolicy
               to be true. Defaults to false.
        """
        if allowed_device_management_levels is not None:
            pulumi.set(__self__, "allowed_device_management_levels", allowed_device_management_levels)
        if allowed_encryption_statuses is not None:
            pulumi.set(__self__, "allowed_encryption_statuses", allowed_encryption_statuses)
        if os_constraints is not None:
            pulumi.set(__self__, "os_constraints", os_constraints)
        if require_admin_approval is not None:
            pulumi.set(__self__, "require_admin_approval", require_admin_approval)
        if require_corp_owned is not None:
            pulumi.set(__self__, "require_corp_owned", require_corp_owned)
        if require_screen_lock is not None:
            pulumi.set(__self__, "require_screen_lock", require_screen_lock)

    @property
    @pulumi.getter(name="allowedDeviceManagementLevels")
    def allowed_device_management_levels(self) -> Optional[Sequence[str]]:
        """
        A list of allowed device management levels.
        An empty list allows all management levels.
        Each value may be one of `MANAGEMENT_UNSPECIFIED`, `NONE`, `BASIC`, and `COMPLETE`.
        """
        return pulumi.get(self, "allowed_device_management_levels")

    @property
    @pulumi.getter(name="allowedEncryptionStatuses")
    def allowed_encryption_statuses(self) -> Optional[Sequence[str]]:
        """
        A list of allowed encryptions statuses.
        An empty list allows all statuses.
        Each value may be one of `ENCRYPTION_UNSPECIFIED`, `ENCRYPTION_UNSUPPORTED`, `UNENCRYPTED`, and `ENCRYPTED`.
        """
        return pulumi.get(self, "allowed_encryption_statuses")

    @property
    @pulumi.getter(name="osConstraints")
    def os_constraints(self) -> Optional[Sequence['outputs.AccessLevelsAccessLevelBasicConditionDevicePolicyOsConstraint']]:
        """
        A list of allowed OS versions.
        An empty list allows all types and all versions.
        Structure is documented below.
        """
        return pulumi.get(self, "os_constraints")

    @property
    @pulumi.getter(name="requireAdminApproval")
    def require_admin_approval(self) -> Optional[bool]:
        """
        Whether the device needs to be approved by the customer admin.
        """
        return pulumi.get(self, "require_admin_approval")

    @property
    @pulumi.getter(name="requireCorpOwned")
    def require_corp_owned(self) -> Optional[bool]:
        """
        Whether the device needs to be corp owned.
        """
        return pulumi.get(self, "require_corp_owned")

    @property
    @pulumi.getter(name="requireScreenLock")
    def require_screen_lock(self) -> Optional[bool]:
        """
        Whether or not screenlock is required for the DevicePolicy
        to be true. Defaults to false.
        """
        return pulumi.get(self, "require_screen_lock")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class AccessLevelsAccessLevelBasicConditionDevicePolicyOsConstraint(dict):
    def __init__(__self__, *,
                 os_type: str,
                 minimum_version: Optional[str] = None):
        """
        :param str os_type: The operating system type of the device.
               Possible values are `OS_UNSPECIFIED`, `DESKTOP_MAC`, `DESKTOP_WINDOWS`, `DESKTOP_LINUX`, and `DESKTOP_CHROME_OS`.
        :param str minimum_version: The minimum allowed OS version. If not set, any version
               of this OS satisfies the constraint.
               Format: "major.minor.patch" such as "10.5.301", "9.2.1".
        """
        pulumi.set(__self__, "os_type", os_type)
        if minimum_version is not None:
            pulumi.set(__self__, "minimum_version", minimum_version)

    @property
    @pulumi.getter(name="osType")
    def os_type(self) -> str:
        """
        The operating system type of the device.
        Possible values are `OS_UNSPECIFIED`, `DESKTOP_MAC`, `DESKTOP_WINDOWS`, `DESKTOP_LINUX`, and `DESKTOP_CHROME_OS`.
        """
        return pulumi.get(self, "os_type")

    @property
    @pulumi.getter(name="minimumVersion")
    def minimum_version(self) -> Optional[str]:
        """
        The minimum allowed OS version. If not set, any version
        of this OS satisfies the constraint.
        Format: "major.minor.patch" such as "10.5.301", "9.2.1".
        """
        return pulumi.get(self, "minimum_version")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class AccessLevelsAccessLevelCustom(dict):
    def __init__(__self__, *,
                 expr: 'outputs.AccessLevelsAccessLevelCustomExpr'):
        """
        :param 'AccessLevelsAccessLevelCustomExprArgs' expr: Represents a textual expression in the Common Expression Language (CEL) syntax. CEL is a C-like expression language.
               This page details the objects and attributes that are used to the build the CEL expressions for
               custom access levels - https://cloud.google.com/access-context-manager/docs/custom-access-level-spec.
               Structure is documented below.
        """
        pulumi.set(__self__, "expr", expr)

    @property
    @pulumi.getter
    def expr(self) -> 'outputs.AccessLevelsAccessLevelCustomExpr':
        """
        Represents a textual expression in the Common Expression Language (CEL) syntax. CEL is a C-like expression language.
        This page details the objects and attributes that are used to the build the CEL expressions for
        custom access levels - https://cloud.google.com/access-context-manager/docs/custom-access-level-spec.
        Structure is documented below.
        """
        return pulumi.get(self, "expr")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class AccessLevelsAccessLevelCustomExpr(dict):
    def __init__(__self__, *,
                 expression: str,
                 description: Optional[str] = None,
                 location: Optional[str] = None,
                 title: Optional[str] = None):
        """
        :param str expression: Textual representation of an expression in Common Expression Language syntax.
        :param str description: Description of the expression
        :param str location: String indicating the location of the expression for error reporting, e.g. a file name and a position in the file
        :param str title: Title for the expression, i.e. a short string describing its purpose.
        """
        pulumi.set(__self__, "expression", expression)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if title is not None:
            pulumi.set(__self__, "title", title)

    @property
    @pulumi.getter
    def expression(self) -> str:
        """
        Textual representation of an expression in Common Expression Language syntax.
        """
        return pulumi.get(self, "expression")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        Description of the expression
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def location(self) -> Optional[str]:
        """
        String indicating the location of the expression for error reporting, e.g. a file name and a position in the file
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def title(self) -> Optional[str]:
        """
        Title for the expression, i.e. a short string describing its purpose.
        """
        return pulumi.get(self, "title")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class ServicePerimeterSpec(dict):
    def __init__(__self__, *,
                 access_levels: Optional[Sequence[str]] = None,
                 resources: Optional[Sequence[str]] = None,
                 restricted_services: Optional[Sequence[str]] = None,
                 vpc_accessible_services: Optional['outputs.ServicePerimeterSpecVpcAccessibleServices'] = None):
        """
        :param Sequence[str] access_levels: A list of AccessLevel resource names that allow resources within
               the ServicePerimeter to be accessed from the internet.
               AccessLevels listed must be in the same policy as this
               ServicePerimeter. Referencing a nonexistent AccessLevel is a
               syntax error. If no AccessLevel names are listed, resources within
               the perimeter can only be accessed via GCP calls with request
               origins within the perimeter. For Service Perimeter Bridge, must
               be empty.
               Format: accessPolicies/{policy_id}/accessLevels/{access_level_name}
        :param Sequence[str] resources: A list of GCP resources that are inside of the service perimeter.
               Currently only projects are allowed.
               Format: projects/{project_number}
        :param Sequence[str] restricted_services: GCP services that are subject to the Service Perimeter
               restrictions. Must contain a list of services. For example, if
               `storage.googleapis.com` is specified, access to the storage
               buckets inside the perimeter must meet the perimeter's access
               restrictions.
        :param 'ServicePerimeterSpecVpcAccessibleServicesArgs' vpc_accessible_services: Specifies how APIs are allowed to communicate within the Service
               Perimeter.
               Structure is documented below.
        """
        if access_levels is not None:
            pulumi.set(__self__, "access_levels", access_levels)
        if resources is not None:
            pulumi.set(__self__, "resources", resources)
        if restricted_services is not None:
            pulumi.set(__self__, "restricted_services", restricted_services)
        if vpc_accessible_services is not None:
            pulumi.set(__self__, "vpc_accessible_services", vpc_accessible_services)

    @property
    @pulumi.getter(name="accessLevels")
    def access_levels(self) -> Optional[Sequence[str]]:
        """
        A list of AccessLevel resource names that allow resources within
        the ServicePerimeter to be accessed from the internet.
        AccessLevels listed must be in the same policy as this
        ServicePerimeter. Referencing a nonexistent AccessLevel is a
        syntax error. If no AccessLevel names are listed, resources within
        the perimeter can only be accessed via GCP calls with request
        origins within the perimeter. For Service Perimeter Bridge, must
        be empty.
        Format: accessPolicies/{policy_id}/accessLevels/{access_level_name}
        """
        return pulumi.get(self, "access_levels")

    @property
    @pulumi.getter
    def resources(self) -> Optional[Sequence[str]]:
        """
        A list of GCP resources that are inside of the service perimeter.
        Currently only projects are allowed.
        Format: projects/{project_number}
        """
        return pulumi.get(self, "resources")

    @property
    @pulumi.getter(name="restrictedServices")
    def restricted_services(self) -> Optional[Sequence[str]]:
        """
        GCP services that are subject to the Service Perimeter
        restrictions. Must contain a list of services. For example, if
        `storage.googleapis.com` is specified, access to the storage
        buckets inside the perimeter must meet the perimeter's access
        restrictions.
        """
        return pulumi.get(self, "restricted_services")

    @property
    @pulumi.getter(name="vpcAccessibleServices")
    def vpc_accessible_services(self) -> Optional['outputs.ServicePerimeterSpecVpcAccessibleServices']:
        """
        Specifies how APIs are allowed to communicate within the Service
        Perimeter.
        Structure is documented below.
        """
        return pulumi.get(self, "vpc_accessible_services")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class ServicePerimeterSpecVpcAccessibleServices(dict):
    def __init__(__self__, *,
                 allowed_services: Optional[Sequence[str]] = None,
                 enable_restriction: Optional[bool] = None):
        """
        :param Sequence[str] allowed_services: The list of APIs usable within the Service Perimeter.
               Must be empty unless `enableRestriction` is True.
        :param bool enable_restriction: Whether to restrict API calls within the Service Perimeter to the
               list of APIs specified in 'allowedServices'.
        """
        if allowed_services is not None:
            pulumi.set(__self__, "allowed_services", allowed_services)
        if enable_restriction is not None:
            pulumi.set(__self__, "enable_restriction", enable_restriction)

    @property
    @pulumi.getter(name="allowedServices")
    def allowed_services(self) -> Optional[Sequence[str]]:
        """
        The list of APIs usable within the Service Perimeter.
        Must be empty unless `enableRestriction` is True.
        """
        return pulumi.get(self, "allowed_services")

    @property
    @pulumi.getter(name="enableRestriction")
    def enable_restriction(self) -> Optional[bool]:
        """
        Whether to restrict API calls within the Service Perimeter to the
        list of APIs specified in 'allowedServices'.
        """
        return pulumi.get(self, "enable_restriction")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class ServicePerimeterStatus(dict):
    def __init__(__self__, *,
                 access_levels: Optional[Sequence[str]] = None,
                 resources: Optional[Sequence[str]] = None,
                 restricted_services: Optional[Sequence[str]] = None,
                 vpc_accessible_services: Optional['outputs.ServicePerimeterStatusVpcAccessibleServices'] = None):
        """
        :param Sequence[str] access_levels: A list of AccessLevel resource names that allow resources within
               the ServicePerimeter to be accessed from the internet.
               AccessLevels listed must be in the same policy as this
               ServicePerimeter. Referencing a nonexistent AccessLevel is a
               syntax error. If no AccessLevel names are listed, resources within
               the perimeter can only be accessed via GCP calls with request
               origins within the perimeter. For Service Perimeter Bridge, must
               be empty.
               Format: accessPolicies/{policy_id}/accessLevels/{access_level_name}
        :param Sequence[str] resources: A list of GCP resources that are inside of the service perimeter.
               Currently only projects are allowed.
               Format: projects/{project_number}
        :param Sequence[str] restricted_services: GCP services that are subject to the Service Perimeter
               restrictions. Must contain a list of services. For example, if
               `storage.googleapis.com` is specified, access to the storage
               buckets inside the perimeter must meet the perimeter's access
               restrictions.
        :param 'ServicePerimeterStatusVpcAccessibleServicesArgs' vpc_accessible_services: Specifies how APIs are allowed to communicate within the Service
               Perimeter.
               Structure is documented below.
        """
        if access_levels is not None:
            pulumi.set(__self__, "access_levels", access_levels)
        if resources is not None:
            pulumi.set(__self__, "resources", resources)
        if restricted_services is not None:
            pulumi.set(__self__, "restricted_services", restricted_services)
        if vpc_accessible_services is not None:
            pulumi.set(__self__, "vpc_accessible_services", vpc_accessible_services)

    @property
    @pulumi.getter(name="accessLevels")
    def access_levels(self) -> Optional[Sequence[str]]:
        """
        A list of AccessLevel resource names that allow resources within
        the ServicePerimeter to be accessed from the internet.
        AccessLevels listed must be in the same policy as this
        ServicePerimeter. Referencing a nonexistent AccessLevel is a
        syntax error. If no AccessLevel names are listed, resources within
        the perimeter can only be accessed via GCP calls with request
        origins within the perimeter. For Service Perimeter Bridge, must
        be empty.
        Format: accessPolicies/{policy_id}/accessLevels/{access_level_name}
        """
        return pulumi.get(self, "access_levels")

    @property
    @pulumi.getter
    def resources(self) -> Optional[Sequence[str]]:
        """
        A list of GCP resources that are inside of the service perimeter.
        Currently only projects are allowed.
        Format: projects/{project_number}
        """
        return pulumi.get(self, "resources")

    @property
    @pulumi.getter(name="restrictedServices")
    def restricted_services(self) -> Optional[Sequence[str]]:
        """
        GCP services that are subject to the Service Perimeter
        restrictions. Must contain a list of services. For example, if
        `storage.googleapis.com` is specified, access to the storage
        buckets inside the perimeter must meet the perimeter's access
        restrictions.
        """
        return pulumi.get(self, "restricted_services")

    @property
    @pulumi.getter(name="vpcAccessibleServices")
    def vpc_accessible_services(self) -> Optional['outputs.ServicePerimeterStatusVpcAccessibleServices']:
        """
        Specifies how APIs are allowed to communicate within the Service
        Perimeter.
        Structure is documented below.
        """
        return pulumi.get(self, "vpc_accessible_services")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class ServicePerimeterStatusVpcAccessibleServices(dict):
    def __init__(__self__, *,
                 allowed_services: Optional[Sequence[str]] = None,
                 enable_restriction: Optional[bool] = None):
        """
        :param Sequence[str] allowed_services: The list of APIs usable within the Service Perimeter.
               Must be empty unless `enableRestriction` is True.
        :param bool enable_restriction: Whether to restrict API calls within the Service Perimeter to the
               list of APIs specified in 'allowedServices'.
        """
        if allowed_services is not None:
            pulumi.set(__self__, "allowed_services", allowed_services)
        if enable_restriction is not None:
            pulumi.set(__self__, "enable_restriction", enable_restriction)

    @property
    @pulumi.getter(name="allowedServices")
    def allowed_services(self) -> Optional[Sequence[str]]:
        """
        The list of APIs usable within the Service Perimeter.
        Must be empty unless `enableRestriction` is True.
        """
        return pulumi.get(self, "allowed_services")

    @property
    @pulumi.getter(name="enableRestriction")
    def enable_restriction(self) -> Optional[bool]:
        """
        Whether to restrict API calls within the Service Perimeter to the
        list of APIs specified in 'allowedServices'.
        """
        return pulumi.get(self, "enable_restriction")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class ServicePerimetersServicePerimeter(dict):
    def __init__(__self__, *,
                 name: str,
                 title: str,
                 create_time: Optional[str] = None,
                 description: Optional[str] = None,
                 perimeter_type: Optional[str] = None,
                 spec: Optional['outputs.ServicePerimetersServicePerimeterSpec'] = None,
                 status: Optional['outputs.ServicePerimetersServicePerimeterStatus'] = None,
                 update_time: Optional[str] = None,
                 use_explicit_dry_run_spec: Optional[bool] = None):
        """
        :param str name: Resource name for the ServicePerimeter. The short_name component must
               begin with a letter and only include alphanumeric and '_'.
               Format: accessPolicies/{policy_id}/servicePerimeters/{short_name}
        :param str title: Human readable title. Must be unique within the Policy.
        :param str create_time: -
               Time the AccessPolicy was created in UTC.
        :param str description: Description of the ServicePerimeter and its use. Does not affect
               behavior.
        :param str perimeter_type: Specifies the type of the Perimeter. There are two types: regular and
               bridge. Regular Service Perimeter contains resources, access levels,
               and restricted services. Every resource can be in at most
               ONE regular Service Perimeter.
               In addition to being in a regular service perimeter, a resource can also
               be in zero or more perimeter bridges. A perimeter bridge only contains
               resources. Cross project operations are permitted if all effected
               resources share some perimeter (whether bridge or regular). Perimeter
               Bridge does not contain access levels or services: those are governed
               entirely by the regular perimeter that resource is in.
               Perimeter Bridges are typically useful when building more complex
               topologies with many independent perimeters that need to share some data
               with a common perimeter, but should not be able to share data among
               themselves.
               Default value is `PERIMETER_TYPE_REGULAR`.
               Possible values are `PERIMETER_TYPE_REGULAR` and `PERIMETER_TYPE_BRIDGE`.
        :param 'ServicePerimetersServicePerimeterSpecArgs' spec: Proposed (or dry run) ServicePerimeter configuration.
               This configuration allows to specify and test ServicePerimeter configuration
               without enforcing actual access restrictions. Only allowed to be set when
               the `useExplicitDryRunSpec` flag is set.
               Structure is documented below.
        :param 'ServicePerimetersServicePerimeterStatusArgs' status: ServicePerimeter configuration. Specifies sets of resources,
               restricted services and access levels that determine
               perimeter content and boundaries.
               Structure is documented below.
        :param str update_time: -
               Time the AccessPolicy was updated in UTC.
        :param bool use_explicit_dry_run_spec: Use explicit dry run spec flag. Ordinarily, a dry-run spec implicitly exists
               for all Service Perimeters, and that spec is identical to the status for those
               Service Perimeters. When this flag is set, it inhibits the generation of the
               implicit spec, thereby allowing the user to explicitly provide a
               configuration ("spec") to use in a dry-run version of the Service Perimeter.
               This allows the user to test changes to the enforced config ("status") without
               actually enforcing them. This testing is done through analyzing the differences
               between currently enforced and suggested restrictions. useExplicitDryRunSpec must
               bet set to True if any of the fields in the spec are set to non-default values.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "title", title)
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if perimeter_type is not None:
            pulumi.set(__self__, "perimeter_type", perimeter_type)
        if spec is not None:
            pulumi.set(__self__, "spec", spec)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if update_time is not None:
            pulumi.set(__self__, "update_time", update_time)
        if use_explicit_dry_run_spec is not None:
            pulumi.set(__self__, "use_explicit_dry_run_spec", use_explicit_dry_run_spec)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Resource name for the ServicePerimeter. The short_name component must
        begin with a letter and only include alphanumeric and '_'.
        Format: accessPolicies/{policy_id}/servicePerimeters/{short_name}
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def title(self) -> str:
        """
        Human readable title. Must be unique within the Policy.
        """
        return pulumi.get(self, "title")

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[str]:
        """
        -
        Time the AccessPolicy was created in UTC.
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        Description of the ServicePerimeter and its use. Does not affect
        behavior.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="perimeterType")
    def perimeter_type(self) -> Optional[str]:
        """
        Specifies the type of the Perimeter. There are two types: regular and
        bridge. Regular Service Perimeter contains resources, access levels,
        and restricted services. Every resource can be in at most
        ONE regular Service Perimeter.
        In addition to being in a regular service perimeter, a resource can also
        be in zero or more perimeter bridges. A perimeter bridge only contains
        resources. Cross project operations are permitted if all effected
        resources share some perimeter (whether bridge or regular). Perimeter
        Bridge does not contain access levels or services: those are governed
        entirely by the regular perimeter that resource is in.
        Perimeter Bridges are typically useful when building more complex
        topologies with many independent perimeters that need to share some data
        with a common perimeter, but should not be able to share data among
        themselves.
        Default value is `PERIMETER_TYPE_REGULAR`.
        Possible values are `PERIMETER_TYPE_REGULAR` and `PERIMETER_TYPE_BRIDGE`.
        """
        return pulumi.get(self, "perimeter_type")

    @property
    @pulumi.getter
    def spec(self) -> Optional['outputs.ServicePerimetersServicePerimeterSpec']:
        """
        Proposed (or dry run) ServicePerimeter configuration.
        This configuration allows to specify and test ServicePerimeter configuration
        without enforcing actual access restrictions. Only allowed to be set when
        the `useExplicitDryRunSpec` flag is set.
        Structure is documented below.
        """
        return pulumi.get(self, "spec")

    @property
    @pulumi.getter
    def status(self) -> Optional['outputs.ServicePerimetersServicePerimeterStatus']:
        """
        ServicePerimeter configuration. Specifies sets of resources,
        restricted services and access levels that determine
        perimeter content and boundaries.
        Structure is documented below.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> Optional[str]:
        """
        -
        Time the AccessPolicy was updated in UTC.
        """
        return pulumi.get(self, "update_time")

    @property
    @pulumi.getter(name="useExplicitDryRunSpec")
    def use_explicit_dry_run_spec(self) -> Optional[bool]:
        """
        Use explicit dry run spec flag. Ordinarily, a dry-run spec implicitly exists
        for all Service Perimeters, and that spec is identical to the status for those
        Service Perimeters. When this flag is set, it inhibits the generation of the
        implicit spec, thereby allowing the user to explicitly provide a
        configuration ("spec") to use in a dry-run version of the Service Perimeter.
        This allows the user to test changes to the enforced config ("status") without
        actually enforcing them. This testing is done through analyzing the differences
        between currently enforced and suggested restrictions. useExplicitDryRunSpec must
        bet set to True if any of the fields in the spec are set to non-default values.
        """
        return pulumi.get(self, "use_explicit_dry_run_spec")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class ServicePerimetersServicePerimeterSpec(dict):
    def __init__(__self__, *,
                 access_levels: Optional[Sequence[str]] = None,
                 resources: Optional[Sequence[str]] = None,
                 restricted_services: Optional[Sequence[str]] = None,
                 vpc_accessible_services: Optional['outputs.ServicePerimetersServicePerimeterSpecVpcAccessibleServices'] = None):
        """
        :param Sequence[str] access_levels: A list of AccessLevel resource names that allow resources within
               the ServicePerimeter to be accessed from the internet.
               AccessLevels listed must be in the same policy as this
               ServicePerimeter. Referencing a nonexistent AccessLevel is a
               syntax error. If no AccessLevel names are listed, resources within
               the perimeter can only be accessed via GCP calls with request
               origins within the perimeter. For Service Perimeter Bridge, must
               be empty.
               Format: accessPolicies/{policy_id}/accessLevels/{access_level_name}
        :param Sequence[str] resources: A list of GCP resources that are inside of the service perimeter.
               Currently only projects are allowed.
               Format: projects/{project_number}
        :param Sequence[str] restricted_services: GCP services that are subject to the Service Perimeter
               restrictions. Must contain a list of services. For example, if
               `storage.googleapis.com` is specified, access to the storage
               buckets inside the perimeter must meet the perimeter's access
               restrictions.
        :param 'ServicePerimetersServicePerimeterSpecVpcAccessibleServicesArgs' vpc_accessible_services: Specifies how APIs are allowed to communicate within the Service
               Perimeter.
               Structure is documented below.
        """
        if access_levels is not None:
            pulumi.set(__self__, "access_levels", access_levels)
        if resources is not None:
            pulumi.set(__self__, "resources", resources)
        if restricted_services is not None:
            pulumi.set(__self__, "restricted_services", restricted_services)
        if vpc_accessible_services is not None:
            pulumi.set(__self__, "vpc_accessible_services", vpc_accessible_services)

    @property
    @pulumi.getter(name="accessLevels")
    def access_levels(self) -> Optional[Sequence[str]]:
        """
        A list of AccessLevel resource names that allow resources within
        the ServicePerimeter to be accessed from the internet.
        AccessLevels listed must be in the same policy as this
        ServicePerimeter. Referencing a nonexistent AccessLevel is a
        syntax error. If no AccessLevel names are listed, resources within
        the perimeter can only be accessed via GCP calls with request
        origins within the perimeter. For Service Perimeter Bridge, must
        be empty.
        Format: accessPolicies/{policy_id}/accessLevels/{access_level_name}
        """
        return pulumi.get(self, "access_levels")

    @property
    @pulumi.getter
    def resources(self) -> Optional[Sequence[str]]:
        """
        A list of GCP resources that are inside of the service perimeter.
        Currently only projects are allowed.
        Format: projects/{project_number}
        """
        return pulumi.get(self, "resources")

    @property
    @pulumi.getter(name="restrictedServices")
    def restricted_services(self) -> Optional[Sequence[str]]:
        """
        GCP services that are subject to the Service Perimeter
        restrictions. Must contain a list of services. For example, if
        `storage.googleapis.com` is specified, access to the storage
        buckets inside the perimeter must meet the perimeter's access
        restrictions.
        """
        return pulumi.get(self, "restricted_services")

    @property
    @pulumi.getter(name="vpcAccessibleServices")
    def vpc_accessible_services(self) -> Optional['outputs.ServicePerimetersServicePerimeterSpecVpcAccessibleServices']:
        """
        Specifies how APIs are allowed to communicate within the Service
        Perimeter.
        Structure is documented below.
        """
        return pulumi.get(self, "vpc_accessible_services")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class ServicePerimetersServicePerimeterSpecVpcAccessibleServices(dict):
    def __init__(__self__, *,
                 allowed_services: Optional[Sequence[str]] = None,
                 enable_restriction: Optional[bool] = None):
        """
        :param Sequence[str] allowed_services: The list of APIs usable within the Service Perimeter.
               Must be empty unless `enableRestriction` is True.
        :param bool enable_restriction: Whether to restrict API calls within the Service Perimeter to the
               list of APIs specified in 'allowedServices'.
        """
        if allowed_services is not None:
            pulumi.set(__self__, "allowed_services", allowed_services)
        if enable_restriction is not None:
            pulumi.set(__self__, "enable_restriction", enable_restriction)

    @property
    @pulumi.getter(name="allowedServices")
    def allowed_services(self) -> Optional[Sequence[str]]:
        """
        The list of APIs usable within the Service Perimeter.
        Must be empty unless `enableRestriction` is True.
        """
        return pulumi.get(self, "allowed_services")

    @property
    @pulumi.getter(name="enableRestriction")
    def enable_restriction(self) -> Optional[bool]:
        """
        Whether to restrict API calls within the Service Perimeter to the
        list of APIs specified in 'allowedServices'.
        """
        return pulumi.get(self, "enable_restriction")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class ServicePerimetersServicePerimeterStatus(dict):
    def __init__(__self__, *,
                 access_levels: Optional[Sequence[str]] = None,
                 resources: Optional[Sequence[str]] = None,
                 restricted_services: Optional[Sequence[str]] = None,
                 vpc_accessible_services: Optional['outputs.ServicePerimetersServicePerimeterStatusVpcAccessibleServices'] = None):
        """
        :param Sequence[str] access_levels: A list of AccessLevel resource names that allow resources within
               the ServicePerimeter to be accessed from the internet.
               AccessLevels listed must be in the same policy as this
               ServicePerimeter. Referencing a nonexistent AccessLevel is a
               syntax error. If no AccessLevel names are listed, resources within
               the perimeter can only be accessed via GCP calls with request
               origins within the perimeter. For Service Perimeter Bridge, must
               be empty.
               Format: accessPolicies/{policy_id}/accessLevels/{access_level_name}
        :param Sequence[str] resources: A list of GCP resources that are inside of the service perimeter.
               Currently only projects are allowed.
               Format: projects/{project_number}
        :param Sequence[str] restricted_services: GCP services that are subject to the Service Perimeter
               restrictions. Must contain a list of services. For example, if
               `storage.googleapis.com` is specified, access to the storage
               buckets inside the perimeter must meet the perimeter's access
               restrictions.
        :param 'ServicePerimetersServicePerimeterStatusVpcAccessibleServicesArgs' vpc_accessible_services: Specifies how APIs are allowed to communicate within the Service
               Perimeter.
               Structure is documented below.
        """
        if access_levels is not None:
            pulumi.set(__self__, "access_levels", access_levels)
        if resources is not None:
            pulumi.set(__self__, "resources", resources)
        if restricted_services is not None:
            pulumi.set(__self__, "restricted_services", restricted_services)
        if vpc_accessible_services is not None:
            pulumi.set(__self__, "vpc_accessible_services", vpc_accessible_services)

    @property
    @pulumi.getter(name="accessLevels")
    def access_levels(self) -> Optional[Sequence[str]]:
        """
        A list of AccessLevel resource names that allow resources within
        the ServicePerimeter to be accessed from the internet.
        AccessLevels listed must be in the same policy as this
        ServicePerimeter. Referencing a nonexistent AccessLevel is a
        syntax error. If no AccessLevel names are listed, resources within
        the perimeter can only be accessed via GCP calls with request
        origins within the perimeter. For Service Perimeter Bridge, must
        be empty.
        Format: accessPolicies/{policy_id}/accessLevels/{access_level_name}
        """
        return pulumi.get(self, "access_levels")

    @property
    @pulumi.getter
    def resources(self) -> Optional[Sequence[str]]:
        """
        A list of GCP resources that are inside of the service perimeter.
        Currently only projects are allowed.
        Format: projects/{project_number}
        """
        return pulumi.get(self, "resources")

    @property
    @pulumi.getter(name="restrictedServices")
    def restricted_services(self) -> Optional[Sequence[str]]:
        """
        GCP services that are subject to the Service Perimeter
        restrictions. Must contain a list of services. For example, if
        `storage.googleapis.com` is specified, access to the storage
        buckets inside the perimeter must meet the perimeter's access
        restrictions.
        """
        return pulumi.get(self, "restricted_services")

    @property
    @pulumi.getter(name="vpcAccessibleServices")
    def vpc_accessible_services(self) -> Optional['outputs.ServicePerimetersServicePerimeterStatusVpcAccessibleServices']:
        """
        Specifies how APIs are allowed to communicate within the Service
        Perimeter.
        Structure is documented below.
        """
        return pulumi.get(self, "vpc_accessible_services")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class ServicePerimetersServicePerimeterStatusVpcAccessibleServices(dict):
    def __init__(__self__, *,
                 allowed_services: Optional[Sequence[str]] = None,
                 enable_restriction: Optional[bool] = None):
        """
        :param Sequence[str] allowed_services: The list of APIs usable within the Service Perimeter.
               Must be empty unless `enableRestriction` is True.
        :param bool enable_restriction: Whether to restrict API calls within the Service Perimeter to the
               list of APIs specified in 'allowedServices'.
        """
        if allowed_services is not None:
            pulumi.set(__self__, "allowed_services", allowed_services)
        if enable_restriction is not None:
            pulumi.set(__self__, "enable_restriction", enable_restriction)

    @property
    @pulumi.getter(name="allowedServices")
    def allowed_services(self) -> Optional[Sequence[str]]:
        """
        The list of APIs usable within the Service Perimeter.
        Must be empty unless `enableRestriction` is True.
        """
        return pulumi.get(self, "allowed_services")

    @property
    @pulumi.getter(name="enableRestriction")
    def enable_restriction(self) -> Optional[bool]:
        """
        Whether to restrict API calls within the Service Perimeter to the
        list of APIs specified in 'allowedServices'.
        """
        return pulumi.get(self, "enable_restriction")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


