# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union
from .. import _utilities, _tables
from . import outputs
from ._inputs import *

__all__ = ['Certificate']


class Certificate(pulumi.CustomResource):
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 certificate_authority: Optional[pulumi.Input[str]] = None,
                 config: Optional[pulumi.Input[pulumi.InputType['CertificateConfigArgs']]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 lifetime: Optional[pulumi.Input[str]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 pem_csr: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 __props__=None,
                 __name__=None,
                 __opts__=None):
        """
        A Certificate corresponds to a signed X.509 certificate issued by a CertificateAuthority.

        > **Note:** The Certificate Authority that is referenced by this resource **must** be
        `tier = "ENTERPRISE"`

        > **Warning:** Please remember that all resources created during preview (via this provider)
        will be deleted when CA service transitions to General Availability (GA). Relying on these
        certificate authorities for production traffic is discouraged.

        ## Example Usage
        ### Privateca Certificate Csr

        ```python
        import pulumi
        import pulumi_gcp as gcp

        test_ca = gcp.certificateauthority.Authority("test-ca",
            certificate_authority_id="my-certificate-authority",
            location="us-central1",
            tier="ENTERPRISE",
            config=gcp.certificateauthority.AuthorityConfigArgs(
                subject_config=gcp.certificateauthority.AuthorityConfigSubjectConfigArgs(
                    subject=gcp.certificateauthority.AuthorityConfigSubjectConfigSubjectArgs(
                        organization="HashiCorp",
                    ),
                    common_name="my-certificate-authority",
                    subject_alt_name=gcp.certificateauthority.AuthorityConfigSubjectConfigSubjectAltNameArgs(
                        dns_names=["hashicorp.com"],
                    ),
                ),
                reusable_config=gcp.certificateauthority.AuthorityConfigReusableConfigArgs(
                    reusable_config="projects/568668481468/locations/us-central1/reusableConfigs/root-unconstrained",
                ),
            ),
            key_spec=gcp.certificateauthority.AuthorityKeySpecArgs(
                algorithm="RSA_PKCS1_4096_SHA256",
            ),
            disable_on_delete=True,
            opts=pulumi.ResourceOptions(provider=google_beta))
        default = gcp.certificateauthority.Certificate("default",
            project="my-project-name",
            location="us-central1",
            certificate_authority=test_ca.certificate_authority_id,
            lifetime="860s",
            pem_csr=(lambda path: open(path).read())("test-fixtures/rsa_csr.pem"),
            opts=pulumi.ResourceOptions(provider=google_beta))
        ```

        ## Import

        Certificate can be imported using any of these accepted formats

        ```sh
         $ pulumi import gcp:certificateauthority/certificate:Certificate default projects/{{project}}/locations/{{location}}/certificateAuthorities/{{certificate_authority}}/certificates/{{name}}
        ```

        ```sh
         $ pulumi import gcp:certificateauthority/certificate:Certificate default {{project}}/{{location}}/{{certificate_authority}}/{{name}}
        ```

        ```sh
         $ pulumi import gcp:certificateauthority/certificate:Certificate default {{location}}/{{certificate_authority}}/{{name}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] certificate_authority: Certificate Authority name.
        :param pulumi.Input[pulumi.InputType['CertificateConfigArgs']] config: The config used to create a self-signed X.509 certificate or CSR.
               Structure is documented below.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] labels: Labels with user-defined metadata to apply to this resource.
        :param pulumi.Input[str] lifetime: The desired lifetime of the CA certificate. Used to create the "notBeforeTime" and
               "notAfterTime" fields inside an X.509 certificate. A duration in seconds with up to nine
               fractional digits, terminated by 's'. Example: "3.5s".
        :param pulumi.Input[str] location: Location of the CertificateAuthority. A full list of valid locations can be found by
               running `gcloud beta privateca locations list`.
        :param pulumi.Input[str] name: The name for this Certificate .
        :param pulumi.Input[str] pem_csr: Immutable. A pem-encoded X.509 certificate signing request (CSR).
        :param pulumi.Input[str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        """
        if __name__ is not None:
            warnings.warn("explicit use of __name__ is deprecated", DeprecationWarning)
            resource_name = __name__
        if __opts__ is not None:
            warnings.warn("explicit use of __opts__ is deprecated, use 'opts' instead", DeprecationWarning)
            opts = __opts__
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = dict()

            if certificate_authority is None and not opts.urn:
                raise TypeError("Missing required property 'certificate_authority'")
            __props__['certificate_authority'] = certificate_authority
            __props__['config'] = config
            __props__['labels'] = labels
            __props__['lifetime'] = lifetime
            if location is None and not opts.urn:
                raise TypeError("Missing required property 'location'")
            __props__['location'] = location
            __props__['name'] = name
            __props__['pem_csr'] = pem_csr
            __props__['project'] = project
            __props__['certificate_descriptions'] = None
            __props__['create_time'] = None
            __props__['pem_certificate'] = None
            __props__['pem_certificates'] = None
            __props__['revocation_details'] = None
            __props__['update_time'] = None
        super(Certificate, __self__).__init__(
            'gcp:certificateauthority/certificate:Certificate',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            certificate_authority: Optional[pulumi.Input[str]] = None,
            certificate_descriptions: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['CertificateCertificateDescriptionArgs']]]]] = None,
            config: Optional[pulumi.Input[pulumi.InputType['CertificateConfigArgs']]] = None,
            create_time: Optional[pulumi.Input[str]] = None,
            labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            lifetime: Optional[pulumi.Input[str]] = None,
            location: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            pem_certificate: Optional[pulumi.Input[str]] = None,
            pem_certificates: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            pem_csr: Optional[pulumi.Input[str]] = None,
            project: Optional[pulumi.Input[str]] = None,
            revocation_details: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['CertificateRevocationDetailArgs']]]]] = None,
            update_time: Optional[pulumi.Input[str]] = None) -> 'Certificate':
        """
        Get an existing Certificate resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] certificate_authority: Certificate Authority name.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['CertificateCertificateDescriptionArgs']]]] certificate_descriptions: Output only. Details regarding the revocation of this Certificate. This Certificate is considered revoked if and only if
               this field is present.
        :param pulumi.Input[pulumi.InputType['CertificateConfigArgs']] config: The config used to create a self-signed X.509 certificate or CSR.
               Structure is documented below.
        :param pulumi.Input[str] create_time: The time that this resource was created on the server. This is in RFC3339 text format.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] labels: Labels with user-defined metadata to apply to this resource.
        :param pulumi.Input[str] lifetime: The desired lifetime of the CA certificate. Used to create the "notBeforeTime" and
               "notAfterTime" fields inside an X.509 certificate. A duration in seconds with up to nine
               fractional digits, terminated by 's'. Example: "3.5s".
        :param pulumi.Input[str] location: Location of the CertificateAuthority. A full list of valid locations can be found by
               running `gcloud beta privateca locations list`.
        :param pulumi.Input[str] name: The name for this Certificate .
        :param pulumi.Input[str] pem_certificate: Output only. The pem-encoded, signed X.509 certificate.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] pem_certificates: Required. Expected to be in leaf-to-root order according to RFC 5246.
        :param pulumi.Input[str] pem_csr: Immutable. A pem-encoded X.509 certificate signing request (CSR).
        :param pulumi.Input[str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['CertificateRevocationDetailArgs']]]] revocation_details: Output only. Details regarding the revocation of this Certificate. This Certificate is considered revoked if and only if
               this field is present.
        :param pulumi.Input[str] update_time: Output only. The time at which this CertificateAuthority was updated. This is in RFC3339 text format.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = dict()

        __props__["certificate_authority"] = certificate_authority
        __props__["certificate_descriptions"] = certificate_descriptions
        __props__["config"] = config
        __props__["create_time"] = create_time
        __props__["labels"] = labels
        __props__["lifetime"] = lifetime
        __props__["location"] = location
        __props__["name"] = name
        __props__["pem_certificate"] = pem_certificate
        __props__["pem_certificates"] = pem_certificates
        __props__["pem_csr"] = pem_csr
        __props__["project"] = project
        __props__["revocation_details"] = revocation_details
        __props__["update_time"] = update_time
        return Certificate(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="certificateAuthority")
    def certificate_authority(self) -> pulumi.Output[str]:
        """
        Certificate Authority name.
        """
        return pulumi.get(self, "certificate_authority")

    @property
    @pulumi.getter(name="certificateDescriptions")
    def certificate_descriptions(self) -> pulumi.Output[Sequence['outputs.CertificateCertificateDescription']]:
        """
        Output only. Details regarding the revocation of this Certificate. This Certificate is considered revoked if and only if
        this field is present.
        """
        return pulumi.get(self, "certificate_descriptions")

    @property
    @pulumi.getter
    def config(self) -> pulumi.Output[Optional['outputs.CertificateConfig']]:
        """
        The config used to create a self-signed X.509 certificate or CSR.
        Structure is documented below.
        """
        return pulumi.get(self, "config")

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[str]:
        """
        The time that this resource was created on the server. This is in RFC3339 text format.
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter
    def labels(self) -> pulumi.Output[Optional[Mapping[str, str]]]:
        """
        Labels with user-defined metadata to apply to this resource.
        """
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter
    def lifetime(self) -> pulumi.Output[Optional[str]]:
        """
        The desired lifetime of the CA certificate. Used to create the "notBeforeTime" and
        "notAfterTime" fields inside an X.509 certificate. A duration in seconds with up to nine
        fractional digits, terminated by 's'. Example: "3.5s".
        """
        return pulumi.get(self, "lifetime")

    @property
    @pulumi.getter
    def location(self) -> pulumi.Output[str]:
        """
        Location of the CertificateAuthority. A full list of valid locations can be found by
        running `gcloud beta privateca locations list`.
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The name for this Certificate .
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="pemCertificate")
    def pem_certificate(self) -> pulumi.Output[str]:
        """
        Output only. The pem-encoded, signed X.509 certificate.
        """
        return pulumi.get(self, "pem_certificate")

    @property
    @pulumi.getter(name="pemCertificates")
    def pem_certificates(self) -> pulumi.Output[Sequence[str]]:
        """
        Required. Expected to be in leaf-to-root order according to RFC 5246.
        """
        return pulumi.get(self, "pem_certificates")

    @property
    @pulumi.getter(name="pemCsr")
    def pem_csr(self) -> pulumi.Output[Optional[str]]:
        """
        Immutable. A pem-encoded X.509 certificate signing request (CSR).
        """
        return pulumi.get(self, "pem_csr")

    @property
    @pulumi.getter
    def project(self) -> pulumi.Output[str]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @property
    @pulumi.getter(name="revocationDetails")
    def revocation_details(self) -> pulumi.Output[Sequence['outputs.CertificateRevocationDetail']]:
        """
        Output only. Details regarding the revocation of this Certificate. This Certificate is considered revoked if and only if
        this field is present.
        """
        return pulumi.get(self, "revocation_details")

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> pulumi.Output[str]:
        """
        Output only. The time at which this CertificateAuthority was updated. This is in RFC3339 text format.
        """
        return pulumi.get(self, "update_time")

    def translate_output_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop

    def translate_input_property(self, prop):
        return _tables.SNAKE_TO_CAMEL_CASE_TABLE.get(prop) or prop

