# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union
from .. import _utilities, _tables
from . import outputs
from ._inputs import *

__all__ = ['MetastoreService']


class MetastoreService(pulumi.CustomResource):
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 hive_metastore_config: Optional[pulumi.Input[pulumi.InputType['MetastoreServiceHiveMetastoreConfigArgs']]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 maintenance_window: Optional[pulumi.Input[pulumi.InputType['MetastoreServiceMaintenanceWindowArgs']]] = None,
                 network: Optional[pulumi.Input[str]] = None,
                 port: Optional[pulumi.Input[int]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 service_id: Optional[pulumi.Input[str]] = None,
                 tier: Optional[pulumi.Input[str]] = None,
                 __props__=None,
                 __name__=None,
                 __opts__=None):
        """
        A managed metastore service that serves metadata queries.

        ## Example Usage
        ### Dataproc Metastore Service Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default = gcp.dataproc.MetastoreService("default",
            service_id="metastore-srv",
            location="us-central1",
            port=9080,
            tier="DEVELOPER",
            maintenance_window=gcp.dataproc.MetastoreServiceMaintenanceWindowArgs(
                hour_of_day=2,
                day_of_week="SUNDAY",
            ),
            hive_metastore_config=gcp.dataproc.MetastoreServiceHiveMetastoreConfigArgs(
                version="2.3.6",
            ),
            opts=pulumi.ResourceOptions(provider=google_beta))
        ```

        ## Import

        Service can be imported using any of these accepted formats

        ```sh
         $ pulumi import gcp:dataproc/metastoreService:MetastoreService default projects/{{project}}/locations/{{location}}/services/{{service_id}}
        ```

        ```sh
         $ pulumi import gcp:dataproc/metastoreService:MetastoreService default {{project}}/{{location}}/{{service_id}}
        ```

        ```sh
         $ pulumi import gcp:dataproc/metastoreService:MetastoreService default {{location}}/{{service_id}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[pulumi.InputType['MetastoreServiceHiveMetastoreConfigArgs']] hive_metastore_config: Configuration information specific to running Hive metastore software as the metastore service.
               Structure is documented below.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] labels: User-defined labels for the metastore service.
        :param pulumi.Input[str] location: The  location where the autoscaling policy should reside.
               The default value is `global`.
        :param pulumi.Input[pulumi.InputType['MetastoreServiceMaintenanceWindowArgs']] maintenance_window: The one hour maintenance window of the metastore service.
               This specifies when the service can be restarted for maintenance purposes in UTC time.
               Structure is documented below.
        :param pulumi.Input[str] network: The relative resource name of the VPC network on which the instance can be accessed. It is specified in the following form:
               "projects/{projectNumber}/global/networks/{network_id}".
        :param pulumi.Input[int] port: The TCP port at which the metastore service is reached. Default: 9083.
        :param pulumi.Input[str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[str] service_id: The ID of the metastore service. The id must contain only letters (a-z, A-Z), numbers (0-9), underscores (_),
               and hyphens (-). Cannot begin or end with underscore or hyphen. Must consist of between
               3 and 63 characters.
        :param pulumi.Input[str] tier: The tier of the service.
               Possible values are `DEVELOPER` and `ENTERPRISE`.
        """
        if __name__ is not None:
            warnings.warn("explicit use of __name__ is deprecated", DeprecationWarning)
            resource_name = __name__
        if __opts__ is not None:
            warnings.warn("explicit use of __opts__ is deprecated, use 'opts' instead", DeprecationWarning)
            opts = __opts__
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = dict()

            __props__['hive_metastore_config'] = hive_metastore_config
            __props__['labels'] = labels
            __props__['location'] = location
            __props__['maintenance_window'] = maintenance_window
            __props__['network'] = network
            __props__['port'] = port
            __props__['project'] = project
            if service_id is None and not opts.urn:
                raise TypeError("Missing required property 'service_id'")
            __props__['service_id'] = service_id
            __props__['tier'] = tier
            __props__['artifact_gcs_uri'] = None
            __props__['endpoint_uri'] = None
            __props__['name'] = None
            __props__['state'] = None
            __props__['state_message'] = None
        super(MetastoreService, __self__).__init__(
            'gcp:dataproc/metastoreService:MetastoreService',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            artifact_gcs_uri: Optional[pulumi.Input[str]] = None,
            endpoint_uri: Optional[pulumi.Input[str]] = None,
            hive_metastore_config: Optional[pulumi.Input[pulumi.InputType['MetastoreServiceHiveMetastoreConfigArgs']]] = None,
            labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            location: Optional[pulumi.Input[str]] = None,
            maintenance_window: Optional[pulumi.Input[pulumi.InputType['MetastoreServiceMaintenanceWindowArgs']]] = None,
            name: Optional[pulumi.Input[str]] = None,
            network: Optional[pulumi.Input[str]] = None,
            port: Optional[pulumi.Input[int]] = None,
            project: Optional[pulumi.Input[str]] = None,
            service_id: Optional[pulumi.Input[str]] = None,
            state: Optional[pulumi.Input[str]] = None,
            state_message: Optional[pulumi.Input[str]] = None,
            tier: Optional[pulumi.Input[str]] = None) -> 'MetastoreService':
        """
        Get an existing MetastoreService resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] artifact_gcs_uri: A Cloud Storage URI (starting with gs://) that specifies where artifacts related to the metastore service are stored.
        :param pulumi.Input[str] endpoint_uri: The URI of the endpoint used to access the metastore service.
        :param pulumi.Input[pulumi.InputType['MetastoreServiceHiveMetastoreConfigArgs']] hive_metastore_config: Configuration information specific to running Hive metastore software as the metastore service.
               Structure is documented below.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] labels: User-defined labels for the metastore service.
        :param pulumi.Input[str] location: The  location where the autoscaling policy should reside.
               The default value is `global`.
        :param pulumi.Input[pulumi.InputType['MetastoreServiceMaintenanceWindowArgs']] maintenance_window: The one hour maintenance window of the metastore service.
               This specifies when the service can be restarted for maintenance purposes in UTC time.
               Structure is documented below.
        :param pulumi.Input[str] name: The relative resource name of the metastore service.
        :param pulumi.Input[str] network: The relative resource name of the VPC network on which the instance can be accessed. It is specified in the following form:
               "projects/{projectNumber}/global/networks/{network_id}".
        :param pulumi.Input[int] port: The TCP port at which the metastore service is reached. Default: 9083.
        :param pulumi.Input[str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[str] service_id: The ID of the metastore service. The id must contain only letters (a-z, A-Z), numbers (0-9), underscores (_),
               and hyphens (-). Cannot begin or end with underscore or hyphen. Must consist of between
               3 and 63 characters.
        :param pulumi.Input[str] state: The current state of the metastore service.
        :param pulumi.Input[str] state_message: Additional information about the current state of the metastore service, if available.
        :param pulumi.Input[str] tier: The tier of the service.
               Possible values are `DEVELOPER` and `ENTERPRISE`.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = dict()

        __props__["artifact_gcs_uri"] = artifact_gcs_uri
        __props__["endpoint_uri"] = endpoint_uri
        __props__["hive_metastore_config"] = hive_metastore_config
        __props__["labels"] = labels
        __props__["location"] = location
        __props__["maintenance_window"] = maintenance_window
        __props__["name"] = name
        __props__["network"] = network
        __props__["port"] = port
        __props__["project"] = project
        __props__["service_id"] = service_id
        __props__["state"] = state
        __props__["state_message"] = state_message
        __props__["tier"] = tier
        return MetastoreService(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="artifactGcsUri")
    def artifact_gcs_uri(self) -> pulumi.Output[str]:
        """
        A Cloud Storage URI (starting with gs://) that specifies where artifacts related to the metastore service are stored.
        """
        return pulumi.get(self, "artifact_gcs_uri")

    @property
    @pulumi.getter(name="endpointUri")
    def endpoint_uri(self) -> pulumi.Output[str]:
        """
        The URI of the endpoint used to access the metastore service.
        """
        return pulumi.get(self, "endpoint_uri")

    @property
    @pulumi.getter(name="hiveMetastoreConfig")
    def hive_metastore_config(self) -> pulumi.Output[Optional['outputs.MetastoreServiceHiveMetastoreConfig']]:
        """
        Configuration information specific to running Hive metastore software as the metastore service.
        Structure is documented below.
        """
        return pulumi.get(self, "hive_metastore_config")

    @property
    @pulumi.getter
    def labels(self) -> pulumi.Output[Optional[Mapping[str, str]]]:
        """
        User-defined labels for the metastore service.
        """
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter
    def location(self) -> pulumi.Output[Optional[str]]:
        """
        The  location where the autoscaling policy should reside.
        The default value is `global`.
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter(name="maintenanceWindow")
    def maintenance_window(self) -> pulumi.Output[Optional['outputs.MetastoreServiceMaintenanceWindow']]:
        """
        The one hour maintenance window of the metastore service.
        This specifies when the service can be restarted for maintenance purposes in UTC time.
        Structure is documented below.
        """
        return pulumi.get(self, "maintenance_window")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The relative resource name of the metastore service.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def network(self) -> pulumi.Output[str]:
        """
        The relative resource name of the VPC network on which the instance can be accessed. It is specified in the following form:
        "projects/{projectNumber}/global/networks/{network_id}".
        """
        return pulumi.get(self, "network")

    @property
    @pulumi.getter
    def port(self) -> pulumi.Output[int]:
        """
        The TCP port at which the metastore service is reached. Default: 9083.
        """
        return pulumi.get(self, "port")

    @property
    @pulumi.getter
    def project(self) -> pulumi.Output[str]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @property
    @pulumi.getter(name="serviceId")
    def service_id(self) -> pulumi.Output[str]:
        """
        The ID of the metastore service. The id must contain only letters (a-z, A-Z), numbers (0-9), underscores (_),
        and hyphens (-). Cannot begin or end with underscore or hyphen. Must consist of between
        3 and 63 characters.
        """
        return pulumi.get(self, "service_id")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[str]:
        """
        The current state of the metastore service.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="stateMessage")
    def state_message(self) -> pulumi.Output[str]:
        """
        Additional information about the current state of the metastore service, if available.
        """
        return pulumi.get(self, "state_message")

    @property
    @pulumi.getter
    def tier(self) -> pulumi.Output[str]:
        """
        The tier of the service.
        Possible values are `DEVELOPER` and `ENTERPRISE`.
        """
        return pulumi.get(self, "tier")

    def translate_output_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop

    def translate_input_property(self, prop):
        return _tables.SNAKE_TO_CAMEL_CASE_TABLE.get(prop) or prop

