# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union
from .. import _utilities, _tables
from . import outputs

__all__ = [
    'TriggerDestination',
    'TriggerDestinationCloudRunService',
    'TriggerMatchingCriteria',
    'TriggerTransport',
    'TriggerTransportPubsub',
]

@pulumi.output_type
class TriggerDestination(dict):
    def __init__(__self__, *,
                 cloud_run_service: Optional['outputs.TriggerDestinationCloudRunService'] = None):
        """
        :param 'TriggerDestinationCloudRunServiceArgs' cloud_run_service: Cloud Run fully-managed service that receives the events. The service should be running in the same project as the trigger.
               The `matching_criteria` block supports:
        """
        if cloud_run_service is not None:
            pulumi.set(__self__, "cloud_run_service", cloud_run_service)

    @property
    @pulumi.getter(name="cloudRunService")
    def cloud_run_service(self) -> Optional['outputs.TriggerDestinationCloudRunService']:
        """
        Cloud Run fully-managed service that receives the events. The service should be running in the same project as the trigger.
        The `matching_criteria` block supports:
        """
        return pulumi.get(self, "cloud_run_service")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class TriggerDestinationCloudRunService(dict):
    def __init__(__self__, *,
                 service: str,
                 path: Optional[str] = None,
                 region: Optional[str] = None):
        """
        :param str service: Required. The name of the Cloud run service being addressed (see https://cloud.google.com/run/docs/reference/rest/v1/namespaces.services). Only services located in the same project of the trigger object can be addressed.
        :param str path: Optional. The relative path on the Cloud Run service the events should be sent to. The value must conform to the definition of URI path segment (section 3.3 of RFC2396). Examples: "/route", "route", "route/subroute".
        :param str region: Required. The region the Cloud Run service is deployed in.
        """
        pulumi.set(__self__, "service", service)
        if path is not None:
            pulumi.set(__self__, "path", path)
        if region is not None:
            pulumi.set(__self__, "region", region)

    @property
    @pulumi.getter
    def service(self) -> str:
        """
        Required. The name of the Cloud run service being addressed (see https://cloud.google.com/run/docs/reference/rest/v1/namespaces.services). Only services located in the same project of the trigger object can be addressed.
        """
        return pulumi.get(self, "service")

    @property
    @pulumi.getter
    def path(self) -> Optional[str]:
        """
        Optional. The relative path on the Cloud Run service the events should be sent to. The value must conform to the definition of URI path segment (section 3.3 of RFC2396). Examples: "/route", "route", "route/subroute".
        """
        return pulumi.get(self, "path")

    @property
    @pulumi.getter
    def region(self) -> Optional[str]:
        """
        Required. The region the Cloud Run service is deployed in.
        """
        return pulumi.get(self, "region")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class TriggerMatchingCriteria(dict):
    def __init__(__self__, *,
                 attribute: str,
                 value: str):
        """
        :param str attribute: Required. The name of a CloudEvents attribute. Currently, only a subset of attributes can be specified. All triggers MUST provide a matching criteria for the 'type' attribute.
        :param str value: Required. The value for the attribute.
        """
        pulumi.set(__self__, "attribute", attribute)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def attribute(self) -> str:
        """
        Required. The name of a CloudEvents attribute. Currently, only a subset of attributes can be specified. All triggers MUST provide a matching criteria for the 'type' attribute.
        """
        return pulumi.get(self, "attribute")

    @property
    @pulumi.getter
    def value(self) -> str:
        """
        Required. The value for the attribute.
        """
        return pulumi.get(self, "value")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class TriggerTransport(dict):
    def __init__(__self__, *,
                 pubsubs: Optional[Sequence['outputs.TriggerTransportPubsub']] = None):
        if pubsubs is not None:
            pulumi.set(__self__, "pubsubs", pubsubs)

    @property
    @pulumi.getter
    def pubsubs(self) -> Optional[Sequence['outputs.TriggerTransportPubsub']]:
        return pulumi.get(self, "pubsubs")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class TriggerTransportPubsub(dict):
    def __init__(__self__, *,
                 subscription: Optional[str] = None,
                 topic: Optional[str] = None):
        if subscription is not None:
            pulumi.set(__self__, "subscription", subscription)
        if topic is not None:
            pulumi.set(__self__, "topic", topic)

    @property
    @pulumi.getter
    def subscription(self) -> Optional[str]:
        return pulumi.get(self, "subscription")

    @property
    @pulumi.getter
    def topic(self) -> Optional[str]:
        return pulumi.get(self, "topic")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


